const createdFunctions = new Map();
/**
 * Creates a function from a string.
 */
export const createFunction = (functionValue) => {
    let fn = createdFunctions.get(functionValue);
    if (fn) {
        return fn;
    }
    fn = new Function(`return ${functionValue}`)();
    createdFunctions.set(functionValue, fn);
    return fn;
};
//# sourceMappingURL=util.js.map