(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define('primeng/utils', ['exports'], factory) :
    (global = global || self, factory((global.primeng = global.primeng || {}, global.primeng.utils = {})));
}(this, (function (exports) { 'use strict';

    var __values = (this && this.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var ObjectUtils = /** @class */ (function () {
        function ObjectUtils() {
        }
        ObjectUtils.equals = function (obj1, obj2, field) {
            if (field)
                return (this.resolveFieldData(obj1, field) === this.resolveFieldData(obj2, field));
            else
                return this.equalsByValue(obj1, obj2);
        };
        ObjectUtils.equalsByValue = function (obj1, obj2) {
            if (obj1 === obj2)
                return true;
            if (obj1 && obj2 && typeof obj1 == 'object' && typeof obj2 == 'object') {
                var arrA = Array.isArray(obj1), arrB = Array.isArray(obj2), i, length, key;
                if (arrA && arrB) {
                    length = obj1.length;
                    if (length != obj2.length)
                        return false;
                    for (i = length; i-- !== 0;)
                        if (!this.equalsByValue(obj1[i], obj2[i]))
                            return false;
                    return true;
                }
                if (arrA != arrB)
                    return false;
                var dateA = obj1 instanceof Date, dateB = obj2 instanceof Date;
                if (dateA != dateB)
                    return false;
                if (dateA && dateB)
                    return obj1.getTime() == obj2.getTime();
                var regexpA = obj1 instanceof RegExp, regexpB = obj2 instanceof RegExp;
                if (regexpA != regexpB)
                    return false;
                if (regexpA && regexpB)
                    return obj1.toString() == obj2.toString();
                var keys = Object.keys(obj1);
                length = keys.length;
                if (length !== Object.keys(obj2).length)
                    return false;
                for (i = length; i-- !== 0;)
                    if (!Object.prototype.hasOwnProperty.call(obj2, keys[i]))
                        return false;
                for (i = length; i-- !== 0;) {
                    key = keys[i];
                    if (!this.equalsByValue(obj1[key], obj2[key]))
                        return false;
                }
                return true;
            }
            return obj1 !== obj1 && obj2 !== obj2;
        };
        ObjectUtils.resolveFieldData = function (data, field) {
            if (data && field) {
                if (this.isFunction(field)) {
                    return field(data);
                }
                else if (field.indexOf('.') == -1) {
                    return data[field];
                }
                else {
                    var fields = field.split('.');
                    var value = data;
                    for (var i = 0, len = fields.length; i < len; ++i) {
                        if (value == null) {
                            return null;
                        }
                        value = value[fields[i]];
                    }
                    return value;
                }
            }
            else {
                return null;
            }
        };
        ObjectUtils.isFunction = function (obj) {
            return !!(obj && obj.constructor && obj.call && obj.apply);
        };
        ObjectUtils.reorderArray = function (value, from, to) {
            var target;
            if (value && from !== to) {
                if (to >= value.length) {
                    to %= value.length;
                    from %= value.length;
                }
                value.splice(to, 0, value.splice(from, 1)[0]);
            }
        };
        ObjectUtils.generateSelectItems = function (val, field) {
            var e_1, _a;
            var selectItems;
            if (val && val.length) {
                selectItems = [];
                try {
                    for (var val_1 = __values(val), val_1_1 = val_1.next(); !val_1_1.done; val_1_1 = val_1.next()) {
                        var item = val_1_1.value;
                        selectItems.push({ label: this.resolveFieldData(item, field), value: item });
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (val_1_1 && !val_1_1.done && (_a = val_1.return)) _a.call(val_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            return selectItems;
        };
        ObjectUtils.insertIntoOrderedArray = function (item, index, arr, sourceArr) {
            if (arr.length > 0) {
                var injected = false;
                for (var i = 0; i < arr.length; i++) {
                    var currentItemIndex = this.findIndexInList(arr[i], sourceArr);
                    if (currentItemIndex > index) {
                        arr.splice(i, 0, item);
                        injected = true;
                        break;
                    }
                }
                if (!injected) {
                    arr.push(item);
                }
            }
            else {
                arr.push(item);
            }
        };
        ObjectUtils.findIndexInList = function (item, list) {
            var index = -1;
            if (list) {
                for (var i = 0; i < list.length; i++) {
                    if (list[i] == item) {
                        index = i;
                        break;
                    }
                }
            }
            return index;
        };
        ObjectUtils.removeAccents = function (str) {
            if (str && str.search(/[\xC0-\xFF]/g) > -1) {
                str = str
                    .replace(/[\xC0-\xC5]/g, "A")
                    .replace(/[\xC6]/g, "AE")
                    .replace(/[\xC7]/g, "C")
                    .replace(/[\xC8-\xCB]/g, "E")
                    .replace(/[\xCC-\xCF]/g, "I")
                    .replace(/[\xD0]/g, "D")
                    .replace(/[\xD1]/g, "N")
                    .replace(/[\xD2-\xD6\xD8]/g, "O")
                    .replace(/[\xD9-\xDC]/g, "U")
                    .replace(/[\xDD]/g, "Y")
                    .replace(/[\xDE]/g, "P")
                    .replace(/[\xE0-\xE5]/g, "a")
                    .replace(/[\xE6]/g, "ae")
                    .replace(/[\xE7]/g, "c")
                    .replace(/[\xE8-\xEB]/g, "e")
                    .replace(/[\xEC-\xEF]/g, "i")
                    .replace(/[\xF1]/g, "n")
                    .replace(/[\xF2-\xF6\xF8]/g, "o")
                    .replace(/[\xF9-\xFC]/g, "u")
                    .replace(/[\xFE]/g, "p")
                    .replace(/[\xFD\xFF]/g, "y");
            }
            return str;
        };
        return ObjectUtils;
    }());

    var __values$1 = (this && this.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var FilterUtils = /** @class */ (function () {
        function FilterUtils() {
        }
        FilterUtils.filter = function (value, fields, filterValue, filterMatchMode, filterLocale) {
            var e_1, _a, e_2, _b;
            var filteredItems = [];
            var filterText = ObjectUtils.removeAccents(filterValue).toLocaleLowerCase(filterLocale);
            if (value) {
                try {
                    for (var value_1 = __values$1(value), value_1_1 = value_1.next(); !value_1_1.done; value_1_1 = value_1.next()) {
                        var item = value_1_1.value;
                        try {
                            for (var fields_1 = (e_2 = void 0, __values$1(fields)), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
                                var field = fields_1_1.value;
                                var fieldValue = ObjectUtils.removeAccents(String(ObjectUtils.resolveFieldData(item, field))).toLocaleLowerCase(filterLocale);
                                if (FilterUtils[filterMatchMode](fieldValue, filterText, filterLocale)) {
                                    filteredItems.push(item);
                                    break;
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (fields_1_1 && !fields_1_1.done && (_b = fields_1.return)) _b.call(fields_1);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (value_1_1 && !value_1_1.done && (_a = value_1.return)) _a.call(value_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            return filteredItems;
        };
        FilterUtils.startsWith = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null || filter.trim() === '') {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
            var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
            return stringValue.slice(0, filterValue.length) === filterValue;
        };
        FilterUtils.contains = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null || (typeof filter === 'string' && filter.trim() === '')) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
            var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
            return stringValue.indexOf(filterValue) !== -1;
        };
        FilterUtils.endsWith = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null || filter.trim() === '') {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
            var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
            return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
        };
        FilterUtils.equals = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null || (typeof filter === 'string' && filter.trim() === '')) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            if (value.getTime && filter.getTime)
                return value.getTime() === filter.getTime();
            else
                return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) == ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        };
        FilterUtils.notEquals = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null || (typeof filter === 'string' && filter.trim() === '')) {
                return false;
            }
            if (value === undefined || value === null) {
                return true;
            }
            if (value.getTime && filter.getTime)
                return value.getTime() !== filter.getTime();
            else
                return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) != ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        };
        FilterUtils.in = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null || filter.length === 0) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            for (var i = 0; i < filter.length; i++) {
                if (ObjectUtils.equals(value, filter[i])) {
                    return true;
                }
            }
            return false;
        };
        FilterUtils.lt = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            if (value.getTime && filter.getTime)
                return value.getTime() < filter.getTime();
            else
                return value < filter;
        };
        FilterUtils.lte = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            if (value.getTime && filter.getTime)
                return value.getTime() <= filter.getTime();
            else
                return value <= filter;
        };
        FilterUtils.gt = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            if (value.getTime && filter.getTime)
                return value.getTime() > filter.getTime();
            else
                return value > filter;
        };
        FilterUtils.gte = function (value, filter, filterLocale) {
            if (filter === undefined || filter === null) {
                return true;
            }
            if (value === undefined || value === null) {
                return false;
            }
            if (value.getTime && filter.getTime)
                return value.getTime() >= filter.getTime();
            else
                return value >= filter;
        };
        return FilterUtils;
    }());

    exports.lastId = 0;
    function UniqueComponentId() {
        var prefix = 'pr_id_';
        exports.lastId++;
        return "" + prefix + exports.lastId;
    }

    exports.FilterUtils = FilterUtils;
    exports.ObjectUtils = ObjectUtils;
    exports.UniqueComponentId = UniqueComponentId;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=primeng-utils.umd.js.map
