!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/common"),require("primeng/tooltip"),require("primeng/api")):"function"==typeof define&&define.amd?define("primeng/tabview",["exports","@angular/core","@angular/common","primeng/tooltip","primeng/api"],e):e(((t=t||self).primeng=t.primeng||{},t.primeng.tabview={}),t.ng.core,t.ng.common,t.primeng.tooltip,t.primeng.api)}(this,(function(t,e,n,i,o){"use strict";var a=this&&this.__decorate||function(t,e,n,i){var o,a=arguments.length,l=a<3?e:null===i?i=Object.getOwnPropertyDescriptor(e,n):i;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)l=Reflect.decorate(t,e,n,i);else for(var s=t.length-1;s>=0;s--)(o=t[s])&&(l=(a<3?o(l):a>3?o(e,n,l):o(e,n))||l);return a>3&&l&&Object.defineProperty(e,n,l),l},l=0,s=function(){function t(){this.orientation="top",this.onTabClick=new e.EventEmitter,this.onTabCloseClick=new e.EventEmitter}return t.prototype.getDefaultHeaderClass=function(t){var e="ui-state-default ui-corner-"+this.orientation;return t.headerStyleClass&&(e=e+" "+t.headerStyleClass),e},t.prototype.clickTab=function(t,e){this.onTabClick.emit({originalEvent:t,tab:e})},t.prototype.clickClose=function(t,e){this.onTabCloseClick.emit({originalEvent:t,tab:e})},a([e.Input()],t.prototype,"tabs",void 0),a([e.Input()],t.prototype,"orientation",void 0),a([e.Output()],t.prototype,"onTabClick",void 0),a([e.Output()],t.prototype,"onTabCloseClick",void 0),t=a([e.Component({selector:"[p-tabViewNav]",host:{"[class.ui-tabview-nav]":"true","[class.ui-helper-reset]":"true","[class.ui-helper-clearfix]":"true","[class.ui-widget-header]":"true","[class.ui-corner-all]":"true"},template:'\n        <ng-template ngFor let-tab [ngForOf]="tabs">\n            <li [class]="getDefaultHeaderClass(tab)" [ngStyle]="tab.headerStyle" role="presentation" [attr.tabindex]="tab.disabled ? -1 : 0"\n                [ngClass]="{\'ui-tabview-selected ui-state-active\': tab.selected, \'ui-state-disabled\': tab.disabled}"\n                (click)="clickTab($event,tab)" *ngIf="!tab.closed" tabindex="0" (keydown.enter)="clickTab($event,tab)">\n                <a [attr.id]="tab.id + \'-label\'" role="tab" [attr.aria-selected]="tab.selected" [attr.aria-controls]="tab.id" [pTooltip]="tab.tooltip" [tooltipPosition]="tab.tooltipPosition"\n                    [attr.aria-selected]="tab.selected" [positionStyle]="tab.tooltipPositionStyle" [tooltipStyleClass]="tab.tooltipStyleClass">\n                    <ng-container *ngIf="!tab.headerTemplate" >\n                        <span class="ui-tabview-left-icon" [ngClass]="tab.leftIcon" *ngIf="tab.leftIcon"></span>\n                        <span class="ui-tabview-title">{{tab.header}}</span>\n                        <span class="ui-tabview-right-icon" [ngClass]="tab.rightIcon" *ngIf="tab.rightIcon"></span>\n                    </ng-container>\n                    <ng-container *ngIf="tab.headerTemplate">\n                        <ng-container *ngTemplateOutlet="tab.headerTemplate"></ng-container>\n                    </ng-container>\n                </a>\n                <span *ngIf="tab.closable" class="ui-tabview-close pi pi-times" (click)="clickClose($event,tab)"></span>\n            </li>\n        </ng-template>\n    '})],t)}(),r=function(){function t(t,e){this.viewContainer=t,this.cd=e,this.cache=!0,this.tooltipPosition="top",this.tooltipPositionStyle="absolute",this.id="ui-tabpanel-"+l++}return t.prototype.ngAfterContentInit=function(){var t=this;this.templates.forEach((function(e){switch(e.getType()){case"header":t.headerTemplate=e.template;break;case"content":default:t.contentTemplate=e.template}}))},Object.defineProperty(t.prototype,"selected",{get:function(){return this._selected},set:function(t){this._selected=t,this.loaded||this.cd.detectChanges(),this.loaded=!0},enumerable:!0,configurable:!0}),t.prototype.ngOnDestroy=function(){this.view=null},t.ctorParameters=function(){return[{type:e.ViewContainerRef},{type:e.ChangeDetectorRef}]},a([e.Input()],t.prototype,"header",void 0),a([e.Input()],t.prototype,"disabled",void 0),a([e.Input()],t.prototype,"closable",void 0),a([e.Input()],t.prototype,"headerStyle",void 0),a([e.Input()],t.prototype,"headerStyleClass",void 0),a([e.Input()],t.prototype,"leftIcon",void 0),a([e.Input()],t.prototype,"rightIcon",void 0),a([e.Input()],t.prototype,"cache",void 0),a([e.Input()],t.prototype,"tooltip",void 0),a([e.Input()],t.prototype,"tooltipPosition",void 0),a([e.Input()],t.prototype,"tooltipPositionStyle",void 0),a([e.Input()],t.prototype,"tooltipStyleClass",void 0),a([e.ContentChildren(o.PrimeTemplate)],t.prototype,"templates",void 0),a([e.Input()],t.prototype,"selected",null),t=a([e.Component({selector:"p-tabPanel",template:'\n        <div [attr.id]="id" class="ui-tabview-panel ui-widget-content" [ngClass]="{\'ui-helper-hidden\': !selected}"\n            role="tabpanel" [attr.aria-hidden]="!selected" [attr.aria-labelledby]="id + \'-label\'" *ngIf="!closed">\n            <ng-content></ng-content>\n            <ng-container *ngIf="contentTemplate && (cache ? loaded : selected)">\n                <ng-container *ngTemplateOutlet="contentTemplate"></ng-container>\n            </ng-container>\n        </div>\n    '})],t)}(),p=function(){function t(t){this.el=t,this.orientation="top",this.onChange=new e.EventEmitter,this.onClose=new e.EventEmitter,this.activeIndexChange=new e.EventEmitter}return t.prototype.ngAfterContentInit=function(){var t=this;this.initTabs(),this.tabPanels.changes.subscribe((function(e){t.initTabs()}))},t.prototype.initTabs=function(){this.tabs=this.tabPanels.toArray(),!this.findSelectedTab()&&this.tabs.length&&(null!=this.activeIndex&&this.tabs.length>this.activeIndex?this.tabs[this.activeIndex].selected=!0:this.tabs[0].selected=!0)},t.prototype.open=function(t,e){if(e.disabled)t&&t.preventDefault();else{if(!e.selected){var n=this.findSelectedTab();n&&(n.selected=!1),e.selected=!0;var i=this.findTabIndex(e);this.preventActiveIndexPropagation=!0,this.activeIndexChange.emit(i),this.onChange.emit({originalEvent:t,index:i})}t&&t.preventDefault()}},t.prototype.close=function(t,e){var n=this;this.controlClose?this.onClose.emit({originalEvent:t,index:this.findTabIndex(e),close:function(){n.closeTab(e)}}):(this.closeTab(e),this.onClose.emit({originalEvent:t,index:this.findTabIndex(e)})),t.stopPropagation()},t.prototype.closeTab=function(t){if(!t.disabled){if(t.selected){t.selected=!1;for(var e=0;e<this.tabs.length;e++){var n=this.tabs[e];if(!n.closed&&!t.disabled){n.selected=!0;break}}}t.closed=!0}},t.prototype.findSelectedTab=function(){for(var t=0;t<this.tabs.length;t++)if(this.tabs[t].selected)return this.tabs[t];return null},t.prototype.findTabIndex=function(t){for(var e=-1,n=0;n<this.tabs.length;n++)if(this.tabs[n]==t){e=n;break}return e},t.prototype.getBlockableElement=function(){return this.el.nativeElement.children[0]},Object.defineProperty(t.prototype,"activeIndex",{get:function(){return this._activeIndex},set:function(t){this._activeIndex=t,this.preventActiveIndexPropagation?this.preventActiveIndexPropagation=!1:this.tabs&&this.tabs.length&&null!=this._activeIndex&&this.tabs.length>this._activeIndex&&(this.findSelectedTab().selected=!1,this.tabs[this._activeIndex].selected=!0)},enumerable:!0,configurable:!0}),t.ctorParameters=function(){return[{type:e.ElementRef}]},a([e.Input()],t.prototype,"orientation",void 0),a([e.Input()],t.prototype,"style",void 0),a([e.Input()],t.prototype,"styleClass",void 0),a([e.Input()],t.prototype,"controlClose",void 0),a([e.ContentChildren(r)],t.prototype,"tabPanels",void 0),a([e.Output()],t.prototype,"onChange",void 0),a([e.Output()],t.prototype,"onClose",void 0),a([e.Output()],t.prototype,"activeIndexChange",void 0),a([e.Input()],t.prototype,"activeIndex",null),t=a([e.Component({selector:"p-tabView",template:'\n        <div [ngClass]="\'ui-tabview ui-widget ui-widget-content ui-corner-all ui-tabview-\' + orientation" [ngStyle]="style" [class]="styleClass">\n            <ul p-tabViewNav role="tablist" *ngIf="orientation!=\'bottom\'" [tabs]="tabs" [orientation]="orientation"\n                (onTabClick)="open($event.originalEvent, $event.tab)" (onTabCloseClick)="close($event.originalEvent, $event.tab)"></ul>\n            <div class="ui-tabview-panels">\n                <ng-content></ng-content>\n            </div>\n            <ul p-tabViewNav role="tablist" *ngIf="orientation==\'bottom\'" [tabs]="tabs" [orientation]="orientation"\n                (onTabClick)="open($event.originalEvent, $event.tab)" (onTabCloseClick)="close($event.originalEvent, $event.tab)"></ul>\n        </div>\n    ',changeDetection:e.ChangeDetectionStrategy.Default})],t)}(),c=function(){function t(){}return t=a([e.NgModule({imports:[n.CommonModule,o.SharedModule,i.TooltipModule],exports:[p,r,s,o.SharedModule],declarations:[p,r,s]})],t)}();t.TabPanel=r,t.TabView=p,t.TabViewModule=c,t.TabViewNav=s,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=primeng-tabview.umd.min.js.map