import { EventEmitter, ElementRef, Input, Output, ViewChild, ContentChildren, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { ButtonModule } from 'primeng/button';
import { PrimeTemplate, SharedModule } from 'primeng/api';
import { DomHandler } from 'primeng/dom';
import { ObjectUtils, FilterUtils } from 'primeng/utils';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';
import * as ɵngcc2 from 'primeng/button';

var _c0 = ["listelement"];
function OrderList_div_7_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 12);
    ɵngcc0.ɵɵtext(1);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r0 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵtextInterpolate(ctx_r0.header);
} }
function OrderList_div_8_Template(rf, ctx) { if (rf & 1) {
    var _r5 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "div", 13);
    ɵngcc0.ɵɵelementStart(1, "input", 14);
    ɵngcc0.ɵɵlistener("keyup", function OrderList_div_8_Template_input_keyup_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r5); var ctx_r4 = ɵngcc0.ɵɵnextContext(); return ctx_r4.onFilterKeyup($event); });
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelement(2, "span", 15);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵattribute("placeholder", ctx_r1.filterPlaceholder)("aria-label", ctx_r1.ariaFilterLabel);
} }
var _c1 = function (a0) { return { "ui-orderlist-droppoint-highlight": a0 }; };
function OrderList_ng_template_11_li_0_Template(rf, ctx) { if (rf & 1) {
    var _r13 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "li", 19);
    ɵngcc0.ɵɵlistener("dragover", function OrderList_ng_template_11_li_0_Template_li_dragover_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r13); var i_r7 = ɵngcc0.ɵɵnextContext().index; var ctx_r12 = ɵngcc0.ɵɵnextContext(); return ctx_r12.onDragOver($event, i_r7); })("drop", function OrderList_ng_template_11_li_0_Template_li_drop_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r13); var i_r7 = ɵngcc0.ɵɵnextContext().index; var ctx_r15 = ɵngcc0.ɵɵnextContext(); return ctx_r15.onDrop($event, i_r7); })("dragleave", function OrderList_ng_template_11_li_0_Template_li_dragleave_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r13); var ctx_r17 = ɵngcc0.ɵɵnextContext(2); return ctx_r17.onDragLeave($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var i_r7 = ɵngcc0.ɵɵnextContext().index;
    var ctx_r9 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(1, _c1, i_r7 === ctx_r9.dragOverItemIndex));
} }
function OrderList_ng_template_11_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementContainer(0);
} }
function OrderList_ng_template_11_li_3_Template(rf, ctx) { if (rf & 1) {
    var _r20 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "li", 19);
    ɵngcc0.ɵɵlistener("dragover", function OrderList_ng_template_11_li_3_Template_li_dragover_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r20); var i_r7 = ɵngcc0.ɵɵnextContext().index; var ctx_r19 = ɵngcc0.ɵɵnextContext(); return ctx_r19.onDragOver($event, i_r7 + 1); })("drop", function OrderList_ng_template_11_li_3_Template_li_drop_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r20); var i_r7 = ɵngcc0.ɵɵnextContext().index; var ctx_r22 = ɵngcc0.ɵɵnextContext(); return ctx_r22.onDrop($event, i_r7 + 1); })("dragleave", function OrderList_ng_template_11_li_3_Template_li_dragleave_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r20); var ctx_r24 = ɵngcc0.ɵɵnextContext(2); return ctx_r24.onDragLeave($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var i_r7 = ɵngcc0.ɵɵnextContext().index;
    var ctx_r11 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(1, _c1, i_r7 + 1 === ctx_r11.dragOverItemIndex));
} }
var _c2 = function (a0) { return { "ui-state-highlight": a0 }; };
var _c3 = function (a0, a1) { return { $implicit: a0, index: a1 }; };
function OrderList_ng_template_11_Template(rf, ctx) { if (rf & 1) {
    var _r27 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵtemplate(0, OrderList_ng_template_11_li_0_Template, 1, 3, "li", 16);
    ɵngcc0.ɵɵelementStart(1, "li", 17);
    ɵngcc0.ɵɵlistener("click", function OrderList_ng_template_11_Template_li_click_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r27); var item_r6 = ctx.$implicit; var i_r7 = ctx.index; var ctx_r26 = ɵngcc0.ɵɵnextContext(); return ctx_r26.onItemClick($event, item_r6, i_r7); })("touchend", function OrderList_ng_template_11_Template_li_touchend_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r27); var ctx_r28 = ɵngcc0.ɵɵnextContext(); return ctx_r28.onItemTouchEnd($event); })("keydown", function OrderList_ng_template_11_Template_li_keydown_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r27); var item_r6 = ctx.$implicit; var i_r7 = ctx.index; var ctx_r29 = ɵngcc0.ɵɵnextContext(); return ctx_r29.onItemKeydown($event, item_r6, i_r7); })("dragstart", function OrderList_ng_template_11_Template_li_dragstart_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r27); var i_r7 = ctx.index; var ctx_r30 = ɵngcc0.ɵɵnextContext(); return ctx_r30.onDragStart($event, i_r7); })("dragend", function OrderList_ng_template_11_Template_li_dragend_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r27); var ctx_r31 = ɵngcc0.ɵɵnextContext(); return ctx_r31.onDragEnd($event); });
    ɵngcc0.ɵɵtemplate(2, OrderList_ng_template_11_ng_container_2_Template, 1, 0, "ng-container", 18);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵtemplate(3, OrderList_ng_template_11_li_3_Template, 1, 3, "li", 16);
} if (rf & 2) {
    var item_r6 = ctx.$implicit;
    var i_r7 = ctx.index;
    var l_r8 = ctx.last;
    var ctx_r3 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngIf", ctx_r3.dragdrop && ctx_r3.isItemVisible(item_r6));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵstyleProp("display", ctx_r3.isItemVisible(item_r6) ? "block" : "none");
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(9, _c2, ctx_r3.isSelected(item_r6)))("draggable", ctx_r3.dragdrop);
    ɵngcc0.ɵɵattribute("aria-selected", ctx_r3.isSelected(item_r6));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngTemplateOutlet", ctx_r3.itemTemplate)("ngTemplateOutletContext", ɵngcc0.ɵɵpureFunction2(11, _c3, item_r6, i_r7));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r3.dragdrop && l_r8);
} }
var _c4 = function (a1, a2) { return { "ui-orderlist ui-widget": true, "ui-orderlist-controls-left": a1, "ui-orderlist-controls-right": a2 }; };
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var OrderList = /** @class */ (function () {
    function OrderList(el) {
        this.el = el;
        this.metaKeySelection = true;
        this.controlsPosition = 'left';
        this.filterMatchMode = "contains";
        this.selectionChange = new EventEmitter();
        this.trackBy = function (index, item) { return item; };
        this.onReorder = new EventEmitter();
        this.onSelectionChange = new EventEmitter();
        this.onFilterEvent = new EventEmitter();
    }
    Object.defineProperty(OrderList.prototype, "selection", {
        get: function () {
            return this._selection;
        },
        set: function (val) {
            this._selection = val;
        },
        enumerable: true,
        configurable: true
    });
    OrderList.prototype.ngAfterContentInit = function () {
        var _this = this;
        this.templates.forEach(function (item) {
            switch (item.getType()) {
                case 'item':
                    _this.itemTemplate = item.template;
                    break;
                default:
                    _this.itemTemplate = item.template;
                    break;
            }
        });
    };
    OrderList.prototype.ngAfterViewChecked = function () {
        if (this.movedUp || this.movedDown) {
            var listItems = DomHandler.find(this.listViewChild.nativeElement, 'li.ui-state-highlight');
            var listItem = void 0;
            if (listItems.length > 0) {
                if (this.movedUp)
                    listItem = listItems[0];
                else
                    listItem = listItems[listItems.length - 1];
                DomHandler.scrollInView(this.listViewChild.nativeElement, listItem);
            }
            this.movedUp = false;
            this.movedDown = false;
        }
    };
    Object.defineProperty(OrderList.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (val) {
            this._value = val;
            if (this.filterValue) {
                this.filter();
            }
        },
        enumerable: true,
        configurable: true
    });
    OrderList.prototype.onItemClick = function (event, item, index) {
        this.itemTouched = false;
        var selectedIndex = ObjectUtils.findIndexInList(item, this.selection);
        var selected = (selectedIndex != -1);
        var metaSelection = this.itemTouched ? false : this.metaKeySelection;
        if (metaSelection) {
            var metaKey = (event.metaKey || event.ctrlKey || event.shiftKey);
            if (selected && metaKey) {
                this._selection = this._selection.filter(function (val, index) { return index !== selectedIndex; });
            }
            else {
                this._selection = (metaKey) ? this._selection ? __spread(this._selection) : [] : [];
                ObjectUtils.insertIntoOrderedArray(item, index, this._selection, this.value);
            }
        }
        else {
            if (selected) {
                this._selection = this._selection.filter(function (val, index) { return index !== selectedIndex; });
            }
            else {
                this._selection = this._selection ? __spread(this._selection) : [];
                ObjectUtils.insertIntoOrderedArray(item, index, this._selection, this.value);
            }
        }
        //binding
        this.selectionChange.emit(this._selection);
        //event
        this.onSelectionChange.emit({ originalEvent: event, value: this._selection });
    };
    OrderList.prototype.onFilterKeyup = function (event) {
        this.filterValue = event.target.value.trim().toLocaleLowerCase(this.filterLocale);
        this.filter();
        this.onFilterEvent.emit({
            originalEvent: event,
            value: this.visibleOptions
        });
    };
    OrderList.prototype.filter = function () {
        var searchFields = this.filterBy.split(',');
        this.visibleOptions = FilterUtils.filter(this.value, searchFields, this.filterValue, this.filterMatchMode, this.filterLocale);
    };
    OrderList.prototype.isItemVisible = function (item) {
        if (this.filterValue && this.filterValue.trim().length) {
            for (var i = 0; i < this.visibleOptions.length; i++) {
                if (item == this.visibleOptions[i]) {
                    return true;
                }
            }
        }
        else {
            return true;
        }
    };
    OrderList.prototype.onItemTouchEnd = function (event) {
        this.itemTouched = true;
    };
    OrderList.prototype.isSelected = function (item) {
        return ObjectUtils.findIndexInList(item, this.selection) != -1;
    };
    OrderList.prototype.moveUp = function (event) {
        if (this.selection) {
            for (var i = 0; i < this.selection.length; i++) {
                var selectedItem = this.selection[i];
                var selectedItemIndex = ObjectUtils.findIndexInList(selectedItem, this.value);
                if (selectedItemIndex != 0) {
                    var movedItem = this.value[selectedItemIndex];
                    var temp = this.value[selectedItemIndex - 1];
                    this.value[selectedItemIndex - 1] = movedItem;
                    this.value[selectedItemIndex] = temp;
                }
                else {
                    break;
                }
            }
            this.movedUp = true;
            this.onReorder.emit(event);
        }
    };
    OrderList.prototype.moveTop = function (event) {
        if (this.selection) {
            for (var i = this.selection.length - 1; i >= 0; i--) {
                var selectedItem = this.selection[i];
                var selectedItemIndex = ObjectUtils.findIndexInList(selectedItem, this.value);
                if (selectedItemIndex != 0) {
                    var movedItem = this.value.splice(selectedItemIndex, 1)[0];
                    this.value.unshift(movedItem);
                }
                else {
                    break;
                }
            }
            this.onReorder.emit(event);
            this.listViewChild.nativeElement.scrollTop = 0;
        }
    };
    OrderList.prototype.moveDown = function (event) {
        if (this.selection) {
            for (var i = this.selection.length - 1; i >= 0; i--) {
                var selectedItem = this.selection[i];
                var selectedItemIndex = ObjectUtils.findIndexInList(selectedItem, this.value);
                if (selectedItemIndex != (this.value.length - 1)) {
                    var movedItem = this.value[selectedItemIndex];
                    var temp = this.value[selectedItemIndex + 1];
                    this.value[selectedItemIndex + 1] = movedItem;
                    this.value[selectedItemIndex] = temp;
                }
                else {
                    break;
                }
            }
            this.movedDown = true;
            this.onReorder.emit(event);
        }
    };
    OrderList.prototype.moveBottom = function (event) {
        if (this.selection) {
            for (var i = 0; i < this.selection.length; i++) {
                var selectedItem = this.selection[i];
                var selectedItemIndex = ObjectUtils.findIndexInList(selectedItem, this.value);
                if (selectedItemIndex != (this.value.length - 1)) {
                    var movedItem = this.value.splice(selectedItemIndex, 1)[0];
                    this.value.push(movedItem);
                }
                else {
                    break;
                }
            }
            this.onReorder.emit(event);
            this.listViewChild.nativeElement.scrollTop = this.listViewChild.nativeElement.scrollHeight;
        }
    };
    OrderList.prototype.onDragStart = function (event, index) {
        event.dataTransfer.setData('text', 'b'); // For firefox
        event.target.blur();
        this.dragging = true;
        this.draggedItemIndex = index;
    };
    OrderList.prototype.onDragOver = function (event, index) {
        if (this.dragging && this.draggedItemIndex !== index && this.draggedItemIndex + 1 !== index) {
            this.dragOverItemIndex = index;
            event.preventDefault();
        }
    };
    OrderList.prototype.onDragLeave = function (event) {
        this.dragOverItemIndex = null;
    };
    OrderList.prototype.onDrop = function (event, index) {
        var dropIndex = (this.draggedItemIndex > index) ? index : (index === 0) ? 0 : index - 1;
        ObjectUtils.reorderArray(this.value, this.draggedItemIndex, dropIndex);
        this.dragOverItemIndex = null;
        this.onReorder.emit(event);
        event.preventDefault();
    };
    OrderList.prototype.onDragEnd = function (event) {
        this.dragging = false;
    };
    OrderList.prototype.onListMouseMove = function (event) {
        if (this.dragging) {
            var offsetY = this.listViewChild.nativeElement.getBoundingClientRect().top + document.body.scrollTop;
            var bottomDiff = (offsetY + this.listViewChild.nativeElement.clientHeight) - event.pageY;
            var topDiff = (event.pageY - offsetY);
            if (bottomDiff < 25 && bottomDiff > 0)
                this.listViewChild.nativeElement.scrollTop += 15;
            else if (topDiff < 25 && topDiff > 0)
                this.listViewChild.nativeElement.scrollTop -= 15;
        }
    };
    OrderList.prototype.onItemKeydown = function (event, item, index) {
        var listItem = event.currentTarget;
        switch (event.which) {
            //down
            case 40:
                var nextItem = this.findNextItem(listItem);
                if (nextItem) {
                    nextItem.focus();
                }
                event.preventDefault();
                break;
            //up
            case 38:
                var prevItem = this.findPrevItem(listItem);
                if (prevItem) {
                    prevItem.focus();
                }
                event.preventDefault();
                break;
            //enter
            case 13:
                this.onItemClick(event, item, index);
                event.preventDefault();
                break;
        }
    };
    OrderList.prototype.findNextItem = function (item) {
        var nextItem = item.nextElementSibling;
        if (nextItem)
            return !DomHandler.hasClass(nextItem, 'ui-orderlist-item') || DomHandler.isHidden(nextItem) ? this.findNextItem(nextItem) : nextItem;
        else
            return null;
    };
    OrderList.prototype.findPrevItem = function (item) {
        var prevItem = item.previousElementSibling;
        if (prevItem)
            return !DomHandler.hasClass(prevItem, 'ui-orderlist-item') || DomHandler.isHidden(prevItem) ? this.findPrevItem(prevItem) : prevItem;
        else
            return null;
    };
    OrderList.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        Input()
    ], OrderList.prototype, "header", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "style", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "listStyle", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "responsive", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "filterBy", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "filterPlaceholder", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "filterLocale", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "metaKeySelection", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "dragdrop", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "controlsPosition", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "ariaFilterLabel", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "filterMatchMode", void 0);
    __decorate([
        Output()
    ], OrderList.prototype, "selectionChange", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "trackBy", void 0);
    __decorate([
        Output()
    ], OrderList.prototype, "onReorder", void 0);
    __decorate([
        Output()
    ], OrderList.prototype, "onSelectionChange", void 0);
    __decorate([
        Output()
    ], OrderList.prototype, "onFilterEvent", void 0);
    __decorate([
        ViewChild('listelement')
    ], OrderList.prototype, "listViewChild", void 0);
    __decorate([
        ContentChildren(PrimeTemplate)
    ], OrderList.prototype, "templates", void 0);
    __decorate([
        Input()
    ], OrderList.prototype, "selection", null);
    __decorate([
        Input()
    ], OrderList.prototype, "value", null);
OrderList.ɵfac = function OrderList_Factory(t) { return new (t || OrderList)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef)); };
OrderList.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: OrderList, selectors: [["p-orderList"]], contentQueries: function OrderList_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        ɵngcc0.ɵɵcontentQuery(dirIndex, PrimeTemplate, false);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.templates = _t);
    } }, viewQuery: function OrderList_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.listViewChild = _t.first);
    } }, inputs: { metaKeySelection: "metaKeySelection", controlsPosition: "controlsPosition", filterMatchMode: "filterMatchMode", trackBy: "trackBy", selection: "selection", value: "value", header: "header", style: "style", styleClass: "styleClass", listStyle: "listStyle", responsive: "responsive", filterBy: "filterBy", filterPlaceholder: "filterPlaceholder", filterLocale: "filterLocale", dragdrop: "dragdrop", ariaFilterLabel: "ariaFilterLabel" }, outputs: { selectionChange: "selectionChange", onReorder: "onReorder", onSelectionChange: "onSelectionChange", onFilterEvent: "onFilterEvent" }, decls: 12, vars: 12, consts: [[3, "ngClass", "ngStyle"], [1, "ui-orderlist-controls"], ["type", "button", "pButton", "", "icon", "pi pi-angle-up", 3, "click"], ["type", "button", "pButton", "", "icon", "pi pi-angle-double-up", 3, "click"], ["type", "button", "pButton", "", "icon", "pi pi-angle-down", 3, "click"], ["type", "button", "pButton", "", "icon", "pi pi-angle-double-down", 3, "click"], [1, "ui-orderlist-list-container"], ["class", "ui-orderlist-caption ui-widget-header ui-corner-top", 4, "ngIf"], ["class", "ui-orderlist-filter-container ui-widget-content", 4, "ngIf"], [1, "ui-widget-content", "ui-orderlist-list", "ui-corner-bottom", 3, "ngStyle", "dragover"], ["listelement", ""], ["ngFor", "", 3, "ngForTrackBy", "ngForOf"], [1, "ui-orderlist-caption", "ui-widget-header", "ui-corner-top"], [1, "ui-orderlist-filter-container", "ui-widget-content"], ["type", "text", "role", "textbox", 1, "ui-inputtext", "ui-widget", "ui-state-default", "ui-corner-all", 3, "keyup"], [1, "ui-orderlist-filter-icon", "pi", "pi-search"], ["class", "ui-orderlist-droppoint", 3, "ngClass", "dragover", "drop", "dragleave", 4, "ngIf"], ["tabindex", "0", "role", "option", 1, "ui-orderlist-item", 3, "ngClass", "draggable", "click", "touchend", "keydown", "dragstart", "dragend"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [1, "ui-orderlist-droppoint", 3, "ngClass", "dragover", "drop", "dragleave"]], template: function OrderList_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵelementStart(1, "div", 1);
        ɵngcc0.ɵɵelementStart(2, "button", 2);
        ɵngcc0.ɵɵlistener("click", function OrderList_Template_button_click_2_listener($event) { return ctx.moveUp($event); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(3, "button", 3);
        ɵngcc0.ɵɵlistener("click", function OrderList_Template_button_click_3_listener($event) { return ctx.moveTop($event); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(4, "button", 4);
        ɵngcc0.ɵɵlistener("click", function OrderList_Template_button_click_4_listener($event) { return ctx.moveDown($event); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(5, "button", 5);
        ɵngcc0.ɵɵlistener("click", function OrderList_Template_button_click_5_listener($event) { return ctx.moveBottom($event); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(6, "div", 6);
        ɵngcc0.ɵɵtemplate(7, OrderList_div_7_Template, 2, 1, "div", 7);
        ɵngcc0.ɵɵtemplate(8, OrderList_div_8_Template, 3, 2, "div", 8);
        ɵngcc0.ɵɵelementStart(9, "ul", 9, 10);
        ɵngcc0.ɵɵlistener("dragover", function OrderList_Template_ul_dragover_9_listener($event) { return ctx.onListMouseMove($event); });
        ɵngcc0.ɵɵtemplate(11, OrderList_ng_template_11_Template, 4, 14, "ng-template", 11);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(9, _c4, ctx.controlsPosition === "left", ctx.controlsPosition === "right"))("ngStyle", ctx.style);
        ɵngcc0.ɵɵadvance(7);
        ɵngcc0.ɵɵproperty("ngIf", ctx.header);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.filterBy);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngStyle", ctx.listStyle);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngForTrackBy", ctx.trackBy)("ngForOf", ctx.value);
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle, ɵngcc2.ButtonDirective, ɵngcc1.NgIf, ɵngcc1.NgForOf, ɵngcc1.NgTemplateOutlet], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(OrderList, [{
        type: Component,
        args: [{
                selector: 'p-orderList',
                template: "\n        <div [ngClass]=\"{'ui-orderlist ui-widget': true, 'ui-orderlist-controls-left': controlsPosition === 'left',\n                    'ui-orderlist-controls-right': controlsPosition === 'right'}\" [ngStyle]=\"style\" [class]=\"styleClass\">\n            <div class=\"ui-orderlist-controls\">\n                <button type=\"button\" pButton icon=\"pi pi-angle-up\" (click)=\"moveUp($event)\"></button>\n                <button type=\"button\" pButton icon=\"pi pi-angle-double-up\" (click)=\"moveTop($event)\"></button>\n                <button type=\"button\" pButton icon=\"pi pi-angle-down\" (click)=\"moveDown($event)\"></button>\n                <button type=\"button\" pButton icon=\"pi pi-angle-double-down\" (click)=\"moveBottom($event)\"></button>\n            </div>\n            <div class=\"ui-orderlist-list-container\">\n                <div class=\"ui-orderlist-caption ui-widget-header ui-corner-top\" *ngIf=\"header\">{{header}}</div>\n                <div class=\"ui-orderlist-filter-container ui-widget-content\" *ngIf=\"filterBy\">\n                    <input type=\"text\" role=\"textbox\" (keyup)=\"onFilterKeyup($event)\" class=\"ui-inputtext ui-widget ui-state-default ui-corner-all\" [attr.placeholder]=\"filterPlaceholder\" [attr.aria-label]=\"ariaFilterLabel\">\n                    <span class=\"ui-orderlist-filter-icon pi pi-search\"></span>\n                </div>\n                <ul #listelement class=\"ui-widget-content ui-orderlist-list ui-corner-bottom\" [ngStyle]=\"listStyle\" (dragover)=\"onListMouseMove($event)\">\n                    <ng-template ngFor [ngForTrackBy]=\"trackBy\" let-item [ngForOf]=\"value\" let-i=\"index\" let-l=\"last\">\n                        <li class=\"ui-orderlist-droppoint\" *ngIf=\"dragdrop && isItemVisible(item)\" (dragover)=\"onDragOver($event, i)\" (drop)=\"onDrop($event, i)\" (dragleave)=\"onDragLeave($event)\"\n                            [ngClass]=\"{'ui-orderlist-droppoint-highlight': (i === dragOverItemIndex)}\"></li>\n                        <li class=\"ui-orderlist-item\" tabindex=\"0\"\n                            [ngClass]=\"{'ui-state-highlight':isSelected(item)}\"\n                            (click)=\"onItemClick($event,item,i)\" (touchend)=\"onItemTouchEnd($event)\" (keydown)=\"onItemKeydown($event,item,i)\"\n                            [style.display]=\"isItemVisible(item) ? 'block' : 'none'\" role=\"option\" [attr.aria-selected]=\"isSelected(item)\"\n                            [draggable]=\"dragdrop\" (dragstart)=\"onDragStart($event, i)\" (dragend)=\"onDragEnd($event)\">\n                            <ng-container *ngTemplateOutlet=\"itemTemplate; context: {$implicit: item, index: i}\"></ng-container>\n                        </li>\n                        <li class=\"ui-orderlist-droppoint\" *ngIf=\"dragdrop && l\" (dragover)=\"onDragOver($event, i + 1)\" (drop)=\"onDrop($event, i + 1)\" (dragleave)=\"onDragLeave($event)\"\n                            [ngClass]=\"{'ui-orderlist-droppoint-highlight': (i + 1 === dragOverItemIndex)}\"></li>\n                    </ng-template>\n                </ul>\n            </div>\n        </div>\n    ",
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }]; }, { metaKeySelection: [{
            type: Input
        }], controlsPosition: [{
            type: Input
        }], filterMatchMode: [{
            type: Input
        }], selectionChange: [{
            type: Output
        }], trackBy: [{
            type: Input
        }], onReorder: [{
            type: Output
        }], onSelectionChange: [{
            type: Output
        }], onFilterEvent: [{
            type: Output
        }], selection: [{
            type: Input
        }], value: [{
            type: Input
        }], header: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], listStyle: [{
            type: Input
        }], responsive: [{
            type: Input
        }], filterBy: [{
            type: Input
        }], filterPlaceholder: [{
            type: Input
        }], filterLocale: [{
            type: Input
        }], dragdrop: [{
            type: Input
        }], ariaFilterLabel: [{
            type: Input
        }], listViewChild: [{
            type: ViewChild,
            args: ['listelement']
        }], templates: [{
            type: ContentChildren,
            args: [PrimeTemplate]
        }] }); })();
    return OrderList;
}());
var OrderListModule = /** @class */ (function () {
    function OrderListModule() {
    }
OrderListModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: OrderListModule });
OrderListModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function OrderListModule_Factory(t) { return new (t || OrderListModule)(); }, imports: [[CommonModule, ButtonModule, SharedModule],
        SharedModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(OrderListModule, { declarations: function () { return [OrderList]; }, imports: function () { return [CommonModule, ButtonModule, SharedModule]; }, exports: function () { return [OrderList,
        SharedModule]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(OrderListModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule, ButtonModule, SharedModule],
                exports: [OrderList, SharedModule],
                declarations: [OrderList]
            }]
    }], function () { return []; }, null); })();
    return OrderListModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { OrderList, OrderListModule };

//# sourceMappingURL=primeng-orderlist.js.map