import { ElementRef, Renderer2, ChangeDetectorRef, Input, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomHandler } from 'primeng/dom';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

function Lightbox_div_0_a_1_Template(rf, ctx) { if (rf & 1) {
    var _r8 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "a", 19);
    ɵngcc0.ɵɵlistener("click", function Lightbox_div_0_a_1_Template_a_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r8); var image_r5 = ctx.$implicit; var i_r6 = ctx.index; var ctx_r7 = ɵngcc0.ɵɵnextContext(2); var _r2 = ɵngcc0.ɵɵreference(7); return ctx_r7.onImageClick($event, image_r5, i_r6, _r2); });
    ɵngcc0.ɵɵelement(1, "img", 20);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var image_r5 = ctx.$implicit;
    ɵngcc0.ɵɵproperty("href", image_r5.source, ɵngcc0.ɵɵsanitizeUrl);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("src", image_r5.thumbnail, ɵngcc0.ɵɵsanitizeUrl)("title", image_r5.title)("alt", image_r5.alt);
} }
function Lightbox_div_0_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 17);
    ɵngcc0.ɵɵtemplate(1, Lightbox_div_0_a_1_Template, 2, 4, "a", 18);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r0 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵclassMap(ctx_r0.styleClass);
    ɵngcc0.ɵɵproperty("ngStyle", ctx_r0.style);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngForOf", ctx_r0.images);
} }
function Lightbox_span_1_Template(rf, ctx) { if (rf & 1) {
    var _r10 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "span", 21);
    ɵngcc0.ɵɵlistener("click", function Lightbox_span_1_Template_span_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r10); var ctx_r9 = ɵngcc0.ɵɵnextContext(); var _r2 = ɵngcc0.ɵɵreference(7); return ctx_r9.onLinkClick($event, _r2); });
    ɵngcc0.ɵɵprojection(1, 1);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵclassMap(ctx_r1.styleClass);
    ɵngcc0.ɵɵproperty("ngStyle", ctx_r1.style);
} }
var _c0 = ["*", [["a"]]];
var _c1 = function (a0) { return { "ui-lightbox-loading": a0 }; };
var _c2 = function (a0) { return { "ui-helper-hidden": a0 }; };
var _c3 = ["*", "a"];
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var Lightbox = /** @class */ (function () {
    function Lightbox(el, renderer, cd) {
        this.el = el;
        this.renderer = renderer;
        this.cd = cd;
        this.type = 'image';
        this.effectDuration = '500ms';
        this.autoZIndex = true;
        this.baseZIndex = 0;
        this.closeOnEscape = true;
    }
    Lightbox.prototype.onImageClick = function (event, image, i, content) {
        this.index = i;
        this.loading = true;
        content.style.width = 32 + 'px';
        content.style.height = 32 + 'px';
        this.preventDocumentClickListener = true;
        this.show();
        this.displayImage(image);
        event.preventDefault();
    };
    Lightbox.prototype.ngAfterViewInit = function () {
        this.panel = DomHandler.findSingle(this.el.nativeElement, '.ui-lightbox ');
        if (this.appendTo) {
            if (this.appendTo === 'body')
                document.body.appendChild(this.panel);
            else
                DomHandler.appendChild(this.panel, this.appendTo);
        }
    };
    Lightbox.prototype.onLinkClick = function (event, content) {
        this.preventDocumentClickListener = true;
        this.show();
        event.preventDefault();
    };
    Lightbox.prototype.displayImage = function (image) {
        var _this = this;
        setTimeout(function () {
            _this.cd.markForCheck();
            _this.currentImage = image;
            _this.captionText = image.title;
            _this.center();
        }, 1000);
    };
    Lightbox.prototype.show = function () {
        this.mask = document.createElement('div');
        DomHandler.addMultipleClasses(this.mask, 'ui-widget-overlay ui-dialog-mask');
        document.body.appendChild(this.mask);
        if (this.autoZIndex) {
            this.zindex = this.baseZIndex + (++DomHandler.zindex);
        }
        this.mask.style.zIndex = this.zindex - 1;
        this.center();
        this.visible = true;
        this.bindGlobalListeners();
    };
    Lightbox.prototype.hide = function (event) {
        this.captionText = null;
        this.index = null;
        this.currentImage = null;
        this.visible = false;
        if (this.mask) {
            document.body.removeChild(this.mask);
            this.mask = null;
        }
        this.unbindGlobalListeners();
        event.preventDefault();
    };
    Lightbox.prototype.center = function () {
        var elementWidth = DomHandler.getOuterWidth(this.panel);
        var elementHeight = DomHandler.getOuterHeight(this.panel);
        if (elementWidth == 0 && elementHeight == 0) {
            this.panel.style.visibility = 'hidden';
            this.panel.style.display = 'block';
            elementWidth = DomHandler.getOuterWidth(this.panel);
            elementHeight = DomHandler.getOuterHeight(this.panel);
            this.panel.style.display = 'none';
            this.panel.style.visibility = 'visible';
        }
    };
    Lightbox.prototype.onImageLoad = function (event, content) {
        var _this = this;
        var image = event.target;
        image.style.visibility = 'hidden';
        image.style.display = 'block';
        var imageWidth = DomHandler.getOuterWidth(image);
        var imageHeight = DomHandler.getOuterHeight(image);
        image.style.display = 'none';
        image.style.visibility = 'visible';
        content.style.width = imageWidth + 'px';
        content.style.height = imageHeight + 'px';
        this.panel.style.left = parseInt(this.panel.style.left) + (DomHandler.getOuterWidth(this.panel) - imageWidth) / 2 + 'px';
        this.panel.style.top = parseInt(this.panel.style.top) + (DomHandler.getOuterHeight(this.panel) - imageHeight) / 2 + 'px';
        setTimeout(function () {
            _this.cd.markForCheck();
            DomHandler.fadeIn(image, 500);
            image.style.display = 'block';
            //this.captionText = this.currentImage.title;
            _this.loading = false;
        }, parseInt(this.effectDuration));
    };
    Lightbox.prototype.prev = function (placeholder) {
        this.captionText = null;
        this.loading = true;
        placeholder.style.display = 'none';
        if (this.index > 0) {
            this.displayImage(this.images[--this.index]);
        }
    };
    Lightbox.prototype.next = function (placeholder) {
        this.captionText = null;
        this.loading = true;
        placeholder.style.display = 'none';
        if (this.index <= (this.images.length - 1)) {
            this.displayImage(this.images[++this.index]);
        }
    };
    Lightbox.prototype.bindGlobalListeners = function () {
        var _this = this;
        this.documentClickListener = this.renderer.listen('document', 'click', function (event) {
            if (!_this.preventDocumentClickListener && _this.visible) {
                _this.hide(event);
            }
            _this.preventDocumentClickListener = false;
            _this.cd.markForCheck();
        });
        if (this.closeOnEscape && !this.documentEscapeListener) {
            this.documentEscapeListener = this.renderer.listen('document', 'keydown', function (event) {
                if (event.which == 27) {
                    if (parseInt(_this.panel.style.zIndex) === (DomHandler.zindex + _this.baseZIndex)) {
                        _this.hide(event);
                    }
                }
            });
        }
    };
    Lightbox.prototype.unbindGlobalListeners = function () {
        if (this.documentEscapeListener) {
            this.documentEscapeListener();
            this.documentEscapeListener = null;
        }
        if (this.documentClickListener) {
            this.documentClickListener();
            this.documentClickListener = null;
        }
    };
    Object.defineProperty(Lightbox.prototype, "leftVisible", {
        get: function () {
            return this.images && this.images.length && this.index != 0 && !this.loading;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Lightbox.prototype, "rightVisible", {
        get: function () {
            return this.images && this.images.length && this.index < (this.images.length - 1) && !this.loading;
        },
        enumerable: true,
        configurable: true
    });
    Lightbox.prototype.ngOnDestroy = function () {
        this.unbindGlobalListeners();
        if (this.appendTo) {
            this.el.nativeElement.appendChild(this.panel);
        }
    };
    Lightbox.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 },
        { type: ChangeDetectorRef }
    ]; };
    __decorate([
        Input()
    ], Lightbox.prototype, "images", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "type", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "style", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "appendTo", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "easing", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "effectDuration", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "autoZIndex", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "baseZIndex", void 0);
    __decorate([
        Input()
    ], Lightbox.prototype, "closeOnEscape", void 0);
Lightbox.ɵfac = function Lightbox_Factory(t) { return new (t || Lightbox)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.Renderer2), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ChangeDetectorRef)); };
Lightbox.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: Lightbox, selectors: [["p-lightbox"]], inputs: { type: "type", effectDuration: "effectDuration", autoZIndex: "autoZIndex", baseZIndex: "baseZIndex", closeOnEscape: "closeOnEscape", images: "images", style: "style", styleClass: "styleClass", appendTo: "appendTo", easing: "easing" }, ngContentSelectors: _c3, decls: 19, vars: 35, consts: [[3, "ngStyle", "class", 4, "ngIf"], [3, "ngStyle", "class", "click", 4, "ngIf"], [1, "ui-lightbox", "ui-widget", "ui-corner-all", "ui-shadow", 3, "ngClass", "click"], [1, "ui-lightbox-content-wrapper"], [1, "ui-state-default", "ui-lightbox-nav-left", "ui-corner-right", 3, "ngClass", "click"], [1, "ui-lightbox-nav-icon", "pi", "pi-chevron-left"], [1, "ui-lightbox-content", "ui-corner-all"], ["content", ""], [2, "display", "none", 3, "src", "load"], ["img", ""], [1, "ui-state-default", "ui-lightbox-nav-right", "ui-corner-left", "ui-helper-hidden", 3, "ngClass", "click"], [1, "ui-lightbox-nav-icon", "pi", "pi-chevron-right"], [1, "ui-lightbox-caption", "ui-widget-header"], [1, "ui-lightbox-caption-text"], ["tabindex", "0", 1, "ui-lightbox-close", "ui-corner-all", 3, "click", "keydown.enter"], [1, "pi", "pi-times"], [2, "clear", "both"], [3, "ngStyle"], [3, "href", "click", 4, "ngFor", "ngForOf"], [3, "href", "click"], [3, "src", "title", "alt"], [3, "ngStyle", "click"]], template: function Lightbox_Template(rf, ctx) { if (rf & 1) {
        var _r11 = ɵngcc0.ɵɵgetCurrentView();
        ɵngcc0.ɵɵprojectionDef(_c0);
        ɵngcc0.ɵɵtemplate(0, Lightbox_div_0_Template, 2, 4, "div", 0);
        ɵngcc0.ɵɵtemplate(1, Lightbox_span_1_Template, 2, 3, "span", 1);
        ɵngcc0.ɵɵelementStart(2, "div", 2);
        ɵngcc0.ɵɵlistener("click", function Lightbox_Template_div_click_2_listener() { return ctx.preventDocumentClickListener = true; });
        ɵngcc0.ɵɵelementStart(3, "div", 3);
        ɵngcc0.ɵɵelementStart(4, "a", 4);
        ɵngcc0.ɵɵlistener("click", function Lightbox_Template_a_click_4_listener() { ɵngcc0.ɵɵrestoreView(_r11); var _r3 = ɵngcc0.ɵɵreference(9); return ctx.prev(_r3); });
        ɵngcc0.ɵɵelement(5, "span", 5);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(6, "div", 6, 7);
        ɵngcc0.ɵɵelementStart(8, "img", 8, 9);
        ɵngcc0.ɵɵlistener("load", function Lightbox_Template_img_load_8_listener($event) { ɵngcc0.ɵɵrestoreView(_r11); var _r2 = ɵngcc0.ɵɵreference(7); return ctx.onImageLoad($event, _r2); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵprojection(10);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(11, "a", 10);
        ɵngcc0.ɵɵlistener("click", function Lightbox_Template_a_click_11_listener() { ɵngcc0.ɵɵrestoreView(_r11); var _r3 = ɵngcc0.ɵɵreference(9); return ctx.next(_r3); });
        ɵngcc0.ɵɵelement(12, "span", 11);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(13, "div", 12);
        ɵngcc0.ɵɵelementStart(14, "span", 13);
        ɵngcc0.ɵɵtext(15);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(16, "a", 14);
        ɵngcc0.ɵɵlistener("click", function Lightbox_Template_a_click_16_listener($event) { return ctx.hide($event); })("keydown.enter", function Lightbox_Template_a_keydown_enter_16_listener($event) { return ctx.hide($event); });
        ɵngcc0.ɵɵelement(17, "span", 15);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelement(18, "div", 16);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵproperty("ngIf", ctx.type == "image");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.type == "content");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵstyleProp("display", ctx.visible ? "block" : "none")("z-index", ctx.zindex)("transition-property", "all")("transition-duration", ctx.effectDuration)("transition-timing-function", ctx.easing);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(29, _c1, ctx.loading));
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵstyleProp("z-index", ctx.zindex + 1);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(31, _c2, !ctx.leftVisible));
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵstyleProp("transition-property", "width,height")("transition-duration", ctx.effectDuration)("transition-timing-function", ctx.easing);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("src", ctx.currentImage ? ctx.currentImage.source || "" : "", ɵngcc0.ɵɵsanitizeUrl);
        ɵngcc0.ɵɵadvance(3);
        ɵngcc0.ɵɵstyleProp("z-index", ctx.zindex + 1);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(33, _c2, !ctx.rightVisible));
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵstyleProp("display", ctx.captionText ? "block" : "none");
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵtextInterpolate(ctx.captionText);
    } }, directives: [ɵngcc1.NgIf, ɵngcc1.NgClass, ɵngcc1.NgStyle, ɵngcc1.NgForOf], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(Lightbox, [{
        type: Component,
        args: [{
                selector: 'p-lightbox',
                template: "\n        <div [ngStyle]=\"style\" [class]=\"styleClass\" *ngIf=\"(type == 'image')\">\n            <a *ngFor=\"let image of images; let i = index;\" [href]=\"image.source\" (click)=\"onImageClick($event,image,i,content)\">\n                <img [src]=\"image.thumbnail\" [title]=\"image.title\" [alt]=\"image.alt\">\n            </a>\n        </div>\n        <span [ngStyle]=\"style\" [class]=\"styleClass\" *ngIf=\"(type == 'content')\" (click)=\"onLinkClick($event,content)\">\n            <ng-content select=\"a\"></ng-content>\n        </span>\n        <div class=\"ui-lightbox ui-widget ui-corner-all ui-shadow\" [style.display]=\"visible ? 'block' : 'none'\" [style.zIndex]=\"zindex\"\n            [ngClass]=\"{'ui-lightbox-loading': loading}\"\n            [style.transitionProperty]=\"'all'\" [style.transitionDuration]=\"effectDuration\" [style.transitionTimingFunction]=\"easing\" (click)=\"preventDocumentClickListener=true\">\n           <div class=\"ui-lightbox-content-wrapper\">\n              <a class=\"ui-state-default ui-lightbox-nav-left ui-corner-right\" [style.zIndex]=\"zindex + 1\" (click)=\"prev(img)\"\n                [ngClass]=\"{'ui-helper-hidden':!leftVisible}\"><span class=\"ui-lightbox-nav-icon pi pi-chevron-left\"></span></a>\n              <div #content class=\"ui-lightbox-content ui-corner-all\" \n                [style.transitionProperty]=\"'width,height'\" [style.transitionDuration]=\"effectDuration\" [style.transitionTimingFunction]=\"easing\">\n                <img #img [src]=\"currentImage ? currentImage.source||'' : ''\" (load)=\"onImageLoad($event,content)\" style=\"display:none\">\n                <ng-content></ng-content>\n              </div>\n              <a class=\"ui-state-default ui-lightbox-nav-right ui-corner-left ui-helper-hidden\" [style.zIndex]=\"zindex + 1\" (click)=\"next(img)\"\n                [ngClass]=\"{'ui-helper-hidden':!rightVisible}\"><span class=\"ui-lightbox-nav-icon pi pi-chevron-right\"></span></a>\n           </div>\n           <div class=\"ui-lightbox-caption ui-widget-header\" [style.display]=\"captionText ? 'block' : 'none'\">\n              <span class=\"ui-lightbox-caption-text\">{{captionText}}</span><a class=\"ui-lightbox-close ui-corner-all\" tabindex=\"0\" (click)=\"hide($event)\" (keydown.enter)=\"hide($event)\"><span class=\"pi pi-times\"></span></a>\n              <div style=\"clear:both\"></div>\n           </div>\n        </div>\n    ",
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }, { type: ɵngcc0.Renderer2 }, { type: ɵngcc0.ChangeDetectorRef }]; }, { type: [{
            type: Input
        }], effectDuration: [{
            type: Input
        }], autoZIndex: [{
            type: Input
        }], baseZIndex: [{
            type: Input
        }], closeOnEscape: [{
            type: Input
        }], images: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], appendTo: [{
            type: Input
        }], easing: [{
            type: Input
        }] }); })();
    return Lightbox;
}());
var LightboxModule = /** @class */ (function () {
    function LightboxModule() {
    }
LightboxModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: LightboxModule });
LightboxModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function LightboxModule_Factory(t) { return new (t || LightboxModule)(); }, imports: [[CommonModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(LightboxModule, { declarations: function () { return [Lightbox]; }, imports: function () { return [CommonModule]; }, exports: function () { return [Lightbox]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(LightboxModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [Lightbox],
                declarations: [Lightbox]
            }]
    }], function () { return []; }, null); })();
    return LightboxModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { Lightbox, LightboxModule };

//# sourceMappingURL=primeng-lightbox.js.map