import { ElementRef, Input, HostListener, Directive, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomHandler } from 'primeng/dom';

import * as ɵngcc0 from '@angular/core';
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var FocusTrap = /** @class */ (function () {
    function FocusTrap(el) {
        this.el = el;
    }
    FocusTrap.prototype.onkeydown = function (e) {
        if (this.pFocusTrapDisabled !== true) {
            e.preventDefault();
            var focusableElements = DomHandler.getFocusableElements(this.el.nativeElement);
            if (focusableElements && focusableElements.length > 0) {
                if (!document.activeElement) {
                    focusableElements[0].focus();
                }
                else {
                    var focusedIndex = focusableElements.indexOf(document.activeElement);
                    if (e.shiftKey) {
                        if (focusedIndex == -1 || focusedIndex === 0)
                            focusableElements[focusableElements.length - 1].focus();
                        else
                            focusableElements[focusedIndex - 1].focus();
                    }
                    else {
                        if (focusedIndex == -1 || focusedIndex === (focusableElements.length - 1))
                            focusableElements[0].focus();
                        else
                            focusableElements[focusedIndex + 1].focus();
                    }
                }
            }
        }
    };
    FocusTrap.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        Input()
    ], FocusTrap.prototype, "pFocusTrapDisabled", void 0);
    __decorate([
        HostListener('keydown.tab', ['$event']),
        HostListener('keydown.shift.tab', ['$event'])
    ], FocusTrap.prototype, "onkeydown", null);
FocusTrap.ɵfac = function FocusTrap_Factory(t) { return new (t || FocusTrap)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef)); };
FocusTrap.ɵdir = ɵngcc0.ɵɵdefineDirective({ type: FocusTrap, selectors: [["", "pFocusTrap", ""]], hostBindings: function FocusTrap_HostBindings(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵlistener("keydown.tab", function FocusTrap_keydown_tab_HostBindingHandler($event) { return ctx.onkeydown($event); })("keydown.shift.tab", function FocusTrap_keydown_shift_tab_HostBindingHandler($event) { return ctx.onkeydown($event); });
    } }, inputs: { pFocusTrapDisabled: "pFocusTrapDisabled" } });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(FocusTrap, [{
        type: Directive,
        args: [{
                selector: '[pFocusTrap]'
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }]; }, { onkeydown: [{
            type: HostListener,
            args: ['keydown.tab', ['$event']]
        }, {
            type: HostListener,
            args: ['keydown.shift.tab', ['$event']]
        }], pFocusTrapDisabled: [{
            type: Input
        }] }); })();
    return FocusTrap;
}());
var FocusTrapModule = /** @class */ (function () {
    function FocusTrapModule() {
    }
FocusTrapModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: FocusTrapModule });
FocusTrapModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function FocusTrapModule_Factory(t) { return new (t || FocusTrapModule)(); }, imports: [[CommonModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(FocusTrapModule, { declarations: function () { return [FocusTrap]; }, imports: function () { return [CommonModule]; }, exports: function () { return [FocusTrap]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(FocusTrapModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [FocusTrap],
                declarations: [FocusTrap]
            }]
    }], function () { return []; }, null); })();
    return FocusTrapModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { FocusTrap, FocusTrapModule };

//# sourceMappingURL=primeng-focustrap.js.map