import { forwardRef, EventEmitter, ElementRef, Output, ContentChild, Input, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { Header, SharedModule } from 'primeng/api';
import { DomHandler } from 'primeng/dom';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import * as Quill from 'quill';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

function Editor_div_1_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 3);
    ɵngcc0.ɵɵprojection(1);
    ɵngcc0.ɵɵelementEnd();
} }
function Editor_div_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 3);
    ɵngcc0.ɵɵelementStart(1, "span", 4);
    ɵngcc0.ɵɵelementStart(2, "select", 5);
    ɵngcc0.ɵɵelementStart(3, "option", 6);
    ɵngcc0.ɵɵtext(4, "Heading");
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(5, "option", 7);
    ɵngcc0.ɵɵtext(6, "Subheading");
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(7, "option", 8);
    ɵngcc0.ɵɵtext(8, "Normal");
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(9, "select", 9);
    ɵngcc0.ɵɵelementStart(10, "option", 8);
    ɵngcc0.ɵɵtext(11, "Sans Serif");
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(12, "option", 10);
    ɵngcc0.ɵɵtext(13, "Serif");
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(14, "option", 11);
    ɵngcc0.ɵɵtext(15, "Monospace");
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(16, "span", 4);
    ɵngcc0.ɵɵelement(17, "button", 12);
    ɵngcc0.ɵɵelement(18, "button", 13);
    ɵngcc0.ɵɵelement(19, "button", 14);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(20, "span", 4);
    ɵngcc0.ɵɵelement(21, "select", 15);
    ɵngcc0.ɵɵelement(22, "select", 16);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(23, "span", 4);
    ɵngcc0.ɵɵelement(24, "button", 17);
    ɵngcc0.ɵɵelement(25, "button", 18);
    ɵngcc0.ɵɵelementStart(26, "select", 19);
    ɵngcc0.ɵɵelement(27, "option", 8);
    ɵngcc0.ɵɵelement(28, "option", 20);
    ɵngcc0.ɵɵelement(29, "option", 21);
    ɵngcc0.ɵɵelement(30, "option", 22);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(31, "span", 4);
    ɵngcc0.ɵɵelement(32, "button", 23);
    ɵngcc0.ɵɵelement(33, "button", 24);
    ɵngcc0.ɵɵelement(34, "button", 25);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(35, "span", 4);
    ɵngcc0.ɵɵelement(36, "button", 26);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
} }
var _c0 = [[["p-header"]]];
var _c1 = ["p-header"];
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var EDITOR_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return Editor; }),
    multi: true
};
var Editor = /** @class */ (function () {
    function Editor(el) {
        this.el = el;
        this.onTextChange = new EventEmitter();
        this.onSelectionChange = new EventEmitter();
        this.onInit = new EventEmitter();
        this.onModelChange = function () { };
        this.onModelTouched = function () { };
    }
    Editor.prototype.ngAfterViewInit = function () {
        var _this = this;
        var editorElement = DomHandler.findSingle(this.el.nativeElement, 'div.ui-editor-content');
        var toolbarElement = DomHandler.findSingle(this.el.nativeElement, 'div.ui-editor-toolbar');
        var defaultModule = { toolbar: toolbarElement };
        var modules = this.modules ? __assign(__assign({}, defaultModule), this.modules) : defaultModule;
        this.quill = new Quill(editorElement, {
            modules: modules,
            placeholder: this.placeholder,
            readOnly: this.readonly,
            theme: 'snow',
            formats: this.formats,
            bounds: this.bounds,
            debug: this.debug,
            scrollingContainer: this.scrollingContainer
        });
        if (this.value) {
            this.quill.pasteHTML(this.value);
        }
        this.quill.on('text-change', function (delta, oldContents, source) {
            if (source === 'user') {
                var html = editorElement.children[0].innerHTML;
                var text = _this.quill.getText().trim();
                if (html === '<p><br></p>') {
                    html = null;
                }
                _this.onTextChange.emit({
                    htmlValue: html,
                    textValue: text,
                    delta: delta,
                    source: source
                });
                _this.onModelChange(html);
                _this.onModelTouched();
            }
        });
        this.quill.on('selection-change', function (range, oldRange, source) {
            _this.onSelectionChange.emit({
                range: range,
                oldRange: oldRange,
                source: source
            });
        });
        this.onInit.emit({
            editor: this.quill
        });
    };
    Editor.prototype.writeValue = function (value) {
        this.value = value;
        if (this.quill) {
            if (value)
                this.quill.pasteHTML(value);
            else
                this.quill.setText('');
        }
    };
    Editor.prototype.registerOnChange = function (fn) {
        this.onModelChange = fn;
    };
    Editor.prototype.registerOnTouched = function (fn) {
        this.onModelTouched = fn;
    };
    Editor.prototype.getQuill = function () {
        return this.quill;
    };
    Object.defineProperty(Editor.prototype, "readonly", {
        get: function () {
            return this._readonly;
        },
        set: function (val) {
            this._readonly = val;
            if (this.quill) {
                if (this._readonly)
                    this.quill.disable();
                else
                    this.quill.enable();
            }
        },
        enumerable: true,
        configurable: true
    });
    Editor.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        Output()
    ], Editor.prototype, "onTextChange", void 0);
    __decorate([
        Output()
    ], Editor.prototype, "onSelectionChange", void 0);
    __decorate([
        ContentChild(Header)
    ], Editor.prototype, "toolbar", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "style", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "placeholder", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "formats", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "modules", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "bounds", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "scrollingContainer", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "debug", void 0);
    __decorate([
        Output()
    ], Editor.prototype, "onInit", void 0);
    __decorate([
        Input()
    ], Editor.prototype, "readonly", null);
Editor.ɵfac = function Editor_Factory(t) { return new (t || Editor)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef)); };
Editor.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: Editor, selectors: [["p-editor"]], contentQueries: function Editor_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        ɵngcc0.ɵɵcontentQuery(dirIndex, Header, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.toolbar = _t.first);
    } }, inputs: { readonly: "readonly", style: "style", styleClass: "styleClass", placeholder: "placeholder", formats: "formats", modules: "modules", bounds: "bounds", scrollingContainer: "scrollingContainer", debug: "debug" }, outputs: { onTextChange: "onTextChange", onSelectionChange: "onSelectionChange", onInit: "onInit" }, features: [ɵngcc0.ɵɵProvidersFeature([EDITOR_VALUE_ACCESSOR])], ngContentSelectors: _c1, decls: 4, vars: 6, consts: [[3, "ngClass"], ["class", "ui-editor-toolbar ui-widget-header ui-corner-top", 4, "ngIf"], [1, "ui-editor-content", 3, "ngStyle"], [1, "ui-editor-toolbar", "ui-widget-header", "ui-corner-top"], [1, "ql-formats"], [1, "ql-header"], ["value", "1"], ["value", "2"], ["selected", ""], [1, "ql-font"], ["value", "serif"], ["value", "monospace"], ["aria-label", "Bold", 1, "ql-bold"], ["aria-label", "Italic", 1, "ql-italic"], ["aria-label", "Underline", 1, "ql-underline"], [1, "ql-color"], [1, "ql-background"], ["value", "ordered", "aria-label", "Ordered List", 1, "ql-list"], ["value", "bullet", "aria-label", "Unordered List", 1, "ql-list"], [1, "ql-align"], ["value", "center"], ["value", "right"], ["value", "justify"], ["aria-label", "Insert Link", 1, "ql-link"], ["aria-label", "Insert Image", 1, "ql-image"], ["aria-label", "Insert Code Block", 1, "ql-code-block"], ["aria-label", "Remove Styles", 1, "ql-clean"]], template: function Editor_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c0);
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵtemplate(1, Editor_div_1_Template, 2, 0, "div", 1);
        ɵngcc0.ɵɵtemplate(2, Editor_div_2_Template, 37, 0, "div", 1);
        ɵngcc0.ɵɵelement(3, "div", 2);
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", "ui-widget ui-editor-container ui-corner-all");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.toolbar);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", !ctx.toolbar);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngStyle", ctx.style);
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgIf, ɵngcc1.NgStyle], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(Editor, [{
        type: Component,
        args: [{
                selector: 'p-editor',
                template: "\n        <div [ngClass]=\"'ui-widget ui-editor-container ui-corner-all'\" [class]=\"styleClass\">\n            <div class=\"ui-editor-toolbar ui-widget-header ui-corner-top\" *ngIf=\"toolbar\">\n                <ng-content select=\"p-header\"></ng-content>\n            </div>\n            <div class=\"ui-editor-toolbar ui-widget-header ui-corner-top\" *ngIf=\"!toolbar\">\n                <span class=\"ql-formats\">\n                    <select class=\"ql-header\">\n                      <option value=\"1\">Heading</option>\n                      <option value=\"2\">Subheading</option>\n                      <option selected>Normal</option>\n                    </select>\n                    <select class=\"ql-font\">\n                      <option selected>Sans Serif</option>\n                      <option value=\"serif\">Serif</option>\n                      <option value=\"monospace\">Monospace</option>\n                    </select>\n                </span>\n                <span class=\"ql-formats\">\n                    <button class=\"ql-bold\" aria-label=\"Bold\"></button>\n                    <button class=\"ql-italic\" aria-label=\"Italic\"></button>\n                    <button class=\"ql-underline\" aria-label=\"Underline\"></button>\n                </span>\n                <span class=\"ql-formats\">\n                    <select class=\"ql-color\"></select>\n                    <select class=\"ql-background\"></select>\n                </span>\n                <span class=\"ql-formats\">\n                    <button class=\"ql-list\" value=\"ordered\" aria-label=\"Ordered List\"></button>\n                    <button class=\"ql-list\" value=\"bullet\" aria-label=\"Unordered List\"></button>\n                    <select class=\"ql-align\">\n                        <option selected></option>\n                        <option value=\"center\"></option>\n                        <option value=\"right\"></option>\n                        <option value=\"justify\"></option>\n                    </select>\n                </span>\n                <span class=\"ql-formats\">\n                    <button class=\"ql-link\" aria-label=\"Insert Link\"></button>\n                    <button class=\"ql-image\" aria-label=\"Insert Image\"></button>\n                    <button class=\"ql-code-block\" aria-label=\"Insert Code Block\"></button>\n                </span>\n                <span class=\"ql-formats\">\n                    <button class=\"ql-clean\" aria-label=\"Remove Styles\"></button>\n                </span>\n            </div>\n            <div class=\"ui-editor-content\" [ngStyle]=\"style\"></div>\n        </div>\n    ",
                providers: [EDITOR_VALUE_ACCESSOR],
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }]; }, { onTextChange: [{
            type: Output
        }], onSelectionChange: [{
            type: Output
        }], onInit: [{
            type: Output
        }], readonly: [{
            type: Input
        }], toolbar: [{
            type: ContentChild,
            args: [Header]
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], placeholder: [{
            type: Input
        }], formats: [{
            type: Input
        }], modules: [{
            type: Input
        }], bounds: [{
            type: Input
        }], scrollingContainer: [{
            type: Input
        }], debug: [{
            type: Input
        }] }); })();
    return Editor;
}());
var EditorModule = /** @class */ (function () {
    function EditorModule() {
    }
EditorModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: EditorModule });
EditorModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function EditorModule_Factory(t) { return new (t || EditorModule)(); }, imports: [[CommonModule],
        SharedModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(EditorModule, { declarations: function () { return [Editor]; }, imports: function () { return [CommonModule]; }, exports: function () { return [Editor,
        SharedModule]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(EditorModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [Editor, SharedModule],
                declarations: [Editor]
            }]
    }], function () { return []; }, null); })();
    return EditorModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { EDITOR_VALUE_ACCESSOR, Editor, EditorModule };

//# sourceMappingURL=primeng-editor.js.map