import { EventEmitter, ElementRef, Input, Output, ContentChild, ContentChildren, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { ObjectUtils, FilterUtils } from 'primeng/utils';
import { Header, Footer, PrimeTemplate, SharedModule } from 'primeng/api';
import { PaginatorModule } from 'primeng/paginator';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';
import * as ɵngcc2 from 'primeng/paginator';

function DataView_div_1_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "div", 11);
} }
function DataView_div_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 12);
    ɵngcc0.ɵɵelement(1, "i");
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵclassMap("ui-dataview-loading-icon pi-spin " + ctx_r1.loadingIcon);
} }
function DataView_p_paginator_5_Template(rf, ctx) { if (rf & 1) {
    var _r8 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "p-paginator", 13);
    ɵngcc0.ɵɵlistener("onPageChange", function DataView_p_paginator_5_Template_p_paginator_onPageChange_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r8); var ctx_r7 = ɵngcc0.ɵɵnextContext(); return ctx_r7.paginate($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r2 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("rows", ctx_r2.rows)("first", ctx_r2.first)("totalRecords", ctx_r2.totalRecords)("pageLinkSize", ctx_r2.pageLinks)("alwaysShow", ctx_r2.alwaysShowPaginator)("rowsPerPageOptions", ctx_r2.rowsPerPageOptions)("dropdownAppendTo", ctx_r2.paginatorDropdownAppendTo)("dropdownScrollHeight", ctx_r2.paginatorDropdownScrollHeight)("templateLeft", ctx_r2.paginatorLeftTemplate)("templateRight", ctx_r2.paginatorRightTemplate)("currentPageReportTemplate", ctx_r2.currentPageReportTemplate)("showCurrentPageReport", ctx_r2.showCurrentPageReport);
} }
function DataView_ng_template_8_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementContainer(0);
} }
var _c0 = function (a0, a1) { return { $implicit: a0, rowIndex: a1 }; };
function DataView_ng_template_8_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵtemplate(0, DataView_ng_template_8_ng_container_0_Template, 1, 0, "ng-container", 14);
} if (rf & 2) {
    var rowData_r9 = ctx.$implicit;
    var rowIndex_r10 = ctx.index;
    var ctx_r3 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngTemplateOutlet", ctx_r3.itemTemplate)("ngTemplateOutletContext", ɵngcc0.ɵɵpureFunction2(2, _c0, rowData_r9, rowIndex_r10));
} }
function DataView_div_10_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 15);
    ɵngcc0.ɵɵtext(1);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r4 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵtextInterpolate(ctx_r4.emptyMessage);
} }
function DataView_p_paginator_11_Template(rf, ctx) { if (rf & 1) {
    var _r13 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "p-paginator", 16);
    ɵngcc0.ɵɵlistener("onPageChange", function DataView_p_paginator_11_Template_p_paginator_onPageChange_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r13); var ctx_r12 = ɵngcc0.ɵɵnextContext(); return ctx_r12.paginate($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r5 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("rows", ctx_r5.rows)("first", ctx_r5.first)("totalRecords", ctx_r5.totalRecords)("pageLinkSize", ctx_r5.pageLinks)("alwaysShow", ctx_r5.alwaysShowPaginator)("rowsPerPageOptions", ctx_r5.rowsPerPageOptions)("dropdownAppendTo", ctx_r5.paginatorDropdownAppendTo)("dropdownScrollHeight", ctx_r5.paginatorDropdownScrollHeight)("templateLeft", ctx_r5.paginatorLeftTemplate)("templateRight", ctx_r5.paginatorRightTemplate)("currentPageReportTemplate", ctx_r5.currentPageReportTemplate)("showCurrentPageReport", ctx_r5.showCurrentPageReport);
} }
function DataView_div_12_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 17);
    ɵngcc0.ɵɵprojection(1, 1);
    ɵngcc0.ɵɵelementEnd();
} }
var _c1 = [[["p-header"]], [["p-footer"]]];
var _c2 = function (a1, a2) { return { "ui-dataview ui-widget": true, "ui-dataview-list": a1, "ui-dataview-grid": a2 }; };
var _c3 = ["p-header", "p-footer"];
var _c4 = function (a0) { return { "ui-state-active": a0 }; };
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var DataView = /** @class */ (function () {
    function DataView(el) {
        this.el = el;
        this.layout = 'list';
        this.pageLinks = 5;
        this.paginatorPosition = 'bottom';
        this.alwaysShowPaginator = true;
        this.paginatorDropdownScrollHeight = '200px';
        this.currentPageReportTemplate = '{currentPage} of {totalPages}';
        this.emptyMessage = 'No records found';
        this.onLazyLoad = new EventEmitter();
        this.trackBy = function (index, item) { return item; };
        this.loadingIcon = 'pi pi-spinner';
        this.first = 0;
        this.onPage = new EventEmitter();
        this.onSort = new EventEmitter();
        this.onChangeLayout = new EventEmitter();
    }
    DataView.prototype.ngOnInit = function () {
        if (this.lazy) {
            this.onLazyLoad.emit(this.createLazyLoadMetadata());
        }
        this.initialized = true;
    };
    DataView.prototype.ngOnChanges = function (simpleChanges) {
        if (simpleChanges.value) {
            this._value = simpleChanges.value.currentValue;
            this.updateTotalRecords();
            if (!this.lazy && this.hasFilter()) {
                this.filter(this.filterValue);
            }
        }
        if (simpleChanges.sortField || simpleChanges.sortOrder) {
            //avoid triggering lazy load prior to lazy initialization at onInit
            if (!this.lazy || this.initialized) {
                this.sort();
            }
        }
    };
    DataView.prototype.ngAfterContentInit = function () {
        var _this = this;
        this.templates.forEach(function (item) {
            switch (item.getType()) {
                case 'listItem':
                    _this.listItemTemplate = item.template;
                    break;
                case 'gridItem':
                    _this.gridItemTemplate = item.template;
                    break;
                case 'paginatorleft':
                    _this.paginatorLeftTemplate = item.template;
                    break;
                case 'paginatorright':
                    _this.paginatorRightTemplate = item.template;
                    break;
            }
        });
        this.updateItemTemplate();
    };
    DataView.prototype.updateItemTemplate = function () {
        switch (this.layout) {
            case 'list':
                this.itemTemplate = this.listItemTemplate;
                break;
            case 'grid':
                this.itemTemplate = this.gridItemTemplate;
                break;
        }
    };
    DataView.prototype.changeLayout = function (layout) {
        this.layout = layout;
        this.onChangeLayout.emit({
            layout: this.layout
        });
        this.updateItemTemplate();
    };
    DataView.prototype.updateTotalRecords = function () {
        this.totalRecords = this.lazy ? this.totalRecords : (this._value ? this._value.length : 0);
    };
    DataView.prototype.paginate = function (event) {
        this.first = event.first;
        this.rows = event.rows;
        if (this.lazy) {
            this.onLazyLoad.emit(this.createLazyLoadMetadata());
        }
        this.onPage.emit({
            first: this.first,
            rows: this.rows
        });
    };
    DataView.prototype.sort = function () {
        var _this = this;
        this.first = 0;
        if (this.lazy) {
            this.onLazyLoad.emit(this.createLazyLoadMetadata());
        }
        else if (this.value) {
            this.value.sort(function (data1, data2) {
                var value1 = ObjectUtils.resolveFieldData(data1, _this.sortField);
                var value2 = ObjectUtils.resolveFieldData(data2, _this.sortField);
                var result = null;
                if (value1 == null && value2 != null)
                    result = -1;
                else if (value1 != null && value2 == null)
                    result = 1;
                else if (value1 == null && value2 == null)
                    result = 0;
                else if (typeof value1 === 'string' && typeof value2 === 'string')
                    result = value1.localeCompare(value2);
                else
                    result = (value1 < value2) ? -1 : (value1 > value2) ? 1 : 0;
                return (_this.sortOrder * result);
            });
            if (this.hasFilter()) {
                this.filter(this.filterValue);
            }
        }
        this.onSort.emit({
            sortField: this.sortField,
            sortOrder: this.sortOrder
        });
    };
    DataView.prototype.isEmpty = function () {
        var data = this.filteredValue || this.value;
        return data == null || data.length == 0;
    };
    DataView.prototype.createLazyLoadMetadata = function () {
        return {
            first: this.first,
            rows: this.rows,
            sortField: this.sortField,
            sortOrder: this.sortOrder
        };
    };
    DataView.prototype.getBlockableElement = function () {
        return this.el.nativeElement.children[0];
    };
    DataView.prototype.filter = function (filter, filterMatchMode) {
        if (filterMatchMode === void 0) { filterMatchMode = "contains"; }
        this.filterValue = filter;
        if (this.value && this.value.length) {
            var searchFields = this.filterBy.split(',');
            this.filteredValue = FilterUtils.filter(this.value, searchFields, filter, filterMatchMode, this.filterLocale);
            if (this.filteredValue.length === this.value.length) {
                this.filteredValue = null;
            }
            if (this.paginator) {
                this.first = 0;
                this.totalRecords = this.filteredValue ? this.filteredValue.length : this.value ? this.value.length : 0;
            }
        }
    };
    DataView.prototype.hasFilter = function () {
        return this.filterValue && this.filterValue.trim().length > 0;
    };
    DataView.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        Input()
    ], DataView.prototype, "layout", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "paginator", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "rows", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "totalRecords", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "pageLinks", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "rowsPerPageOptions", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "paginatorPosition", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "alwaysShowPaginator", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "paginatorDropdownAppendTo", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "paginatorDropdownScrollHeight", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "currentPageReportTemplate", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "showCurrentPageReport", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "lazy", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "emptyMessage", void 0);
    __decorate([
        Output()
    ], DataView.prototype, "onLazyLoad", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "style", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "trackBy", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "filterBy", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "filterLocale", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "loading", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "loadingIcon", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "first", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "sortField", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "sortOrder", void 0);
    __decorate([
        Input()
    ], DataView.prototype, "value", void 0);
    __decorate([
        Output()
    ], DataView.prototype, "onPage", void 0);
    __decorate([
        Output()
    ], DataView.prototype, "onSort", void 0);
    __decorate([
        Output()
    ], DataView.prototype, "onChangeLayout", void 0);
    __decorate([
        ContentChild(Header)
    ], DataView.prototype, "header", void 0);
    __decorate([
        ContentChild(Footer)
    ], DataView.prototype, "footer", void 0);
    __decorate([
        ContentChildren(PrimeTemplate)
    ], DataView.prototype, "templates", void 0);
DataView.ɵfac = function DataView_Factory(t) { return new (t || DataView)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef)); };
DataView.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: DataView, selectors: [["p-dataView"]], contentQueries: function DataView_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        ɵngcc0.ɵɵcontentQuery(dirIndex, Header, true);
        ɵngcc0.ɵɵcontentQuery(dirIndex, Footer, true);
        ɵngcc0.ɵɵcontentQuery(dirIndex, PrimeTemplate, false);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.header = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.footer = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.templates = _t);
    } }, inputs: { layout: "layout", pageLinks: "pageLinks", paginatorPosition: "paginatorPosition", alwaysShowPaginator: "alwaysShowPaginator", paginatorDropdownScrollHeight: "paginatorDropdownScrollHeight", currentPageReportTemplate: "currentPageReportTemplate", emptyMessage: "emptyMessage", trackBy: "trackBy", loadingIcon: "loadingIcon", first: "first", totalRecords: "totalRecords", rows: "rows", paginator: "paginator", rowsPerPageOptions: "rowsPerPageOptions", paginatorDropdownAppendTo: "paginatorDropdownAppendTo", showCurrentPageReport: "showCurrentPageReport", lazy: "lazy", style: "style", styleClass: "styleClass", filterBy: "filterBy", filterLocale: "filterLocale", loading: "loading", sortField: "sortField", sortOrder: "sortOrder", value: "value" }, outputs: { onLazyLoad: "onLazyLoad", onPage: "onPage", onSort: "onSort", onChangeLayout: "onChangeLayout" }, features: [ɵngcc0.ɵɵNgOnChangesFeature], ngContentSelectors: _c3, decls: 13, vars: 19, consts: [[3, "ngClass", "ngStyle"], ["class", "ui-dataview-loading ui-widget-overlay", 4, "ngIf"], ["class", "ui-dataview-loading-content", 4, "ngIf"], [1, "ui-dataview-header", "ui-widget-header", "ui-corner-top"], ["styleClass", "ui-paginator-top", 3, "rows", "first", "totalRecords", "pageLinkSize", "alwaysShow", "rowsPerPageOptions", "dropdownAppendTo", "dropdownScrollHeight", "templateLeft", "templateRight", "currentPageReportTemplate", "showCurrentPageReport", "onPageChange", 4, "ngIf"], [1, "ui-dataview-content", "ui-widget-content"], [1, "p-grid"], ["ngFor", "", 3, "ngForOf", "ngForTrackBy"], ["class", "p-col-12 ui-dataview-emptymessage", 4, "ngIf"], ["styleClass", "ui-paginator-bottom", 3, "rows", "first", "totalRecords", "pageLinkSize", "alwaysShow", "rowsPerPageOptions", "dropdownAppendTo", "dropdownScrollHeight", "templateLeft", "templateRight", "currentPageReportTemplate", "showCurrentPageReport", "onPageChange", 4, "ngIf"], ["class", "ui-dataview-footer ui-widget-header ui-corner-bottom", 4, "ngIf"], [1, "ui-dataview-loading", "ui-widget-overlay"], [1, "ui-dataview-loading-content"], ["styleClass", "ui-paginator-top", 3, "rows", "first", "totalRecords", "pageLinkSize", "alwaysShow", "rowsPerPageOptions", "dropdownAppendTo", "dropdownScrollHeight", "templateLeft", "templateRight", "currentPageReportTemplate", "showCurrentPageReport", "onPageChange"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [1, "p-col-12", "ui-dataview-emptymessage"], ["styleClass", "ui-paginator-bottom", 3, "rows", "first", "totalRecords", "pageLinkSize", "alwaysShow", "rowsPerPageOptions", "dropdownAppendTo", "dropdownScrollHeight", "templateLeft", "templateRight", "currentPageReportTemplate", "showCurrentPageReport", "onPageChange"], [1, "ui-dataview-footer", "ui-widget-header", "ui-corner-bottom"]], template: function DataView_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c1);
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵtemplate(1, DataView_div_1_Template, 1, 0, "div", 1);
        ɵngcc0.ɵɵtemplate(2, DataView_div_2_Template, 2, 2, "div", 2);
        ɵngcc0.ɵɵelementStart(3, "div", 3);
        ɵngcc0.ɵɵprojection(4);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵtemplate(5, DataView_p_paginator_5_Template, 1, 12, "p-paginator", 4);
        ɵngcc0.ɵɵelementStart(6, "div", 5);
        ɵngcc0.ɵɵelementStart(7, "div", 6);
        ɵngcc0.ɵɵtemplate(8, DataView_ng_template_8_Template, 1, 5, "ng-template", 7);
        ɵngcc0.ɵɵpipe(9, "slice");
        ɵngcc0.ɵɵtemplate(10, DataView_div_10_Template, 2, 1, "div", 8);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵtemplate(11, DataView_p_paginator_11_Template, 1, 12, "p-paginator", 9);
        ɵngcc0.ɵɵtemplate(12, DataView_div_12_Template, 2, 0, "div", 10);
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(16, _c2, ctx.layout === "list", ctx.layout === "grid"))("ngStyle", ctx.style);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.loading);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.loading);
        ɵngcc0.ɵɵadvance(3);
        ɵngcc0.ɵɵproperty("ngIf", ctx.paginator && (ctx.paginatorPosition === "top" || ctx.paginatorPosition == "both"));
        ɵngcc0.ɵɵadvance(3);
        ɵngcc0.ɵɵproperty("ngForOf", ctx.paginator ? ɵngcc0.ɵɵpipeBind3(9, 12, ctx.filteredValue || ctx.value, ctx.lazy ? 0 : ctx.first, (ctx.lazy ? 0 : ctx.first) + ctx.rows) : ctx.filteredValue || ctx.value)("ngForTrackBy", ctx.trackBy);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngIf", ctx.isEmpty());
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.paginator && (ctx.paginatorPosition === "bottom" || ctx.paginatorPosition == "both"));
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.footer);
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle, ɵngcc1.NgIf, ɵngcc1.NgForOf, ɵngcc2.Paginator, ɵngcc1.NgTemplateOutlet], pipes: [ɵngcc1.SlicePipe], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(DataView, [{
        type: Component,
        args: [{
                selector: 'p-dataView',
                template: "\n        <div [ngClass]=\"{'ui-dataview ui-widget': true, 'ui-dataview-list': (layout === 'list'), 'ui-dataview-grid': (layout === 'grid')}\" [ngStyle]=\"style\" [class]=\"styleClass\">\n            <div class=\"ui-dataview-loading ui-widget-overlay\" *ngIf=\"loading\"></div>\n            <div class=\"ui-dataview-loading-content\" *ngIf=\"loading\">\n                <i [class]=\"'ui-dataview-loading-icon pi-spin ' + loadingIcon\"></i>\n            </div>\n            <div class=\"ui-dataview-header ui-widget-header ui-corner-top\">\n                <ng-content select=\"p-header\"></ng-content>\n            </div>\n            <p-paginator [rows]=\"rows\" [first]=\"first\" [totalRecords]=\"totalRecords\" [pageLinkSize]=\"pageLinks\" [alwaysShow]=\"alwaysShowPaginator\"\n                (onPageChange)=\"paginate($event)\" styleClass=\"ui-paginator-top\" [rowsPerPageOptions]=\"rowsPerPageOptions\" *ngIf=\"paginator && (paginatorPosition === 'top' || paginatorPosition =='both')\"\n                [dropdownAppendTo]=\"paginatorDropdownAppendTo\" [dropdownScrollHeight]=\"paginatorDropdownScrollHeight\" [templateLeft]=\"paginatorLeftTemplate\" [templateRight]=\"paginatorRightTemplate\"\n                [currentPageReportTemplate]=\"currentPageReportTemplate\" [showCurrentPageReport]=\"showCurrentPageReport\"></p-paginator>\n            <div class=\"ui-dataview-content ui-widget-content\">\n                <div class=\"p-grid\">\n                    <ng-template ngFor let-rowData let-rowIndex=\"index\" [ngForOf]=\"paginator ? ((filteredValue||value) | slice:(lazy ? 0 : first):((lazy ? 0 : first) + rows)) : (filteredValue||value)\" [ngForTrackBy]=\"trackBy\">\n                        <ng-container *ngTemplateOutlet=\"itemTemplate; context: {$implicit: rowData, rowIndex: rowIndex}\"></ng-container>\n                    </ng-template>\n                    <div *ngIf=\"isEmpty()\" class=\"p-col-12 ui-dataview-emptymessage\">{{emptyMessage}}</div>\n                </div>\n            </div>\n            <p-paginator [rows]=\"rows\" [first]=\"first\" [totalRecords]=\"totalRecords\" [pageLinkSize]=\"pageLinks\" [alwaysShow]=\"alwaysShowPaginator\"\n                (onPageChange)=\"paginate($event)\" styleClass=\"ui-paginator-bottom\" [rowsPerPageOptions]=\"rowsPerPageOptions\" *ngIf=\"paginator && (paginatorPosition === 'bottom' || paginatorPosition =='both')\"\n                [dropdownAppendTo]=\"paginatorDropdownAppendTo\" [dropdownScrollHeight]=\"paginatorDropdownScrollHeight\" [templateLeft]=\"paginatorLeftTemplate\" [templateRight]=\"paginatorRightTemplate\"\n                [currentPageReportTemplate]=\"currentPageReportTemplate\" [showCurrentPageReport]=\"showCurrentPageReport\"></p-paginator>\n            <div class=\"ui-dataview-footer ui-widget-header ui-corner-bottom\" *ngIf=\"footer\">\n                <ng-content select=\"p-footer\"></ng-content>\n            </div>\n        </div>\n    ",
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }]; }, { layout: [{
            type: Input
        }], pageLinks: [{
            type: Input
        }], paginatorPosition: [{
            type: Input
        }], alwaysShowPaginator: [{
            type: Input
        }], paginatorDropdownScrollHeight: [{
            type: Input
        }], currentPageReportTemplate: [{
            type: Input
        }], emptyMessage: [{
            type: Input
        }], onLazyLoad: [{
            type: Output
        }], trackBy: [{
            type: Input
        }], loadingIcon: [{
            type: Input
        }], first: [{
            type: Input
        }], onPage: [{
            type: Output
        }], onSort: [{
            type: Output
        }], onChangeLayout: [{
            type: Output
        }], totalRecords: [{
            type: Input
        }], rows: [{
            type: Input
        }], paginator: [{
            type: Input
        }], rowsPerPageOptions: [{
            type: Input
        }], paginatorDropdownAppendTo: [{
            type: Input
        }], showCurrentPageReport: [{
            type: Input
        }], lazy: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], filterBy: [{
            type: Input
        }], filterLocale: [{
            type: Input
        }], loading: [{
            type: Input
        }], sortField: [{
            type: Input
        }], sortOrder: [{
            type: Input
        }], value: [{
            type: Input
        }], header: [{
            type: ContentChild,
            args: [Header]
        }], footer: [{
            type: ContentChild,
            args: [Footer]
        }], templates: [{
            type: ContentChildren,
            args: [PrimeTemplate]
        }] }); })();
    return DataView;
}());
var DataViewLayoutOptions = /** @class */ (function () {
    function DataViewLayoutOptions(dv) {
        this.dv = dv;
    }
    DataViewLayoutOptions.prototype.changeLayout = function (event, layout) {
        this.dv.changeLayout(layout);
        event.preventDefault();
    };
    DataViewLayoutOptions.ctorParameters = function () { return [
        { type: DataView }
    ]; };
    __decorate([
        Input()
    ], DataViewLayoutOptions.prototype, "style", void 0);
    __decorate([
        Input()
    ], DataViewLayoutOptions.prototype, "styleClass", void 0);
DataViewLayoutOptions.ɵfac = function DataViewLayoutOptions_Factory(t) { return new (t || DataViewLayoutOptions)(ɵngcc0.ɵɵdirectiveInject(DataView)); };
DataViewLayoutOptions.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: DataViewLayoutOptions, selectors: [["p-dataViewLayoutOptions"]], inputs: { style: "style", styleClass: "styleClass" }, decls: 9, vars: 10, consts: [[3, "ngClass", "ngStyle"], ["tabindex", "0", 1, "ui-button", "ui-button-icon-only", "ui-state-default", 3, "ngClass", "click", "keydown.enter"], [1, "pi", "pi-bars", "ui-button-icon-left"], [1, "ui-button-text", "ui-clickable"], [1, "pi", "pi-th-large", "ui-button-icon-left"]], template: function DataViewLayoutOptions_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵelementStart(1, "a", 1);
        ɵngcc0.ɵɵlistener("click", function DataViewLayoutOptions_Template_a_click_1_listener($event) { return ctx.changeLayout($event, "list"); })("keydown.enter", function DataViewLayoutOptions_Template_a_keydown_enter_1_listener($event) { return ctx.changeLayout($event, "list"); });
        ɵngcc0.ɵɵelement(2, "i", 2);
        ɵngcc0.ɵɵelementStart(3, "span", 3);
        ɵngcc0.ɵɵtext(4, "ui-btn");
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementStart(5, "a", 1);
        ɵngcc0.ɵɵlistener("click", function DataViewLayoutOptions_Template_a_click_5_listener($event) { return ctx.changeLayout($event, "grid"); })("keydown.enter", function DataViewLayoutOptions_Template_a_keydown_enter_5_listener($event) { return ctx.changeLayout($event, "grid"); });
        ɵngcc0.ɵɵelement(6, "i", 4);
        ɵngcc0.ɵɵelementStart(7, "span", 3);
        ɵngcc0.ɵɵtext(8, "ui-btn");
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", "ui-dataview-layout-options ui-selectbutton ui-buttonset")("ngStyle", ctx.style);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(6, _c4, ctx.dv.layout === "list"));
        ɵngcc0.ɵɵadvance(4);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(8, _c4, ctx.dv.layout === "grid"));
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(DataViewLayoutOptions, [{
        type: Component,
        args: [{
                selector: 'p-dataViewLayoutOptions',
                template: "\n        <div [ngClass]=\"'ui-dataview-layout-options ui-selectbutton ui-buttonset'\" [ngStyle]=\"style\" [class]=\"styleClass\">\n            <a tabindex=\"0\" class=\"ui-button ui-button-icon-only ui-state-default\" (click)=\"changeLayout($event, 'list')\" (keydown.enter)=\"changeLayout($event, 'list')\"\n                [ngClass]=\"{'ui-state-active': dv.layout === 'list'}\">\n                <i class=\"pi pi-bars ui-button-icon-left\"></i>\n                <span class=\"ui-button-text ui-clickable\">ui-btn</span>\n            </a><a tabindex=\"0\" class=\"ui-button ui-button-icon-only ui-state-default\" (click)=\"changeLayout($event, 'grid')\" (keydown.enter)=\"changeLayout($event, 'grid')\"\n                [ngClass]=\"{'ui-state-active': dv.layout === 'grid'}\">\n                <i class=\"pi pi-th-large ui-button-icon-left\"></i>\n                <span class=\"ui-button-text ui-clickable\">ui-btn</span>\n            </a>\n        </div>\n    "
            }]
    }], function () { return [{ type: DataView }]; }, { style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }] }); })();
    return DataViewLayoutOptions;
}());
var DataViewModule = /** @class */ (function () {
    function DataViewModule() {
    }
DataViewModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: DataViewModule });
DataViewModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function DataViewModule_Factory(t) { return new (t || DataViewModule)(); }, imports: [[CommonModule, SharedModule, PaginatorModule],
        SharedModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(DataViewModule, { declarations: function () { return [DataView,
        DataViewLayoutOptions]; }, imports: function () { return [CommonModule, SharedModule, PaginatorModule]; }, exports: function () { return [DataView,
        SharedModule,
        DataViewLayoutOptions]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(DataViewModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule, SharedModule, PaginatorModule],
                exports: [DataView, SharedModule, DataViewLayoutOptions],
                declarations: [DataView, DataViewLayoutOptions]
            }]
    }], function () { return []; }, null); })();
    return DataViewModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { DataView, DataViewLayoutOptions, DataViewModule };

//# sourceMappingURL=primeng-dataview.js.map