/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ViewChild, Output, EventEmitter } from '@angular/core';
export class PdfZoomDropdownComponent {
    constructor() {
        this.zoomChange = new EventEmitter();
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
    /**
     * @return {?}
     */
    emitZoomChange() {
        /** @type {?} */
        const selectedIndex = this.sizeSelector.nativeElement.selectedIndex;
        if (selectedIndex || selectedIndex === 0) {
            /** @type {?} */
            const s = (/** @type {?} */ (this.sizeSelector.nativeElement.options[selectedIndex]));
            /** @type {?} */
            let value = s.label;
            if (value.endsWith('%')) {
                value = Number(value.replace('%', ''));
            }
            else {
                value = s.value;
            }
            this.zoomChange.emit(value);
        }
    }
}
PdfZoomDropdownComponent.decorators = [
    { type: Component, args: [{
                selector: 'pdf-zoom-dropdown',
                template: "<span id=\"scaleSelectContainer\" class=\"dropdownToolbarButton\">\n  <select\n    id=\"scaleSelect\"\n    title=\"Zoom\"\n    data-l10n-id=\"zoom\"\n    #sizeSelector\n  >\n    <option\n      id=\"pageAutoOption\"\n      title=\"\"\n      value=\"auto\"\n      selected=\"selected\"\n      data-l10n-id=\"page_scale_auto\"\n      >Automatic Zoom</option\n    >\n    <option\n      id=\"pageActualOption\"\n      title=\"\"\n      value=\"page-actual\"\n      data-l10n-id=\"page_scale_actual\"\n      >Actual Size</option\n    >\n    <option\n      id=\"pageFitOption\"\n      title=\"\"\n      value=\"page-fit\"\n      data-l10n-id=\"page_scale_fit\"\n      >Page Fit</option\n    >\n    <option\n      id=\"pageWidthOption\"\n      title=\"\"\n      value=\"page-width\"\n      data-l10n-id=\"page_scale_width\"\n      >Page Width</option\n    >\n    <option\n      id=\"customScaleOption\"\n      title=\"\"\n      value=\"custom\"\n      disabled=\"disabled\"\n      hidden=\"true\"\n    ></option>\n    <option\n      title=\"\"\n      value=\"0.5\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 50 }\"\n      >50%</option\n    >\n    <option\n      title=\"\"\n      value=\"0.75\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 75 }\"\n      >75%</option\n    >\n    <option\n      title=\"\"\n      value=\"1\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 100 }\"\n      >100%</option\n    >\n    <option\n      title=\"\"\n      value=\"1.25\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 125 }\"\n      >125%</option\n    >\n    <option\n      title=\"\"\n      value=\"1.5\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 150 }\"\n      >150%</option\n    >\n    <option\n      title=\"\"\n      value=\"2\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 200 }\"\n      >200%</option\n    >\n    <option\n      title=\"\"\n      value=\"3\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 300 }\"\n      >300%</option\n    >\n    <option\n      title=\"\"\n      value=\"4\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 400 }\"\n      >400%</option\n    >\n  </select>\n</span>\n",
                styles: [".dropdownToolbarButton{display:table-cell;-webkit-appearance:none;width:150px;max-width:150px}.dropdownToolbarButton>select{width:170px}@media screen and (-webkit-min-device-pixel-ratio:1.1),screen and (min-resolution:1.1dppx){.dropdownToolbarButton::after{top:-1px}}"]
            }] }
];
/** @nocollapse */
PdfZoomDropdownComponent.ctorParameters = () => [];
PdfZoomDropdownComponent.propDecorators = {
    sizeSelector: [{ type: ViewChild, args: ['sizeSelector',] }],
    zoomChange: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    PdfZoomDropdownComponent.prototype.sizeSelector;
    /** @type {?} */
    PdfZoomDropdownComponent.prototype.zoomChange;
}
//# sourceMappingURL=data:application/json;base64,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