/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { PdfFindbarService } from './../pdf-findbar-service';
import { Component } from '@angular/core';
export class PdfSearchInputFieldComponent {
    /**
     * @param {?} pdfFindbarService
     */
    constructor(pdfFindbarService) {
        this.pdfFindbarService = pdfFindbarService;
    }
}
PdfSearchInputFieldComponent.decorators = [
    { type: Component, args: [{
                selector: 'pdf-search-input-field',
                template: "<input [class.hidden]=\"!pdfFindbarService.individualWordsMode\"\n  autocomplete=\"search-input-field\"\n  id=\"findInput\"\n  class=\"toolbarField\"\n  title=\"Find\"\n  [placeholder]=\"'Find in document\u2026'\"\n  data-l10n-id=\"find_input\"\n  name=\"search-input-field\"\n/>\n<textarea\n  [class.hidden]=\"pdfFindbarService.individualWordsMode\"\n  id=\"findInputMultiline\"\n  type=\"checkbox\"\n  class=\"toolbarField\"\n  placeholder=\"Multiple search terms. Each line is a search term.\"\n  data-l10n-id=\"find_input_line_by_line\"\n  lines=\"3\"\n></textarea>\n",
                styles: ["textarea{width:200px;height:3.5em}textarea::-webkit-input-placeholder{color:#bfbfbf}textarea::-moz-placeholder{font-style:italic}textarea:-ms-input-placeholder{font-style:italic}textarea::-ms-input-placeholder{font-style:italic}textarea::placeholder{font-style:italic}"]
            }] }
];
/** @nocollapse */
PdfSearchInputFieldComponent.ctorParameters = () => [
    { type: PdfFindbarService }
];
if (false) {
    /** @type {?} */
    PdfSearchInputFieldComponent.prototype.pdfFindbarService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGRmLXNlYXJjaC1pbnB1dC1maWVsZC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9uZ3gtZXh0ZW5kZWQtcGRmLXZpZXdlci8iLCJzb3VyY2VzIjpbImxpYi90b29sYmFyL3BkZi1maW5kYmFyL3BkZi1zZWFyY2gtaW5wdXQtZmllbGQvcGRmLXNlYXJjaC1pbnB1dC1maWVsZC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxNQUFNLDBCQUEwQixDQUFDO0FBQzdELE9BQU8sRUFBRSxTQUFTLEVBQVUsTUFBTSxlQUFlLENBQUM7QUFPbEQsTUFBTSxPQUFPLDRCQUE0Qjs7OztJQUN2QyxZQUFtQixpQkFBb0M7UUFBcEMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtJQUFHLENBQUM7OztZQU41RCxTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLHdCQUF3QjtnQkFDbEMsdWtCQUFzRDs7YUFFdkQ7Ozs7WUFQUSxpQkFBaUI7Ozs7SUFTWix5REFBMkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQZGZGaW5kYmFyU2VydmljZSB9IGZyb20gJy4vLi4vcGRmLWZpbmRiYXItc2VydmljZSc7XG5pbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdwZGYtc2VhcmNoLWlucHV0LWZpZWxkJyxcbiAgdGVtcGxhdGVVcmw6ICcuL3BkZi1zZWFyY2gtaW5wdXQtZmllbGQuY29tcG9uZW50Lmh0bWwnLFxuICBzdHlsZVVybHM6IFsnLi9wZGYtc2VhcmNoLWlucHV0LWZpZWxkLmNvbXBvbmVudC5jc3MnXSxcbn0pXG5leHBvcnQgY2xhc3MgUGRmU2VhcmNoSW5wdXRGaWVsZENvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBwZGZGaW5kYmFyU2VydmljZTogUGRmRmluZGJhclNlcnZpY2UpIHt9XG59XG4iXX0=