/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, Output, EventEmitter, TemplateRef, ElementRef, HostListener } from '@angular/core';
export class PdfSecondaryToolbarComponent {
    /**
     * @param {?} element
     */
    constructor(element) {
        this.element = element;
        this.showPresentationModeButton = true;
        this.showOpenFileButton = true;
        this.showPrintButton = true;
        this.showDownloadButton = true;
        this.showBookmarkButton = true;
        this.showPagingButtons = true;
        this.showRotateButton = true;
        this.showHandToolButton = true;
        this.showScrollingButton = true;
        this.showSpreadButton = true;
        this.showPropertiesButton = true;
        this.spreadChange = new EventEmitter();
        this.secondaryMenuIsEmpty = new EventEmitter();
    }
    /**
     * @param {?} newSpread
     * @return {?}
     */
    onSpreadChange(newSpread) {
        this.spreadChange.emit(newSpread);
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        setTimeout((/**
         * @return {?}
         */
        () => this.checkVisibility()));
    }
    /**
     * @return {?}
     */
    onResize() {
        setTimeout((/**
         * @return {?}
         */
        () => this.checkVisibility()));
    }
    /**
     * @return {?}
     */
    ngAfterViewInit() {
        setTimeout((/**
         * @return {?}
         */
        () => this.checkVisibility()));
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        setTimeout((/**
         * @return {?}
         */
        () => this.checkVisibility()));
    }
    /**
     * @return {?}
     */
    checkVisibility() {
        /** @type {?} */
        let visibleButtons = 0;
        /** @type {?} */
        const e = (/** @type {?} */ (this.element.nativeElement));
        /** @type {?} */
        const f = e.children.item(0);
        if (f) {
            /** @type {?} */
            const g = f.children.item(0);
            if (g && g instanceof HTMLElement) {
                visibleButtons = this.checkVisibilityRecursively(g);
            }
        }
        this.secondaryMenuIsEmpty.emit(visibleButtons === 0);
    }
    /**
     * @private
     * @param {?} e
     * @return {?}
     */
    checkVisibilityRecursively(e) {
        if (e.style.display === 'none') {
            return 0;
        }
        if (e.classList.contains('hidden')) {
            return 0;
        }
        if (e.classList.contains('invisible')) {
            return 0;
        }
        /** @type {?} */
        const style = window.getComputedStyle(e);
        if (style.display === 'none') {
            return 0;
        }
        if (e instanceof HTMLButtonElement || e instanceof HTMLAnchorElement) {
            return 1;
        }
        /** @type {?} */
        let count = 0;
        /** @type {?} */
        const children = e.children;
        if (children && children.length) {
            for (let i = 0; i < children.length && count === 0; i++) {
                /** @type {?} */
                const child = children.item(i);
                if (child && child instanceof HTMLElement) {
                    count += this.checkVisibilityRecursively(child);
                }
            }
        }
        return count;
    }
}
PdfSecondaryToolbarComponent.decorators = [
    { type: Component, args: [{
                selector: 'pdf-secondary-toolbar',
                template: "<ng-container [ngTemplateOutlet]=\"customSecondaryToolbar ? customSecondaryToolbar : defaultSecondaryToolbar\"> </ng-container>\n\n<ng-template #defaultSecondaryToolbar>\n  <div\n    id=\"secondaryToolbar\"\n    class=\"secondaryToolbar hidden doorHangerRight\"\n    [style.top]=\"secondaryToolbarTop\"\n    [style.transform]=\"'scale(' + mobileFriendlyZoomScale + ')'\"\n    [style.transformOrigin]=\"'right top'\"\n  >\n    <div id=\"secondaryToolbarButtonContainer\">\n      <button\n        type=\"button\"\n        id=\"secondaryPresentationMode\"\n        [class.invisible]=\"!showPresentationModeButton\"\n        class=\"secondaryToolbarButton visibleLargeView\"\n        title=\"Switch to Presentation Mode\"\n        data-l10n-id=\"presentation_mode\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M5,5H10V7H7V10H5V5M14,5H19V10H17V7H14V5M17,14H19V19H14V17H17V14M10,17V19H5V14H7V17H10Z\" />\n        </svg>\n        <span data-l10n-id=\"presentation_mode_label\">Presentation Mode</span>\n      </button>\n\n      <button\n        type=\"button\"\n        id=\"secondaryOpenFile\"\n        [class.invisible]=\"!showOpenFileButton\"\n        class=\"secondaryToolbarButton visibleMediumView\"\n        title=\"Open File\"\n        data-l10n-id=\"open_file\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M14,2L20,8V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V4A2,2 0 0,1 6,2H14M18,20V9H13V4H6V20H18M12,12L16,16H13.5V19H10.5V16H8L12,12Z\" />\n        </svg>\n        <span data-l10n-id=\"open_file_label\">Open</span>\n      </button>\n\n      <button\n        type=\"button\"\n        id=\"secondaryPrint\"\n        class=\"secondaryToolbarButton visibleSmallView\"\n        [class.invisible]=\"!showPrintButton\"\n        title=\"Print\"\n        data-l10n-id=\"print\"\n      >\n      <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n        <path fill=\"currentColor\" d=\"M18,3H6V7H18M19,12A1,1 0 0,1 18,11A1,1 0 0,1 19,10A1,1 0 0,1 20,11A1,1 0 0,1 19,12M16,19H8V14H16M19,8H5A3,3 0 0,0 2,11V17H6V21H18V17H22V11A3,3 0 0,0 19,8Z\" />\n    </svg>\n        <span data-l10n-id=\"print_label\">Print</span>\n      </button>\n\n      <button\n        type=\"button\"\n        id=\"secondaryDownload\"\n        class=\"secondaryToolbarButton visibleSmallView\"\n        [class.invisible]=\"!showDownloadButton\"\n        title=\"Download\"\n        data-l10n-id=\"download\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M14,2L20,8V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V4A2,2 0 0,1 6,2H14M18,20V9H13V4H6V20H18M12,19L8,15H10.5V12H13.5V15H16L12,19Z\" />\n        </svg>\n        <span data-l10n-id=\"download_label\">Download</span>\n      </button>\n\n      <a\n        href=\"#\"\n        id=\"secondaryViewBookmark\"\n        class=\"secondaryToolbarButton bookmark visibleTinyView\"\n        [class.invisible]=\"!showBookmarkButton\"\n        title=\"Current view (copy or open in new window)\"\n        data-l10n-id=\"bookmark\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M17,18L12,15.82L7,18V5H17M17,3H7A2,2 0 0,0 5,5V21L12,18L19,21V5C19,3.89 18.1,3 17,3Z\" />\n        </svg>\n        <span data-l10n-id=\"bookmark_label\">Current View</span>\n      </a>\n\n      <div class=\"horizontalToolbarSeparator visibleLargeView\"></div>\n\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showPagingButtons\"\n        id=\"firstPage\"\n        class=\"secondaryToolbarButton firstPage visibleLargeView\"\n        title=\"Go to First Page\"\n        data-l10n-id=\"first_page\"\n      >\n        <svg style=\"width:24px;height:24px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M18.41,16.59L13.82,12L18.41,7.41L17,6L11,12L17,18L18.41,16.59M6,6H8V18H6V6Z\" />\n        </svg>\n        <span data-l10n-id=\"first_page_label\">Go to First Page</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showPagingButtons\"\n        id=\"lastPage\"\n        class=\"secondaryToolbarButton lastPage visibleLargeView\"\n        title=\"Go to Last Page\"\n        data-l10n-id=\"last_page\"\n      >\n        <svg style=\"width:24px;height:24px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M5.59,7.41L10.18,12L5.59,16.59L7,18L13,12L7,6L5.59,7.41M16,6H18V18H16V6Z\" />\n        </svg>\n        <span data-l10n-id=\"last_page_label\">Go to Last Page</span>\n      </button>\n\n      <div [class.invisible]=\"!showRotateButton\" class=\"horizontalToolbarSeparator visibleXLView\"></div>\n\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showRotateButton\"\n        id=\"pageRotateCw\"\n        class=\"secondaryToolbarButton rotateCw visibleXLView\"\n        title=\"Rotate Clockwise\"\n        data-l10n-id=\"page_rotate_cw\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M12 3C7.03 3 3 7.03 3 12S7.03 21 12 21C14 21 15.92 20.34 17.5 19.14L16.06 17.7C14.87 18.54 13.45 19 12 19C8.13 19 5 15.87 5 12S8.13 5 12 5 19 8.13 19 12H16L20 16L24 12H21C21 7.03 16.97 3 12 3\" />\n        </svg>\n        <span data-l10n-id=\"page_rotate_cw_label\">Rotate Clockwise</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showRotateButton\"\n        id=\"pageRotateCcw\"\n        class=\"secondaryToolbarButton rotateCcw visibleXLView\"\n        title=\"Rotate Counterclockwise\"\n        data-l10n-id=\"page_rotate_ccw\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M12 3C7.03 3 3 7.03 3 12H0L4 16L8 12H5C5 8.13 8.13 5 12 5S19 8.13 19 12 15.87 19 12 19C10.55 19 9.13 18.54 7.94 17.7L6.5 19.14C8.08 20.34 10 21 12 21C16.97 21 21 16.97 21 12S16.97 3 12 3\" />\n        </svg>\n        <span data-l10n-id=\"page_rotate_ccw_label\">Rotate Counterclockwise</span>\n      </button>\n\n      <div class=\"horizontalToolbarSeparator visibleXXLView\" [class.invisible]=\"!showHandToolButton\"></div>\n\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showHandToolButton\"\n        id=\"cursorSelectTool\"\n        class=\"secondaryToolbarButton toggled visibleXXLView\"\n        title=\"Enable Text Selection Tool\"\n        data-l10n-id=\"cursor_text_select_tool\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M2 4C2 2.89 2.9 2 4 2H7V4H4V7H2V4M22 4V7H20V4H17V2H20C21.1 2 22 2.89 22 4M2 20V17H4V20H7V22H4C2.9 22 2 21.11 2 20M10 2H14V4H10V2M10 20H14V22H10V20M2 10H4V14H2V10M18.5 13C20.4 13 22 14.6 22 16.5C22 19.1 18.5 23 18.5 23C18.5 23 15 19.1 15 16.5C15 14.6 16.6 13 18.5 13M18.5 17.8C19.2 17.8 19.8 17.2 19.7 16.6C19.7 16 19.1 15.4 18.5 15.4C17.9 15.4 17.3 15.9 17.3 16.6C17.3 17.2 17.8 17.8 18.5 17.8M20 10H22V12.34C21.42 11.84 20.74 11.45 20 11.23V10Z\" />\n        </svg>\n        <span data-l10n-id=\"cursor_text_select_tool_label\">Text Selection Tool</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showHandToolButton\"\n        id=\"cursorHandTool\"\n        class=\"secondaryToolbarButton visibleXXLView\"\n        title=\"Enable Hand Tool\"\n        data-l10n-id=\"cursor_hand_tool\"\n      >\n        <svg style=\"width:22px;height:22px\" viewBox=\"0 0 24 24\">\n          <path fill=\"currentColor\" d=\"M13,6V11H18V7.75L22.25,12L18,16.25V13H13V18H16.25L12,22.25L7.75,18H11V13H6V16.25L1.75,12L6,7.75V11H11V6H7.75L12,1.75L16.25,6H13Z\" />\n        </svg>\n        <span data-l10n-id=\"cursor_hand_tool_label\">Hand Tool</span>\n      </button>\n\n      <div [class.invisible]=\"!showScrollingButton\" class=\"horizontalToolbarSeparator\"></div>\n\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showScrollingButton\"\n        id=\"scrollVertical\"\n        class=\"secondaryToolbarButton scrollVertical toggled\"\n        title=\"Use Vertical Scrolling\"\n        data-l10n-id=\"scroll_vertical\"\n      >\n        <span data-l10n-id=\"scroll_vertical_label\">Vertical Scrolling</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showScrollingButton\"\n        id=\"scrollHorizontal\"\n        class=\"secondaryToolbarButton scrollHorizontal\"\n        title=\"Use Horizontal Scrolling\"\n        data-l10n-id=\"scroll_horizontal\"\n      >\n        <span data-l10n-id=\"scroll_horizontal_label\">Horizontal Scrolling</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showScrollingButton\"\n        id=\"scrollWrapped\"\n        class=\"secondaryToolbarButton scrollWrapped\"\n        title=\"Use Wrapped Scrolling\"\n        data-l10n-id=\"scroll_wrapped\"\n      >\n        <span data-l10n-id=\"scroll_wrapped_label\">Wrapped Scrolling</span>\n      </button>\n\n      <div [class.invisible]=\"!showSpreadButton\" class=\"horizontalToolbarSeparator\"></div>\n\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showSpreadButton\"\n        id=\"spreadNone\"\n        class=\"secondaryToolbarButton spreadNone toggled\"\n        title=\"Do not join page spreads\"\n        data-l10n-id=\"spread_none\"\n        (click)=\"onSpreadChange('off')\"\n      >\n        <span data-l10n-id=\"spread_none_label\">No Spreads</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showSpreadButton\"\n        id=\"spreadOdd\"\n        class=\"secondaryToolbarButton spreadOdd\"\n        title=\"Join page spreads starting with odd-numbered pages\"\n        data-l10n-id=\"spread_odd\"\n        (click)=\"onSpreadChange('odd')\"\n      >\n        <span data-l10n-id=\"spread_odd_label\">Odd Spreads</span>\n      </button>\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showSpreadButton\"\n        id=\"spreadEven\"\n        class=\"secondaryToolbarButton spreadEven\"\n        title=\"Join page spreads starting with even-numbered pages\"\n        data-l10n-id=\"spread_even\"\n        (click)=\"onSpreadChange('even')\"\n      >\n        <span data-l10n-id=\"spread_even_label\">Even Spreads</span>\n      </button>\n\n      <div [class.invisible]=\"!showPropertiesButton\" class=\"horizontalToolbarSeparator spreadModeButtons\"></div>\n\n      <button\n        type=\"button\"\n        [class.invisible]=\"!showPropertiesButton\"\n        id=\"documentProperties\"\n        class=\"secondaryToolbarButton documentProperties\"\n        title=\"Document Properties\u2026\"\n        data-l10n-id=\"document_properties\"\n      >\n        <span data-l10n-id=\"document_properties_label\">Document Properties\u2026</span>\n      </button>\n    </div>\n  </div>\n</ng-template>\n",
                styles: ["svg{position:absolute;display:inline-block;top:0;left:0}"]
            }] }
];
/** @nocollapse */
PdfSecondaryToolbarComponent.ctorParameters = () => [
    { type: ElementRef }
];
PdfSecondaryToolbarComponent.propDecorators = {
    customSecondaryToolbar: [{ type: Input }],
    secondaryToolbarTop: [{ type: Input }],
    mobileFriendlyZoomScale: [{ type: Input }],
    showPresentationModeButton: [{ type: Input }],
    showOpenFileButton: [{ type: Input }],
    showPrintButton: [{ type: Input }],
    showDownloadButton: [{ type: Input }],
    showBookmarkButton: [{ type: Input }],
    showPagingButtons: [{ type: Input }],
    showRotateButton: [{ type: Input }],
    showHandToolButton: [{ type: Input }],
    showScrollingButton: [{ type: Input }],
    showSpreadButton: [{ type: Input }],
    showPropertiesButton: [{ type: Input }],
    spreadChange: [{ type: Output }],
    secondaryMenuIsEmpty: [{ type: Output }],
    onResize: [{ type: HostListener, args: ['window:resize',] }]
};
if (false) {
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.customSecondaryToolbar;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.secondaryToolbarTop;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.mobileFriendlyZoomScale;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showPresentationModeButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showOpenFileButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showPrintButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showDownloadButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showBookmarkButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showPagingButtons;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showRotateButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showHandToolButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showScrollingButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showSpreadButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.showPropertiesButton;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.spreadChange;
    /** @type {?} */
    PdfSecondaryToolbarComponent.prototype.secondaryMenuIsEmpty;
    /**
     * @type {?}
     * @private
     */
    PdfSecondaryToolbarComponent.prototype.element;
}
//# sourceMappingURL=data:application/json;base64,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