/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Output, Input, ViewChild, ContentChildren, QueryList, HostBinding, HostListener, Self, ElementRef } from '@angular/core';
import { NgxDropzoneService } from '../ngx-dropzone.service';
import { coerceBooleanProperty, coerceNumberProperty } from '../helpers';
import { NgxDropzonePreviewComponent } from '../ngx-dropzone-preview/ngx-dropzone-preview.component';
/**
 * @record
 */
export function NgxDropzoneChangeEvent() { }
if (false) {
    /** @type {?} */
    NgxDropzoneChangeEvent.prototype.source;
    /** @type {?} */
    NgxDropzoneChangeEvent.prototype.addedFiles;
    /** @type {?} */
    NgxDropzoneChangeEvent.prototype.rejectedFiles;
}
var NgxDropzoneComponent = /** @class */ (function () {
    function NgxDropzoneComponent(service) {
        this.service = service;
        /**
         * Emitted when any files were added or rejected.
         */
        this.change = new EventEmitter();
        /**
         * Set the accepted file types. Defaults to '*'.
         */
        this.accept = '*';
        this._disabled = false;
        this._multiple = true;
        this._maxFileSize = undefined;
        this._expandable = false;
        this._disableClick = false;
        this._isHovered = false;
    }
    Object.defineProperty(NgxDropzoneComponent.prototype, "_hasPreviews", {
        get: /**
         * @return {?}
         */
        function () {
            return !!this._previewChildren.length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "disabled", {
        /** Disable any user interaction with the component. */
        get: /**
         * Disable any user interaction with the component.
         * @return {?}
         */
        function () {
            return this._disabled;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._disabled = coerceBooleanProperty(value);
            if (this._isHovered) {
                this._isHovered = false;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "multiple", {
        /** Allow the selection of multiple files. */
        get: /**
         * Allow the selection of multiple files.
         * @return {?}
         */
        function () {
            return this._multiple;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._multiple = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "maxFileSize", {
        /** Set the maximum size a single file may have. */
        get: /**
         * Set the maximum size a single file may have.
         * @return {?}
         */
        function () {
            return this._maxFileSize;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._maxFileSize = coerceNumberProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "expandable", {
        /** Allow the dropzone container to expand vertically. */
        get: /**
         * Allow the dropzone container to expand vertically.
         * @return {?}
         */
        function () {
            return this._expandable;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._expandable = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "disableClick", {
        /** Open the file selector on click. */
        get: /**
         * Open the file selector on click.
         * @return {?}
         */
        function () {
            return this._disableClick;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._disableClick = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    /** Show the native OS file explorer to select files. */
    /**
     * Show the native OS file explorer to select files.
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onClick = /**
     * Show the native OS file explorer to select files.
     * @return {?}
     */
    function () {
        if (!this.disableClick) {
            this.showFileSelector();
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onDragOver = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (this.disabled) {
            return;
        }
        this.preventDefault(event);
        this._isHovered = true;
    };
    /**
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onDragLeave = /**
     * @return {?}
     */
    function () {
        this._isHovered = false;
    };
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onDrop = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (this.disabled) {
            return;
        }
        this.preventDefault(event);
        this._isHovered = false;
        this.handleFileDrop(event.dataTransfer.files);
    };
    /**
     * @return {?}
     */
    NgxDropzoneComponent.prototype.showFileSelector = /**
     * @return {?}
     */
    function () {
        if (!this.disabled) {
            ((/** @type {?} */ (this._fileInput.nativeElement))).click();
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onFilesSelected = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        /** @type {?} */
        var files = event.target.files;
        this.handleFileDrop(files);
        // Reset the native file input element to allow selecting the same file again
        this._fileInput.nativeElement.value = '';
        // fix(#32): Prevent the default event behaviour which caused the change event to emit twice.
        this.preventDefault(event);
    };
    /**
     * @private
     * @param {?} files
     * @return {?}
     */
    NgxDropzoneComponent.prototype.handleFileDrop = /**
     * @private
     * @param {?} files
     * @return {?}
     */
    function (files) {
        /** @type {?} */
        var result = this.service.parseFileList(files, this.accept, this.maxFileSize, this.multiple);
        this.change.next({
            addedFiles: result.addedFiles,
            rejectedFiles: result.rejectedFiles,
            source: this
        });
    };
    /**
     * @private
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype.preventDefault = /**
     * @private
     * @param {?} event
     * @return {?}
     */
    function (event) {
        event.preventDefault();
        event.stopPropagation();
    };
    NgxDropzoneComponent.decorators = [
        { type: Component, args: [{
                    selector: 'ngx-dropzone, [ngx-dropzone]',
                    template: "<input #fileInput type=\"file\" [id]=\"id\" [multiple]=\"multiple\" [accept]=\"accept\" [disabled]=\"disabled\"\n  (change)=\"_onFilesSelected($event)\" [attr.aria-label]=\"ariaLabel\" [attr.aria-labelledby]=\"ariaLabelledby\"\n  [attr.aria-describedby]=\"ariaDescribedBy\">\n<ng-content select=\"ngx-dropzone-label\" *ngIf=\"!_hasPreviews\"></ng-content>\n<ng-content select=\"ngx-dropzone-preview\"></ng-content>\n<ng-content></ng-content>\n",
                    styles: [":host(){display:flex;align-items:center;height:180px;background:#fff;cursor:pointer;color:#717386;border:2px dashed #717386;border-radius:5px;font-size:16px;overflow-x:auto}:host().ngx-dz-hovered{border-style:solid}:host().ngx-dz-disabled{opacity:.5;cursor:no-drop;pointer-events:none}:host().expandable{overflow:hidden;height:unset;min-height:180px;flex-wrap:wrap}:host().unclickable{cursor:default}:host() ::ng-deep ngx-dropzone-label{text-align:center;z-index:10;margin:10px auto}:host() input{width:.1px;height:.1px;opacity:0;overflow:hidden;position:absolute;z-index:-1}:host() input:focus+::ng-deep ngx-dropzone-label{outline:#000 dotted 1px;outline:-webkit-focus-ring-color auto 5px}"],
                    providers: [NgxDropzoneService]
                },] },
    ];
    /** @nocollapse */
    NgxDropzoneComponent.ctorParameters = function () { return [
        { type: NgxDropzoneService, decorators: [{ type: Self }] }
    ]; };
    NgxDropzoneComponent.propDecorators = {
        _previewChildren: [{ type: ContentChildren, args: [NgxDropzonePreviewComponent, { descendants: true },] }],
        _fileInput: [{ type: ViewChild, args: ['fileInput',] }],
        change: [{ type: Output }],
        accept: [{ type: Input }],
        disabled: [{ type: Input }, { type: HostBinding, args: ['class.ngx-dz-disabled',] }],
        multiple: [{ type: Input }],
        maxFileSize: [{ type: Input }],
        expandable: [{ type: Input }, { type: HostBinding, args: ['class.expandable',] }],
        disableClick: [{ type: Input }, { type: HostBinding, args: ['class.unclickable',] }],
        id: [{ type: Input }],
        ariaLabel: [{ type: Input, args: ['aria-label',] }],
        ariaLabelledby: [{ type: Input, args: ['aria-labelledby',] }],
        ariaDescribedBy: [{ type: Input, args: ['aria-describedby',] }],
        _isHovered: [{ type: HostBinding, args: ['class.ngx-dz-hovered',] }],
        _onClick: [{ type: HostListener, args: ['click',] }],
        _onDragOver: [{ type: HostListener, args: ['dragover', ['$event'],] }],
        _onDragLeave: [{ type: HostListener, args: ['dragleave',] }],
        _onDrop: [{ type: HostListener, args: ['drop', ['$event'],] }]
    };
    return NgxDropzoneComponent;
}());
export { NgxDropzoneComponent };
if (false) {
    /**
     * A list of the content-projected preview children.
     * @type {?}
     */
    NgxDropzoneComponent.prototype._previewChildren;
    /**
     * A template reference to the native file input element.
     * @type {?}
     */
    NgxDropzoneComponent.prototype._fileInput;
    /**
     * Emitted when any files were added or rejected.
     * @type {?}
     */
    NgxDropzoneComponent.prototype.change;
    /**
     * Set the accepted file types. Defaults to '*'.
     * @type {?}
     */
    NgxDropzoneComponent.prototype.accept;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneComponent.prototype._disabled;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneComponent.prototype._multiple;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneComponent.prototype._maxFileSize;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneComponent.prototype._expandable;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneComponent.prototype._disableClick;
    /**
     * Expose the id, aria-label, aria-labelledby and aria-describedby of the native file input for proper accessibility.
     * @type {?}
     */
    NgxDropzoneComponent.prototype.id;
    /** @type {?} */
    NgxDropzoneComponent.prototype.ariaLabel;
    /** @type {?} */
    NgxDropzoneComponent.prototype.ariaLabelledby;
    /** @type {?} */
    NgxDropzoneComponent.prototype.ariaDescribedBy;
    /** @type {?} */
    NgxDropzoneComponent.prototype._isHovered;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneComponent.prototype.service;
}
//# sourceMappingURL=data:application/json;base64,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