/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
/**
 * @record
 */
export function FileSelectResult() { }
if (false) {
    /**
     * The added files, emitted in the filesAdded event.
     * @type {?}
     */
    FileSelectResult.prototype.addedFiles;
    /**
     * The rejected files, emitted in the filesRejected event.
     * @type {?}
     */
    FileSelectResult.prototype.rejectedFiles;
}
/**
 * @record
 */
export function RejectedFile() { }
if (false) {
    /**
     * The reason the file was rejected.
     * @type {?|undefined}
     */
    RejectedFile.prototype.reason;
}
/**
 * This service contains the filtering logic to be applied to
 * any dropped or selected file. If a file matches all criteria
 * like maximum size or accept type, it will be emitted in the
 * addedFiles array, otherwise in the rejectedFiles array.
 */
export class NgxDropzoneService {
    /**
     * @param {?} files
     * @param {?} accept
     * @param {?} maxFileSize
     * @param {?} multiple
     * @return {?}
     */
    parseFileList(files, accept, maxFileSize, multiple) {
        /** @type {?} */
        const addedFiles = [];
        /** @type {?} */
        const rejectedFiles = [];
        for (let i = 0; i < files.length; i++) {
            /** @type {?} */
            const file = files.item(i);
            if (!this.isAccepted(file, accept)) {
                this.rejectFile(rejectedFiles, file, 'type');
                continue;
            }
            if (maxFileSize && file.size > maxFileSize) {
                this.rejectFile(rejectedFiles, file, 'size');
                continue;
            }
            if (!multiple && addedFiles.length >= 1) {
                this.rejectFile(rejectedFiles, file, 'no_multiple');
                continue;
            }
            addedFiles.push(file);
        }
        /** @type {?} */
        const result = {
            addedFiles,
            rejectedFiles
        };
        return result;
    }
    /**
     * @private
     * @param {?} file
     * @param {?} accept
     * @return {?}
     */
    isAccepted(file, accept) {
        if (accept === '*') {
            return true;
        }
        /** @type {?} */
        const acceptFiletypes = accept.split(',').map((/**
         * @param {?} it
         * @return {?}
         */
        it => it.toLowerCase().trim()));
        /** @type {?} */
        const filetype = file.type.toLowerCase();
        /** @type {?} */
        const filename = file.name.toLowerCase();
        /** @type {?} */
        const matchedFileType = acceptFiletypes.find((/**
         * @param {?} acceptFiletype
         * @return {?}
         */
        acceptFiletype => {
            // check for wildcard mimetype (e.g. image/*)
            if (acceptFiletype.endsWith('/*')) {
                return filetype.split('/')[0] === acceptFiletype.split('/')[0];
            }
            // check for file extension (e.g. .csv)
            if (acceptFiletype.startsWith(".")) {
                return filename.endsWith(acceptFiletype);
            }
            // check for exact mimetype match (e.g. image/jpeg)
            return acceptFiletype == filetype;
        }));
        return !!matchedFileType;
    }
    /**
     * @private
     * @param {?} rejectedFiles
     * @param {?} file
     * @param {?} reason
     * @return {?}
     */
    rejectFile(rejectedFiles, file, reason) {
        /** @type {?} */
        const rejectedFile = (/** @type {?} */ (file));
        rejectedFile.reason = reason;
        rejectedFiles.push(rejectedFile);
    }
}
NgxDropzoneService.decorators = [
    { type: Injectable },
];
//# sourceMappingURL=data:application/json;base64,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