/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Input, Output, EventEmitter, HostBinding, HostListener } from '@angular/core';
import { coerceBooleanProperty } from '../helpers';
import { DomSanitizer } from '@angular/platform-browser';
/** @enum {number} */
const KEY_CODE = {
    BACKSPACE: 8,
    DELETE: 46,
};
KEY_CODE[KEY_CODE.BACKSPACE] = 'BACKSPACE';
KEY_CODE[KEY_CODE.DELETE] = 'DELETE';
export class NgxDropzonePreviewComponent {
    /**
     * @param {?} sanitizer
     */
    constructor(sanitizer) {
        this.sanitizer = sanitizer;
        this._removable = false;
        /**
         * Emitted when the element should be removed.
         */
        this.removed = new EventEmitter();
        /**
         * Make the preview item focusable using the tab key.
         */
        this.tabIndex = 0;
    }
    /**
     * Allow the user to remove files.
     * @return {?}
     */
    get removable() {
        return this._removable;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    set removable(value) {
        this._removable = coerceBooleanProperty(value);
    }
    /**
     * @param {?} event
     * @return {?}
     */
    keyEvent(event) {
        switch (event.keyCode) {
            case KEY_CODE.BACKSPACE:
            case KEY_CODE.DELETE:
                this.remove();
                break;
            default:
                break;
        }
    }
    /**
     * We use the HostBinding to pass these common styles to child components.
     * @return {?}
     */
    get hostStyle() {
        /** @type {?} */
        const styles = `
			display: flex;
			height: 140px;
			min-height: 140px;
			min-width: 180px;
			max-width: 180px;
			justify-content: center;
			align-items: center;
			padding: 0 20px;
			margin: 10px;
			border-radius: 5px;
			position: relative;
		`;
        return this.sanitizer.bypassSecurityTrustStyle(styles);
    }
    /**
     * Remove method to be used from the template.
     * @param {?} event
     * @return {?}
     */
    _remove(event) {
        event.stopPropagation();
        this.remove();
    }
    /**
     * Remove the preview item (use from component code).
     * @return {?}
     */
    remove() {
        if (this._removable) {
            this.removed.next(this.file);
        }
    }
    /**
     * @protected
     * @return {?}
     */
    readFile() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new Promise((/**
             * @param {?} resolve
             * @param {?} reject
             * @return {?}
             */
            (resolve, reject) => {
                /** @type {?} */
                const reader = new FileReader();
                reader.onload = (/**
                 * @param {?} e
                 * @return {?}
                 */
                e => {
                    resolve(((/** @type {?} */ (e.target))).result);
                });
                reader.onerror = (/**
                 * @param {?} e
                 * @return {?}
                 */
                e => {
                    console.error(`FileReader failed on file ${this.file.name}.`);
                    reject(e);
                });
                if (!this.file) {
                    return reject('No file to read. Please provide a file using the [file] Input property.');
                }
                reader.readAsDataURL(this.file);
            }));
        });
    }
}
NgxDropzonePreviewComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-dropzone-preview',
                template: `
		<ng-content select="ngx-dropzone-label"></ng-content>
		<ngx-dropzone-remove-badge *ngIf="removable" (click)="_remove($event)">
		</ngx-dropzone-remove-badge>
	`,
                styles: [`:host(){background-image:linear-gradient(to top,#ededed,#efefef,#f1f1f1,#f4f4f4,#f6f6f6)}:host():focus,:host():hover{background-image:linear-gradient(to top,#e3e3e3,#ebeaea,#e8e7e7,#ebeaea,#f4f4f4);outline:0}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() ::ng-deep ngx-dropzone-label{overflow-wrap:break-word}`]
            },] },
];
/** @nocollapse */
NgxDropzonePreviewComponent.ctorParameters = () => [
    { type: DomSanitizer }
];
NgxDropzonePreviewComponent.propDecorators = {
    file: [{ type: Input }],
    removable: [{ type: Input }],
    removed: [{ type: Output }],
    keyEvent: [{ type: HostListener, args: ['keyup', ['$event'],] }],
    hostStyle: [{ type: HostBinding, args: ['style',] }],
    tabIndex: [{ type: HostBinding, args: ['tabindex',] }]
};
if (false) {
    /**
     * The file to preview.
     * @type {?}
     */
    NgxDropzonePreviewComponent.prototype.file;
    /**
     * @type {?}
     * @protected
     */
    NgxDropzonePreviewComponent.prototype._removable;
    /**
     * Emitted when the element should be removed.
     * @type {?}
     */
    NgxDropzonePreviewComponent.prototype.removed;
    /**
     * Make the preview item focusable using the tab key.
     * @type {?}
     */
    NgxDropzonePreviewComponent.prototype.tabIndex;
    /**
     * @type {?}
     * @protected
     */
    NgxDropzonePreviewComponent.prototype.sanitizer;
}
//# sourceMappingURL=data:application/json;base64,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