/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component } from '@angular/core';
import { NgxDropzonePreviewComponent } from '../ngx-dropzone-preview.component';
import { DomSanitizer } from '@angular/platform-browser';
export class NgxDropzoneImagePreviewComponent extends NgxDropzonePreviewComponent {
    /**
     * @param {?} sanitizer
     */
    constructor(sanitizer) {
        super(sanitizer);
        /**
         * The image data source.
         */
        this.imageSrc = '';
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.readFile()
            .then((/**
         * @param {?} img
         * @return {?}
         */
        img => setTimeout((/**
         * @return {?}
         */
        () => this.imageSrc = img))))
            .catch((/**
         * @param {?} err
         * @return {?}
         */
        err => console.error(err)));
    }
}
NgxDropzoneImagePreviewComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-dropzone-image-preview',
                template: `
    <img [src]="imageSrc" />
		<ng-content select="ngx-dropzone-label"></ng-content>
    <ngx-dropzone-remove-badge *ngIf="removable" (click)="_remove($event)">
    </ngx-dropzone-remove-badge>
	`,
                styles: [`:host(){min-width:unset!important;max-width:unset!important;padding:0!important}:host():focus img,:host():hover img{opacity:.7}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() img{max-height:100%;border-radius:5px;opacity:.8}:host() ::ng-deep ngx-dropzone-label{position:absolute;overflow-wrap:break-word}`],
                providers: [
                    {
                        provide: NgxDropzonePreviewComponent,
                        useExisting: NgxDropzoneImagePreviewComponent
                    }
                ]
            },] },
];
/** @nocollapse */
NgxDropzoneImagePreviewComponent.ctorParameters = () => [
    { type: DomSanitizer }
];
if (false) {
    /**
     * The image data source.
     * @type {?}
     */
    NgxDropzoneImagePreviewComponent.prototype.imageSrc;
}
//# sourceMappingURL=data:application/json;base64,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