import { Directive, Component, Input, Output, EventEmitter, HostBinding, HostListener, Injectable, ViewChild, ContentChildren, Self, NgModule } from '@angular/core';
import { __extends, __awaiter, __generator } from 'tslib';
import { DomSanitizer } from '@angular/platform-browser';
import { CommonModule } from '@angular/common';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/platform-browser';
import * as ɵngcc2 from '@angular/common';

function NgxDropzonePreviewComponent_ngx_dropzone_remove_badge_1_Template(rf, ctx) { if (rf & 1) {
    var _r2 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "ngx-dropzone-remove-badge", 1);
    ɵngcc0.ɵɵlistener("click", function NgxDropzonePreviewComponent_ngx_dropzone_remove_badge_1_Template_ngx_dropzone_remove_badge_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r2); var ctx_r1 = ɵngcc0.ɵɵnextContext(); return ctx_r1._remove($event); });
    ɵngcc0.ɵɵelementEnd();
} }
var _c0 = [[["ngx-dropzone-label"]]];
var _c1 = ["ngx-dropzone-label"];
var _c2 = ["fileInput"];
function NgxDropzoneComponent_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵprojection(0, 2, ["*ngIf", "!_hasPreviews"]);
} }
var _c3 = [[["ngx-dropzone-preview"]], "*", [["ngx-dropzone-label"]]];
var _c4 = ["ngx-dropzone-preview", "*", "ngx-dropzone-label"];
function NgxDropzoneImagePreviewComponent_ngx_dropzone_remove_badge_2_Template(rf, ctx) { if (rf & 1) {
    var _r2 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "ngx-dropzone-remove-badge", 2);
    ɵngcc0.ɵɵlistener("click", function NgxDropzoneImagePreviewComponent_ngx_dropzone_remove_badge_2_Template_ngx_dropzone_remove_badge_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r2); var ctx_r1 = ɵngcc0.ɵɵnextContext(); return ctx_r1._remove($event); });
    ɵngcc0.ɵɵelementEnd();
} }
function NgxDropzoneVideoPreviewComponent_video_0_Template(rf, ctx) { if (rf & 1) {
    var _r3 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "video", 2);
    ɵngcc0.ɵɵlistener("click", function NgxDropzoneVideoPreviewComponent_video_0_Template_video_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r3); return $event.stopPropagation(); });
    ɵngcc0.ɵɵelement(1, "source", 3);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r0 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("src", ctx_r0.sanitizedVideoSrc, ɵngcc0.ɵɵsanitizeUrl);
} }
function NgxDropzoneVideoPreviewComponent_ngx_dropzone_remove_badge_2_Template(rf, ctx) { if (rf & 1) {
    var _r5 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "ngx-dropzone-remove-badge", 4);
    ɵngcc0.ɵɵlistener("click", function NgxDropzoneVideoPreviewComponent_ngx_dropzone_remove_badge_2_Template_ngx_dropzone_remove_badge_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r5); var ctx_r4 = ɵngcc0.ɵɵnextContext(); return ctx_r4._remove($event); });
    ɵngcc0.ɵɵelementEnd();
} }
var NgxDropzoneLabelDirective = /** @class */ (function () {
    function NgxDropzoneLabelDirective() {
    }
NgxDropzoneLabelDirective.ɵfac = function NgxDropzoneLabelDirective_Factory(t) { return new (t || NgxDropzoneLabelDirective)(); };
NgxDropzoneLabelDirective.ɵdir = ɵngcc0.ɵɵdefineDirective({ type: NgxDropzoneLabelDirective, selectors: [["ngx-dropzone-label"]] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneLabelDirective, [{
        type: Directive,
        args: [{
                selector: 'ngx-dropzone-label'
            }]
    }], function () { return []; }, null); })();
    return NgxDropzoneLabelDirective;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Coerces a data-bound value (typically a string) to a boolean.
 * Taken from https://github.com/angular/components/blob/master/src/cdk/coercion/boolean-property.ts
 * @param {?} value
 * @return {?}
 */
function coerceBooleanProperty(value) {
    return value != null && "" + value !== 'false';
}
/**
 * Whether the provided value is considered a number.
 * Taken from https://github.com/angular/components/blob/master/src/cdk/coercion/number-property.ts
 * @param {?} value
 * @return {?}
 */
function coerceNumberProperty(value) {
    // parseFloat(value) handles most of the cases we're interested in (it treats null, empty string,
    // and other non-number values as NaN, where Number just uses 0) but it considers the string
    // '123hello' to be a valid number. Therefore we also check if Number(value) is NaN.
    return (!isNaN(parseFloat((/** @type {?} */ (value)))) && !isNaN(Number(value))) ? Number(value) : null;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @enum {number} */
var KEY_CODE = {
    BACKSPACE: 8,
    DELETE: 46,
};
KEY_CODE[KEY_CODE.BACKSPACE] = 'BACKSPACE';
KEY_CODE[KEY_CODE.DELETE] = 'DELETE';
var NgxDropzonePreviewComponent = /** @class */ (function () {
    function NgxDropzonePreviewComponent(sanitizer) {
        this.sanitizer = sanitizer;
        this._removable = false;
        /**
         * Emitted when the element should be removed.
         */
        this.removed = new EventEmitter();
        /**
         * Make the preview item focusable using the tab key.
         */
        this.tabIndex = 0;
    }
    Object.defineProperty(NgxDropzonePreviewComponent.prototype, "removable", {
        /** Allow the user to remove files. */
        get: /**
         * Allow the user to remove files.
         * @return {?}
         */
        function () {
            return this._removable;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._removable = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype.keyEvent = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        switch (event.keyCode) {
            case KEY_CODE.BACKSPACE:
            case KEY_CODE.DELETE:
                this.remove();
                break;
            default:
                break;
        }
    };
    Object.defineProperty(NgxDropzonePreviewComponent.prototype, "hostStyle", {
        /** We use the HostBinding to pass these common styles to child components. */
        get: /**
         * We use the HostBinding to pass these common styles to child components.
         * @return {?}
         */
        function () {
            /** @type {?} */
            var styles = "\n\t\t\tdisplay: flex;\n\t\t\theight: 140px;\n\t\t\tmin-height: 140px;\n\t\t\tmin-width: 180px;\n\t\t\tmax-width: 180px;\n\t\t\tjustify-content: center;\n\t\t\talign-items: center;\n\t\t\tpadding: 0 20px;\n\t\t\tmargin: 10px;\n\t\t\tborder-radius: 5px;\n\t\t\tposition: relative;\n\t\t";
            return this.sanitizer.bypassSecurityTrustStyle(styles);
        },
        enumerable: true,
        configurable: true
    });
    /** Remove method to be used from the template. */
    /**
     * Remove method to be used from the template.
     * @param {?} event
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype._remove = /**
     * Remove method to be used from the template.
     * @param {?} event
     * @return {?}
     */
    function (event) {
        event.stopPropagation();
        this.remove();
    };
    /** Remove the preview item (use from component code). */
    /**
     * Remove the preview item (use from component code).
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype.remove = /**
     * Remove the preview item (use from component code).
     * @return {?}
     */
    function () {
        if (this._removable) {
            this.removed.next(this.file);
        }
    };
    /**
     * @protected
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype.readFile = /**
     * @protected
     * @return {?}
     */
    function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise((/**
                     * @param {?} resolve
                     * @param {?} reject
                     * @return {?}
                     */
                    function (resolve, reject) {
                        /** @type {?} */
                        var reader = new FileReader();
                        reader.onload = (/**
                         * @param {?} e
                         * @return {?}
                         */
                        function (e) {
                            resolve(((/** @type {?} */ (e.target))).result);
                        });
                        reader.onerror = (/**
                         * @param {?} e
                         * @return {?}
                         */
                        function (e) {
                            console.error("FileReader failed on file " + _this.file.name + ".");
                            reject(e);
                        });
                        if (!_this.file) {
                            return reject('No file to read. Please provide a file using the [file] Input property.');
                        }
                        reader.readAsDataURL(_this.file);
                    }))];
            });
        });
    };
    /** @nocollapse */
    NgxDropzonePreviewComponent.ctorParameters = function () { return [
        { type: DomSanitizer }
    ]; };
    NgxDropzonePreviewComponent.propDecorators = {
        file: [{ type: Input }],
        removable: [{ type: Input }],
        removed: [{ type: Output }],
        keyEvent: [{ type: HostListener, args: ['keyup', ['$event'],] }],
        hostStyle: [{ type: HostBinding, args: ['style',] }],
        tabIndex: [{ type: HostBinding, args: ['tabindex',] }]
    };
NgxDropzonePreviewComponent.ɵfac = function NgxDropzonePreviewComponent_Factory(t) { return new (t || NgxDropzonePreviewComponent)(ɵngcc0.ɵɵdirectiveInject(ɵngcc1.DomSanitizer)); };
NgxDropzonePreviewComponent.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: NgxDropzonePreviewComponent, selectors: [["ngx-dropzone-preview"]], hostVars: 3, hostBindings: function NgxDropzonePreviewComponent_HostBindings(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵlistener("keyup", function NgxDropzonePreviewComponent_keyup_HostBindingHandler($event) { return ctx.keyEvent($event); });
    } if (rf & 2) {
        ɵngcc0.ɵɵhostProperty("tabindex", ctx.tabIndex);
        ɵngcc0.ɵɵstyleMap(ctx.hostStyle);
    } }, inputs: { removable: "removable", file: "file" }, outputs: { removed: "removed" }, ngContentSelectors: _c1, decls: 2, vars: 1, consts: [[3, "click", 4, "ngIf"], [3, "click"]], template: function NgxDropzonePreviewComponent_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c0);
        ɵngcc0.ɵɵprojection(0);
        ɵngcc0.ɵɵtemplate(1, NgxDropzonePreviewComponent_ngx_dropzone_remove_badge_1_Template, 1, 0, "ngx-dropzone-remove-badge", 0);
    } if (rf & 2) {
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.removable);
    } }, directives: function () { return [ɵngcc2.NgIf, NgxDropzoneRemoveBadgeComponent]; }, styles: ["[_nghost-%COMP%]{background-image:linear-gradient(to top,#ededed,#efefef,#f1f1f1,#f4f4f4,#f6f6f6)}[_nghost-%COMP%]:focus, [_nghost-%COMP%]:hover{background-image:linear-gradient(to top,#e3e3e3,#ebeaea,#e8e7e7,#ebeaea,#f4f4f4);outline:0}[_nghost-%COMP%]:focus   ngx-dropzone-remove-badge[_ngcontent-%COMP%], [_nghost-%COMP%]:hover   ngx-dropzone-remove-badge[_ngcontent-%COMP%]{opacity:1}[_nghost-%COMP%]   ngx-dropzone-remove-badge[_ngcontent-%COMP%]{opacity:0}[_nghost-%COMP%]     ngx-dropzone-label{overflow-wrap:break-word}"] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzonePreviewComponent, [{
        type: Component,
        args: [{
                selector: 'ngx-dropzone-preview',
                template: "\n\t\t<ng-content select=\"ngx-dropzone-label\"></ng-content>\n\t\t<ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n\t\t</ngx-dropzone-remove-badge>\n\t",
                styles: [":host(){background-image:linear-gradient(to top,#ededed,#efefef,#f1f1f1,#f4f4f4,#f6f6f6)}:host():focus,:host():hover{background-image:linear-gradient(to top,#e3e3e3,#ebeaea,#e8e7e7,#ebeaea,#f4f4f4);outline:0}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() ::ng-deep ngx-dropzone-label{overflow-wrap:break-word}"]
            }]
    }], function () { return [{ type: ɵngcc1.DomSanitizer }]; }, { removed: [{
            type: Output
        }], tabIndex: [{
            type: HostBinding,
            args: ['tabindex']
        }], removable: [{
            type: Input
        }], keyEvent: [{
            type: HostListener,
            args: ['keyup', ['$event']]
        }], hostStyle: [{
            type: HostBinding,
            args: ['style']
        }], file: [{
            type: Input
        }] }); })();
    return NgxDropzonePreviewComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * This service contains the filtering logic to be applied to
 * any dropped or selected file. If a file matches all criteria
 * like maximum size or accept type, it will be emitted in the
 * addedFiles array, otherwise in the rejectedFiles array.
 */
var NgxDropzoneService = /** @class */ (function () {
    function NgxDropzoneService() {
    }
    /**
     * @param {?} files
     * @param {?} accept
     * @param {?} maxFileSize
     * @param {?} multiple
     * @return {?}
     */
    NgxDropzoneService.prototype.parseFileList = /**
     * @param {?} files
     * @param {?} accept
     * @param {?} maxFileSize
     * @param {?} multiple
     * @return {?}
     */
    function (files, accept, maxFileSize, multiple) {
        /** @type {?} */
        var addedFiles = [];
        /** @type {?} */
        var rejectedFiles = [];
        for (var i = 0; i < files.length; i++) {
            /** @type {?} */
            var file = files.item(i);
            if (!this.isAccepted(file, accept)) {
                this.rejectFile(rejectedFiles, file, 'type');
                continue;
            }
            if (maxFileSize && file.size > maxFileSize) {
                this.rejectFile(rejectedFiles, file, 'size');
                continue;
            }
            if (!multiple && addedFiles.length >= 1) {
                this.rejectFile(rejectedFiles, file, 'no_multiple');
                continue;
            }
            addedFiles.push(file);
        }
        /** @type {?} */
        var result = {
            addedFiles: addedFiles,
            rejectedFiles: rejectedFiles
        };
        return result;
    };
    /**
     * @private
     * @param {?} file
     * @param {?} accept
     * @return {?}
     */
    NgxDropzoneService.prototype.isAccepted = /**
     * @private
     * @param {?} file
     * @param {?} accept
     * @return {?}
     */
    function (file, accept) {
        if (accept === '*') {
            return true;
        }
        /** @type {?} */
        var acceptFiletypes = accept.split(',').map((/**
         * @param {?} it
         * @return {?}
         */
        function (it) { return it.toLowerCase().trim(); }));
        /** @type {?} */
        var filetype = file.type.toLowerCase();
        /** @type {?} */
        var filename = file.name.toLowerCase();
        /** @type {?} */
        var matchedFileType = acceptFiletypes.find((/**
         * @param {?} acceptFiletype
         * @return {?}
         */
        function (acceptFiletype) {
            // check for wildcard mimetype (e.g. image/*)
            if (acceptFiletype.endsWith('/*')) {
                return filetype.split('/')[0] === acceptFiletype.split('/')[0];
            }
            // check for file extension (e.g. .csv)
            if (acceptFiletype.startsWith(".")) {
                return filename.endsWith(acceptFiletype);
            }
            // check for exact mimetype match (e.g. image/jpeg)
            return acceptFiletype == filetype;
        }));
        return !!matchedFileType;
    };
    /**
     * @private
     * @param {?} rejectedFiles
     * @param {?} file
     * @param {?} reason
     * @return {?}
     */
    NgxDropzoneService.prototype.rejectFile = /**
     * @private
     * @param {?} rejectedFiles
     * @param {?} file
     * @param {?} reason
     * @return {?}
     */
    function (rejectedFiles, file, reason) {
        /** @type {?} */
        var rejectedFile = (/** @type {?} */ (file));
        rejectedFile.reason = reason;
        rejectedFiles.push(rejectedFile);
    };
NgxDropzoneService.ɵfac = function NgxDropzoneService_Factory(t) { return new (t || NgxDropzoneService)(); };
NgxDropzoneService.ɵprov = ɵngcc0.ɵɵdefineInjectable({ token: NgxDropzoneService, factory: function (t) { return NgxDropzoneService.ɵfac(t); } });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneService, [{
        type: Injectable
    }], function () { return []; }, null); })();
    return NgxDropzoneService;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgxDropzoneComponent = /** @class */ (function () {
    function NgxDropzoneComponent(service) {
        this.service = service;
        /**
         * Emitted when any files were added or rejected.
         */
        this.change = new EventEmitter();
        /**
         * Set the accepted file types. Defaults to '*'.
         */
        this.accept = '*';
        this._disabled = false;
        this._multiple = true;
        this._maxFileSize = undefined;
        this._expandable = false;
        this._disableClick = false;
        this._isHovered = false;
    }
    Object.defineProperty(NgxDropzoneComponent.prototype, "_hasPreviews", {
        get: /**
         * @return {?}
         */
        function () {
            return !!this._previewChildren.length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "disabled", {
        /** Disable any user interaction with the component. */
        get: /**
         * Disable any user interaction with the component.
         * @return {?}
         */
        function () {
            return this._disabled;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._disabled = coerceBooleanProperty(value);
            if (this._isHovered) {
                this._isHovered = false;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "multiple", {
        /** Allow the selection of multiple files. */
        get: /**
         * Allow the selection of multiple files.
         * @return {?}
         */
        function () {
            return this._multiple;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._multiple = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "maxFileSize", {
        /** Set the maximum size a single file may have. */
        get: /**
         * Set the maximum size a single file may have.
         * @return {?}
         */
        function () {
            return this._maxFileSize;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._maxFileSize = coerceNumberProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "expandable", {
        /** Allow the dropzone container to expand vertically. */
        get: /**
         * Allow the dropzone container to expand vertically.
         * @return {?}
         */
        function () {
            return this._expandable;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._expandable = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgxDropzoneComponent.prototype, "disableClick", {
        /** Open the file selector on click. */
        get: /**
         * Open the file selector on click.
         * @return {?}
         */
        function () {
            return this._disableClick;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._disableClick = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    /** Show the native OS file explorer to select files. */
    /**
     * Show the native OS file explorer to select files.
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onClick = /**
     * Show the native OS file explorer to select files.
     * @return {?}
     */
    function () {
        if (!this.disableClick) {
            this.showFileSelector();
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onDragOver = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (this.disabled) {
            return;
        }
        this.preventDefault(event);
        this._isHovered = true;
    };
    /**
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onDragLeave = /**
     * @return {?}
     */
    function () {
        this._isHovered = false;
    };
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onDrop = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (this.disabled) {
            return;
        }
        this.preventDefault(event);
        this._isHovered = false;
        this.handleFileDrop(event.dataTransfer.files);
    };
    /**
     * @return {?}
     */
    NgxDropzoneComponent.prototype.showFileSelector = /**
     * @return {?}
     */
    function () {
        if (!this.disabled) {
            ((/** @type {?} */ (this._fileInput.nativeElement))).click();
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype._onFilesSelected = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        /** @type {?} */
        var files = event.target.files;
        this.handleFileDrop(files);
        // Reset the native file input element to allow selecting the same file again
        this._fileInput.nativeElement.value = '';
        // fix(#32): Prevent the default event behaviour which caused the change event to emit twice.
        this.preventDefault(event);
    };
    /**
     * @private
     * @param {?} files
     * @return {?}
     */
    NgxDropzoneComponent.prototype.handleFileDrop = /**
     * @private
     * @param {?} files
     * @return {?}
     */
    function (files) {
        /** @type {?} */
        var result = this.service.parseFileList(files, this.accept, this.maxFileSize, this.multiple);
        this.change.next({
            addedFiles: result.addedFiles,
            rejectedFiles: result.rejectedFiles,
            source: this
        });
    };
    /**
     * @private
     * @param {?} event
     * @return {?}
     */
    NgxDropzoneComponent.prototype.preventDefault = /**
     * @private
     * @param {?} event
     * @return {?}
     */
    function (event) {
        event.preventDefault();
        event.stopPropagation();
    };
    /** @nocollapse */
    NgxDropzoneComponent.ctorParameters = function () { return [
        { type: NgxDropzoneService, decorators: [{ type: Self }] }
    ]; };
    NgxDropzoneComponent.propDecorators = {
        _previewChildren: [{ type: ContentChildren, args: [NgxDropzonePreviewComponent, { descendants: true },] }],
        _fileInput: [{ type: ViewChild, args: ['fileInput',] }],
        change: [{ type: Output }],
        accept: [{ type: Input }],
        disabled: [{ type: Input }, { type: HostBinding, args: ['class.ngx-dz-disabled',] }],
        multiple: [{ type: Input }],
        maxFileSize: [{ type: Input }],
        expandable: [{ type: Input }, { type: HostBinding, args: ['class.expandable',] }],
        disableClick: [{ type: Input }, { type: HostBinding, args: ['class.unclickable',] }],
        id: [{ type: Input }],
        ariaLabel: [{ type: Input, args: ['aria-label',] }],
        ariaLabelledby: [{ type: Input, args: ['aria-labelledby',] }],
        ariaDescribedBy: [{ type: Input, args: ['aria-describedby',] }],
        _isHovered: [{ type: HostBinding, args: ['class.ngx-dz-hovered',] }],
        _onClick: [{ type: HostListener, args: ['click',] }],
        _onDragOver: [{ type: HostListener, args: ['dragover', ['$event'],] }],
        _onDragLeave: [{ type: HostListener, args: ['dragleave',] }],
        _onDrop: [{ type: HostListener, args: ['drop', ['$event'],] }]
    };
NgxDropzoneComponent.ɵfac = function NgxDropzoneComponent_Factory(t) { return new (t || NgxDropzoneComponent)(ɵngcc0.ɵɵdirectiveInject(NgxDropzoneService, 2)); };
NgxDropzoneComponent.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: NgxDropzoneComponent, selectors: [["ngx-dropzone"], ["", "ngx-dropzone", ""]], contentQueries: function NgxDropzoneComponent_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        ɵngcc0.ɵɵcontentQuery(dirIndex, NgxDropzonePreviewComponent, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx._previewChildren = _t);
    } }, viewQuery: function NgxDropzoneComponent_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c2, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx._fileInput = _t.first);
    } }, hostVars: 8, hostBindings: function NgxDropzoneComponent_HostBindings(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵlistener("click", function NgxDropzoneComponent_click_HostBindingHandler() { return ctx._onClick(); })("dragover", function NgxDropzoneComponent_dragover_HostBindingHandler($event) { return ctx._onDragOver($event); })("dragleave", function NgxDropzoneComponent_dragleave_HostBindingHandler() { return ctx._onDragLeave(); })("drop", function NgxDropzoneComponent_drop_HostBindingHandler($event) { return ctx._onDrop($event); });
    } if (rf & 2) {
        ɵngcc0.ɵɵclassProp("ngx-dz-hovered", ctx._isHovered)("ngx-dz-disabled", ctx.disabled)("expandable", ctx.expandable)("unclickable", ctx.disableClick);
    } }, inputs: { accept: "accept", disabled: "disabled", multiple: "multiple", maxFileSize: "maxFileSize", expandable: "expandable", disableClick: "disableClick", id: "id", ariaLabel: ["aria-label", "ariaLabel"], ariaLabelledby: ["aria-labelledby", "ariaLabelledby"], ariaDescribedBy: ["aria-describedby", "ariaDescribedBy"] }, outputs: { change: "change" }, features: [ɵngcc0.ɵɵProvidersFeature([NgxDropzoneService])], ngContentSelectors: _c4, decls: 5, vars: 8, consts: [["type", "file", 3, "id", "multiple", "accept", "disabled", "change"], ["fileInput", ""], [4, "ngIf"]], template: function NgxDropzoneComponent_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c3);
        ɵngcc0.ɵɵelementStart(0, "input", 0, 1);
        ɵngcc0.ɵɵlistener("change", function NgxDropzoneComponent_Template_input_change_0_listener($event) { return ctx._onFilesSelected($event); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵtemplate(2, NgxDropzoneComponent_2_Template, 1, 0, undefined, 2);
        ɵngcc0.ɵɵprojection(3);
        ɵngcc0.ɵɵprojection(4, 1);
    } if (rf & 2) {
        ɵngcc0.ɵɵproperty("id", ctx.id)("multiple", ctx.multiple)("accept", ctx.accept)("disabled", ctx.disabled);
        ɵngcc0.ɵɵattribute("aria-label", ctx.ariaLabel)("aria-labelledby", ctx.ariaLabelledby)("aria-describedby", ctx.ariaDescribedBy);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngIf", !ctx._hasPreviews);
    } }, directives: [ɵngcc2.NgIf], styles: ["[_nghost-%COMP%]{display:flex;align-items:center;height:180px;background:#fff;cursor:pointer;color:#717386;border:2px dashed #717386;border-radius:5px;font-size:16px;overflow-x:auto}.ngx-dz-hovered[_nghost-%COMP%]{border-style:solid}.ngx-dz-disabled[_nghost-%COMP%]{opacity:.5;cursor:no-drop;pointer-events:none}.expandable[_nghost-%COMP%]{overflow:hidden;height:unset;min-height:180px;flex-wrap:wrap}.unclickable[_nghost-%COMP%]{cursor:default}[_nghost-%COMP%]     ngx-dropzone-label{text-align:center;z-index:10;margin:10px auto}[_nghost-%COMP%]   input[_ngcontent-%COMP%]{width:.1px;height:.1px;opacity:0;overflow:hidden;position:absolute;z-index:-1}[_nghost-%COMP%]   input[_ngcontent-%COMP%]:focus +   ngx-dropzone-label{outline:#000 dotted 1px;outline:-webkit-focus-ring-color auto 5px}"] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneComponent, [{
        type: Component,
        args: [{
                selector: 'ngx-dropzone, [ngx-dropzone]',
                template: "<input #fileInput type=\"file\" [id]=\"id\" [multiple]=\"multiple\" [accept]=\"accept\" [disabled]=\"disabled\"\n  (change)=\"_onFilesSelected($event)\" [attr.aria-label]=\"ariaLabel\" [attr.aria-labelledby]=\"ariaLabelledby\"\n  [attr.aria-describedby]=\"ariaDescribedBy\">\n<ng-content select=\"ngx-dropzone-label\" *ngIf=\"!_hasPreviews\"></ng-content>\n<ng-content select=\"ngx-dropzone-preview\"></ng-content>\n<ng-content></ng-content>\n",
                styles: [":host(){display:flex;align-items:center;height:180px;background:#fff;cursor:pointer;color:#717386;border:2px dashed #717386;border-radius:5px;font-size:16px;overflow-x:auto}:host().ngx-dz-hovered{border-style:solid}:host().ngx-dz-disabled{opacity:.5;cursor:no-drop;pointer-events:none}:host().expandable{overflow:hidden;height:unset;min-height:180px;flex-wrap:wrap}:host().unclickable{cursor:default}:host() ::ng-deep ngx-dropzone-label{text-align:center;z-index:10;margin:10px auto}:host() input{width:.1px;height:.1px;opacity:0;overflow:hidden;position:absolute;z-index:-1}:host() input:focus+::ng-deep ngx-dropzone-label{outline:#000 dotted 1px;outline:-webkit-focus-ring-color auto 5px}"],
                providers: [NgxDropzoneService]
            }]
    }], function () { return [{ type: NgxDropzoneService, decorators: [{
                type: Self
            }] }]; }, { change: [{
            type: Output
        }], accept: [{
            type: Input
        }], _isHovered: [{
            type: HostBinding,
            args: ['class.ngx-dz-hovered']
        }], disabled: [{
            type: Input
        }, {
            type: HostBinding,
            args: ['class.ngx-dz-disabled']
        }], multiple: [{
            type: Input
        }], maxFileSize: [{
            type: Input
        }], expandable: [{
            type: Input
        }, {
            type: HostBinding,
            args: ['class.expandable']
        }], disableClick: [{
            type: Input
        }, {
            type: HostBinding,
            args: ['class.unclickable']
        }], _onClick: [{
            type: HostListener,
            args: ['click']
        }], _onDragOver: [{
            type: HostListener,
            args: ['dragover', ['$event']]
        }], _onDragLeave: [{
            type: HostListener,
            args: ['dragleave']
        }], _onDrop: [{
            type: HostListener,
            args: ['drop', ['$event']]
        }], _previewChildren: [{
            type: ContentChildren,
            args: [NgxDropzonePreviewComponent, { descendants: true }]
        }], _fileInput: [{
            type: ViewChild,
            args: ['fileInput']
        }], id: [{
            type: Input
        }], ariaLabel: [{
            type: Input,
            args: ['aria-label']
        }], ariaLabelledby: [{
            type: Input,
            args: ['aria-labelledby']
        }], ariaDescribedBy: [{
            type: Input,
            args: ['aria-describedby']
        }] }); })();
    return NgxDropzoneComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgxDropzoneImagePreviewComponent = /** @class */ (function (_super) {
    __extends(NgxDropzoneImagePreviewComponent, _super);
    function NgxDropzoneImagePreviewComponent(sanitizer) {
        var _this = _super.call(this, sanitizer) || this;
        /**
         * The image data source.
         */
        _this.imageSrc = '';
        return _this;
    }
    /**
     * @return {?}
     */
    NgxDropzoneImagePreviewComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.readFile()
            .then((/**
         * @param {?} img
         * @return {?}
         */
        function (img) { return setTimeout((/**
         * @return {?}
         */
        function () { return _this.imageSrc = img; })); }))
            .catch((/**
         * @param {?} err
         * @return {?}
         */
        function (err) { return console.error(err); }));
    };
    /** @nocollapse */
    NgxDropzoneImagePreviewComponent.ctorParameters = function () { return [
        { type: DomSanitizer }
    ]; };
NgxDropzoneImagePreviewComponent.ɵfac = function NgxDropzoneImagePreviewComponent_Factory(t) { return new (t || NgxDropzoneImagePreviewComponent)(ɵngcc0.ɵɵdirectiveInject(ɵngcc1.DomSanitizer)); };
NgxDropzoneImagePreviewComponent.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: NgxDropzoneImagePreviewComponent, selectors: [["ngx-dropzone-image-preview"]], features: [ɵngcc0.ɵɵProvidersFeature([
            {
                provide: NgxDropzonePreviewComponent,
                useExisting: NgxDropzoneImagePreviewComponent
            }
        ]), ɵngcc0.ɵɵInheritDefinitionFeature], ngContentSelectors: _c1, decls: 3, vars: 2, consts: [[3, "src"], [3, "click", 4, "ngIf"], [3, "click"]], template: function NgxDropzoneImagePreviewComponent_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c0);
        ɵngcc0.ɵɵelement(0, "img", 0);
        ɵngcc0.ɵɵprojection(1);
        ɵngcc0.ɵɵtemplate(2, NgxDropzoneImagePreviewComponent_ngx_dropzone_remove_badge_2_Template, 1, 0, "ngx-dropzone-remove-badge", 1);
    } if (rf & 2) {
        ɵngcc0.ɵɵproperty("src", ctx.imageSrc, ɵngcc0.ɵɵsanitizeUrl);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngIf", ctx.removable);
    } }, directives: function () { return [ɵngcc2.NgIf, NgxDropzoneRemoveBadgeComponent]; }, styles: ["[_nghost-%COMP%]{min-width:unset!important;max-width:unset!important;padding:0!important}[_nghost-%COMP%]:focus   img[_ngcontent-%COMP%], [_nghost-%COMP%]:hover   img[_ngcontent-%COMP%]{opacity:.7}[_nghost-%COMP%]:focus   ngx-dropzone-remove-badge[_ngcontent-%COMP%], [_nghost-%COMP%]:hover   ngx-dropzone-remove-badge[_ngcontent-%COMP%]{opacity:1}[_nghost-%COMP%]   ngx-dropzone-remove-badge[_ngcontent-%COMP%]{opacity:0}[_nghost-%COMP%]   img[_ngcontent-%COMP%]{max-height:100%;border-radius:5px;opacity:.8}[_nghost-%COMP%]     ngx-dropzone-label{position:absolute;overflow-wrap:break-word}"] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneImagePreviewComponent, [{
        type: Component,
        args: [{
                selector: 'ngx-dropzone-image-preview',
                template: "\n    <img [src]=\"imageSrc\" />\n\t\t<ng-content select=\"ngx-dropzone-label\"></ng-content>\n    <ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n    </ngx-dropzone-remove-badge>\n\t",
                styles: [":host(){min-width:unset!important;max-width:unset!important;padding:0!important}:host():focus img,:host():hover img{opacity:.7}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() img{max-height:100%;border-radius:5px;opacity:.8}:host() ::ng-deep ngx-dropzone-label{position:absolute;overflow-wrap:break-word}"],
                providers: [
                    {
                        provide: NgxDropzonePreviewComponent,
                        useExisting: NgxDropzoneImagePreviewComponent
                    }
                ]
            }]
    }], function () { return [{ type: ɵngcc1.DomSanitizer }]; }, null); })();
    return NgxDropzoneImagePreviewComponent;
}(NgxDropzonePreviewComponent));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgxDropzoneRemoveBadgeComponent = /** @class */ (function () {
    function NgxDropzoneRemoveBadgeComponent() {
    }
NgxDropzoneRemoveBadgeComponent.ɵfac = function NgxDropzoneRemoveBadgeComponent_Factory(t) { return new (t || NgxDropzoneRemoveBadgeComponent)(); };
NgxDropzoneRemoveBadgeComponent.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: NgxDropzoneRemoveBadgeComponent, selectors: [["ngx-dropzone-remove-badge"]], decls: 3, vars: 0, consts: [["x1", "0", "y1", "0", "x2", "10", "y2", "10"], ["x1", "0", "y1", "10", "x2", "10", "y2", "0"]], template: function NgxDropzoneRemoveBadgeComponent_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵnamespaceSVG();
        ɵngcc0.ɵɵelementStart(0, "svg");
        ɵngcc0.ɵɵelement(1, "line", 0);
        ɵngcc0.ɵɵelement(2, "line", 1);
        ɵngcc0.ɵɵelementEnd();
    } }, styles: ["[_nghost-%COMP%]{display:flex;justify-content:center;align-items:center;height:22px;width:22px;position:absolute;top:5px;right:5px;border-radius:50%;background:#bbb;color:#333;cursor:pointer}[_nghost-%COMP%]:hover{background:#aeaeae}[_nghost-%COMP%] > svg[_ngcontent-%COMP%]{height:10px;width:10px}[_nghost-%COMP%] > svg[_ngcontent-%COMP%] > line[_ngcontent-%COMP%]{stroke-width:2px;stroke:#fff}"] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneRemoveBadgeComponent, [{
        type: Component,
        args: [{
                selector: 'ngx-dropzone-remove-badge',
                template: "\n    <svg>\n      <line x1=\"0\" y1=\"0\" x2=\"10\" y2=\"10\" />\n      <line x1=\"0\" y1=\"10\" x2=\"10\" y2=\"0\" />\n    </svg>\n  ",
                styles: [":host(){display:flex;justify-content:center;align-items:center;height:22px;width:22px;position:absolute;top:5px;right:5px;border-radius:50%;background:#bbb;color:#333;cursor:pointer}:host():hover{background:#aeaeae}:host()>svg{height:10px;width:10px}:host()>svg>line{stroke-width:2px;stroke:#fff}"]
            }]
    }], function () { return []; }, null); })();
    return NgxDropzoneRemoveBadgeComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgxDropzoneVideoPreviewComponent = /** @class */ (function (_super) {
    __extends(NgxDropzoneVideoPreviewComponent, _super);
    function NgxDropzoneVideoPreviewComponent(sanitizer) {
        return _super.call(this, sanitizer) || this;
    }
    /**
     * @return {?}
     */
    NgxDropzoneVideoPreviewComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        if (!this.file) {
            console.error('No file to read. Please provide a file using the [file] Input property.');
            return;
        }
        /**
         * We sanitize the URL here to enable the preview.
         * Please note that this could cause security issues!
         **/
        this.videoSrc = URL.createObjectURL(this.file);
        this.sanitizedVideoSrc = this.sanitizer.bypassSecurityTrustUrl(this.videoSrc);
    };
    /**
     * @return {?}
     */
    NgxDropzoneVideoPreviewComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        URL.revokeObjectURL(this.videoSrc);
    };
    /** @nocollapse */
    NgxDropzoneVideoPreviewComponent.ctorParameters = function () { return [
        { type: DomSanitizer }
    ]; };
NgxDropzoneVideoPreviewComponent.ɵfac = function NgxDropzoneVideoPreviewComponent_Factory(t) { return new (t || NgxDropzoneVideoPreviewComponent)(ɵngcc0.ɵɵdirectiveInject(ɵngcc1.DomSanitizer)); };
NgxDropzoneVideoPreviewComponent.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: NgxDropzoneVideoPreviewComponent, selectors: [["ngx-dropzone-video-preview"]], features: [ɵngcc0.ɵɵProvidersFeature([
            {
                provide: NgxDropzonePreviewComponent,
                useExisting: NgxDropzoneVideoPreviewComponent
            }
        ]), ɵngcc0.ɵɵInheritDefinitionFeature], ngContentSelectors: _c1, decls: 3, vars: 2, consts: [["controls", "", 3, "click", 4, "ngIf"], [3, "click", 4, "ngIf"], ["controls", "", 3, "click"], [3, "src"], [3, "click"]], template: function NgxDropzoneVideoPreviewComponent_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c0);
        ɵngcc0.ɵɵtemplate(0, NgxDropzoneVideoPreviewComponent_video_0_Template, 2, 1, "video", 0);
        ɵngcc0.ɵɵprojection(1);
        ɵngcc0.ɵɵtemplate(2, NgxDropzoneVideoPreviewComponent_ngx_dropzone_remove_badge_2_Template, 1, 0, "ngx-dropzone-remove-badge", 1);
    } if (rf & 2) {
        ɵngcc0.ɵɵproperty("ngIf", ctx.sanitizedVideoSrc);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngIf", ctx.removable);
    } }, directives: [ɵngcc2.NgIf, NgxDropzoneRemoveBadgeComponent], styles: ["[_nghost-%COMP%]{min-width:unset!important;max-width:unset!important;padding:0!important}[_nghost-%COMP%]:focus   video[_ngcontent-%COMP%], [_nghost-%COMP%]:hover   video[_ngcontent-%COMP%]{opacity:.7}[_nghost-%COMP%]:focus   ngx-dropzone-remove-badge[_ngcontent-%COMP%], [_nghost-%COMP%]:hover   ngx-dropzone-remove-badge[_ngcontent-%COMP%]{opacity:1}[_nghost-%COMP%]   ngx-dropzone-remove-badge[_ngcontent-%COMP%]{opacity:0}[_nghost-%COMP%]   video[_ngcontent-%COMP%]{max-height:100%;border-radius:5px}[_nghost-%COMP%]     ngx-dropzone-label{position:absolute;overflow-wrap:break-word}"] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneVideoPreviewComponent, [{
        type: Component,
        args: [{
                selector: 'ngx-dropzone-video-preview',
                template: "\n    <video *ngIf=\"sanitizedVideoSrc\" controls (click)=\"$event.stopPropagation()\">\n      <source [src]=\"sanitizedVideoSrc\" />\n    </video>\n    <ng-content select=\"ngx-dropzone-label\"></ng-content>\n    <ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n    </ngx-dropzone-remove-badge>\n\t",
                styles: [":host(){min-width:unset!important;max-width:unset!important;padding:0!important}:host():focus video,:host():hover video{opacity:.7}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() video{max-height:100%;border-radius:5px}:host() ::ng-deep ngx-dropzone-label{position:absolute;overflow-wrap:break-word}"],
                providers: [
                    {
                        provide: NgxDropzonePreviewComponent,
                        useExisting: NgxDropzoneVideoPreviewComponent
                    }
                ]
            }]
    }], function () { return [{ type: ɵngcc1.DomSanitizer }]; }, null); })();
    return NgxDropzoneVideoPreviewComponent;
}(NgxDropzonePreviewComponent));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgxDropzoneModule = /** @class */ (function () {
    function NgxDropzoneModule() {
    }
NgxDropzoneModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: NgxDropzoneModule });
NgxDropzoneModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function NgxDropzoneModule_Factory(t) { return new (t || NgxDropzoneModule)(); }, imports: [[
            CommonModule
        ]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(NgxDropzoneModule, { declarations: function () { return [NgxDropzoneComponent,
        NgxDropzoneLabelDirective,
        NgxDropzonePreviewComponent,
        NgxDropzoneImagePreviewComponent,
        NgxDropzoneRemoveBadgeComponent,
        NgxDropzoneVideoPreviewComponent]; }, imports: function () { return [CommonModule]; }, exports: function () { return [NgxDropzoneComponent,
        NgxDropzoneLabelDirective,
        NgxDropzonePreviewComponent,
        NgxDropzoneImagePreviewComponent,
        NgxDropzoneRemoveBadgeComponent,
        NgxDropzoneVideoPreviewComponent]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(NgxDropzoneModule, [{
        type: NgModule,
        args: [{
                imports: [
                    CommonModule
                ],
                declarations: [
                    NgxDropzoneComponent,
                    NgxDropzoneLabelDirective,
                    NgxDropzonePreviewComponent,
                    NgxDropzoneImagePreviewComponent,
                    NgxDropzoneRemoveBadgeComponent,
                    NgxDropzoneVideoPreviewComponent,
                ],
                exports: [
                    NgxDropzoneComponent,
                    NgxDropzoneLabelDirective,
                    NgxDropzonePreviewComponent,
                    NgxDropzoneImagePreviewComponent,
                    NgxDropzoneRemoveBadgeComponent,
                    NgxDropzoneVideoPreviewComponent,
                ]
            }]
    }], function () { return []; }, null); })();
    return NgxDropzoneModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

export { NgxDropzoneModule, NgxDropzoneComponent, NgxDropzonePreviewComponent, NgxDropzoneImagePreviewComponent, NgxDropzoneVideoPreviewComponent, NgxDropzoneRemoveBadgeComponent, NgxDropzoneLabelDirective as ɵb, NgxDropzoneService as ɵa };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmd4LWRyb3B6b25lLmpzIiwic291cmNlcyI6WyJuZzovbmd4LWRyb3B6b25lL2xpYi9uZ3gtZHJvcHpvbmUtbGFiZWwuZGlyZWN0aXZlLnRzIiwibmc6L25neC1kcm9wem9uZS9saWIvaGVscGVycy50cyIsIm5nOi9uZ3gtZHJvcHpvbmUvbGliL25neC1kcm9wem9uZS1wcmV2aWV3L25neC1kcm9wem9uZS1wcmV2aWV3LmNvbXBvbmVudC50cyIsIm5nOi9uZ3gtZHJvcHpvbmUvbGliL25neC1kcm9wem9uZS5zZXJ2aWNlLnRzIiwibmc6L25neC1kcm9wem9uZS9saWIvbmd4LWRyb3B6b25lL25neC1kcm9wem9uZS5jb21wb25lbnQudHMiLCJuZzovbmd4LWRyb3B6b25lL2xpYi9uZ3gtZHJvcHpvbmUtcHJldmlldy9uZ3gtZHJvcHpvbmUtaW1hZ2UtcHJldmlldy9uZ3gtZHJvcHpvbmUtaW1hZ2UtcHJldmlldy5jb21wb25lbnQudHMiLCJuZzovbmd4LWRyb3B6b25lL2xpYi9uZ3gtZHJvcHpvbmUtcHJldmlldy9uZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdlL25neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UuY29tcG9uZW50LnRzIiwibmc6L25neC1kcm9wem9uZS9saWIvbmd4LWRyb3B6b25lLXByZXZpZXcvbmd4LWRyb3B6b25lLXZpZGVvLXByZXZpZXcvbmd4LWRyb3B6b25lLXZpZGVvLXByZXZpZXcuY29tcG9uZW50LnRzIiwibmc6L25neC1kcm9wem9uZS9saWIvbmd4LWRyb3B6b25lLm1vZHVsZS50cyJdLCJuYW1lcyI6WyJ0c2xpYl8xLl9fZXh0ZW5kcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTtJQUVBO0tBRzBDOzZEQUh6QyxTQUFTLFNBQUMsc0JBQ1YsUUFBUSxFQUFFO0FBQW9CLGtCQUM5Qjs7Ozs7O2dEQUNTO0lBQStCLGdDQUFDO0NBQUE7Ozs7Ozs7Ozs7OztBQ0ExQyxTQUFnQixxQkFBcUIsQ0FBQyxLQUFVO0lBRS9DLE9BQU8sS0FBSyxJQUFJLElBQUksSUFBSSxLQUFHLEtBQU8sS0FBSyxPQUFPLENBQUM7Q0FDL0M7Ozs7Ozs7QUFNRCxTQUFnQixvQkFBb0IsQ0FBQyxLQUFVOzs7O0lBSzlDLE9BQU8sQ0FBQyxDQUFDLEtBQUssQ0FBQyxVQUFVLG9CQUFDLEtBQUssR0FBUSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLElBQUksTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLElBQUksQ0FBQztDQUMxRjs7Ozs7Ozs7SUNmQSxZQUFhO0lBQ2IsVUFBVzs7OztBQUdaO0lBV0MscUNBQ1csU0FBdUI7UUFBdkIsY0FBUyxHQUFULFNBQVMsQ0FBYztRQWN4QixlQUFVLEdBQUcsS0FBSyxDQUFDOzs7O1FBR1YsWUFBTyxHQUFHLElBQUksWUFBWSxFQUFRLENBQUM7Ozs7UUFtQzdCLGFBQVEsR0FBRyxDQUFDLENBQUM7S0FuRGpDO0lBTUwsc0JBQ0ksa0RBQVM7Ozs7OztRQURiO1lBRUMsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO1NBQ3ZCOzs7OztRQUNELFVBQWMsS0FBYztZQUMzQixJQUFJLENBQUMsVUFBVSxHQUFHLHFCQUFxQixDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQy9DOzs7T0FIQTs7Ozs7SUFVRCw4Q0FBUTs7OztJQURSLFVBQ1MsS0FBb0I7UUFDNUIsUUFBUSxLQUFLLENBQUMsT0FBTztZQUNwQixLQUFLLFFBQVEsQ0FBQyxTQUFTLENBQUM7WUFDeEIsS0FBSyxRQUFRLENBQUMsTUFBTTtnQkFDbkIsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO2dCQUNkLE1BQU07WUFDUDtnQkFDQyxNQUFNO1NBQ1A7S0FDRDtJQUdELHNCQUNJLGtEQUFTOzs7Ozs7UUFEYjs7Z0JBRU8sTUFBTSxHQUFHLCtSQVlkO1lBRUQsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLHdCQUF3QixDQUFDLE1BQU0sQ0FBQyxDQUFDO1NBQ3ZEOzs7T0FBQTs7Ozs7OztJQU1ELDZDQUFPOzs7OztJQUFQLFVBQVEsS0FBSztRQUNaLEtBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQztRQUN4QixJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7S0FDZDs7Ozs7O0lBR0QsNENBQU07Ozs7SUFBTjtRQUNDLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUNwQixJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDN0I7S0FDRDs7Ozs7SUFFZSw4Q0FBUTs7OztJQUF4Qjs7OztnQkFDQyxzQkFBTyxJQUFJLE9BQU87Ozs7O29CQUF1QixVQUFDLE9BQU8sRUFBRSxNQUFNOzs0QkFDbEQsTUFBTSxHQUFHLElBQUksVUFBVSxFQUFFO3dCQUUvQixNQUFNLENBQUMsTUFBTTs7Ozt3QkFBRyxVQUFBLENBQUM7NEJBQ2hCLE9BQU8sQ0FBQyxvQkFBQyxDQUFDLENBQUMsTUFBTSxJQUFnQixNQUFNLENBQUMsQ0FBQzt5QkFDekMsQ0FBQSxDQUFDO3dCQUVGLE1BQU0sQ0FBQyxPQUFPOzs7O3dCQUFHLFVBQUEsQ0FBQzs0QkFDakIsT0FBTyxDQUFDLEtBQUssQ0FBQywrQkFBNkIsS0FBSSxDQUFDLElBQUksQ0FBQyxJQUFJLE1BQUcsQ0FBQyxDQUFDOzRCQUM5RCxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7eUJBQ1YsQ0FBQSxDQUFDO3dCQUVGLElBQUksQ0FBQyxLQUFJLENBQUMsSUFBSSxFQUFFOzRCQUNmLE9BQU8sTUFBTSxDQUFDLHlFQUF5RSxDQUFDLENBQUM7eUJBQ3pGO3dCQUVELE1BQU0sQ0FBQyxhQUFhLENBQUMsS0FBSSxDQUFDLElBQUksQ0FBQyxDQUFDO3FCQUNoQyxFQUFDLEVBQUM7OztLQUNILENBQ0YsQUExRlU7O3dDQVRULFNBQVMsU0FBQztRQUNWLFFBQVEsRUFBRSxGQVJTLFlBQVk7U0FRQztxQkFDaEMsUUFBUSxFQUFFO3VCQWNULEtBQUs7NEJBR0wsS0FBSzswQkFVTCxNQUFNO3NEQXZCTiwzQkF5QkEsWUFBWSxTQUFDLE9BQU8sRUFBRSxDQUFDLFFBQVEsQ0FBQztFQXhCakMsTUFBTSxFQUFFLENBQUMsaUJBcUNSLFdBQVcsU0FBQyxPQUFPOzJCQW9CbkIsV0FBVyxTQUFDLFVBQVU7Ozt1R0F6RHdZLENBQUMsa0JBQ2hhOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztvQkF3RG1DO0lBbUNwQyxrQ0FBQztDQUFBOzs7Ozs7QUM1R0Q7Ozs7OztBQXlCQTtJQUFBO0tBeUVDOzs7Ozs7OztJQXRFQSwwQ0FBYTs7Ozs7OztJQUFiLFVBQWMsS0FBZSxFQUFFLE1BQWMsRUFBRSxXQUFtQixFQUFFLFFBQWlCOztZQUU5RSxVQUFVLEdBQVcsRUFBRTs7WUFDdkIsYUFBYSxHQUFtQixFQUFFO1FBRXhDLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFOztnQkFDaEMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1lBRTFCLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsRUFBRTtnQkFDbkMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEVBQUUsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO2dCQUM3QyxTQUFTO2FBQ1Q7WUFFRCxJQUFJLFdBQVcsSUFBSSxJQUFJLENBQUMsSUFBSSxHQUFHLFdBQVcsRUFBRTtnQkFDM0MsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEVBQUUsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO2dCQUM3QyxTQUFTO2FBQ1Q7WUFFRCxJQUFJLENBQUMsUUFBUSxJQUFJLFVBQVUsQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUFFO2dCQUN4QyxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsRUFBRSxJQUFJLEVBQUUsYUFBYSxDQUFDLENBQUM7Z0JBQ3BELFNBQVM7YUFDVDtZQUVELFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDdEI7O1lBRUssTUFBTSxHQUFxQjtZQUNoQyxVQUFVLFlBQUE7WUFDVixhQUFhLGVBQUE7U0FDYjtRQUVELE9BQU8sTUFBTSxDQUFDO0tBQ2Q7Ozs7Ozs7SUFFTyx1Q0FBVTs7Ozs7O0lBQWxCLFVBQW1CLElBQVUsRUFBRSxNQUFjO1FBRTVDLElBQUksTUFBTSxLQUFLLEdBQUcsRUFBRTtZQUNuQixPQUFPLElBQUksQ0FBQztTQUNaOztZQUVLLGVBQWUsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEdBQUc7Ozs7UUFBQyxVQUFBLEVBQUUsSUFBSSxPQUFBLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxJQUFJLEVBQUUsR0FBQSxFQUFDOztZQUN0RSxRQUFRLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUU7O1lBQ2xDLFFBQVEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRTs7WUFFbEMsZUFBZSxHQUFHLGVBQWUsQ0FBQyxJQUFJOzs7O1FBQUMsVUFBQSxjQUFjOztZQUcxRCxJQUFJLGNBQWMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUU7Z0JBQ2xDLE9BQU8sUUFBUSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxjQUFjLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQy9EOztZQUdELElBQUksY0FBYyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsRUFBRTtnQkFDbkMsT0FBTyxRQUFRLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxDQUFDO2FBQ3pDOztZQUdELE9BQU8sY0FBYyxJQUFJLFFBQVEsQ0FBQztTQUNsQyxFQUFDO1FBRUYsT0FBTyxDQUFDLENBQUMsZUFBZSxDQUFDO0tBQ3pCOzs7Ozs7OztJQUVPLHVDQUFVOzs7Ozs7O0lBQWxCLFVBQW1CLGFBQTZCLEVBQUUsSUFBVSxFQUFFLE1BQW9COztZQUUzRSxZQUFZLHNCQUFHLElBQUksRUFBZ0I7UUFDekMsWUFBWSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFFN0IsYUFBYSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztLQUNqQyxDQUNGO3NEQXpFQyxVQUFVOzs7O2dEQUNKO0lBd0VQLHlCQUFDO0NBQUE7Ozs7OztBQ2xHRDtJQXlCRSw4QkFDa0IsT0FBMkI7UUFBM0IsWUFBTyxHQUFQLE9BQU8sQ0FBb0I7Ozs7UUFlMUIsV0FBTSxHQUFHLElBQUksWUFBWSxFQUEwQixDQUFDOzs7O1FBRzlELFdBQU0sR0FBRyxHQUFHLENBQUM7UUFlZCxjQUFTLEdBQUcsS0FBSyxDQUFDO1FBVWxCLGNBQVMsR0FBRyxJQUFJLENBQUM7UUFVakIsaUJBQVksR0FBVyxTQUFTLENBQUM7UUFXakMsZ0JBQVcsR0FBWSxLQUFLLENBQUM7UUFXN0Isa0JBQWEsR0FBRyxLQUFLLENBQUM7UUFTOUIsZUFBVSxHQUFHLEtBQUssQ0FBQztLQW5GZDtJQU1MLHNCQUFJLDhDQUFZOzs7O1FBQWhCO1lBQ0UsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQztTQUN2Qzs7O09BQUE7SUFZRCxzQkFFSSwwQ0FBUTs7Ozs7O1FBRlo7WUFHRSxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7U0FDdkI7Ozs7O1FBQ0QsVUFBYSxLQUFjO1lBQ3pCLElBQUksQ0FBQyxTQUFTLEdBQUcscUJBQXFCLENBQUMsS0FBSyxDQUFDLENBQUM7WUFFOUMsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFO2dCQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQzthQUN6QjtTQUNGOzs7T0FQQTtJQVdELHNCQUNJLDBDQUFROzs7Ozs7UUFEWjtZQUVFLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUN2Qjs7Ozs7UUFDRCxVQUFhLEtBQWM7WUFDekIsSUFBSSxDQUFDLFNBQVMsR0FBRyxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUMvQzs7O09BSEE7SUFPRCxzQkFDSSw2Q0FBVzs7Ozs7O1FBRGY7WUFFRSxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDMUI7Ozs7O1FBQ0QsVUFBZ0IsS0FBYTtZQUMzQixJQUFJLENBQUMsWUFBWSxHQUFHLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQ2pEOzs7T0FIQTtJQU9ELHNCQUVJLDRDQUFVOzs7Ozs7UUFGZDtZQUdFLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUN6Qjs7Ozs7UUFDRCxVQUFlLEtBQWM7WUFDM0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUNqRDs7O09BSEE7SUFPRCxzQkFFSSw4Q0FBWTs7Ozs7O1FBRmhCO1lBR0UsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQzNCOzs7OztRQUNELFVBQWlCLEtBQWM7WUFDN0IsSUFBSSxDQUFDLGFBQWEsR0FBRyxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUNuRDs7O09BSEE7Ozs7OztJQWlCRCx1Q0FBUTs7OztJQURSO1FBRUUsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUU7WUFDdEIsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7U0FDekI7S0FDRjs7Ozs7SUFHRCwwQ0FBVzs7OztJQURYLFVBQ1ksS0FBSztRQUNmLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNqQixPQUFPO1NBQ1I7UUFFRCxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ3hCOzs7O0lBR0QsMkNBQVk7OztJQURaO1FBRUUsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7S0FDekI7Ozs7O0lBR0Qsc0NBQU87Ozs7SUFEUCxVQUNRLEtBQUs7UUFDWCxJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDakIsT0FBTztTQUNSO1FBRUQsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUMzQixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztRQUN4QixJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0M7Ozs7SUFFRCwrQ0FBZ0I7OztJQUFoQjtRQUNFLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFO1lBQ2xCLG9CQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxJQUFzQixLQUFLLEVBQUUsQ0FBQztTQUM3RDtLQUNGOzs7OztJQUVELCtDQUFnQjs7OztJQUFoQixVQUFpQixLQUFLOztZQUNkLEtBQUssR0FBYSxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUs7UUFDMUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQzs7UUFHM0IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQzs7UUFHekMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUM1Qjs7Ozs7O0lBRU8sNkNBQWM7Ozs7O0lBQXRCLFVBQXVCLEtBQWU7O1lBQzlCLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUM7UUFFOUYsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUM7WUFDZixVQUFVLEVBQUUsTUFBTSxDQUFDLFVBQVU7WUFDN0IsYUFBYSxFQUFFLE1BQU0sQ0FBQyxhQUFhO1lBQ25DLE1BQU0sRUFBRSxJQUFJO1NBQ2IsQ0FBQyxDQUFDO0tBQ0o7Ozs7OztJQUVPLDZDQUFjOzs7OztJQUF0QixVQUF1QixLQUFnQjtRQUNyQyxLQUFLLENBQUMsY0FBYyxFQUFFLENBQUM7UUFDdkIsS0FBSyxDQUFDLGVBQWUsRUFBRSxDQUFDO0tBQ3pCLENBQ0gsQUExSlU7O2lDQVpULFNBQVMsU0FBQztRQUNULFFBQVEsRUFBRSw4QkFBOEIsaENBWGpDLGtCQUFrQix1QkF5QnRCLElBQUk7R0FiUDtDQUFRLEVBQUU7bUNBaUJULGVBQWUsU0FBQywyQkFBMkIsRUFBRSxFQUFFLFdBQVcsRUFBRSxJQUFJLEVBQUU7NkJBUWxFLFNBQVMsU0FBQyxXQUFXO3lCQUdyQixNQUFNO3lCQUdOLEtBQUs7MkJBR0wsS0FBSyxZQUNMLFdBQVcsU0FBQyx1QkFBdUI7MkJBY25DLEtBQUs7cUJBM0NQLFNBcURFLEtBQUs7R0FwRE4sTUFBTSxFQUFFLENBQUMsaUJBOERSLEtBQUssWUFDTCxXQUFXLFNBQUMsa0JBQWtCOytCQVU5QixLQUFLLFlBQ0wsV0FBVyxTQUFDLG1CQUFtQjtxQkFVL0IsS0FBSzs0QkFDTCxLQUFLLFNBQUMsWUFBWTtpQ0FDbEIsS0FBSyxTQUFDLGlCQUFpQjtrQ0FDdkIsS0FBSyxTQUFDLGtCQUFrQjs2QkFFeEIsV0FBVyxTQUFDLHNCQUFzQjsyQkFJbEMsWUFBWSxTQUFDLE9BQU87OEJBT3BCLFlBQVksU0FBQyxVQUFVLEVBQUUsQ0FBQyxRQUFRLENBQUM7K0RBcEd5cEIsQ0FBQyxqQ0E4RzdyQixZQUFZLFNBQUMsV0FBVztnQkE3R3pCLFNBQVMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLGtCQUNoQyx2Q0FpSEUsWUFBWSxTQUFDLE1BQU0sRUFBRSxDQUFDLFFBQVEsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O29CQUN4QjtJQXlDViwyQkFBQztDQUFBOzs7Ozs7O0lDN0pxREEsb0RBQTJCO0lBRS9FLDBDQUNFLFNBQXVCO1FBRHpCLFlBR0Usa0JBQU0sU0FBUyxDQUFDLFNBQ2pCOzs7O1FBR0QsY0FBUSxHQUF5QixFQUFFLENBQUM7O0tBSG5DOzs7O0lBS0QsbURBQVE7OztJQUFSO1FBQUEsaUJBSUM7UUFIQyxJQUFJLENBQUMsUUFBUSxFQUFFO2FBQ1osSUFBSTs7OztRQUFDLFVBQUEsR0FBRyxJQUFJLE9BQUEsVUFBVTs7O1FBQUMsY0FBTSxPQUFBLEtBQUksQ0FBQyxRQUFRLEdBQUcsR0FBRyxHQUFBLEVBQUMsR0FBQSxFQUFDO2FBQ2xELEtBQUs7Ozs7UUFBQyxVQUFBLEdBQUcsSUFBSSxPQUFBLE9BQU8sQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLEdBQUEsRUFBQyxDQUFDO0tBQ3JDLENBQ0gsQUFoQlU7OzZDQWhCVCxTQUFTLFNBQUM7UUFDVCxRQUFRLEVBQUUsRkFISCxZQUFZOztLQUdtQixzQkFDdEMsUUFBUSxFQUFFO3NEQUtWLHNCQUNBLE1BQU0sRUFBRSxDQUFDOzs7OztzSkFBZ1osQ0FBQyxzQkFDMVosU0FBUyxFQUFFLDBCQUNUO0NBQ0UsT0FBTyxFQUFFO0FBQTJCLDhCQUNwQztFQUFXLEVBQUU7SUFBZ0MsMEJBQzlDLHNCQUNGLGtCQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OzZFQWpCZ0M7SUFrQ2pDLHVDQUFDO0NBQUEsQ0FoQnFELDJCQUEyQjs7Ozs7O0FDcEJqRjtJQUVBO0tBVWdEO21FQVYvQyxTQUFTLFNBQUMsc0JBQ1QsUUFBUSxFQUFFLDJCQUEyQjtpQkFDckMsUUFBUSxFQUFFLHlJQUtULHNCQUNELE1BQU0sRUFBRSxDQUFDOzs7O29CQUEwUyxDQUFDLGtCQUNyVDs7Ozs7Ozs7OztnREFDUztJQUFxQyxzQ0FBQztDQUFBOzs7Ozs7O0lDVU1BLG9EQUEyQjtJQUUvRSwwQ0FDRSxTQUF1QjtlQUV2QixrQkFBTSxTQUFTLENBQUM7S0FDakI7Ozs7SUFPRCxtREFBUTs7O0lBQVI7UUFDRSxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRTtZQUNkLE9BQU8sQ0FBQyxLQUFLLENBQUMseUVBQXlFLENBQUMsQ0FBQztZQUN6RixPQUFPO1NBQ1I7Ozs7O1FBTUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxHQUFHLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7S0FDL0U7Ozs7SUFFRCxzREFBVzs7O0lBQVg7UUFDRSxHQUFHLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUNwQyxDQUNILEFBOUJVOzs2Q0FsQlQsU0FBUyxTQUFDO1FBQ1QsUUFBUSxFQUFFLEZBSEgsWUFBWTs7S0FHbUIsc0JBQ3RDLFFBQVEsRUFBRTt5S0FPVjtBQUNBLE1BQU0sRUFBRSxDQUFDOzs7O29RQUEyWSxDQUFDLHNCQUNyWixTQUFTLEVBQUU7VUFDVDtHQUNFLE9BQU8sRUFBRSwyQkFBMkIsOEJBQ3BDLFdBQVcsRUFBRTtlQUFnQztTQUM5QyxzQkFDRixrQkFDRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs2RUFuQmdDO0lBa0RqQyx1Q0FBQztDQUFBLENBOUJxRCwyQkFBMkI7Ozs7OztBQ3RCakY7SUFTQTtLQXFCa0M7cURBckJqQyxRQUFRLFNBQUM7YUFDVCxPQUFPLEVBQUUsMEJBQ1IsWUFBWSxzQkFDWixzQkFDRCxZQUFZLEVBQUUsMEJBQ2I7VUFBb0I7V0FDcEI7cUJBQXlCLDBCQUN6QiwyQkFBMkIsMEJBQzNCLGdDQUFnQywwQkFDaEM7a0JBQStCO1NBQy9CO0lBQWdDLHVCQUNoQztPQUNELE9BQU8sRUFBRTtDQUNSLG9CQUFvQiwwQkFDcEIseUJBQXlCLDBCQUN6QiwyQkFBMkI7R0FDM0I7QUFBZ0MsMEJBQ2hDO29CQUErQjtJQUMvQixnQ0FBZ0M7a0JBQ2hDLGtCQUNEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Z0RBQ1M7SUFBdUIsd0JBQUM7Q0FBQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERpcmVjdGl2ZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuXG5ARGlyZWN0aXZlKHtcblx0c2VsZWN0b3I6ICduZ3gtZHJvcHpvbmUtbGFiZWwnXG59KVxuZXhwb3J0IGNsYXNzIE5neERyb3B6b25lTGFiZWxEaXJlY3RpdmUgeyB9XG4iLCJcbi8qKlxuICogQ29lcmNlcyBhIGRhdGEtYm91bmQgdmFsdWUgKHR5cGljYWxseSBhIHN0cmluZykgdG8gYSBib29sZWFuLlxuICogVGFrZW4gZnJvbSBodHRwczovL2dpdGh1Yi5jb20vYW5ndWxhci9jb21wb25lbnRzL2Jsb2IvbWFzdGVyL3NyYy9jZGsvY29lcmNpb24vYm9vbGVhbi1wcm9wZXJ0eS50c1xuICovXG5leHBvcnQgZnVuY3Rpb24gY29lcmNlQm9vbGVhblByb3BlcnR5KHZhbHVlOiBhbnkpOiBib29sZWFuXG57XG5cdHJldHVybiB2YWx1ZSAhPSBudWxsICYmIGAke3ZhbHVlfWAgIT09ICdmYWxzZSc7XG59XG5cbi8qKlxuICogV2hldGhlciB0aGUgcHJvdmlkZWQgdmFsdWUgaXMgY29uc2lkZXJlZCBhIG51bWJlci5cbiAqIFRha2VuIGZyb20gaHR0cHM6Ly9naXRodWIuY29tL2FuZ3VsYXIvY29tcG9uZW50cy9ibG9iL21hc3Rlci9zcmMvY2RrL2NvZXJjaW9uL251bWJlci1wcm9wZXJ0eS50c1xuICovXG5leHBvcnQgZnVuY3Rpb24gY29lcmNlTnVtYmVyUHJvcGVydHkodmFsdWU6IGFueSk6IG51bWJlclxue1xuXHQvLyBwYXJzZUZsb2F0KHZhbHVlKSBoYW5kbGVzIG1vc3Qgb2YgdGhlIGNhc2VzIHdlJ3JlIGludGVyZXN0ZWQgaW4gKGl0IHRyZWF0cyBudWxsLCBlbXB0eSBzdHJpbmcsXG5cdC8vIGFuZCBvdGhlciBub24tbnVtYmVyIHZhbHVlcyBhcyBOYU4sIHdoZXJlIE51bWJlciBqdXN0IHVzZXMgMCkgYnV0IGl0IGNvbnNpZGVycyB0aGUgc3RyaW5nXG5cdC8vICcxMjNoZWxsbycgdG8gYmUgYSB2YWxpZCBudW1iZXIuIFRoZXJlZm9yZSB3ZSBhbHNvIGNoZWNrIGlmIE51bWJlcih2YWx1ZSkgaXMgTmFOLlxuXHRyZXR1cm4gKCFpc05hTihwYXJzZUZsb2F0KHZhbHVlIGFzIGFueSkpICYmICFpc05hTihOdW1iZXIodmFsdWUpKSkgPyBOdW1iZXIodmFsdWUpIDogbnVsbDtcbn1cbiIsImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE91dHB1dCwgRXZlbnRFbWl0dGVyLCBIb3N0QmluZGluZywgSG9zdExpc3RlbmVyIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBjb2VyY2VCb29sZWFuUHJvcGVydHkgfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCB7IFNhZmVTdHlsZSwgRG9tU2FuaXRpemVyIH0gZnJvbSAnQGFuZ3VsYXIvcGxhdGZvcm0tYnJvd3Nlcic7XG5cbmVudW0gS0VZX0NPREUge1xuXHRCQUNLU1BBQ0UgPSA4LFxuXHRERUxFVEUgPSA0NlxufVxuXG5AQ29tcG9uZW50KHtcblx0c2VsZWN0b3I6ICduZ3gtZHJvcHpvbmUtcHJldmlldycsXG5cdHRlbXBsYXRlOiBgXG5cdFx0PG5nLWNvbnRlbnQgc2VsZWN0PVwibmd4LWRyb3B6b25lLWxhYmVsXCI+PC9uZy1jb250ZW50PlxuXHRcdDxuZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdlICpuZ0lmPVwicmVtb3ZhYmxlXCIgKGNsaWNrKT1cIl9yZW1vdmUoJGV2ZW50KVwiPlxuXHRcdDwvbmd4LWRyb3B6b25lLXJlbW92ZS1iYWRnZT5cblx0YCxcblx0c3R5bGVzOiBbYDpob3N0KCl7YmFja2dyb3VuZC1pbWFnZTpsaW5lYXItZ3JhZGllbnQodG8gdG9wLCNlZGVkZWQsI2VmZWZlZiwjZjFmMWYxLCNmNGY0ZjQsI2Y2ZjZmNil9Omhvc3QoKTpmb2N1cyw6aG9zdCgpOmhvdmVye2JhY2tncm91bmQtaW1hZ2U6bGluZWFyLWdyYWRpZW50KHRvIHRvcCwjZTNlM2UzLCNlYmVhZWEsI2U4ZTdlNywjZWJlYWVhLCNmNGY0ZjQpO291dGxpbmU6MH06aG9zdCgpOmZvY3VzIG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UsOmhvc3QoKTpob3ZlciBuZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdle29wYWNpdHk6MX06aG9zdCgpIG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2V7b3BhY2l0eTowfTpob3N0KCkgOjpuZy1kZWVwIG5neC1kcm9wem9uZS1sYWJlbHtvdmVyZmxvdy13cmFwOmJyZWFrLXdvcmR9YF1cbn0pXG5leHBvcnQgY2xhc3MgTmd4RHJvcHpvbmVQcmV2aWV3Q29tcG9uZW50IHtcblxuXHRjb25zdHJ1Y3Rvcihcblx0XHRwcm90ZWN0ZWQgc2FuaXRpemVyOiBEb21TYW5pdGl6ZXJcblx0KSB7IH1cblxuXHQvKiogVGhlIGZpbGUgdG8gcHJldmlldy4gKi9cblx0QElucHV0KCkgZmlsZTogRmlsZTtcblxuXHQvKiogQWxsb3cgdGhlIHVzZXIgdG8gcmVtb3ZlIGZpbGVzLiAqL1xuXHRASW5wdXQoKVxuXHRnZXQgcmVtb3ZhYmxlKCk6IGJvb2xlYW4ge1xuXHRcdHJldHVybiB0aGlzLl9yZW1vdmFibGU7XG5cdH1cblx0c2V0IHJlbW92YWJsZSh2YWx1ZTogYm9vbGVhbikge1xuXHRcdHRoaXMuX3JlbW92YWJsZSA9IGNvZXJjZUJvb2xlYW5Qcm9wZXJ0eSh2YWx1ZSk7XG5cdH1cblx0cHJvdGVjdGVkIF9yZW1vdmFibGUgPSBmYWxzZTtcblxuXHQvKiogRW1pdHRlZCB3aGVuIHRoZSBlbGVtZW50IHNob3VsZCBiZSByZW1vdmVkLiAqL1xuXHRAT3V0cHV0KCkgcmVhZG9ubHkgcmVtb3ZlZCA9IG5ldyBFdmVudEVtaXR0ZXI8RmlsZT4oKTtcblxuXHRASG9zdExpc3RlbmVyKCdrZXl1cCcsIFsnJGV2ZW50J10pXG5cdGtleUV2ZW50KGV2ZW50OiBLZXlib2FyZEV2ZW50KSB7XG5cdFx0c3dpdGNoIChldmVudC5rZXlDb2RlKSB7XG5cdFx0XHRjYXNlIEtFWV9DT0RFLkJBQ0tTUEFDRTpcblx0XHRcdGNhc2UgS0VZX0NPREUuREVMRVRFOlxuXHRcdFx0XHR0aGlzLnJlbW92ZSgpO1xuXHRcdFx0XHRicmVhaztcblx0XHRcdGRlZmF1bHQ6XG5cdFx0XHRcdGJyZWFrO1xuXHRcdH1cblx0fVxuXG5cdC8qKiBXZSB1c2UgdGhlIEhvc3RCaW5kaW5nIHRvIHBhc3MgdGhlc2UgY29tbW9uIHN0eWxlcyB0byBjaGlsZCBjb21wb25lbnRzLiAqL1xuXHRASG9zdEJpbmRpbmcoJ3N0eWxlJylcblx0Z2V0IGhvc3RTdHlsZSgpOiBTYWZlU3R5bGUge1xuXHRcdGNvbnN0IHN0eWxlcyA9IGBcblx0XHRcdGRpc3BsYXk6IGZsZXg7XG5cdFx0XHRoZWlnaHQ6IDE0MHB4O1xuXHRcdFx0bWluLWhlaWdodDogMTQwcHg7XG5cdFx0XHRtaW4td2lkdGg6IDE4MHB4O1xuXHRcdFx0bWF4LXdpZHRoOiAxODBweDtcblx0XHRcdGp1c3RpZnktY29udGVudDogY2VudGVyO1xuXHRcdFx0YWxpZ24taXRlbXM6IGNlbnRlcjtcblx0XHRcdHBhZGRpbmc6IDAgMjBweDtcblx0XHRcdG1hcmdpbjogMTBweDtcblx0XHRcdGJvcmRlci1yYWRpdXM6IDVweDtcblx0XHRcdHBvc2l0aW9uOiByZWxhdGl2ZTtcblx0XHRgO1xuXG5cdFx0cmV0dXJuIHRoaXMuc2FuaXRpemVyLmJ5cGFzc1NlY3VyaXR5VHJ1c3RTdHlsZShzdHlsZXMpO1xuXHR9XG5cblx0LyoqIE1ha2UgdGhlIHByZXZpZXcgaXRlbSBmb2N1c2FibGUgdXNpbmcgdGhlIHRhYiBrZXkuICovXG5cdEBIb3N0QmluZGluZygndGFiaW5kZXgnKSB0YWJJbmRleCA9IDA7XG5cblx0LyoqIFJlbW92ZSBtZXRob2QgdG8gYmUgdXNlZCBmcm9tIHRoZSB0ZW1wbGF0ZS4gKi9cblx0X3JlbW92ZShldmVudCkge1xuXHRcdGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpO1xuXHRcdHRoaXMucmVtb3ZlKCk7XG5cdH1cblxuXHQvKiogUmVtb3ZlIHRoZSBwcmV2aWV3IGl0ZW0gKHVzZSBmcm9tIGNvbXBvbmVudCBjb2RlKS4gKi9cblx0cmVtb3ZlKCkge1xuXHRcdGlmICh0aGlzLl9yZW1vdmFibGUpIHtcblx0XHRcdHRoaXMucmVtb3ZlZC5uZXh0KHRoaXMuZmlsZSk7XG5cdFx0fVxuXHR9XG5cblx0cHJvdGVjdGVkIGFzeW5jIHJlYWRGaWxlKCk6IFByb21pc2U8c3RyaW5nIHwgQXJyYXlCdWZmZXI+IHtcblx0XHRyZXR1cm4gbmV3IFByb21pc2U8c3RyaW5nIHwgQXJyYXlCdWZmZXI+KChyZXNvbHZlLCByZWplY3QpID0+IHtcblx0XHRcdGNvbnN0IHJlYWRlciA9IG5ldyBGaWxlUmVhZGVyKCk7XG5cblx0XHRcdHJlYWRlci5vbmxvYWQgPSBlID0+IHtcblx0XHRcdFx0cmVzb2x2ZSgoZS50YXJnZXQgYXMgRmlsZVJlYWRlcikucmVzdWx0KTtcblx0XHRcdH07XG5cblx0XHRcdHJlYWRlci5vbmVycm9yID0gZSA9PiB7XG5cdFx0XHRcdGNvbnNvbGUuZXJyb3IoYEZpbGVSZWFkZXIgZmFpbGVkIG9uIGZpbGUgJHt0aGlzLmZpbGUubmFtZX0uYCk7XG5cdFx0XHRcdHJlamVjdChlKTtcblx0XHRcdH07XG5cblx0XHRcdGlmICghdGhpcy5maWxlKSB7XG5cdFx0XHRcdHJldHVybiByZWplY3QoJ05vIGZpbGUgdG8gcmVhZC4gUGxlYXNlIHByb3ZpZGUgYSBmaWxlIHVzaW5nIHRoZSBbZmlsZV0gSW5wdXQgcHJvcGVydHkuJyk7XG5cdFx0XHR9XG5cblx0XHRcdHJlYWRlci5yZWFkQXNEYXRhVVJMKHRoaXMuZmlsZSk7XG5cdFx0fSk7XG5cdH1cbn1cbiIsImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBGaWxlU2VsZWN0UmVzdWx0IHtcblxuXHQvKiogVGhlIGFkZGVkIGZpbGVzLCBlbWl0dGVkIGluIHRoZSBmaWxlc0FkZGVkIGV2ZW50LiAqL1xuXHRhZGRlZEZpbGVzOiBGaWxlW107XG5cblx0LyoqIFRoZSByZWplY3RlZCBmaWxlcywgZW1pdHRlZCBpbiB0aGUgZmlsZXNSZWplY3RlZCBldmVudC4gKi9cblx0cmVqZWN0ZWRGaWxlczogUmVqZWN0ZWRGaWxlW107XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVqZWN0ZWRGaWxlIGV4dGVuZHMgRmlsZSB7XG5cblx0LyoqIFRoZSByZWFzb24gdGhlIGZpbGUgd2FzIHJlamVjdGVkLiAqL1xuXHRyZWFzb24/OiBSZWplY3RSZWFzb247XG59XG5cbmV4cG9ydCB0eXBlIFJlamVjdFJlYXNvbiA9ICd0eXBlJyB8ICdzaXplJyB8ICdub19tdWx0aXBsZSc7XG5cbi8qKlxuICogVGhpcyBzZXJ2aWNlIGNvbnRhaW5zIHRoZSBmaWx0ZXJpbmcgbG9naWMgdG8gYmUgYXBwbGllZCB0b1xuICogYW55IGRyb3BwZWQgb3Igc2VsZWN0ZWQgZmlsZS4gSWYgYSBmaWxlIG1hdGNoZXMgYWxsIGNyaXRlcmlhXG4gKiBsaWtlIG1heGltdW0gc2l6ZSBvciBhY2NlcHQgdHlwZSwgaXQgd2lsbCBiZSBlbWl0dGVkIGluIHRoZVxuICogYWRkZWRGaWxlcyBhcnJheSwgb3RoZXJ3aXNlIGluIHRoZSByZWplY3RlZEZpbGVzIGFycmF5LlxuICovXG5ASW5qZWN0YWJsZSgpXG5leHBvcnQgY2xhc3MgTmd4RHJvcHpvbmVTZXJ2aWNlIHtcblxuXHRwYXJzZUZpbGVMaXN0KGZpbGVzOiBGaWxlTGlzdCwgYWNjZXB0OiBzdHJpbmcsIG1heEZpbGVTaXplOiBudW1iZXIsIG11bHRpcGxlOiBib29sZWFuKTogRmlsZVNlbGVjdFJlc3VsdCB7XG5cblx0XHRjb25zdCBhZGRlZEZpbGVzOiBGaWxlW10gPSBbXTtcblx0XHRjb25zdCByZWplY3RlZEZpbGVzOiBSZWplY3RlZEZpbGVbXSA9IFtdO1xuXG5cdFx0Zm9yIChsZXQgaSA9IDA7IGkgPCBmaWxlcy5sZW5ndGg7IGkrKykge1xuXHRcdFx0Y29uc3QgZmlsZSA9IGZpbGVzLml0ZW0oaSk7XG5cblx0XHRcdGlmICghdGhpcy5pc0FjY2VwdGVkKGZpbGUsIGFjY2VwdCkpIHtcblx0XHRcdFx0dGhpcy5yZWplY3RGaWxlKHJlamVjdGVkRmlsZXMsIGZpbGUsICd0eXBlJyk7XG5cdFx0XHRcdGNvbnRpbnVlO1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAobWF4RmlsZVNpemUgJiYgZmlsZS5zaXplID4gbWF4RmlsZVNpemUpIHtcblx0XHRcdFx0dGhpcy5yZWplY3RGaWxlKHJlamVjdGVkRmlsZXMsIGZpbGUsICdzaXplJyk7XG5cdFx0XHRcdGNvbnRpbnVlO1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAoIW11bHRpcGxlICYmIGFkZGVkRmlsZXMubGVuZ3RoID49IDEpIHtcblx0XHRcdFx0dGhpcy5yZWplY3RGaWxlKHJlamVjdGVkRmlsZXMsIGZpbGUsICdub19tdWx0aXBsZScpO1xuXHRcdFx0XHRjb250aW51ZTtcblx0XHRcdH1cblxuXHRcdFx0YWRkZWRGaWxlcy5wdXNoKGZpbGUpO1xuXHRcdH1cblxuXHRcdGNvbnN0IHJlc3VsdDogRmlsZVNlbGVjdFJlc3VsdCA9IHtcblx0XHRcdGFkZGVkRmlsZXMsXG5cdFx0XHRyZWplY3RlZEZpbGVzXG5cdFx0fTtcblxuXHRcdHJldHVybiByZXN1bHQ7XG5cdH1cblxuXHRwcml2YXRlIGlzQWNjZXB0ZWQoZmlsZTogRmlsZSwgYWNjZXB0OiBzdHJpbmcpOiBib29sZWFuIHtcblxuXHRcdGlmIChhY2NlcHQgPT09ICcqJykge1xuXHRcdFx0cmV0dXJuIHRydWU7XG5cdFx0fVxuXG5cdFx0Y29uc3QgYWNjZXB0RmlsZXR5cGVzID0gYWNjZXB0LnNwbGl0KCcsJykubWFwKGl0ID0+IGl0LnRvTG93ZXJDYXNlKCkudHJpbSgpKTtcblx0XHRjb25zdCBmaWxldHlwZSA9IGZpbGUudHlwZS50b0xvd2VyQ2FzZSgpO1xuXHRcdGNvbnN0IGZpbGVuYW1lID0gZmlsZS5uYW1lLnRvTG93ZXJDYXNlKCk7XG5cblx0XHRjb25zdCBtYXRjaGVkRmlsZVR5cGUgPSBhY2NlcHRGaWxldHlwZXMuZmluZChhY2NlcHRGaWxldHlwZSA9PiB7XG5cblx0XHRcdC8vIGNoZWNrIGZvciB3aWxkY2FyZCBtaW1ldHlwZSAoZS5nLiBpbWFnZS8qKVxuXHRcdFx0aWYgKGFjY2VwdEZpbGV0eXBlLmVuZHNXaXRoKCcvKicpKSB7XG5cdFx0XHRcdHJldHVybiBmaWxldHlwZS5zcGxpdCgnLycpWzBdID09PSBhY2NlcHRGaWxldHlwZS5zcGxpdCgnLycpWzBdO1xuXHRcdFx0fVxuXG5cdFx0XHQvLyBjaGVjayBmb3IgZmlsZSBleHRlbnNpb24gKGUuZy4gLmNzdilcblx0XHRcdGlmIChhY2NlcHRGaWxldHlwZS5zdGFydHNXaXRoKFwiLlwiKSkge1xuXHRcdFx0XHRyZXR1cm4gZmlsZW5hbWUuZW5kc1dpdGgoYWNjZXB0RmlsZXR5cGUpO1xuXHRcdFx0fVxuXG5cdFx0XHQvLyBjaGVjayBmb3IgZXhhY3QgbWltZXR5cGUgbWF0Y2ggKGUuZy4gaW1hZ2UvanBlZylcblx0XHRcdHJldHVybiBhY2NlcHRGaWxldHlwZSA9PSBmaWxldHlwZTtcblx0XHR9KTtcblxuXHRcdHJldHVybiAhIW1hdGNoZWRGaWxlVHlwZTtcblx0fVxuXG5cdHByaXZhdGUgcmVqZWN0RmlsZShyZWplY3RlZEZpbGVzOiBSZWplY3RlZEZpbGVbXSwgZmlsZTogRmlsZSwgcmVhc29uOiBSZWplY3RSZWFzb24pIHtcblxuXHRcdGNvbnN0IHJlamVjdGVkRmlsZSA9IGZpbGUgYXMgUmVqZWN0ZWRGaWxlO1xuXHRcdHJlamVjdGVkRmlsZS5yZWFzb24gPSByZWFzb247XG5cblx0XHRyZWplY3RlZEZpbGVzLnB1c2gocmVqZWN0ZWRGaWxlKTtcblx0fVxufVxuIiwiaW1wb3J0IHsgQ29tcG9uZW50LCBPbkluaXQsIEV2ZW50RW1pdHRlciwgT3V0cHV0LCBJbnB1dCwgVmlld0NoaWxkLCBDb250ZW50Q2hpbGRyZW4sIFF1ZXJ5TGlzdCwgSG9zdEJpbmRpbmcsIEhvc3RMaXN0ZW5lciwgU2VsZiwgRWxlbWVudFJlZiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgTmd4RHJvcHpvbmVTZXJ2aWNlLCBGaWxlU2VsZWN0UmVzdWx0IH0gZnJvbSAnLi4vbmd4LWRyb3B6b25lLnNlcnZpY2UnO1xuaW1wb3J0IHsgY29lcmNlQm9vbGVhblByb3BlcnR5LCBjb2VyY2VOdW1iZXJQcm9wZXJ0eSB9IGZyb20gJy4uL2hlbHBlcnMnO1xuaW1wb3J0IHsgTmd4RHJvcHpvbmVQcmV2aWV3Q29tcG9uZW50IH0gZnJvbSAnLi4vbmd4LWRyb3B6b25lLXByZXZpZXcvbmd4LWRyb3B6b25lLXByZXZpZXcuY29tcG9uZW50JztcblxuZXhwb3J0IGludGVyZmFjZSBOZ3hEcm9wem9uZUNoYW5nZUV2ZW50IHtcbiAgc291cmNlOiBOZ3hEcm9wem9uZUNvbXBvbmVudDtcbiAgYWRkZWRGaWxlczogRmlsZVtdO1xuICByZWplY3RlZEZpbGVzOiBGaWxlW107XG59XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ25neC1kcm9wem9uZSwgW25neC1kcm9wem9uZV0nLFxuICB0ZW1wbGF0ZTogYDxpbnB1dCAjZmlsZUlucHV0IHR5cGU9XCJmaWxlXCIgW2lkXT1cImlkXCIgW211bHRpcGxlXT1cIm11bHRpcGxlXCIgW2FjY2VwdF09XCJhY2NlcHRcIiBbZGlzYWJsZWRdPVwiZGlzYWJsZWRcIlxuICAoY2hhbmdlKT1cIl9vbkZpbGVzU2VsZWN0ZWQoJGV2ZW50KVwiIFthdHRyLmFyaWEtbGFiZWxdPVwiYXJpYUxhYmVsXCIgW2F0dHIuYXJpYS1sYWJlbGxlZGJ5XT1cImFyaWFMYWJlbGxlZGJ5XCJcbiAgW2F0dHIuYXJpYS1kZXNjcmliZWRieV09XCJhcmlhRGVzY3JpYmVkQnlcIj5cbjxuZy1jb250ZW50IHNlbGVjdD1cIm5neC1kcm9wem9uZS1sYWJlbFwiICpuZ0lmPVwiIV9oYXNQcmV2aWV3c1wiPjwvbmctY29udGVudD5cbjxuZy1jb250ZW50IHNlbGVjdD1cIm5neC1kcm9wem9uZS1wcmV2aWV3XCI+PC9uZy1jb250ZW50PlxuPG5nLWNvbnRlbnQ+PC9uZy1jb250ZW50PlxuYCxcbiAgc3R5bGVzOiBbYDpob3N0KCl7ZGlzcGxheTpmbGV4O2FsaWduLWl0ZW1zOmNlbnRlcjtoZWlnaHQ6MTgwcHg7YmFja2dyb3VuZDojZmZmO2N1cnNvcjpwb2ludGVyO2NvbG9yOiM3MTczODY7Ym9yZGVyOjJweCBkYXNoZWQgIzcxNzM4Njtib3JkZXItcmFkaXVzOjVweDtmb250LXNpemU6MTZweDtvdmVyZmxvdy14OmF1dG99Omhvc3QoKS5uZ3gtZHotaG92ZXJlZHtib3JkZXItc3R5bGU6c29saWR9Omhvc3QoKS5uZ3gtZHotZGlzYWJsZWR7b3BhY2l0eTouNTtjdXJzb3I6bm8tZHJvcDtwb2ludGVyLWV2ZW50czpub25lfTpob3N0KCkuZXhwYW5kYWJsZXtvdmVyZmxvdzpoaWRkZW47aGVpZ2h0OnVuc2V0O21pbi1oZWlnaHQ6MTgwcHg7ZmxleC13cmFwOndyYXB9Omhvc3QoKS51bmNsaWNrYWJsZXtjdXJzb3I6ZGVmYXVsdH06aG9zdCgpIDo6bmctZGVlcCBuZ3gtZHJvcHpvbmUtbGFiZWx7dGV4dC1hbGlnbjpjZW50ZXI7ei1pbmRleDoxMDttYXJnaW46MTBweCBhdXRvfTpob3N0KCkgaW5wdXR7d2lkdGg6LjFweDtoZWlnaHQ6LjFweDtvcGFjaXR5OjA7b3ZlcmZsb3c6aGlkZGVuO3Bvc2l0aW9uOmFic29sdXRlO3otaW5kZXg6LTF9Omhvc3QoKSBpbnB1dDpmb2N1cys6Om5nLWRlZXAgbmd4LWRyb3B6b25lLWxhYmVse291dGxpbmU6IzAwMCBkb3R0ZWQgMXB4O291dGxpbmU6LXdlYmtpdC1mb2N1cy1yaW5nLWNvbG9yIGF1dG8gNXB4fWBdLFxuICBwcm92aWRlcnM6IFtOZ3hEcm9wem9uZVNlcnZpY2VdXG59KVxuZXhwb3J0IGNsYXNzIE5neERyb3B6b25lQ29tcG9uZW50IHtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBAU2VsZigpIHByaXZhdGUgc2VydmljZTogTmd4RHJvcHpvbmVTZXJ2aWNlXG4gICkgeyB9XG5cbiAgLyoqIEEgbGlzdCBvZiB0aGUgY29udGVudC1wcm9qZWN0ZWQgcHJldmlldyBjaGlsZHJlbi4gKi9cbiAgQENvbnRlbnRDaGlsZHJlbihOZ3hEcm9wem9uZVByZXZpZXdDb21wb25lbnQsIHsgZGVzY2VuZGFudHM6IHRydWUgfSlcbiAgX3ByZXZpZXdDaGlsZHJlbjogUXVlcnlMaXN0PE5neERyb3B6b25lUHJldmlld0NvbXBvbmVudD47XG5cbiAgZ2V0IF9oYXNQcmV2aWV3cygpOiBib29sZWFuIHtcbiAgICByZXR1cm4gISF0aGlzLl9wcmV2aWV3Q2hpbGRyZW4ubGVuZ3RoO1xuICB9XG5cbiAgLyoqIEEgdGVtcGxhdGUgcmVmZXJlbmNlIHRvIHRoZSBuYXRpdmUgZmlsZSBpbnB1dCBlbGVtZW50LiAqL1xuICBAVmlld0NoaWxkKCdmaWxlSW5wdXQnKSBfZmlsZUlucHV0OiBFbGVtZW50UmVmO1xuXG4gIC8qKiBFbWl0dGVkIHdoZW4gYW55IGZpbGVzIHdlcmUgYWRkZWQgb3IgcmVqZWN0ZWQuICovXG4gIEBPdXRwdXQoKSByZWFkb25seSBjaGFuZ2UgPSBuZXcgRXZlbnRFbWl0dGVyPE5neERyb3B6b25lQ2hhbmdlRXZlbnQ+KCk7XG5cbiAgLyoqIFNldCB0aGUgYWNjZXB0ZWQgZmlsZSB0eXBlcy4gRGVmYXVsdHMgdG8gJyonLiAqL1xuICBASW5wdXQoKSBhY2NlcHQgPSAnKic7XG5cbiAgLyoqIERpc2FibGUgYW55IHVzZXIgaW50ZXJhY3Rpb24gd2l0aCB0aGUgY29tcG9uZW50LiAqL1xuICBASW5wdXQoKVxuICBASG9zdEJpbmRpbmcoJ2NsYXNzLm5neC1kei1kaXNhYmxlZCcpXG4gIGdldCBkaXNhYmxlZCgpOiBib29sZWFuIHtcbiAgICByZXR1cm4gdGhpcy5fZGlzYWJsZWQ7XG4gIH1cbiAgc2V0IGRpc2FibGVkKHZhbHVlOiBib29sZWFuKSB7XG4gICAgdGhpcy5fZGlzYWJsZWQgPSBjb2VyY2VCb29sZWFuUHJvcGVydHkodmFsdWUpO1xuXG4gICAgaWYgKHRoaXMuX2lzSG92ZXJlZCkge1xuICAgICAgdGhpcy5faXNIb3ZlcmVkID0gZmFsc2U7XG4gICAgfVxuICB9XG4gIHByaXZhdGUgX2Rpc2FibGVkID0gZmFsc2U7XG5cbiAgLyoqIEFsbG93IHRoZSBzZWxlY3Rpb24gb2YgbXVsdGlwbGUgZmlsZXMuICovXG4gIEBJbnB1dCgpXG4gIGdldCBtdWx0aXBsZSgpOiBib29sZWFuIHtcbiAgICByZXR1cm4gdGhpcy5fbXVsdGlwbGU7XG4gIH1cbiAgc2V0IG11bHRpcGxlKHZhbHVlOiBib29sZWFuKSB7XG4gICAgdGhpcy5fbXVsdGlwbGUgPSBjb2VyY2VCb29sZWFuUHJvcGVydHkodmFsdWUpO1xuICB9XG4gIHByaXZhdGUgX211bHRpcGxlID0gdHJ1ZTtcblxuICAvKiogU2V0IHRoZSBtYXhpbXVtIHNpemUgYSBzaW5nbGUgZmlsZSBtYXkgaGF2ZS4gKi9cbiAgQElucHV0KClcbiAgZ2V0IG1heEZpbGVTaXplKCk6IG51bWJlciB7XG4gICAgcmV0dXJuIHRoaXMuX21heEZpbGVTaXplO1xuICB9XG4gIHNldCBtYXhGaWxlU2l6ZSh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWF4RmlsZVNpemUgPSBjb2VyY2VOdW1iZXJQcm9wZXJ0eSh2YWx1ZSk7XG4gIH1cbiAgcHJpdmF0ZSBfbWF4RmlsZVNpemU6IG51bWJlciA9IHVuZGVmaW5lZDtcblxuICAvKiogQWxsb3cgdGhlIGRyb3B6b25lIGNvbnRhaW5lciB0byBleHBhbmQgdmVydGljYWxseS4gKi9cbiAgQElucHV0KClcbiAgQEhvc3RCaW5kaW5nKCdjbGFzcy5leHBhbmRhYmxlJylcbiAgZ2V0IGV4cGFuZGFibGUoKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuIHRoaXMuX2V4cGFuZGFibGU7XG4gIH1cbiAgc2V0IGV4cGFuZGFibGUodmFsdWU6IGJvb2xlYW4pIHtcbiAgICB0aGlzLl9leHBhbmRhYmxlID0gY29lcmNlQm9vbGVhblByb3BlcnR5KHZhbHVlKTtcbiAgfVxuICBwcml2YXRlIF9leHBhbmRhYmxlOiBib29sZWFuID0gZmFsc2U7XG5cbiAgLyoqIE9wZW4gdGhlIGZpbGUgc2VsZWN0b3Igb24gY2xpY2suICovXG4gIEBJbnB1dCgpXG4gIEBIb3N0QmluZGluZygnY2xhc3MudW5jbGlja2FibGUnKVxuICBnZXQgZGlzYWJsZUNsaWNrKCk6IGJvb2xlYW4ge1xuICAgIHJldHVybiB0aGlzLl9kaXNhYmxlQ2xpY2s7XG4gIH1cbiAgc2V0IGRpc2FibGVDbGljayh2YWx1ZTogYm9vbGVhbikge1xuICAgIHRoaXMuX2Rpc2FibGVDbGljayA9IGNvZXJjZUJvb2xlYW5Qcm9wZXJ0eSh2YWx1ZSk7XG4gIH1cbiAgcHJpdmF0ZSBfZGlzYWJsZUNsaWNrID0gZmFsc2U7XG5cbiAgLyoqIEV4cG9zZSB0aGUgaWQsIGFyaWEtbGFiZWwsIGFyaWEtbGFiZWxsZWRieSBhbmQgYXJpYS1kZXNjcmliZWRieSBvZiB0aGUgbmF0aXZlIGZpbGUgaW5wdXQgZm9yIHByb3BlciBhY2Nlc3NpYmlsaXR5LiAqL1xuICBASW5wdXQoKSBpZDogc3RyaW5nO1xuICBASW5wdXQoJ2FyaWEtbGFiZWwnKSBhcmlhTGFiZWw6IHN0cmluZztcbiAgQElucHV0KCdhcmlhLWxhYmVsbGVkYnknKSBhcmlhTGFiZWxsZWRieTogc3RyaW5nO1xuICBASW5wdXQoJ2FyaWEtZGVzY3JpYmVkYnknKSBhcmlhRGVzY3JpYmVkQnk6IHN0cmluZztcblxuICBASG9zdEJpbmRpbmcoJ2NsYXNzLm5neC1kei1ob3ZlcmVkJylcbiAgX2lzSG92ZXJlZCA9IGZhbHNlO1xuXG4gIC8qKiBTaG93IHRoZSBuYXRpdmUgT1MgZmlsZSBleHBsb3JlciB0byBzZWxlY3QgZmlsZXMuICovXG4gIEBIb3N0TGlzdGVuZXIoJ2NsaWNrJylcbiAgX29uQ2xpY2soKSB7XG4gICAgaWYgKCF0aGlzLmRpc2FibGVDbGljaykge1xuICAgICAgdGhpcy5zaG93RmlsZVNlbGVjdG9yKCk7XG4gICAgfSBcbiAgfVxuXG4gIEBIb3N0TGlzdGVuZXIoJ2RyYWdvdmVyJywgWyckZXZlbnQnXSlcbiAgX29uRHJhZ092ZXIoZXZlbnQpIHtcbiAgICBpZiAodGhpcy5kaXNhYmxlZCkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIHRoaXMucHJldmVudERlZmF1bHQoZXZlbnQpO1xuICAgIHRoaXMuX2lzSG92ZXJlZCA9IHRydWU7XG4gIH1cblxuICBASG9zdExpc3RlbmVyKCdkcmFnbGVhdmUnKVxuICBfb25EcmFnTGVhdmUoKSB7XG4gICAgdGhpcy5faXNIb3ZlcmVkID0gZmFsc2U7XG4gIH1cblxuICBASG9zdExpc3RlbmVyKCdkcm9wJywgWyckZXZlbnQnXSlcbiAgX29uRHJvcChldmVudCkge1xuICAgIGlmICh0aGlzLmRpc2FibGVkKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgdGhpcy5wcmV2ZW50RGVmYXVsdChldmVudCk7XG4gICAgdGhpcy5faXNIb3ZlcmVkID0gZmFsc2U7XG4gICAgdGhpcy5oYW5kbGVGaWxlRHJvcChldmVudC5kYXRhVHJhbnNmZXIuZmlsZXMpO1xuICB9XG4gIFxuICBzaG93RmlsZVNlbGVjdG9yKCkge1xuICAgIGlmICghdGhpcy5kaXNhYmxlZCkge1xuICAgICAgKHRoaXMuX2ZpbGVJbnB1dC5uYXRpdmVFbGVtZW50IGFzIEhUTUxJbnB1dEVsZW1lbnQpLmNsaWNrKCk7XG4gICAgfVxuICB9XG5cbiAgX29uRmlsZXNTZWxlY3RlZChldmVudCkge1xuICAgIGNvbnN0IGZpbGVzOiBGaWxlTGlzdCA9IGV2ZW50LnRhcmdldC5maWxlcztcbiAgICB0aGlzLmhhbmRsZUZpbGVEcm9wKGZpbGVzKTtcblxuICAgIC8vIFJlc2V0IHRoZSBuYXRpdmUgZmlsZSBpbnB1dCBlbGVtZW50IHRvIGFsbG93IHNlbGVjdGluZyB0aGUgc2FtZSBmaWxlIGFnYWluXG4gICAgdGhpcy5fZmlsZUlucHV0Lm5hdGl2ZUVsZW1lbnQudmFsdWUgPSAnJztcblxuICAgIC8vIGZpeCgjMzIpOiBQcmV2ZW50IHRoZSBkZWZhdWx0IGV2ZW50IGJlaGF2aW91ciB3aGljaCBjYXVzZWQgdGhlIGNoYW5nZSBldmVudCB0byBlbWl0IHR3aWNlLlxuICAgIHRoaXMucHJldmVudERlZmF1bHQoZXZlbnQpO1xuICB9XG5cbiAgcHJpdmF0ZSBoYW5kbGVGaWxlRHJvcChmaWxlczogRmlsZUxpc3QpIHtcbiAgICBjb25zdCByZXN1bHQgPSB0aGlzLnNlcnZpY2UucGFyc2VGaWxlTGlzdChmaWxlcywgdGhpcy5hY2NlcHQsIHRoaXMubWF4RmlsZVNpemUsIHRoaXMubXVsdGlwbGUpO1xuXG4gICAgdGhpcy5jaGFuZ2UubmV4dCh7XG4gICAgICBhZGRlZEZpbGVzOiByZXN1bHQuYWRkZWRGaWxlcyxcbiAgICAgIHJlamVjdGVkRmlsZXM6IHJlc3VsdC5yZWplY3RlZEZpbGVzLFxuICAgICAgc291cmNlOiB0aGlzXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIHByZXZlbnREZWZhdWx0KGV2ZW50OiBEcmFnRXZlbnQpIHtcbiAgICBldmVudC5wcmV2ZW50RGVmYXVsdCgpO1xuICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpO1xuICB9XG59XG4iLCJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCwgSG9zdEJpbmRpbmcgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE5neERyb3B6b25lUHJldmlld0NvbXBvbmVudCB9IGZyb20gJy4uL25neC1kcm9wem9uZS1wcmV2aWV3LmNvbXBvbmVudCc7XG5pbXBvcnQgeyBEb21TYW5pdGl6ZXIsIFNhZmVTdHlsZSB9IGZyb20gJ0Bhbmd1bGFyL3BsYXRmb3JtLWJyb3dzZXInO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICduZ3gtZHJvcHpvbmUtaW1hZ2UtcHJldmlldycsXG4gIHRlbXBsYXRlOiBgXG4gICAgPGltZyBbc3JjXT1cImltYWdlU3JjXCIgLz5cblx0XHQ8bmctY29udGVudCBzZWxlY3Q9XCJuZ3gtZHJvcHpvbmUtbGFiZWxcIj48L25nLWNvbnRlbnQ+XG4gICAgPG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UgKm5nSWY9XCJyZW1vdmFibGVcIiAoY2xpY2spPVwiX3JlbW92ZSgkZXZlbnQpXCI+XG4gICAgPC9uZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdlPlxuXHRgLFxuICBzdHlsZXM6IFtgOmhvc3QoKXttaW4td2lkdGg6dW5zZXQhaW1wb3J0YW50O21heC13aWR0aDp1bnNldCFpbXBvcnRhbnQ7cGFkZGluZzowIWltcG9ydGFudH06aG9zdCgpOmZvY3VzIGltZyw6aG9zdCgpOmhvdmVyIGltZ3tvcGFjaXR5Oi43fTpob3N0KCk6Zm9jdXMgbmd4LWRyb3B6b25lLXJlbW92ZS1iYWRnZSw6aG9zdCgpOmhvdmVyIG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2V7b3BhY2l0eToxfTpob3N0KCkgbmd4LWRyb3B6b25lLXJlbW92ZS1iYWRnZXtvcGFjaXR5OjB9Omhvc3QoKSBpbWd7bWF4LWhlaWdodDoxMDAlO2JvcmRlci1yYWRpdXM6NXB4O29wYWNpdHk6Ljh9Omhvc3QoKSA6Om5nLWRlZXAgbmd4LWRyb3B6b25lLWxhYmVse3Bvc2l0aW9uOmFic29sdXRlO292ZXJmbG93LXdyYXA6YnJlYWstd29yZH1gXSxcbiAgcHJvdmlkZXJzOiBbXG4gICAge1xuICAgICAgcHJvdmlkZTogTmd4RHJvcHpvbmVQcmV2aWV3Q29tcG9uZW50LFxuICAgICAgdXNlRXhpc3Rpbmc6IE5neERyb3B6b25lSW1hZ2VQcmV2aWV3Q29tcG9uZW50XG4gICAgfVxuICBdXG59KVxuZXhwb3J0IGNsYXNzIE5neERyb3B6b25lSW1hZ2VQcmV2aWV3Q29tcG9uZW50IGV4dGVuZHMgTmd4RHJvcHpvbmVQcmV2aWV3Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBzYW5pdGl6ZXI6IERvbVNhbml0aXplclxuICApIHtcbiAgICBzdXBlcihzYW5pdGl6ZXIpO1xuICB9XG5cbiAgLyoqIFRoZSBpbWFnZSBkYXRhIHNvdXJjZS4gKi9cbiAgaW1hZ2VTcmM6IHN0cmluZyB8IEFycmF5QnVmZmVyID0gJyc7XG5cbiAgbmdPbkluaXQoKSB7XG4gICAgdGhpcy5yZWFkRmlsZSgpXG4gICAgICAudGhlbihpbWcgPT4gc2V0VGltZW91dCgoKSA9PiB0aGlzLmltYWdlU3JjID0gaW1nKSlcbiAgICAgIC5jYXRjaChlcnIgPT4gY29uc29sZS5lcnJvcihlcnIpKTtcbiAgfVxufVxuIiwiaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ25neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UnLFxuICB0ZW1wbGF0ZTogYFxuICAgIDxzdmc+XG4gICAgICA8bGluZSB4MT1cIjBcIiB5MT1cIjBcIiB4Mj1cIjEwXCIgeTI9XCIxMFwiIC8+XG4gICAgICA8bGluZSB4MT1cIjBcIiB5MT1cIjEwXCIgeDI9XCIxMFwiIHkyPVwiMFwiIC8+XG4gICAgPC9zdmc+XG4gIGAsXG4gIHN0eWxlczogW2A6aG9zdCgpe2Rpc3BsYXk6ZmxleDtqdXN0aWZ5LWNvbnRlbnQ6Y2VudGVyO2FsaWduLWl0ZW1zOmNlbnRlcjtoZWlnaHQ6MjJweDt3aWR0aDoyMnB4O3Bvc2l0aW9uOmFic29sdXRlO3RvcDo1cHg7cmlnaHQ6NXB4O2JvcmRlci1yYWRpdXM6NTAlO2JhY2tncm91bmQ6I2JiYjtjb2xvcjojMzMzO2N1cnNvcjpwb2ludGVyfTpob3N0KCk6aG92ZXJ7YmFja2dyb3VuZDojYWVhZWFlfTpob3N0KCk+c3Zne2hlaWdodDoxMHB4O3dpZHRoOjEwcHh9Omhvc3QoKT5zdmc+bGluZXtzdHJva2Utd2lkdGg6MnB4O3N0cm9rZTojZmZmfWBdXG59KVxuZXhwb3J0IGNsYXNzIE5neERyb3B6b25lUmVtb3ZlQmFkZ2VDb21wb25lbnQgeyB9XG4iLCJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCwgT25EZXN0cm95IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBOZ3hEcm9wem9uZVByZXZpZXdDb21wb25lbnQgfSBmcm9tICcuLi9uZ3gtZHJvcHpvbmUtcHJldmlldy5jb21wb25lbnQnO1xuaW1wb3J0IHsgRG9tU2FuaXRpemVyLCBTYWZlVXJsIH0gZnJvbSAnQGFuZ3VsYXIvcGxhdGZvcm0tYnJvd3Nlcic7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ25neC1kcm9wem9uZS12aWRlby1wcmV2aWV3JyxcbiAgdGVtcGxhdGU6IGBcbiAgICA8dmlkZW8gKm5nSWY9XCJzYW5pdGl6ZWRWaWRlb1NyY1wiIGNvbnRyb2xzIChjbGljayk9XCIkZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcIj5cbiAgICAgIDxzb3VyY2UgW3NyY109XCJzYW5pdGl6ZWRWaWRlb1NyY1wiIC8+XG4gICAgPC92aWRlbz5cbiAgICA8bmctY29udGVudCBzZWxlY3Q9XCJuZ3gtZHJvcHpvbmUtbGFiZWxcIj48L25nLWNvbnRlbnQ+XG4gICAgPG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UgKm5nSWY9XCJyZW1vdmFibGVcIiAoY2xpY2spPVwiX3JlbW92ZSgkZXZlbnQpXCI+XG4gICAgPC9uZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdlPlxuXHRgLFxuICBzdHlsZXM6IFtgOmhvc3QoKXttaW4td2lkdGg6dW5zZXQhaW1wb3J0YW50O21heC13aWR0aDp1bnNldCFpbXBvcnRhbnQ7cGFkZGluZzowIWltcG9ydGFudH06aG9zdCgpOmZvY3VzIHZpZGVvLDpob3N0KCk6aG92ZXIgdmlkZW97b3BhY2l0eTouN306aG9zdCgpOmZvY3VzIG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UsOmhvc3QoKTpob3ZlciBuZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdle29wYWNpdHk6MX06aG9zdCgpIG5neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2V7b3BhY2l0eTowfTpob3N0KCkgdmlkZW97bWF4LWhlaWdodDoxMDAlO2JvcmRlci1yYWRpdXM6NXB4fTpob3N0KCkgOjpuZy1kZWVwIG5neC1kcm9wem9uZS1sYWJlbHtwb3NpdGlvbjphYnNvbHV0ZTtvdmVyZmxvdy13cmFwOmJyZWFrLXdvcmR9YF0sXG4gIHByb3ZpZGVyczogW1xuICAgIHtcbiAgICAgIHByb3ZpZGU6IE5neERyb3B6b25lUHJldmlld0NvbXBvbmVudCxcbiAgICAgIHVzZUV4aXN0aW5nOiBOZ3hEcm9wem9uZVZpZGVvUHJldmlld0NvbXBvbmVudFxuICAgIH1cbiAgXVxufSlcbmV4cG9ydCBjbGFzcyBOZ3hEcm9wem9uZVZpZGVvUHJldmlld0NvbXBvbmVudCBleHRlbmRzIE5neERyb3B6b25lUHJldmlld0NvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgT25EZXN0cm95IHtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBzYW5pdGl6ZXI6IERvbVNhbml0aXplclxuICApIHtcbiAgICBzdXBlcihzYW5pdGl6ZXIpO1xuICB9XG5cbiAgLyoqIFRoZSB2aWRlbyBkYXRhIHNvdXJjZS4gKi9cbiAgc2FuaXRpemVkVmlkZW9TcmM6IFNhZmVVcmw7XG5cbiAgcHJpdmF0ZSB2aWRlb1NyYzogc3RyaW5nO1xuXG4gIG5nT25Jbml0KCkge1xuICAgIGlmICghdGhpcy5maWxlKSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdObyBmaWxlIHRvIHJlYWQuIFBsZWFzZSBwcm92aWRlIGEgZmlsZSB1c2luZyB0aGUgW2ZpbGVdIElucHV0IHByb3BlcnR5LicpO1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFdlIHNhbml0aXplIHRoZSBVUkwgaGVyZSB0byBlbmFibGUgdGhlIHByZXZpZXcuXG4gICAgICogUGxlYXNlIG5vdGUgdGhhdCB0aGlzIGNvdWxkIGNhdXNlIHNlY3VyaXR5IGlzc3VlcyFcbiAgICAgKiovXG4gICAgdGhpcy52aWRlb1NyYyA9IFVSTC5jcmVhdGVPYmplY3RVUkwodGhpcy5maWxlKTtcbiAgICB0aGlzLnNhbml0aXplZFZpZGVvU3JjID0gdGhpcy5zYW5pdGl6ZXIuYnlwYXNzU2VjdXJpdHlUcnVzdFVybCh0aGlzLnZpZGVvU3JjKTtcbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIFVSTC5yZXZva2VPYmplY3RVUkwodGhpcy52aWRlb1NyYyk7XG4gIH1cbn1cbiIsImltcG9ydCB7IE5nTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBDb21tb25Nb2R1bGUgfSBmcm9tICdAYW5ndWxhci9jb21tb24nO1xuaW1wb3J0IHsgTmd4RHJvcHpvbmVMYWJlbERpcmVjdGl2ZSB9IGZyb20gJy4vbmd4LWRyb3B6b25lLWxhYmVsLmRpcmVjdGl2ZSc7XG5pbXBvcnQgeyBOZ3hEcm9wem9uZVByZXZpZXdDb21wb25lbnQgfSBmcm9tICcuL25neC1kcm9wem9uZS1wcmV2aWV3L25neC1kcm9wem9uZS1wcmV2aWV3LmNvbXBvbmVudCc7XG5pbXBvcnQgeyBOZ3hEcm9wem9uZUNvbXBvbmVudCB9IGZyb20gJy4vbmd4LWRyb3B6b25lL25neC1kcm9wem9uZS5jb21wb25lbnQnO1xuaW1wb3J0IHsgTmd4RHJvcHpvbmVJbWFnZVByZXZpZXdDb21wb25lbnQgfSBmcm9tICcuL25neC1kcm9wem9uZS1wcmV2aWV3L25neC1kcm9wem9uZS1pbWFnZS1wcmV2aWV3L25neC1kcm9wem9uZS1pbWFnZS1wcmV2aWV3LmNvbXBvbmVudCc7XG5pbXBvcnQgeyBOZ3hEcm9wem9uZVJlbW92ZUJhZGdlQ29tcG9uZW50IH0gZnJvbSAnLi9uZ3gtZHJvcHpvbmUtcHJldmlldy9uZ3gtZHJvcHpvbmUtcmVtb3ZlLWJhZGdlL25neC1kcm9wem9uZS1yZW1vdmUtYmFkZ2UuY29tcG9uZW50JztcbmltcG9ydCB7IE5neERyb3B6b25lVmlkZW9QcmV2aWV3Q29tcG9uZW50IH0gZnJvbSAnLi9uZ3gtZHJvcHpvbmUtcHJldmlldy9uZ3gtZHJvcHpvbmUtdmlkZW8tcHJldmlldy9uZ3gtZHJvcHpvbmUtdmlkZW8tcHJldmlldy5jb21wb25lbnQnO1xuXG5ATmdNb2R1bGUoe1xuXHRpbXBvcnRzOiBbXG5cdFx0Q29tbW9uTW9kdWxlXG5cdF0sXG5cdGRlY2xhcmF0aW9uczogW1xuXHRcdE5neERyb3B6b25lQ29tcG9uZW50LFxuXHRcdE5neERyb3B6b25lTGFiZWxEaXJlY3RpdmUsXG5cdFx0Tmd4RHJvcHpvbmVQcmV2aWV3Q29tcG9uZW50LFxuXHRcdE5neERyb3B6b25lSW1hZ2VQcmV2aWV3Q29tcG9uZW50LFxuXHRcdE5neERyb3B6b25lUmVtb3ZlQmFkZ2VDb21wb25lbnQsXG5cdFx0Tmd4RHJvcHpvbmVWaWRlb1ByZXZpZXdDb21wb25lbnQsXG5cdF0sXG5cdGV4cG9ydHM6IFtcblx0XHROZ3hEcm9wem9uZUNvbXBvbmVudCxcblx0XHROZ3hEcm9wem9uZUxhYmVsRGlyZWN0aXZlLFxuXHRcdE5neERyb3B6b25lUHJldmlld0NvbXBvbmVudCxcblx0XHROZ3hEcm9wem9uZUltYWdlUHJldmlld0NvbXBvbmVudCxcblx0XHROZ3hEcm9wem9uZVJlbW92ZUJhZGdlQ29tcG9uZW50LFxuXHRcdE5neERyb3B6b25lVmlkZW9QcmV2aWV3Q29tcG9uZW50LFxuXHRdXG59KVxuZXhwb3J0IGNsYXNzIE5neERyb3B6b25lTW9kdWxlIHsgfVxuIl19