export function _createEventBus(pdfJsViewer) {
    var globalEventBus = new pdfJsViewer.EventBus(true);
    attachDOMEventsToEventBus(globalEventBus);
    return globalEventBus;
}
function attachDOMEventsToEventBus(eventBus) {
    eventBus.on('documentload', function () {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('documentload', true, true, {});
        window.dispatchEvent(event);
    });
    eventBus.on('pagerendered', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagerendered', true, true, {
            pageNumber: evt.pageNumber,
            cssTransform: evt.cssTransform
        });
        evt.source.div.dispatchEvent(event);
    });
    eventBus.on('textlayerrendered', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('textlayerrendered', true, true, {
            pageNumber: evt.pageNumber
        });
        evt.source.textLayerDiv.dispatchEvent(event);
    });
    eventBus.on('pagechanging', function (evt) {
        var event = document.createEvent('UIEvents');
        event.initEvent('pagechanging', true, true);
        /* tslint:disable:no-string-literal */
        event['pageNumber'] = evt.pageNumber;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('pagesinit', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagesinit', true, true, null);
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('pagesloaded', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagesloaded', true, true, {
            pagesCount: evt.pagesCount
        });
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('scalechange', function (evt) {
        var event = document.createEvent('UIEvents');
        event.initEvent('scalechange', true, true);
        /* tslint:disable:no-string-literal */
        event['scale'] = evt.scale;
        /* tslint:disable:no-string-literal */
        event['presetValue'] = evt.presetValue;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('updateviewarea', function (evt) {
        var event = document.createEvent('UIEvents');
        event.initEvent('updateviewarea', true, true);
        event['location'] = evt.location;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('find', function (evt) {
        if (evt.source === window) {
            return; // event comes from FirefoxCom, no need to replicate
        }
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('find' + evt.type, true, true, {
            query: evt.query,
            phraseSearch: evt.phraseSearch,
            caseSensitive: evt.caseSensitive,
            highlightAll: evt.highlightAll,
            findPrevious: evt.findPrevious
        });
        window.dispatchEvent(event);
    });
    eventBus.on('attachmentsloaded', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('attachmentsloaded', true, true, {
            attachmentsCount: evt.attachmentsCount
        });
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('sidebarviewchanged', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('sidebarviewchanged', true, true, {
            view: evt.view
        });
        evt.source.outerContainer.dispatchEvent(event);
    });
    eventBus.on('pagemode', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagemode', true, true, {
            mode: evt.mode
        });
        evt.source.pdfViewer.container.dispatchEvent(event);
    });
    eventBus.on('namedaction', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('namedaction', true, true, {
            action: evt.action
        });
        evt.source.pdfViewer.container.dispatchEvent(event);
    });
    eventBus.on('presentationmodechanged', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('presentationmodechanged', true, true, {
            active: evt.active,
            switchInProgress: evt.switchInProgress
        });
        window.dispatchEvent(event);
    });
    eventBus.on('outlineloaded', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('outlineloaded', true, true, {
            outlineCount: evt.outlineCount
        });
        evt.source.container.dispatchEvent(event);
    });
}
export var createEventBus = _createEventBus;
//# sourceMappingURL=data:application/json;base64,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