export function _createEventBus(pdfJsViewer) {
    const globalEventBus = new pdfJsViewer.EventBus(true);
    attachDOMEventsToEventBus(globalEventBus);
    return globalEventBus;
}
function attachDOMEventsToEventBus(eventBus) {
    eventBus.on('documentload', () => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('documentload', true, true, {});
        window.dispatchEvent(event);
    });
    eventBus.on('pagerendered', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagerendered', true, true, {
            pageNumber: evt.pageNumber,
            cssTransform: evt.cssTransform
        });
        evt.source.div.dispatchEvent(event);
    });
    eventBus.on('textlayerrendered', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('textlayerrendered', true, true, {
            pageNumber: evt.pageNumber
        });
        evt.source.textLayerDiv.dispatchEvent(event);
    });
    eventBus.on('pagechanging', evt => {
        const event = document.createEvent('UIEvents');
        event.initEvent('pagechanging', true, true);
        /* tslint:disable:no-string-literal */
        event['pageNumber'] = evt.pageNumber;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('pagesinit', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagesinit', true, true, null);
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('pagesloaded', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagesloaded', true, true, {
            pagesCount: evt.pagesCount
        });
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('scalechange', evt => {
        const event = document.createEvent('UIEvents');
        event.initEvent('scalechange', true, true);
        /* tslint:disable:no-string-literal */
        event['scale'] = evt.scale;
        /* tslint:disable:no-string-literal */
        event['presetValue'] = evt.presetValue;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('updateviewarea', evt => {
        const event = document.createEvent('UIEvents');
        event.initEvent('updateviewarea', true, true);
        event['location'] = evt.location;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('find', evt => {
        if (evt.source === window) {
            return; // event comes from FirefoxCom, no need to replicate
        }
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('find' + evt.type, true, true, {
            query: evt.query,
            phraseSearch: evt.phraseSearch,
            caseSensitive: evt.caseSensitive,
            highlightAll: evt.highlightAll,
            findPrevious: evt.findPrevious
        });
        window.dispatchEvent(event);
    });
    eventBus.on('attachmentsloaded', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('attachmentsloaded', true, true, {
            attachmentsCount: evt.attachmentsCount
        });
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('sidebarviewchanged', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('sidebarviewchanged', true, true, {
            view: evt.view
        });
        evt.source.outerContainer.dispatchEvent(event);
    });
    eventBus.on('pagemode', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagemode', true, true, {
            mode: evt.mode
        });
        evt.source.pdfViewer.container.dispatchEvent(event);
    });
    eventBus.on('namedaction', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('namedaction', true, true, {
            action: evt.action
        });
        evt.source.pdfViewer.container.dispatchEvent(event);
    });
    eventBus.on('presentationmodechanged', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('presentationmodechanged', true, true, {
            active: evt.active,
            switchInProgress: evt.switchInProgress
        });
        window.dispatchEvent(event);
    });
    eventBus.on('outlineloaded', evt => {
        const event = document.createEvent('CustomEvent');
        event.initCustomEvent('outlineloaded', true, true, {
            outlineCount: evt.outlineCount
        });
        evt.source.container.dispatchEvent(event);
    });
}
export const createEventBus = _createEventBus;
//# sourceMappingURL=data:application/json;base64,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