import { buildMessage, ValidateBy } from "./ValidateBy";
import validator from "validator";
export var IS_LATLONG = "isLatLong";
/**
 * Checks if a value is string in format a "latitude,longitude".
 */
export function isLatLong(value) {
    return typeof value === "string" && validator.isLatLong(value);
}
/**
 * Checks if a value is string in format a "latitude,longitude".
 */
export function IsLatLong(validationOptions) {
    return ValidateBy({
        name: IS_LATLONG,
        validator: {
            validate: function (value, args) { return isLatLong(value); },
            defaultMessage: buildMessage(function (eachPrefix) { return eachPrefix + "$property must be a latitude,longitude string"; }, validationOptions)
        }
    }, validationOptions);
}

//# sourceMappingURL=IsLatLong.js.map
