/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { DOCUMENT } from '@angular/common';
import { inject, InjectionToken } from '@angular/core';
/**
 * Injection token used to inject the document into Directionality.
 * This is used so that the value can be faked in tests.
 *
 * We can't use the real document in tests because changing the real `dir` causes geometry-based
 * tests in Safari to fail.
 *
 * We also can't re-provide the DOCUMENT token from platform-brower because the unit tests
 * themselves use things like `querySelector` in test code.
 *
 * This token is defined in a separate file from Directionality as a workaround for
 * https://github.com/angular/angular/issues/22559
 *
 * @docs-private
 */
export var DIR_DOCUMENT = new InjectionToken('cdk-dir-doc', {
    providedIn: 'root',
    factory: DIR_DOCUMENT_FACTORY,
});
/** @docs-private */
export function DIR_DOCUMENT_FACTORY() {
    return inject(DOCUMENT);
}
//# sourceMappingURL=data:application/json;base64,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