(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/cdk/collections'), require('@angular/cdk/coercion'), require('rxjs')) :
    typeof define === 'function' && define.amd ? define('@angular/cdk/accordion', ['exports', '@angular/core', '@angular/cdk/collections', '@angular/cdk/coercion', 'rxjs'], factory) :
    (global = global || self, factory((global.ng = global.ng || {}, global.ng.cdk = global.ng.cdk || {}, global.ng.cdk.accordion = {}), global.ng.core, global.ng.cdk.collections, global.ng.cdk.coercion, global.rxjs));
}(this, (function (exports, core, collections, coercion, rxjs) { 'use strict';

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /** Used to generate unique ID for each accordion. */
    var nextId = 0;
    /**
     * Directive whose purpose is to manage the expanded state of CdkAccordionItem children.
     */
    var CdkAccordion = /** @class */ (function () {
        function CdkAccordion() {
            /** Emits when the state of the accordion changes */
            this._stateChanges = new rxjs.Subject();
            /** Stream that emits true/false when openAll/closeAll is triggered. */
            this._openCloseAllActions = new rxjs.Subject();
            /** A readonly id value to use for unique selection coordination. */
            this.id = "cdk-accordion-" + nextId++;
            this._multi = false;
        }
        Object.defineProperty(CdkAccordion.prototype, "multi", {
            /** Whether the accordion should allow multiple expanded accordion items simultaneously. */
            get: function () { return this._multi; },
            set: function (multi) { this._multi = coercion.coerceBooleanProperty(multi); },
            enumerable: true,
            configurable: true
        });
        /** Opens all enabled accordion items in an accordion where multi is enabled. */
        CdkAccordion.prototype.openAll = function () {
            this._openCloseAll(true);
        };
        /** Closes all enabled accordion items in an accordion where multi is enabled. */
        CdkAccordion.prototype.closeAll = function () {
            this._openCloseAll(false);
        };
        CdkAccordion.prototype.ngOnChanges = function (changes) {
            this._stateChanges.next(changes);
        };
        CdkAccordion.prototype.ngOnDestroy = function () {
            this._stateChanges.complete();
        };
        CdkAccordion.prototype._openCloseAll = function (expanded) {
            if (this.multi) {
                this._openCloseAllActions.next(expanded);
            }
        };
        CdkAccordion.decorators = [
            { type: core.Directive, args: [{
                        selector: 'cdk-accordion, [cdkAccordion]',
                        exportAs: 'cdkAccordion',
                    },] }
        ];
        CdkAccordion.propDecorators = {
            multi: [{ type: core.Input }]
        };
        return CdkAccordion;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /** Used to generate unique ID for each accordion item. */
    var nextId$1 = 0;
    var ɵ0 = undefined;
    /**
     * An basic directive expected to be extended and decorated as a component.  Sets up all
     * events and attributes needed to be managed by a CdkAccordion parent.
     */
    var CdkAccordionItem = /** @class */ (function () {
        function CdkAccordionItem(accordion, _changeDetectorRef, _expansionDispatcher) {
            var _this = this;
            this.accordion = accordion;
            this._changeDetectorRef = _changeDetectorRef;
            this._expansionDispatcher = _expansionDispatcher;
            /** Subscription to openAll/closeAll events. */
            this._openCloseAllSubscription = rxjs.Subscription.EMPTY;
            /** Event emitted every time the AccordionItem is closed. */
            this.closed = new core.EventEmitter();
            /** Event emitted every time the AccordionItem is opened. */
            this.opened = new core.EventEmitter();
            /** Event emitted when the AccordionItem is destroyed. */
            this.destroyed = new core.EventEmitter();
            /**
             * Emits whenever the expanded state of the accordion changes.
             * Primarily used to facilitate two-way binding.
             * @docs-private
             */
            this.expandedChange = new core.EventEmitter();
            /** The unique AccordionItem id. */
            this.id = "cdk-accordion-child-" + nextId$1++;
            this._expanded = false;
            this._disabled = false;
            /** Unregister function for _expansionDispatcher. */
            this._removeUniqueSelectionListener = function () { };
            this._removeUniqueSelectionListener =
                _expansionDispatcher.listen(function (id, accordionId) {
                    if (_this.accordion && !_this.accordion.multi &&
                        _this.accordion.id === accordionId && _this.id !== id) {
                        _this.expanded = false;
                    }
                });
            // When an accordion item is hosted in an accordion, subscribe to open/close events.
            if (this.accordion) {
                this._openCloseAllSubscription = this._subscribeToOpenCloseAllActions();
            }
        }
        Object.defineProperty(CdkAccordionItem.prototype, "expanded", {
            /** Whether the AccordionItem is expanded. */
            get: function () { return this._expanded; },
            set: function (expanded) {
                expanded = coercion.coerceBooleanProperty(expanded);
                // Only emit events and update the internal value if the value changes.
                if (this._expanded !== expanded) {
                    this._expanded = expanded;
                    this.expandedChange.emit(expanded);
                    if (expanded) {
                        this.opened.emit();
                        /**
                         * In the unique selection dispatcher, the id parameter is the id of the CdkAccordionItem,
                         * the name value is the id of the accordion.
                         */
                        var accordionId = this.accordion ? this.accordion.id : this.id;
                        this._expansionDispatcher.notify(this.id, accordionId);
                    }
                    else {
                        this.closed.emit();
                    }
                    // Ensures that the animation will run when the value is set outside of an `@Input`.
                    // This includes cases like the open, close and toggle methods.
                    this._changeDetectorRef.markForCheck();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CdkAccordionItem.prototype, "disabled", {
            /** Whether the AccordionItem is disabled. */
            get: function () { return this._disabled; },
            set: function (disabled) { this._disabled = coercion.coerceBooleanProperty(disabled); },
            enumerable: true,
            configurable: true
        });
        /** Emits an event for the accordion item being destroyed. */
        CdkAccordionItem.prototype.ngOnDestroy = function () {
            this.opened.complete();
            this.closed.complete();
            this.destroyed.emit();
            this.destroyed.complete();
            this._removeUniqueSelectionListener();
            this._openCloseAllSubscription.unsubscribe();
        };
        /** Toggles the expanded state of the accordion item. */
        CdkAccordionItem.prototype.toggle = function () {
            if (!this.disabled) {
                this.expanded = !this.expanded;
            }
        };
        /** Sets the expanded state of the accordion item to false. */
        CdkAccordionItem.prototype.close = function () {
            if (!this.disabled) {
                this.expanded = false;
            }
        };
        /** Sets the expanded state of the accordion item to true. */
        CdkAccordionItem.prototype.open = function () {
            if (!this.disabled) {
                this.expanded = true;
            }
        };
        CdkAccordionItem.prototype._subscribeToOpenCloseAllActions = function () {
            var _this = this;
            return this.accordion._openCloseAllActions.subscribe(function (expanded) {
                // Only change expanded state if item is enabled
                if (!_this.disabled) {
                    _this.expanded = expanded;
                }
            });
        };
        CdkAccordionItem.decorators = [
            { type: core.Directive, args: [{
                        selector: 'cdk-accordion-item, [cdkAccordionItem]',
                        exportAs: 'cdkAccordionItem',
                        providers: [
                            // Provide CdkAccordion as undefined to prevent nested accordion items from registering
                            // to the same accordion.
                            { provide: CdkAccordion, useValue: ɵ0 },
                        ],
                    },] }
        ];
        /** @nocollapse */
        CdkAccordionItem.ctorParameters = function () { return [
            { type: CdkAccordion, decorators: [{ type: core.Optional }, { type: core.SkipSelf }] },
            { type: core.ChangeDetectorRef },
            { type: collections.UniqueSelectionDispatcher }
        ]; };
        CdkAccordionItem.propDecorators = {
            closed: [{ type: core.Output }],
            opened: [{ type: core.Output }],
            destroyed: [{ type: core.Output }],
            expandedChange: [{ type: core.Output }],
            expanded: [{ type: core.Input }],
            disabled: [{ type: core.Input }]
        };
        return CdkAccordionItem;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var CdkAccordionModule = /** @class */ (function () {
        function CdkAccordionModule() {
        }
        CdkAccordionModule.decorators = [
            { type: core.NgModule, args: [{
                        exports: [CdkAccordion, CdkAccordionItem],
                        declarations: [CdkAccordion, CdkAccordionItem],
                    },] }
        ];
        return CdkAccordionModule;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * Generated bundle index. Do not edit.
     */

    exports.CdkAccordion = CdkAccordion;
    exports.CdkAccordionItem = CdkAccordionItem;
    exports.CdkAccordionModule = CdkAccordionModule;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=cdk-accordion.umd.js.map
