const sharp = require('sharp');
const PDFDocument = require('pdfkit');
var fs = require('fs');
var path = require('path');
var Promise = require('bluebird');
const gm = require('gm')
const pdfLib = require('pdf-lib');

Promise.promisifyAll(gm.prototype);

// const gm = require('gm')
// Promise.promisifyAll(gm.prototype);

// cm Pixel Converter
// https://www.blitzrechner.de/pixel-zentimeter-umrechnen/

// Background set
// https://github.com/oliver-moran/jimp/issues/316

// library canvas
// https://github.com/jhuckaby/canvas-plus

// test 5x8 Zoll
// kdp('/home/mk/IdeaProjects/merch-automation/mockups/helplessninja.png', '#d41c6c', 12.7,20.32, 120,
//     'Hello was geht ab !!!', '#9e0e0e')
// test 5x8 Zoll
// kdpBookSpin('/home/mk/IdeaProjects/merch-automation/mockups/helplessninja_1623055194972_127x2032_kdp.pdf', '#d41c6c', 12.7, 20.32, 120,
//     'Hello was geht ab !!!', '#9e0e0e')

// test 5,25x8 Zoll
// kdp('/home/mk/IdeaProjects/angular-electron/mockups/helplessninja.png', '#1cd41f', 13.34 , 20.32, 100,
//     'Hello was geht ab !!!', '#9e0e0e')

// test 5,5x8,5 Zoll
//  kdp('/home/mk/IdeaProjects/angular-electron/mockups/helplessninja.png', '#1cd425', 13.97,21.59, 120,
//      'Hello was geht ab !!!', '#9e0e0e')

// test 6x9 Zoll
// kdp('/home/mk/IdeaProjects/merch-automation/mockups/helplessninja.png', '#d50850', 15.24, 22.86,
//   120, 'Hello was geht ab !!!', '#9e0e0e')

// hoodie('/home/mk/IdeaProjects/merch-automation/mockups/testdesign.png', '#ff22fd')
// phone('/home/mk/IdeaProjects/angular-electron/mockups/partyninja.png', '#ff22fd')
// phone('/home/mk/testproductor.png', '#2298ff')
// popsocket('/home/mk/IdeaProjects/merch-automation/mockups/testdesign.png')
// bag('/home/mk/IdeaProjects/merch-automation/mockups/testdesign.png', '#31ff22')
// phone('/home/mk/IdeaProjects/merch-automation/mockups/testdesign.png', '#22deff')
// popsocket('/home/mk/IdeaProjects/merch-automation/mockups/testdesign.png', null)
// bag('/home/mk/IdeaProjects/angular-electron/mockups/partyninja.png', '#FFF')
// displate('/home/mk/IdeaProjects/angular-electron/mockups/arrogantninja.png', '#ff22fd')
// Society6
// convert arrogantninja_1601935019749_s6.png -background "rgba(0,0,0,0)" -flatten out.png
// s6('/home/mk/Downloads/Ninja T-Shirt02.png')
// vinatge
// vintage('/home/mk/IdeaProjects/angular-electron/mockups/mydesigns/test/angryninja.png',
// '/home/mk/IdeaProjects/angular-electron/templates/vintagify-template3.png')

async function kdpBookSpin(inputPath, colorHex, coverWidthInCm, coverHeightInCm, pageCount, bookSpinTitle, bookSpinTitleHex) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    const stream = fs.readFileSync(inputPath);
    const pdfDoc = await pdfLib.PDFDocument.load(stream)
    const pages = pdfDoc.getPages()
    const helveticaFont = await pdfDoc.embedFont(pdfLib.StandardFonts.Helvetica);
    const firstPage = pages[0];
    const {width, height} = firstPage.getSize()
    if (bookSpinTitle && bookSpinTitle !== '') {
        // let fontSize = Math.round(mmInPx(kdpCoverBookBackMm) / 2);
        let fontSize = 8;
        if (pageCount > 150) {
            fontSize = 11;
        }
        if (pageCount > 250) {
            fontSize = 12;
        }
        if (pageCount > 350) {
            fontSize = 14;
        }
        if (pageCount > 500) {
            fontSize = 20;
        }
        if (pageCount > 700) {
            fontSize = 22;
        }
        const textLength = helveticaFont.widthOfTextAtSize(bookSpinTitle, fontSize) / 2;
        const rgbColor = hexToRgb(bookSpinTitleHex)
        firstPage.drawText(bookSpinTitle, {
            x: width / 2 + (fontSize / 2),
            y: height / 2 - textLength,
            size: fontSize,
            color: pdfLib.rgb(rgbColor.r / 255, rgbColor.g / 255, rgbColor.b / 255),
            font: helveticaFont,
            rotate: pdfLib.degrees(90),
        })
    }
    const pdfBytes = await pdfDoc.save()
    const kdpFormat = `${coverWidthInCm}x${coverHeightInCm}`.replace(/[,\.]/gi, '');
    const returnFilePathPDF = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_${kdpFormat}_kdp.pdf`;
    fs.writeFileSync(returnFilePathPDF, pdfBytes)
    return returnFilePathPDF;
}

function hexToRgb(hex) {
    // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
    });
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}

async function kdp(inputPath, colorHex, coverWidthInCm, coverHeightInCm, pageCount, bookSpinTitle, bookSpinTitleHex) {
    // cm in points => coverWidthInCm * 28.346
    // points to pixel => 612 points * 1.333333333333
    // const kdpCoverHeightInMm = Math.round(coverHeightInCm * 10  + 3.2 + 3.2 );
    // const beschnittzugabe = 3.2
    const kdpCoverHeightInMm = coverHeightInCm * 10 + 3.175 + 3.175;
    const kdpCoverWidthLeftSideInMm = (coverWidthInCm * 10 + 3.175);
    const kdpCoverWidthRightSideInMm = (coverWidthInCm * 10 + 3.175);
    const kdpCoverBookBackMm = (pageCount * 0.0572008);
    const kdpCoverBookFullMm = Math.round(kdpCoverWidthLeftSideInMm + kdpCoverBookBackMm + kdpCoverWidthRightSideInMm);

    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath);
    let backgroundObj = null;
    if (colorHex) {
        backgroundObj = {background: colorHex};
        mbaImage = await mbaImage.flatten(backgroundObj);
    } else {
        backgroundObj = {background: {r: 0, g: 0, b: 0, alpha: 0}};
    }
    const widthInt = Math.round(mmInPx(kdpCoverWidthRightSideInMm));
    const heightInt = Math.round(mmInPx(kdpCoverHeightInMm));
    const paddingRight = Math.round(mmInPx(3.175));
    // Resize shit mit dem padding
    mbaImage = await mbaImage.resize({width: widthInt - paddingRight - paddingRight - paddingRight, height: heightInt, fit: 'contain', ...backgroundObj});
    const paddingLeft = Math.round(mmInPx(kdpCoverWidthLeftSideInMm + kdpCoverBookBackMm));
    mbaImage = await mbaImage.extend({top: 0, bottom: 0, left: paddingLeft + paddingRight + paddingRight, right: paddingRight + paddingRight, ...backgroundObj})
    /*
    // if (bookSpinTitle && bookSpinTitle !== '' ){
    //     const fontSize = mmInPx(kdpCoverBookBackMm);
    //     const watermarkText = Buffer.from(flattenSVG(
    //    `<svg height="${mmInPx(kdpCoverHeightInMm)}" width="${mmInPx(kdpCoverBookFullMm)}">
    //             <text x="50%" y="50%" font-size="${fontSize}px" fill="${(bookSpinTitleHex === '' ? '#FFFFFF': bookSpinTitleHex)}" dominant-baseline="middle" text-anchor="middle" style="writing-mode: tb;">${bookSpinTitle}</text>
    //         </svg>`
    //     ))
    //     const bufferSVG = await sharp(watermarkText, {density: 60}).toBuffer();
    //     mbaImage = await mbaImage.composite([{ input: bufferSVG,  blend: 'over' }])
    // }
    */
    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_kdp.png`;
    await mbaImage.toFile(returnFilePath);
    const pdfWidthFull = Math.round(mmInPt(kdpCoverBookFullMm))
    const pdfHeight = Math.round(mmInPt(kdpCoverHeightInMm))
    const doc = new PDFDocument({layout: 'landscape', size: [pdfHeight, pdfWidthFull]});
    doc.image(returnFilePath, 0, 0, {width: pdfWidthFull, height: pdfHeight});

    if (bookSpinTitle && bookSpinTitle !== '') {

        // let fontSize = Math.round(mmInPx(kdpCoverBookBackMm) / 2);
        let fontSize = 8;
        if (pageCount > 150) {
            fontSize = 11;
        }
        if (pageCount > 250) {
            fontSize = 12;
        }
        if (pageCount > 350) {
            fontSize = 14;
        }
        if (pageCount > 500) {
            fontSize = 20;
        }
        if (pageCount > 700) {
            fontSize = 22;
        }
        doc.save();
        doc.x = pdfWidthFull / 2 + (fontSize / 2);
        doc.fontSize(fontSize);
        const textLength = doc.widthOfString(bookSpinTitle) / 2;
        doc.y = pdfHeight / 2 - textLength;
        doc.fillColor(`${(bookSpinTitleHex === '' ? '#FFFFFF' : bookSpinTitleHex)}`);
        doc.rotate(89.9, {origin: [doc.x, doc.y]});
        doc.text(bookSpinTitle);
        doc.restore();
    }

    const kdpFormat = `${coverWidthInCm}x${coverHeightInCm}`.replace(/[,\.]/gi, '');
    const returnFilePathPDF = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_${kdpFormat}_kdp.pdf`;
    doc.pipe(fs.createWriteStream(returnFilePathPDF));
    doc.end();
    return returnFilePathPDF;
}

async function hoodie(inputPath, colorHex) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath);
    const backgroundObj = {background: {r: 0, g: 0, b: 0, alpha: 0}};


    // TODO Crop the image after trim
    const flattened = await sharp(inputPath)
        .flatten({background: {r: 255, g: 0, b: 255}})
        .removeAlpha()
        .toBuffer();

    const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
    const crop = {
        left: -buffer.info.trimOffsetLeft,
        top: -buffer.info.trimOffsetTop,
        width: buffer.info.width,
        height: buffer.info.height,
    };
    // OLD 28.10.21
    // mbaImage = await mbaImage.extract(crop).resize({width: 3097, height: 3722, fit: sharp.fit.contain,  position: 'center' , ...backgroundObj});
    // mbaImage = await mbaImage.extend({top: 164, bottom: 164, left: 701, right: 702, ...backgroundObj})
    const leftRight = 110;
    const topBottom = 150;
    mbaImage = await mbaImage.extract(crop).resize({width: 4500 - leftRight - leftRight, height: 4050 - topBottom - topBottom, fit: sharp.fit.contain, position: 'center', ...backgroundObj});
    mbaImage = await mbaImage.extend({top: topBottom, bottom: topBottom, left: leftRight, right: leftRight, ...backgroundObj})


    // TODO OLD
    // mbaImage = await mbaImage.trim(255)
    // mbaImage = await mbaImage.removeAlpha()
    // mbaImage = await mbaImage.resize({width: 3097, height: 3722, fit: sharp.fit.contain , ...backgroundObj});

    // mbaImage = await mbaImage.resize({width: 4500, height: 4050, fit: sharp.fit.contain , ...backgroundObj});
    // mbaImage = await mbaImage.resize({width: 4500, height: 4050, fit: sharp.fit.contain , gravity: sharp.gravity.center,  position: sharp.strategy.centre , ...backgroundObj});
    // mbaImage = await mbaImage.resize({width: 4500 - 220, height: 4050 - 200, fit: sharp.fit.contain , ...backgroundObj});
    // mbaImage = await mbaImage.extend({top: 100, bottom: 100, left: 110, right: 110, ...backgroundObj})


    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_hoodie.png`;
    await mbaImage.toFile(returnFilePath);
    return returnFilePath;
}

function mmInPt(mm) {
    return mm * 2.8346456693
}

function mmInPx(mm) {
    return mm * 2.8346456693 * 1.333333333333
}

function ptInPx(pt) {
    return pt * 1.333333333333
}

async function phone(inputPath, colorHex) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath, {density: 300});
    if (colorHex && /^#[0-9A-F]{6}$/i.test(colorHex)) {
        const backgroundObj = {background: colorHex};
        // TODO trim fix
        // mbaImage = await mbaImage.trim();
        // mbaImage = await mbaImage.resize({width: 1100, height: 1414, fit: sharp.fit.contain , ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: 1200 , bottom: Math.floor((1800 - 1414) + 200), left: Math.floor((1800 - 1100) / 2), right: Math.round((1800 - 1100) / 2), ...backgroundObj})
        // mbaImage = await mbaImage.flatten(backgroundObj);

        // mbaImage = await mbaImage.resize({width: 1100, height: 1350, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: 1200, bottom: 650, left: 350, right: 350, ...backgroundObj})
        // mbaImage = await mbaImage.flatten(backgroundObj);

        const flattened = await sharp(inputPath)
            .flatten({background: {r: 255, g: 0, b: 255}})
            .removeAlpha()
            .toBuffer();

        const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
        const crop = {
            left: -buffer.info.trimOffsetLeft,
            top: -buffer.info.trimOffsetTop,
            width: buffer.info.width,
            height: buffer.info.height,
        };
        mbaImage = await mbaImage.extract(crop).resize({width: 1100, height: 1350, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.resize({width: 3097, height: 3722, fit: sharp.fit.contain, position: 'center', ...backgroundObj});
        mbaImage = await mbaImage.extend({top: 1200, bottom: 650, left: 350, right: 350, ...backgroundObj})
        mbaImage = await mbaImage.flatten(backgroundObj);
    } else {
        const backgroundObj = {background: {r: 0, g: 0, b: 0, alpha: 0}};
        const flattened = await sharp(inputPath)
            .flatten({background: {r: 255, g: 0, b: 255}})
            .removeAlpha()
            .toBuffer();

        const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
        const crop = {
            left: -buffer.info.trimOffsetLeft,
            top: -buffer.info.trimOffsetTop,
            width: buffer.info.width,
            height: buffer.info.height,
        };
        mbaImage = await mbaImage.extract(crop).resize({width: 1100, height: 1350, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.resize({width: 3097, height: 3722, fit: sharp.fit.contain, position: 'center', ...backgroundObj});
        mbaImage = await mbaImage.extend({top: 1200, bottom: 650, left: 350, right: 350, ...backgroundObj})
    }
    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_phone.png`;
    await mbaImage.toFile(returnFilePath);
    return returnFilePath;
}


async function popsocket(inputPath, colorHex) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath);
    if (colorHex && /^#[0-9A-F]{6}$/i.test(colorHex)) {
        const backgroundObj = {background: colorHex};
        // mbaImage = await mbaImage.trim();

        const flattened = await sharp(inputPath)
            .flatten({background: {r: 255, g: 0, b: 255}})
            .removeAlpha()
            .toBuffer();

        const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
        const crop = {
            left: -buffer.info.trimOffsetLeft,
            top: -buffer.info.trimOffsetTop,
            width: buffer.info.width,
            height: buffer.info.height,
        };
        mbaImage = await mbaImage.extract(crop).resize({width: 310, height: 310, fit: sharp.fit.contain, ...backgroundObj});
        mbaImage = await mbaImage.extend({top: Math.round((485 - 310) / 2), bottom: Math.floor((485 - 310) / 2), left: Math.floor((485 - 310) / 2), right: Math.round((485 - 310) / 2), ...backgroundObj})


        // mbaImage = await mbaImage.resize({width: 310, height: 310, fit: sharp.fit.contain, ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: Math.round((485 - 310) / 2), bottom: Math.floor((485 - 310) / 2), left: Math.floor((485 - 310) / 2), right: Math.round((485 - 310) / 2), ...backgroundObj})

        // mbaImage = await mbaImage.resize({width: 259, height: 309, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: 88, bottom: 88, left: 113, right: 113, ...backgroundObj})
        mbaImage = await mbaImage.flatten(backgroundObj);
    } else {
        const backgroundObj = {background: {r: 0, g: 0, b: 0, alpha: 0}};
        // mbaImage = await mbaImage.trim();
        const flattened = await sharp(inputPath)
            .flatten({background: {r: 255, g: 0, b: 255}})
            .removeAlpha()
            .toBuffer();

        const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
        const crop = {
            left: -buffer.info.trimOffsetLeft,
            top: -buffer.info.trimOffsetTop,
            width: buffer.info.width,
            height: buffer.info.height,
        };
        mbaImage = await mbaImage.extract(crop).resize({width: 310, height: 310, fit: sharp.fit.contain, ...backgroundObj});
        mbaImage = await mbaImage.extend({top: Math.round((485 - 310) / 2), bottom: Math.floor((485 - 310) / 2), left: Math.floor((485 - 310) / 2), right: Math.round((485 - 310) / 2), ...backgroundObj})


        // mbaImage = await mbaImage.resize({width: 259, height: 309, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: 88, bottom: 88, left: 113, right: 113, ...backgroundObj})
    }
    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_popsocket.png`;
    await mbaImage.toFile(returnFilePath);
    return returnFilePath;
}

async function bag(inputPath, colorHex) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath);
    if (colorHex && /^#[0-9A-F]{6}$/i.test(colorHex)) {
        const backgroundObj = {background: colorHex};
        // mbaImage = await mbaImage.trim();
        // mbaImage = await mbaImage.resize({width: 2125, height: 2125, fit: sharp.fit.contain, ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: Math.round((2925 - 2125) / 2), bottom: Math.floor((2925 - 2125) / 2), left: Math.floor((2925 - 2125) / 2), right: Math.round((2925 - 2125) / 2), ...backgroundObj})

        const flattened = await sharp(inputPath)
            .flatten({background: {r: 255, g: 0, b: 255}})
            .removeAlpha()
            .toBuffer();

        const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
        const crop = {
            left: -buffer.info.trimOffsetLeft,
            top: -buffer.info.trimOffsetTop,
            width: buffer.info.width,
            height: buffer.info.height,
        };
        mbaImage = await mbaImage.extract(crop).resize({width: 2125, height: 2125, fit: sharp.fit.contain, ...backgroundObj});
        mbaImage = await mbaImage.extend({top: Math.round((2925 - 2125) / 2), bottom: Math.floor((2925 - 2125) / 2), left: Math.floor((2925 - 2125) / 2), right: Math.round((2925 - 2125) / 2), ...backgroundObj})


        mbaImage = await mbaImage.flatten(backgroundObj);


        // mbaImage = await mbaImage.resize({width: 1775, height: 2125, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: 400, bottom: 400, left: 575, right: 575, ...backgroundObj})
        // mbaImage = await mbaImage.flatten(backgroundObj);
    } else {
        const backgroundObj = {background: {r: 0, g: 0, b: 0, alpha: 0}};
        // mbaImage = await mbaImage.trim();
        // mbaImage = await mbaImage.resize({width: 2125, height: 2125, fit: sharp.fit.contain, ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: Math.round((2925 - 2125) / 2), bottom: Math.floor((2925 - 2125) / 2), left: Math.floor((2925 - 2125) / 2), right: Math.round((2925 - 2125) / 2), ...backgroundObj})
        // mbaImage = await mbaImage.resize({width: 1775, height: 2125, fit: 'contain', ...backgroundObj});
        // mbaImage = await mbaImage.extend({top: 400, bottom: 400, left: 575, right: 575, ...backgroundObj})

        const flattened = await sharp(inputPath)
            .flatten({background: {r: 255, g: 0, b: 255}})
            .removeAlpha()
            .toBuffer();

        const buffer = await sharp(flattened).trim().toBuffer({resolveWithObject: true})
        const crop = {
            left: -buffer.info.trimOffsetLeft,
            top: -buffer.info.trimOffsetTop,
            width: buffer.info.width,
            height: buffer.info.height,
        };
        mbaImage = await mbaImage.extract(crop).resize({width: 2125, height: 2125, fit: sharp.fit.contain, ...backgroundObj});
        mbaImage = await mbaImage.extend({top: Math.round((2925 - 2125) / 2), bottom: Math.floor((2925 - 2125) / 2), left: Math.floor((2925 - 2125) / 2), right: Math.round((2925 - 2125) / 2), ...backgroundObj})


    }
    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_bag.png`;
    await mbaImage.toFile(returnFilePath);
    return returnFilePath;
}

async function displate(inputPath, colorHex, displateWidth, displateHeight, displateRightLeft, displateTopBottom) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath);
    displateWidth = (displateWidth && displateWidth > 0) ? displateWidth : 2800;
    displateHeight = (displateHeight && displateHeight > 0) ? displateHeight : 4000;
    displateRightLeft = (displateRightLeft && displateRightLeft > 0) ? displateRightLeft : 50;
    displateTopBottom = (displateTopBottom && displateTopBottom > 0) ? displateTopBottom : 30;
    if (colorHex && /^#[0-9A-F]{6}$/i.test(colorHex)) {
        const backgroundObj = {background: colorHex};
        // mbaImage = await mbaImage.resize({width: 2900, height: 4060, fit: 'contain', ...backgroundObj});
        mbaImage = await mbaImage.resize({width: displateWidth, height: displateHeight, fit: 'contain', ...backgroundObj});
        mbaImage = await mbaImage.extend({top: displateTopBottom, bottom: displateTopBottom, left: displateRightLeft, right: displateRightLeft, ...backgroundObj});
        mbaImage = await mbaImage.flatten(backgroundObj);
    } else {
        const backgroundObj = {background: {r: 0, g: 0, b: 0, alpha: 0}};
        // mbaImage = await mbaImage.resize({width: 2900, height: 4060, fit: 'contain', ...backgroundObj});
        mbaImage = await mbaImage.resize({width: displateWidth, height: displateHeight, fit: 'contain', ...backgroundObj});
        mbaImage = await mbaImage.extend({top: displateTopBottom, bottom: displateTopBottom, left: displateRightLeft, right: displateRightLeft, ...backgroundObj});
    }
    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_displate.jpg`;
    await mbaImage.toFile(returnFilePath);
    return returnFilePath;
}

async function s6(inputPath) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_s6black.png`;
    gm.subClass({imageMagick: true});
    try {
        await gm(inputPath).background('rgba(0,0,0,0)').writeAsync(returnFilePath)
    } catch (e) {
        returnFilePath = e.toString()
    }
    return returnFilePath;
}

async function vintage(inputPath, template) {
    const filedir = path.parse(inputPath).dir;
    const filename = path.basename(inputPath);
    let mbaImage = await sharp(inputPath);
    mbaImage = await mbaImage.composite([
        {input: template, blend: 'dest-out'},
    ]);
    const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_vinatege.png`;
    await mbaImage.toFile(returnFilePath);
    return returnFilePath;
}

async function convert(item) {
    // You must all change here also do in the workler.js
    const platform = item.convertTo;
    if (platform === 'hoodie')
        return await hoodie(item.filepath, item.convertHex);
    if (platform === 'popsocket')
        return await popsocket(item.filepath, item.convertHex);
    if (platform === 'phone')
        return await phone(item.filepath, item.convertHex);
    if (platform === 'bag')
        return await bag(item.filepath, item.convertHex);
    if (platform === 'kdp')
        return await kdp(item.filepath, item.convertHex, item.kdpWidth, item.kdpHeight, item.pageCount, item.bookSpinTitle, item.bookSpinTitleHex);
    if (platform === 'displate')
        return await displate(item.filepath, item.convertHex, item.displateWidth, item.displateHeight, item.displateRightLeft, item.displateTopBottom);
    if (platform === 's6')
        return await s6(item.filepath);
    if (platform === 'bookspin')
        return await kdpBookSpin(item.filepath, item.convertHex, item.kdpWidth, item.kdpHeight, item.pageCount, item.bookSpinTitle, item.bookSpinTitleHex);

}

module.exports = {convert, displate, popsocket, hoodie, kdp, phone, s6, bag};

// Old stuff

//http://www.graphicsmagick.org/README.html
// var Jimp = require('jimp');
// // const PDFDocument = require('pdfkit');
// var fs = require('fs');
// var path = require('path');
//
//
// // Background set
// // https://github.com/oliver-moran/jimp/issues/316
//
// // kdp('/home/mk/IdeaProjects/angular-electron/mockups/helplessninja.png', '#ff22fd')
// // hoodie('/home/mk/IdeaProjects/angular-electron/mockups/helplessninja.png', '#ff22fd')
// //popsocket('/home/mk/IdeaProjects/angular-electron/mockups/partyninja.png', '#377c7d')
// // displate('/home/mk/IdeaProjects/angular-electron/mockups/arrogantninja.png', '#ff22fd')
//
// async function kdp(inputPath, colorHex) {
//     const filedir = path.parse(inputPath).dir;
//     const filename = path.basename(inputPath);
//     const cover = await Jimp.read(inputPath);
//     let bgImage = null;
//     if (colorHex)
//         bgImage = await new Jimp(1107.402, 839.055, colorHex);
//     else
//         bgImage = await new Jimp(1107.402, 839.055);
//
//     await cover.scaleToFit(544.252, 839.055).quality(96);
//     await bgImage.composite(cover, 1106 - 544.252, 0, [{mode: Jimp.BLEND_SOURCE_OVER}]);
//     await bgImage.writeAsync(`${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_kdp.png`);
//     const doc = new PDFDocument({layout: 'landscape', size: [629.291, 830.551]});
//     doc.image(`${filedir}/${filename.split('.')[0]}_kdp.png`, 0, 0, {width: 830.551});
//     doc.pipe(fs.createWriteStream(`${filedir}/${filename.split('.')[0]}_kdp.pdf`));
//     doc.end();
// }
//
// async function hoodie(inputPath, colorHex) {
//     const filedir = path.parse(inputPath).dir;
//     const filename = path.basename(inputPath);
//     const mbaImage = await Jimp.read(inputPath);
//     const bgImage = await new Jimp(4500, 4050);
//     mbaImage.scaleToFit(3375, 4050).quality(96)
//     bgImage.composite(mbaImage, 4050 - 3375, 0, [{mode: Jimp.BLEND_SOURCE_OVER}]);
//     const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_hoodie.png`;
//     bgImage.write(returnFilePath);
//     return returnFilePath;
// }
//
//
// async function popsocket(inputPath, colorHex) {
//     const filedir = path.parse(inputPath).dir;
//     const filename = path.basename(inputPath);
//     const mbaImage = await Jimp.read(inputPath);
//     let bgImage = null;
//     if (colorHex)
//         bgImage = await new Jimp(485, 485, colorHex);
//     else
//         bgImage = await new Jimp(485, 485);
//     const popSocketBorder = 10
//     mbaImage.scaleToFit(404.167, 485 - popSocketBorder).quality(96);
//     bgImage.composite(mbaImage, (485 - 404.167) / 2, popSocketBorder / 2, [{mode: Jimp.BLEND_SOURCE_OVER}]);
//     const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_popsocket.png`;
//     bgImage.write(returnFilePath);
//     return returnFilePath;
// }
//
// //0x4d4d4dff
// async function displate(inputPath, colorHex) {
//     const filedir = path.parse(inputPath).dir;
//     const filename = path.basename(inputPath);
//     const mbaImage = await Jimp.read(inputPath);
//     let bgImage = null;
//     if (colorHex)
//         bgImage = await new Jimp(2900, 4060, colorHex);
//     else
//         bgImage = await new Jimp(2900, 4060);
//     mbaImage.scaleToFit(2900, 3480).quality(96);
//     bgImage.composite(mbaImage, 0, (4060 - 3480) / 2, [{mode: Jimp.BLEND_SOURCE_OVER}]);
//     const returnFilePath = `${filedir}/${filename.split('.')[0]}_${new Date().getTime()}_displate.jpg`;
//     bgImage.write(returnFilePath);
//     return returnFilePath;
// }

// function flattenSVG(svg) {
//     const images = svg.match(/<image [^>]+>/g);
//     if (!images || images.length < 1) {
//         return svg;
//     }
//
//     var result = svg;
//     images.forEach(image => {
//         const [, data] = image.match(/ xlink:href="data:image\/svg\+xml;base64,([^"]+)"/) || [];
//         if (!data) {
//             return;
//         }
//
//         const innerSVG = Buffer.from(data, 'base64').toString();
//         const [, width] = image.match(/ width="([^"]+)"/) || [];
//         const [, height] = image.match(/ height="([^"]+)"/) || [];
//         const [, opacity] = image.match(/ opacity="([^"]+)"/) || [];
//         const [, x] = image.match(/ x="([^"]+)"/) || [];
//         const [, y] = image.match(/ y="([^"]+)"/) || [];
//         const [header] = innerSVG && innerSVG.match(/<svg[^>]+>/) || [];
//         const fixedHeader = header
//             .replace(/ (x|y|width|height)="([^"]+)"/g, '')
//             .replace('<svg', `<svg x="${x}" y="${y}" width="${width}" height="${height}" opacity="${opacity || 1.0}"`);
//         const replacement = innerSVG && innerSVG.replace(header, fixedHeader);
//         result = result.replace(image, replacement);
//     });
//
//     return result;
// }
