var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var ObjectUtils = /** @class */ (function () {
    function ObjectUtils() {
    }
    ObjectUtils.equals = function (obj1, obj2, field) {
        if (field)
            return (this.resolveFieldData(obj1, field) === this.resolveFieldData(obj2, field));
        else
            return this.equalsByValue(obj1, obj2);
    };
    ObjectUtils.equalsByValue = function (obj1, obj2) {
        if (obj1 === obj2)
            return true;
        if (obj1 && obj2 && typeof obj1 == 'object' && typeof obj2 == 'object') {
            var arrA = Array.isArray(obj1), arrB = Array.isArray(obj2), i, length, key;
            if (arrA && arrB) {
                length = obj1.length;
                if (length != obj2.length)
                    return false;
                for (i = length; i-- !== 0;)
                    if (!this.equalsByValue(obj1[i], obj2[i]))
                        return false;
                return true;
            }
            if (arrA != arrB)
                return false;
            var dateA = obj1 instanceof Date, dateB = obj2 instanceof Date;
            if (dateA != dateB)
                return false;
            if (dateA && dateB)
                return obj1.getTime() == obj2.getTime();
            var regexpA = obj1 instanceof RegExp, regexpB = obj2 instanceof RegExp;
            if (regexpA != regexpB)
                return false;
            if (regexpA && regexpB)
                return obj1.toString() == obj2.toString();
            var keys = Object.keys(obj1);
            length = keys.length;
            if (length !== Object.keys(obj2).length)
                return false;
            for (i = length; i-- !== 0;)
                if (!Object.prototype.hasOwnProperty.call(obj2, keys[i]))
                    return false;
            for (i = length; i-- !== 0;) {
                key = keys[i];
                if (!this.equalsByValue(obj1[key], obj2[key]))
                    return false;
            }
            return true;
        }
        return obj1 !== obj1 && obj2 !== obj2;
    };
    ObjectUtils.resolveFieldData = function (data, field) {
        if (data && field) {
            if (this.isFunction(field)) {
                return field(data);
            }
            else if (field.indexOf('.') == -1) {
                return data[field];
            }
            else {
                var fields = field.split('.');
                var value = data;
                for (var i = 0, len = fields.length; i < len; ++i) {
                    if (value == null) {
                        return null;
                    }
                    value = value[fields[i]];
                }
                return value;
            }
        }
        else {
            return null;
        }
    };
    ObjectUtils.isFunction = function (obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
    };
    ObjectUtils.reorderArray = function (value, from, to) {
        var target;
        if (value && from !== to) {
            if (to >= value.length) {
                to %= value.length;
                from %= value.length;
            }
            value.splice(to, 0, value.splice(from, 1)[0]);
        }
    };
    ObjectUtils.generateSelectItems = function (val, field) {
        var e_1, _a;
        var selectItems;
        if (val && val.length) {
            selectItems = [];
            try {
                for (var val_1 = __values(val), val_1_1 = val_1.next(); !val_1_1.done; val_1_1 = val_1.next()) {
                    var item = val_1_1.value;
                    selectItems.push({ label: this.resolveFieldData(item, field), value: item });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (val_1_1 && !val_1_1.done && (_a = val_1.return)) _a.call(val_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        return selectItems;
    };
    ObjectUtils.insertIntoOrderedArray = function (item, index, arr, sourceArr) {
        if (arr.length > 0) {
            var injected = false;
            for (var i = 0; i < arr.length; i++) {
                var currentItemIndex = this.findIndexInList(arr[i], sourceArr);
                if (currentItemIndex > index) {
                    arr.splice(i, 0, item);
                    injected = true;
                    break;
                }
            }
            if (!injected) {
                arr.push(item);
            }
        }
        else {
            arr.push(item);
        }
    };
    ObjectUtils.findIndexInList = function (item, list) {
        var index = -1;
        if (list) {
            for (var i = 0; i < list.length; i++) {
                if (list[i] == item) {
                    index = i;
                    break;
                }
            }
        }
        return index;
    };
    ObjectUtils.removeAccents = function (str) {
        if (str && str.search(/[\xC0-\xFF]/g) > -1) {
            str = str
                .replace(/[\xC0-\xC5]/g, "A")
                .replace(/[\xC6]/g, "AE")
                .replace(/[\xC7]/g, "C")
                .replace(/[\xC8-\xCB]/g, "E")
                .replace(/[\xCC-\xCF]/g, "I")
                .replace(/[\xD0]/g, "D")
                .replace(/[\xD1]/g, "N")
                .replace(/[\xD2-\xD6\xD8]/g, "O")
                .replace(/[\xD9-\xDC]/g, "U")
                .replace(/[\xDD]/g, "Y")
                .replace(/[\xDE]/g, "P")
                .replace(/[\xE0-\xE5]/g, "a")
                .replace(/[\xE6]/g, "ae")
                .replace(/[\xE7]/g, "c")
                .replace(/[\xE8-\xEB]/g, "e")
                .replace(/[\xEC-\xEF]/g, "i")
                .replace(/[\xF1]/g, "n")
                .replace(/[\xF2-\xF6\xF8]/g, "o")
                .replace(/[\xF9-\xFC]/g, "u")
                .replace(/[\xFE]/g, "p")
                .replace(/[\xFD\xFF]/g, "y");
        }
        return str;
    };
    return ObjectUtils;
}());
export { ObjectUtils };
//# sourceMappingURL=data:application/json;base64,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