var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { NgModule, Directive, ElementRef, HostListener, Input, forwardRef, Output, EventEmitter } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomHandler } from 'primeng/dom';
import { NG_VALIDATORS } from '@angular/forms';
export const KEYFILTER_VALIDATOR = {
    provide: NG_VALIDATORS,
    useExisting: forwardRef(() => KeyFilter),
    multi: true
};
const DEFAULT_MASKS = {
    pint: /[\d]/,
    'int': /[\d\-]/,
    pnum: /[\d\.]/,
    money: /[\d\.\s,]/,
    num: /[\d\-\.]/,
    hex: /[0-9a-f]/i,
    email: /[a-z0-9_\.\-@]/i,
    alpha: /[a-z_]/i,
    alphanum: /[a-z0-9_]/i
};
const KEYS = {
    TAB: 9,
    RETURN: 13,
    ESC: 27,
    BACKSPACE: 8,
    DELETE: 46
};
const SAFARI_KEYS = {
    63234: 37,
    63235: 39,
    63232: 38,
    63233: 40,
    63276: 33,
    63277: 34,
    63272: 46,
    63273: 36,
    63275: 35 // end
};
let KeyFilter = class KeyFilter {
    constructor(el) {
        this.el = el;
        this.ngModelChange = new EventEmitter();
        this.isAndroid = DomHandler.isAndroid();
    }
    get pattern() {
        return this._pattern;
    }
    set pattern(_pattern) {
        this._pattern = _pattern;
        this.regex = DEFAULT_MASKS[this._pattern] || this._pattern;
    }
    isNavKeyPress(e) {
        let k = e.keyCode;
        k = DomHandler.getBrowser().safari ? (SAFARI_KEYS[k] || k) : k;
        return (k >= 33 && k <= 40) || k == KEYS.RETURN || k == KEYS.TAB || k == KEYS.ESC;
    }
    ;
    isSpecialKey(e) {
        let k = e.keyCode || e.charCode;
        return k == 9 || k == 13 || k == 27 || k == 16 || k == 17 || (k >= 18 && k <= 20) ||
            (DomHandler.getBrowser().opera && !e.shiftKey && (k == 8 || (k >= 33 && k <= 35) || (k >= 36 && k <= 39) || (k >= 44 && k <= 45)));
    }
    getKey(e) {
        let k = e.keyCode || e.charCode;
        return DomHandler.getBrowser().safari ? (SAFARI_KEYS[k] || k) : k;
    }
    getCharCode(e) {
        return e.charCode || e.keyCode || e.which;
    }
    findDelta(value, prevValue) {
        let delta = '';
        for (let i = 0; i < value.length; i++) {
            let str = value.substr(0, i) + value.substr(i + value.length - prevValue.length);
            if (str === prevValue)
                delta = value.substr(i, value.length - prevValue.length);
        }
        return delta;
    }
    isValidChar(c) {
        return this.regex.test(c);
    }
    isValidString(str) {
        for (let i = 0; i < str.length; i++) {
            if (!this.isValidChar(str.substr(i, 1))) {
                return false;
            }
        }
        return true;
    }
    onInput(e) {
        if (this.isAndroid && !this.pValidateOnly) {
            let val = this.el.nativeElement.value;
            let lastVal = this.lastValue || '';
            let inserted = this.findDelta(val, lastVal);
            let removed = this.findDelta(lastVal, val);
            let pasted = inserted.length > 1 || (!inserted && !removed);
            if (pasted) {
                if (!this.isValidString(val)) {
                    this.el.nativeElement.value = lastVal;
                    this.ngModelChange.emit(lastVal);
                }
            }
            else if (!removed) {
                if (!this.isValidChar(inserted)) {
                    this.el.nativeElement.value = lastVal;
                    this.ngModelChange.emit(lastVal);
                }
            }
            val = this.el.nativeElement.value;
            if (this.isValidString(val)) {
                this.lastValue = val;
            }
        }
    }
    onKeyPress(e) {
        if (this.isAndroid || this.pValidateOnly) {
            return;
        }
        let browser = DomHandler.getBrowser();
        let k = this.getKey(e);
        if (browser.mozilla && (e.ctrlKey || e.altKey)) {
            return;
        }
        else if (k == 17 || k == 18) {
            return;
        }
        let c = this.getCharCode(e);
        let cc = String.fromCharCode(c);
        let ok = true;
        if (!browser.mozilla && (this.isSpecialKey(e) || !cc)) {
            return;
        }
        ok = this.regex.test(cc);
        if (!ok) {
            e.preventDefault();
        }
    }
    onPaste(e) {
        const clipboardData = e.clipboardData || window.clipboardData.getData('text');
        if (clipboardData) {
            const pastedText = clipboardData.getData('text');
            for (let char of pastedText.toString()) {
                if (!this.regex.test(char)) {
                    e.preventDefault();
                    return;
                }
            }
        }
    }
    validate(c) {
        if (this.pValidateOnly) {
            let value = this.el.nativeElement.value;
            if (value && !this.regex.test(value)) {
                return {
                    validatePattern: false
                };
            }
        }
    }
};
KeyFilter.ctorParameters = () => [
    { type: ElementRef }
];
__decorate([
    Input()
], KeyFilter.prototype, "pValidateOnly", void 0);
__decorate([
    Output()
], KeyFilter.prototype, "ngModelChange", void 0);
__decorate([
    Input('pKeyFilter')
], KeyFilter.prototype, "pattern", null);
__decorate([
    HostListener('input', ['$event'])
], KeyFilter.prototype, "onInput", null);
__decorate([
    HostListener('keypress', ['$event'])
], KeyFilter.prototype, "onKeyPress", null);
__decorate([
    HostListener('paste', ['$event'])
], KeyFilter.prototype, "onPaste", null);
KeyFilter = __decorate([
    Directive({
        selector: '[pKeyFilter]',
        providers: [KEYFILTER_VALIDATOR]
    })
], KeyFilter);
export { KeyFilter };
let KeyFilterModule = class KeyFilterModule {
};
KeyFilterModule = __decorate([
    NgModule({
        imports: [CommonModule],
        exports: [KeyFilter],
        declarations: [KeyFilter]
    })
], KeyFilterModule);
export { KeyFilterModule };
//# sourceMappingURL=data:application/json;base64,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