!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/common"),require("@angular/platform-browser"),require("primeng/button"),require("primeng/messages"),require("primeng/progressbar"),require("primeng/dom"),require("primeng/api"),require("@angular/common/http")):"function"==typeof define&&define.amd?define("primeng/fileupload",["exports","@angular/core","@angular/common","@angular/platform-browser","primeng/button","primeng/messages","primeng/progressbar","primeng/dom","primeng/api","@angular/common/http"],t):t(((e=e||self).primeng=e.primeng||{},e.primeng.fileupload={}),e.ng.core,e.ng.common,e.ng.platformBrowser,e.primeng.button,e.primeng.messages,e.primeng.progressbar,e.primeng.dom,e.primeng.api,e.ng.common.http)}(this,(function(e,t,i,o,n,s,l,a,r,p){"use strict";var u=this&&this.__decorate||function(e,t,i,o){var n,s=arguments.length,l=s<3?t:null===o?o=Object.getOwnPropertyDescriptor(t,i):o;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)l=Reflect.decorate(e,t,i,o);else for(var a=e.length-1;a>=0;a--)(n=e[a])&&(l=(s<3?n(l):s>3?n(t,i,l):n(t,i))||l);return s>3&&l&&Object.defineProperty(t,i,l),l},d=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,i=t&&e[t],o=0;if(i)return i.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&o>=e.length&&(e=void 0),{value:e&&e[o++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")},c=function(){function e(e,i,o,n){this.el=e,this.sanitizer=i,this.zone=o,this.http=n,this.method="POST",this.invalidFileSizeMessageSummary="{0}: Invalid file size, ",this.invalidFileSizeMessageDetail="maximum upload size is {0}.",this.invalidFileTypeMessageSummary="{0}: Invalid file type, ",this.invalidFileTypeMessageDetail="allowed file types: {0}.",this.invalidFileLimitMessageDetail="limit is {0} at most.",this.invalidFileLimitMessageSummary="Maximum number of files exceeded, ",this.previewWidth=50,this.chooseLabel="Choose",this.uploadLabel="Upload",this.cancelLabel="Cancel",this.chooseIcon="pi pi-plus",this.uploadIcon="pi pi-upload",this.cancelIcon="pi pi-times",this.showUploadButton=!0,this.showCancelButton=!0,this.mode="advanced",this.onBeforeUpload=new t.EventEmitter,this.onSend=new t.EventEmitter,this.onUpload=new t.EventEmitter,this.onError=new t.EventEmitter,this.onClear=new t.EventEmitter,this.onRemove=new t.EventEmitter,this.onSelect=new t.EventEmitter,this.onProgress=new t.EventEmitter,this.uploadHandler=new t.EventEmitter,this._files=[],this.progress=0,this.uploadedFileCount=0}return Object.defineProperty(e.prototype,"files",{get:function(){return this._files},set:function(e){this._files=[];for(var t=0;t<e.length;t++){var i=e[t];this.validate(i)&&(this.isImage(i)&&(i.objectURL=this.sanitizer.bypassSecurityTrustUrl(window.URL.createObjectURL(e[t]))),this._files.push(e[t]))}},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this.templates.forEach((function(t){switch(t.getType()){case"file":e.fileTemplate=t.template;break;case"content":e.contentTemplate=t.template;break;case"toolbar":e.toolbarTemplate=t.template;break;default:e.fileTemplate=t.template}}))},e.prototype.ngAfterViewInit=function(){var e=this;"advanced"===this.mode&&this.zone.runOutsideAngular((function(){e.content&&e.content.nativeElement.addEventListener("dragover",e.onDragOver.bind(e))}))},e.prototype.onFileSelect=function(e){if("drop"!==e.type&&this.isIE11()&&this.duplicateIEEvent)this.duplicateIEEvent=!1;else{this.msgs=[],this.multiple||(this.files=[]);for(var t=e.dataTransfer?e.dataTransfer.files:e.target.files,i=0;i<t.length;i++){var o=t[i];this.isFileSelected(o)||this.validate(o)&&(this.isImage(o)&&(o.objectURL=this.sanitizer.bypassSecurityTrustUrl(window.URL.createObjectURL(t[i]))),this.files.push(t[i]))}this.onSelect.emit({originalEvent:e,files:t,currentFiles:this.files}),this.fileLimit&&"advanced"==this.mode&&this.checkFileLimit(),!this.hasFiles()||!this.auto||"advanced"===this.mode&&this.isFileLimitExceeded()||this.upload(),"drop"!==e.type&&this.isIE11()?this.clearIEInput():this.clearInputElement()}},e.prototype.isFileSelected=function(e){var t,i;try{for(var o=d(this.files),n=o.next();!n.done;n=o.next()){var s=n.value;if(s.name+s.type+s.size===e.name+e.type+e.size)return!0}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}return!1},e.prototype.isIE11=function(){return!!window.MSInputMethodContext&&!!document.documentMode},e.prototype.validate=function(e){return this.accept&&!this.isFileTypeValid(e)?(this.msgs.push({severity:"error",summary:this.invalidFileTypeMessageSummary.replace("{0}",e.name),detail:this.invalidFileTypeMessageDetail.replace("{0}",this.accept)}),!1):!(this.maxFileSize&&e.size>this.maxFileSize)||(this.msgs.push({severity:"error",summary:this.invalidFileSizeMessageSummary.replace("{0}",e.name),detail:this.invalidFileSizeMessageDetail.replace("{0}",this.formatSize(this.maxFileSize))}),!1)},e.prototype.isFileTypeValid=function(e){var t,i,o=this.accept.split(",").map((function(e){return e.trim()}));try{for(var n=d(o),s=n.next();!s.done;s=n.next()){var l=s.value;if(this.isWildcard(l)?this.getTypeClass(e.type)===this.getTypeClass(l):e.type==l||this.getFileExtension(e).toLowerCase()===l.toLowerCase())return!0}}catch(e){t={error:e}}finally{try{s&&!s.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}return!1},e.prototype.getTypeClass=function(e){return e.substring(0,e.indexOf("/"))},e.prototype.isWildcard=function(e){return-1!==e.indexOf("*")},e.prototype.getFileExtension=function(e){return"."+e.name.split(".").pop()},e.prototype.isImage=function(e){return/^image\//.test(e.type)},e.prototype.onImageLoad=function(e){window.URL.revokeObjectURL(e.src)},e.prototype.upload=function(){var e=this;if(this.customUpload)this.fileLimit&&(this.uploadedFileCount+=this.files.length),this.uploadHandler.emit({files:this.files});else{this.uploading=!0,this.msgs=[];var t=new FormData;this.onBeforeUpload.emit({formData:t});for(var i=0;i<this.files.length;i++)t.append(this.name,this.files[i],this.files[i].name);this.http.post(this.url,t,{headers:this.headers,reportProgress:!0,observe:"events",withCredentials:this.withCredentials}).subscribe((function(i){switch(i.type){case p.HttpEventType.Sent:e.onSend.emit({originalEvent:i,formData:t});break;case p.HttpEventType.Response:e.uploading=!1,e.progress=0,i.status>=200&&i.status<300?(e.fileLimit&&(e.uploadedFileCount+=e.files.length),e.onUpload.emit({originalEvent:i,files:e.files})):e.onError.emit({files:e.files}),e.clear();break;case p.HttpEventType.UploadProgress:i.loaded&&(e.progress=Math.round(100*i.loaded/i.total)),e.onProgress.emit({originalEvent:i,progress:e.progress})}}),(function(t){e.uploading=!1,e.onError.emit({files:e.files,error:t})}))}},e.prototype.clear=function(){this.files=[],this.onClear.emit(),this.clearInputElement()},e.prototype.remove=function(e,t){this.clearInputElement(),this.onRemove.emit({originalEvent:e,file:this.files[t]}),this.files.splice(t,1)},e.prototype.isFileLimitExceeded=function(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount&&this.focus&&(this.focus=!1),this.fileLimit&&this.fileLimit<this.files.length+this.uploadedFileCount},e.prototype.isChooseDisabled=function(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount},e.prototype.checkFileLimit=function(){this.isFileLimitExceeded()&&this.msgs.push({severity:"error",summary:this.invalidFileLimitMessageSummary.replace("{0}",this.fileLimit.toString()),detail:this.invalidFileLimitMessageDetail.replace("{0}",this.fileLimit.toString())})},e.prototype.clearInputElement=function(){this.advancedFileInput&&this.advancedFileInput.nativeElement&&(this.advancedFileInput.nativeElement.value=""),this.basicFileInput&&this.basicFileInput.nativeElement&&(this.basicFileInput.nativeElement.value="")},e.prototype.clearIEInput=function(){this.advancedFileInput&&this.advancedFileInput.nativeElement&&(this.duplicateIEEvent=!0,this.advancedFileInput.nativeElement.value="")},e.prototype.hasFiles=function(){return this.files&&this.files.length>0},e.prototype.onDragEnter=function(e){this.disabled||(e.stopPropagation(),e.preventDefault())},e.prototype.onDragOver=function(e){this.disabled||(a.DomHandler.addClass(this.content.nativeElement,"ui-fileupload-highlight"),this.dragHighlight=!0,e.stopPropagation(),e.preventDefault())},e.prototype.onDragLeave=function(e){this.disabled||a.DomHandler.removeClass(this.content.nativeElement,"ui-fileupload-highlight")},e.prototype.onDrop=function(e){if(!this.disabled){a.DomHandler.removeClass(this.content.nativeElement,"ui-fileupload-highlight"),e.stopPropagation(),e.preventDefault();var t=e.dataTransfer?e.dataTransfer.files:e.target.files;(this.multiple||t&&1===t.length)&&this.onFileSelect(e)}},e.prototype.onFocus=function(){this.focus=!0},e.prototype.onBlur=function(){this.focus=!1},e.prototype.formatSize=function(e){if(0==e)return"0 B";var t=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,t)).toFixed(3))+" "+["B","KB","MB","GB","TB","PB","EB","ZB","YB"][t]},e.prototype.onSimpleUploaderClick=function(e){this.hasFiles()&&this.upload()},e.prototype.getBlockableElement=function(){return this.el.nativeElement.children[0]},e.prototype.ngOnDestroy=function(){this.content&&this.content.nativeElement&&this.content.nativeElement.removeEventListener("dragover",this.onDragOver)},e.ctorParameters=function(){return[{type:t.ElementRef},{type:o.DomSanitizer},{type:t.NgZone},{type:p.HttpClient}]},u([t.Input()],e.prototype,"name",void 0),u([t.Input()],e.prototype,"url",void 0),u([t.Input()],e.prototype,"method",void 0),u([t.Input()],e.prototype,"multiple",void 0),u([t.Input()],e.prototype,"accept",void 0),u([t.Input()],e.prototype,"disabled",void 0),u([t.Input()],e.prototype,"auto",void 0),u([t.Input()],e.prototype,"withCredentials",void 0),u([t.Input()],e.prototype,"maxFileSize",void 0),u([t.Input()],e.prototype,"invalidFileSizeMessageSummary",void 0),u([t.Input()],e.prototype,"invalidFileSizeMessageDetail",void 0),u([t.Input()],e.prototype,"invalidFileTypeMessageSummary",void 0),u([t.Input()],e.prototype,"invalidFileTypeMessageDetail",void 0),u([t.Input()],e.prototype,"invalidFileLimitMessageDetail",void 0),u([t.Input()],e.prototype,"invalidFileLimitMessageSummary",void 0),u([t.Input()],e.prototype,"style",void 0),u([t.Input()],e.prototype,"styleClass",void 0),u([t.Input()],e.prototype,"previewWidth",void 0),u([t.Input()],e.prototype,"chooseLabel",void 0),u([t.Input()],e.prototype,"uploadLabel",void 0),u([t.Input()],e.prototype,"cancelLabel",void 0),u([t.Input()],e.prototype,"chooseIcon",void 0),u([t.Input()],e.prototype,"uploadIcon",void 0),u([t.Input()],e.prototype,"cancelIcon",void 0),u([t.Input()],e.prototype,"showUploadButton",void 0),u([t.Input()],e.prototype,"showCancelButton",void 0),u([t.Input()],e.prototype,"mode",void 0),u([t.Input()],e.prototype,"headers",void 0),u([t.Input()],e.prototype,"customUpload",void 0),u([t.Input()],e.prototype,"fileLimit",void 0),u([t.Output()],e.prototype,"onBeforeUpload",void 0),u([t.Output()],e.prototype,"onSend",void 0),u([t.Output()],e.prototype,"onUpload",void 0),u([t.Output()],e.prototype,"onError",void 0),u([t.Output()],e.prototype,"onClear",void 0),u([t.Output()],e.prototype,"onRemove",void 0),u([t.Output()],e.prototype,"onSelect",void 0),u([t.Output()],e.prototype,"onProgress",void 0),u([t.Output()],e.prototype,"uploadHandler",void 0),u([t.ContentChildren(r.PrimeTemplate)],e.prototype,"templates",void 0),u([t.ViewChild("advancedfileinput")],e.prototype,"advancedFileInput",void 0),u([t.ViewChild("basicfileinput")],e.prototype,"basicFileInput",void 0),u([t.ViewChild("content")],e.prototype,"content",void 0),u([t.Input()],e.prototype,"files",null),e=u([t.Component({selector:"p-fileUpload",template:'\n        <div [ngClass]="\'ui-fileupload ui-widget\'" [ngStyle]="style" [class]="styleClass" *ngIf="mode === \'advanced\'">\n            <div class="ui-fileupload-buttonbar ui-widget-header ui-corner-top">\n                <span class="ui-fileupload-choose" [label]="chooseLabel" [icon]="chooseIcon" pButton [ngClass]="{\'ui-state-focus\': focus, \'ui-state-disabled\':disabled || isChooseDisabled()}"> \n                    <input #advancedfileinput type="file" (change)="onFileSelect($event)" [multiple]="multiple" [accept]="accept" [disabled]="disabled || isChooseDisabled()" \n                        (focus)="onFocus()" (blur)="onBlur()" [attr.title]="\'\'">\n                </span>\n\n                <p-button *ngIf="!auto&&showUploadButton" type="button" [label]="uploadLabel" [icon]="uploadIcon" (onClick)="upload()" [disabled]="!hasFiles() || isFileLimitExceeded()"></p-button>\n                <p-button *ngIf="!auto&&showCancelButton" type="button" [label]="cancelLabel" [icon]="cancelIcon" (onClick)="clear()" [disabled]="!hasFiles() || uploading"></p-button>\n\n                <ng-container *ngTemplateOutlet="toolbarTemplate"></ng-container>\n            </div>\n            <div #content [ngClass]="{\'ui-fileupload-content ui-widget-content ui-corner-bottom\':true}"\n                 (dragenter)="onDragEnter($event)" (dragleave)="onDragLeave($event)" (drop)="onDrop($event)">\n                <p-progressBar [value]="progress" [showValue]="false" *ngIf="hasFiles()"></p-progressBar>\n\n                <p-messages [value]="msgs" [enableService]="false"></p-messages>\n\n                <div class="ui-fileupload-files" *ngIf="hasFiles()">\n                    <div *ngIf="!fileTemplate">\n                        <div class="ui-fileupload-row" *ngFor="let file of files; let i = index;">\n                            <div><img [src]="file.objectURL" *ngIf="isImage(file)" [width]="previewWidth" /></div>\n                            <div>{{file.name}}</div>\n                            <div>{{formatSize(file.size)}}</div>\n                            <div>\n                                <button type="button" icon="pi pi-times" pButton (click)="remove($event,i)" [disabled]="uploading"></button>\n                            </div>\n                        </div>\n                    </div>\n                    <div *ngIf="fileTemplate">\n                        <ng-template ngFor [ngForOf]="files" [ngForTemplate]="fileTemplate"></ng-template>\n                    </div>\n                </div>\n                <ng-container *ngTemplateOutlet="contentTemplate"></ng-container>\n            </div>\n        </div>\n        <span *ngIf="mode === \'basic\'" [ngClass]="{\'ui-button ui-fileupload-choose ui-widget ui-state-default ui-corner-all ui-button-text-icon-left\': true, \n                \'ui-fileupload-choose-selected\': hasFiles(),\'ui-state-focus\': focus, \'ui-state-disabled\':disabled}"\n              [ngStyle]="style" [class]="styleClass" (mouseup)="onSimpleUploaderClick($event)">\n            <span class="ui-button-icon-left pi" [ngClass]="{\'pi-plus\': !hasFiles()||auto, \'pi-upload\': hasFiles()&&!auto}"></span>\n            <span class="ui-button-text ui-clickable">{{auto ? chooseLabel : hasFiles() ? files[0].name : chooseLabel}}</span>\n            <input #basicfileinput type="file" [accept]="accept" [multiple]="multiple" [disabled]="disabled"\n                   (change)="onFileSelect($event)" *ngIf="!hasFiles()" (focus)="onFocus()" (blur)="onBlur()">\n        </span>\n    ',changeDetection:t.ChangeDetectionStrategy.Default})],e)}(),h=function(){function e(){}return e=u([t.NgModule({imports:[i.CommonModule,r.SharedModule,n.ButtonModule,l.ProgressBarModule,s.MessagesModule],exports:[c,r.SharedModule,n.ButtonModule,l.ProgressBarModule,s.MessagesModule],declarations:[c]})],e)}();e.FileUpload=c,e.FileUploadModule=h,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=primeng-fileupload.umd.min.js.map