(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/common'), require('@angular/animations'), require('primeng/inputtext'), require('primeng/button'), require('primeng/api'), require('primeng/dom'), require('primeng/utils'), require('@angular/forms')) :
    typeof define === 'function' && define.amd ? define('primeng/autocomplete', ['exports', '@angular/core', '@angular/common', '@angular/animations', 'primeng/inputtext', 'primeng/button', 'primeng/api', 'primeng/dom', 'primeng/utils', '@angular/forms'], factory) :
    (global = global || self, factory((global.primeng = global.primeng || {}, global.primeng.autocomplete = {}), global.ng.core, global.ng.common, global.ng.animations, global.primeng.inputtext, global.primeng.button, global.primeng.api, global.primeng.dom, global.primeng.utils, global.ng.forms));
}(this, (function (exports, core, common, animations, inputtext, button, api, dom, utils, forms) { 'use strict';

    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    };
    var __spread = (this && this.__spread) || function () {
        for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
        return ar;
    };
    var __values = (this && this.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var AUTOCOMPLETE_VALUE_ACCESSOR = {
        provide: forms.NG_VALUE_ACCESSOR,
        useExisting: core.forwardRef(function () { return AutoComplete; }),
        multi: true
    };
    var AutoComplete = /** @class */ (function () {
        function AutoComplete(el, renderer, cd, differs) {
            this.el = el;
            this.renderer = renderer;
            this.cd = cd;
            this.differs = differs;
            this.minLength = 1;
            this.delay = 300;
            this.type = 'text';
            this.autoZIndex = true;
            this.baseZIndex = 0;
            this.dropdownIcon = "pi pi-caret-down";
            this.unique = true;
            this.completeOnFocus = false;
            this.completeMethod = new core.EventEmitter();
            this.onSelect = new core.EventEmitter();
            this.onUnselect = new core.EventEmitter();
            this.onFocus = new core.EventEmitter();
            this.onBlur = new core.EventEmitter();
            this.onDropdownClick = new core.EventEmitter();
            this.onClear = new core.EventEmitter();
            this.onKeyUp = new core.EventEmitter();
            this.onShow = new core.EventEmitter();
            this.onHide = new core.EventEmitter();
            this.scrollHeight = '200px';
            this.dropdownMode = 'blank';
            this.showTransitionOptions = '225ms ease-out';
            this.hideTransitionOptions = '195ms ease-in';
            this.autocomplete = 'off';
            this.onModelChange = function () { };
            this.onModelTouched = function () { };
            this.overlayVisible = false;
            this.focus = false;
            this.inputFieldValue = null;
            this.differ = differs.find([]).create(null);
            this.listId = utils.UniqueComponentId() + '_list';
        }
        Object.defineProperty(AutoComplete.prototype, "suggestions", {
            get: function () {
                return this._suggestions;
            },
            set: function (val) {
                this._suggestions = val;
                this.handleSuggestionsChange();
            },
            enumerable: true,
            configurable: true
        });
        AutoComplete.prototype.ngAfterViewChecked = function () {
            var _this = this;
            //Use timeouts as since Angular 4.2, AfterViewChecked is broken and not called after panel is updated
            if (this.suggestionsUpdated && this.overlay && this.overlay.offsetParent) {
                setTimeout(function () {
                    if (_this.overlay) {
                        _this.alignOverlay();
                    }
                }, 1);
                this.suggestionsUpdated = false;
            }
            if (this.highlightOptionChanged) {
                setTimeout(function () {
                    if (_this.overlay) {
                        var listItem = dom.DomHandler.findSingle(_this.overlay, 'li.ui-state-highlight');
                        if (listItem) {
                            dom.DomHandler.scrollInView(_this.overlay, listItem);
                        }
                    }
                }, 1);
                this.highlightOptionChanged = false;
            }
        };
        AutoComplete.prototype.handleSuggestionsChange = function () {
            if (this._suggestions != null && this.loading) {
                this.highlightOption = null;
                if (this._suggestions.length) {
                    this.noResults = false;
                    this.show();
                    this.suggestionsUpdated = true;
                    if (this.autoHighlight) {
                        this.highlightOption = this._suggestions[0];
                    }
                }
                else {
                    this.noResults = true;
                    if (this.emptyMessage) {
                        this.show();
                        this.suggestionsUpdated = true;
                    }
                    else {
                        this.hide();
                    }
                }
                this.loading = false;
            }
        };
        AutoComplete.prototype.ngAfterContentInit = function () {
            var _this = this;
            this.templates.forEach(function (item) {
                switch (item.getType()) {
                    case 'item':
                        _this.itemTemplate = item.template;
                        break;
                    case 'selectedItem':
                        _this.selectedItemTemplate = item.template;
                        break;
                    default:
                        _this.itemTemplate = item.template;
                        break;
                }
            });
        };
        AutoComplete.prototype.writeValue = function (value) {
            this.value = value;
            this.filled = this.value && this.value != '';
            this.updateInputField();
        };
        AutoComplete.prototype.registerOnChange = function (fn) {
            this.onModelChange = fn;
        };
        AutoComplete.prototype.registerOnTouched = function (fn) {
            this.onModelTouched = fn;
        };
        AutoComplete.prototype.setDisabledState = function (val) {
            this.disabled = val;
        };
        AutoComplete.prototype.onInput = function (event) {
            var _this = this;
            // When an input element with a placeholder is clicked, the onInput event is invoked in IE.
            if (!this.inputKeyDown && dom.DomHandler.isIE()) {
                return;
            }
            if (this.timeout) {
                clearTimeout(this.timeout);
            }
            var value = event.target.value;
            if (!this.multiple && !this.forceSelection) {
                this.onModelChange(value);
            }
            if (value.length === 0 && !this.multiple) {
                this.hide();
                this.onClear.emit(event);
                this.onModelChange(value);
            }
            if (value.length >= this.minLength) {
                this.timeout = setTimeout(function () {
                    _this.search(event, value);
                }, this.delay);
            }
            else {
                this.suggestions = null;
                this.hide();
            }
            this.updateFilledState();
            this.inputKeyDown = false;
        };
        AutoComplete.prototype.onInputClick = function (event) {
            if (this.documentClickListener) {
                this.inputClick = true;
            }
        };
        AutoComplete.prototype.search = function (event, query) {
            //allow empty string but not undefined or null
            if (query === undefined || query === null) {
                return;
            }
            this.loading = true;
            this.completeMethod.emit({
                originalEvent: event,
                query: query
            });
        };
        AutoComplete.prototype.selectItem = function (option, focus) {
            if (focus === void 0) { focus = true; }
            if (this.forceSelectionUpdateModelTimeout) {
                clearTimeout(this.forceSelectionUpdateModelTimeout);
                this.forceSelectionUpdateModelTimeout = null;
            }
            if (this.multiple) {
                this.multiInputEL.nativeElement.value = '';
                this.value = this.value || [];
                if (!this.isSelected(option) || !this.unique) {
                    this.value = __spread(this.value, [option]);
                    this.onModelChange(this.value);
                }
            }
            else {
                this.inputEL.nativeElement.value = this.field ? utils.ObjectUtils.resolveFieldData(option, this.field) || '' : option;
                this.value = option;
                this.onModelChange(this.value);
            }
            this.onSelect.emit(option);
            this.updateFilledState();
            if (focus) {
                this.itemClicked = true;
                this.focusInput();
            }
        };
        AutoComplete.prototype.show = function () {
            if (this.multiInputEL || this.inputEL) {
                var hasFocus = this.multiple ? document.activeElement == this.multiInputEL.nativeElement : document.activeElement == this.inputEL.nativeElement;
                if (!this.overlayVisible && hasFocus) {
                    this.overlayVisible = true;
                }
            }
        };
        AutoComplete.prototype.onOverlayAnimationStart = function (event) {
            switch (event.toState) {
                case 'visible':
                    this.overlay = event.element;
                    this.appendOverlay();
                    if (this.autoZIndex) {
                        this.overlay.style.zIndex = String(this.baseZIndex + (++dom.DomHandler.zindex));
                    }
                    this.alignOverlay();
                    this.bindDocumentClickListener();
                    this.bindDocumentResizeListener();
                    this.onShow.emit(event);
                    break;
                case 'void':
                    this.onOverlayHide();
                    break;
            }
        };
        AutoComplete.prototype.onOverlayAnimationDone = function (event) {
            if (event.toState === 'void') {
                this._suggestions = null;
            }
        };
        AutoComplete.prototype.appendOverlay = function () {
            if (this.appendTo) {
                if (this.appendTo === 'body')
                    document.body.appendChild(this.overlay);
                else
                    dom.DomHandler.appendChild(this.overlay, this.appendTo);
                if (!this.overlay.style.minWidth) {
                    this.overlay.style.minWidth = dom.DomHandler.getWidth(this.el.nativeElement.children[0]) + 'px';
                }
            }
        };
        AutoComplete.prototype.resolveFieldData = function (value) {
            return this.field ? utils.ObjectUtils.resolveFieldData(value, this.field) : value;
        };
        AutoComplete.prototype.restoreOverlayAppend = function () {
            if (this.overlay && this.appendTo) {
                this.el.nativeElement.appendChild(this.overlay);
            }
        };
        AutoComplete.prototype.alignOverlay = function () {
            if (this.appendTo)
                dom.DomHandler.absolutePosition(this.overlay, (this.multiple ? this.multiContainerEL.nativeElement : this.inputEL.nativeElement));
            else
                dom.DomHandler.relativePosition(this.overlay, (this.multiple ? this.multiContainerEL.nativeElement : this.inputEL.nativeElement));
        };
        AutoComplete.prototype.hide = function () {
            this.overlayVisible = false;
        };
        AutoComplete.prototype.handleDropdownClick = function (event) {
            if (!this.overlayVisible) {
                this.focusInput();
                var queryValue = this.multiple ? this.multiInputEL.nativeElement.value : this.inputEL.nativeElement.value;
                if (this.dropdownMode === 'blank')
                    this.search(event, '');
                else if (this.dropdownMode === 'current')
                    this.search(event, queryValue);
                this.onDropdownClick.emit({
                    originalEvent: event,
                    query: queryValue
                });
            }
            else {
                this.hide();
            }
        };
        AutoComplete.prototype.focusInput = function () {
            if (this.multiple)
                this.multiInputEL.nativeElement.focus();
            else
                this.inputEL.nativeElement.focus();
        };
        AutoComplete.prototype.removeItem = function (item) {
            var itemIndex = dom.DomHandler.index(item);
            var removedValue = this.value[itemIndex];
            this.value = this.value.filter(function (val, i) { return i != itemIndex; });
            this.onModelChange(this.value);
            this.updateFilledState();
            this.onUnselect.emit(removedValue);
        };
        AutoComplete.prototype.onKeydown = function (event) {
            if (this.overlayVisible) {
                var highlightItemIndex = this.findOptionIndex(this.highlightOption);
                switch (event.which) {
                    //down
                    case 40:
                        if (highlightItemIndex != -1) {
                            var nextItemIndex = highlightItemIndex + 1;
                            if (nextItemIndex != (this.suggestions.length)) {
                                this.highlightOption = this.suggestions[nextItemIndex];
                                this.highlightOptionChanged = true;
                            }
                        }
                        else {
                            this.highlightOption = this.suggestions[0];
                        }
                        event.preventDefault();
                        break;
                    //up
                    case 38:
                        if (highlightItemIndex > 0) {
                            var prevItemIndex = highlightItemIndex - 1;
                            this.highlightOption = this.suggestions[prevItemIndex];
                            this.highlightOptionChanged = true;
                        }
                        event.preventDefault();
                        break;
                    //enter
                    case 13:
                        if (this.highlightOption) {
                            this.selectItem(this.highlightOption);
                            this.hide();
                        }
                        event.preventDefault();
                        break;
                    //escape
                    case 27:
                        this.hide();
                        event.preventDefault();
                        break;
                    //tab
                    case 9:
                        if (this.highlightOption) {
                            this.selectItem(this.highlightOption);
                        }
                        this.hide();
                        break;
                }
            }
            else {
                if (event.which === 40 && this.suggestions) {
                    this.search(event, event.target.value);
                }
            }
            if (this.multiple) {
                switch (event.which) {
                    //backspace
                    case 8:
                        if (this.value && this.value.length && !this.multiInputEL.nativeElement.value) {
                            this.value = __spread(this.value);
                            var removedValue = this.value.pop();
                            this.onModelChange(this.value);
                            this.updateFilledState();
                            this.onUnselect.emit(removedValue);
                        }
                        break;
                }
            }
            this.inputKeyDown = true;
        };
        AutoComplete.prototype.onKeyup = function (event) {
            this.onKeyUp.emit(event);
        };
        AutoComplete.prototype.onInputFocus = function (event) {
            if (!this.itemClicked && this.completeOnFocus) {
                var queryValue = this.multiple ? this.multiInputEL.nativeElement.value : this.inputEL.nativeElement.value;
                this.search(event, queryValue);
            }
            this.focus = true;
            this.onFocus.emit(event);
            this.itemClicked = false;
        };
        AutoComplete.prototype.onInputBlur = function (event) {
            this.focus = false;
            this.onModelTouched();
            this.onBlur.emit(event);
        };
        AutoComplete.prototype.onInputChange = function (event) {
            var e_1, _a;
            var _this = this;
            if (this.forceSelection) {
                var valid = false;
                var inputValue = event.target.value.trim();
                if (this.suggestions) {
                    var _loop_1 = function (suggestion) {
                        var itemValue = this_1.field ? utils.ObjectUtils.resolveFieldData(suggestion, this_1.field) : suggestion;
                        if (itemValue && inputValue === itemValue.trim()) {
                            valid = true;
                            this_1.forceSelectionUpdateModelTimeout = setTimeout(function () {
                                _this.selectItem(suggestion, false);
                            }, 250);
                            return "break";
                        }
                    };
                    var this_1 = this;
                    try {
                        for (var _b = __values(this.suggestions), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var suggestion = _c.value;
                            var state_1 = _loop_1(suggestion);
                            if (state_1 === "break")
                                break;
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                }
                if (!valid) {
                    if (this.multiple) {
                        this.multiInputEL.nativeElement.value = '';
                    }
                    else {
                        this.value = null;
                        this.inputEL.nativeElement.value = '';
                    }
                    this.onClear.emit(event);
                    this.onModelChange(this.value);
                }
            }
        };
        AutoComplete.prototype.onInputPaste = function (event) {
            this.onKeydown(event);
        };
        AutoComplete.prototype.isSelected = function (val) {
            var selected = false;
            if (this.value && this.value.length) {
                for (var i = 0; i < this.value.length; i++) {
                    if (utils.ObjectUtils.equals(this.value[i], val, this.dataKey)) {
                        selected = true;
                        break;
                    }
                }
            }
            return selected;
        };
        AutoComplete.prototype.findOptionIndex = function (option) {
            var index = -1;
            if (this.suggestions) {
                for (var i = 0; i < this.suggestions.length; i++) {
                    if (utils.ObjectUtils.equals(option, this.suggestions[i])) {
                        index = i;
                        break;
                    }
                }
            }
            return index;
        };
        AutoComplete.prototype.updateFilledState = function () {
            if (this.multiple)
                this.filled = (this.value && this.value.length) || (this.multiInputEL && this.multiInputEL.nativeElement && this.multiInputEL.nativeElement.value != '');
            else
                this.filled = (this.inputFieldValue && this.inputFieldValue != '') || (this.inputEL && this.inputEL.nativeElement && this.inputEL.nativeElement.value != '');
            ;
        };
        AutoComplete.prototype.updateInputField = function () {
            var formattedValue = this.value ? (this.field ? utils.ObjectUtils.resolveFieldData(this.value, this.field) || '' : this.value) : '';
            this.inputFieldValue = formattedValue;
            if (this.inputEL && this.inputEL.nativeElement) {
                this.inputEL.nativeElement.value = formattedValue;
            }
            this.updateFilledState();
        };
        AutoComplete.prototype.bindDocumentClickListener = function () {
            var _this = this;
            if (!this.documentClickListener) {
                this.documentClickListener = this.renderer.listen('document', 'click', function (event) {
                    if (event.which === 3) {
                        return;
                    }
                    if (!_this.inputClick && !_this.isDropdownClick(event)) {
                        _this.hide();
                    }
                    _this.inputClick = false;
                    _this.cd.markForCheck();
                });
            }
        };
        AutoComplete.prototype.isDropdownClick = function (event) {
            if (this.dropdown) {
                var target = event.target;
                return (target === this.dropdownButton.nativeElement || target.parentNode === this.dropdownButton.nativeElement);
            }
            else {
                return false;
            }
        };
        AutoComplete.prototype.unbindDocumentClickListener = function () {
            if (this.documentClickListener) {
                this.documentClickListener();
                this.documentClickListener = null;
            }
        };
        AutoComplete.prototype.bindDocumentResizeListener = function () {
            this.documentResizeListener = this.onWindowResize.bind(this);
            window.addEventListener('resize', this.documentResizeListener);
        };
        AutoComplete.prototype.unbindDocumentResizeListener = function () {
            if (this.documentResizeListener) {
                window.removeEventListener('resize', this.documentResizeListener);
                this.documentResizeListener = null;
            }
        };
        AutoComplete.prototype.onWindowResize = function () {
            this.hide();
        };
        AutoComplete.prototype.onOverlayHide = function () {
            this.unbindDocumentClickListener();
            this.unbindDocumentResizeListener();
            this.overlay = null;
            this.onHide.emit();
        };
        AutoComplete.prototype.ngOnDestroy = function () {
            if (this.forceSelectionUpdateModelTimeout) {
                clearTimeout(this.forceSelectionUpdateModelTimeout);
                this.forceSelectionUpdateModelTimeout = null;
            }
            this.restoreOverlayAppend();
            this.onOverlayHide();
        };
        AutoComplete.ctorParameters = function () { return [
            { type: core.ElementRef },
            { type: core.Renderer2 },
            { type: core.ChangeDetectorRef },
            { type: core.IterableDiffers }
        ]; };
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "minLength", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "delay", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "style", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "panelStyle", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "styleClass", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "panelStyleClass", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "inputStyle", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "inputId", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "inputStyleClass", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "placeholder", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "readonly", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "disabled", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "maxlength", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "name", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "required", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "size", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "appendTo", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "autoHighlight", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "forceSelection", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "type", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "autoZIndex", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "baseZIndex", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "ariaLabel", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "ariaLabelledBy", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "dropdownIcon", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "unique", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "completeOnFocus", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "completeMethod", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onSelect", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onUnselect", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onFocus", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onBlur", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onDropdownClick", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onClear", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onKeyUp", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onShow", void 0);
        __decorate([
            core.Output()
        ], AutoComplete.prototype, "onHide", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "field", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "scrollHeight", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "dropdown", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "dropdownMode", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "multiple", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "tabindex", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "dataKey", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "emptyMessage", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "showTransitionOptions", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "hideTransitionOptions", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "autofocus", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "autocomplete", void 0);
        __decorate([
            core.ViewChild('in')
        ], AutoComplete.prototype, "inputEL", void 0);
        __decorate([
            core.ViewChild('multiIn')
        ], AutoComplete.prototype, "multiInputEL", void 0);
        __decorate([
            core.ViewChild('multiContainer')
        ], AutoComplete.prototype, "multiContainerEL", void 0);
        __decorate([
            core.ViewChild('ddBtn')
        ], AutoComplete.prototype, "dropdownButton", void 0);
        __decorate([
            core.ContentChildren(api.PrimeTemplate)
        ], AutoComplete.prototype, "templates", void 0);
        __decorate([
            core.Input()
        ], AutoComplete.prototype, "suggestions", null);
        AutoComplete = __decorate([
            core.Component({
                selector: 'p-autoComplete',
                template: "\n        <span [ngClass]=\"{'ui-autocomplete ui-widget':true,'ui-autocomplete-dd':dropdown,'ui-autocomplete-multiple':multiple}\" [ngStyle]=\"style\" [class]=\"styleClass\">\n            <input *ngIf=\"!multiple\" #in [attr.type]=\"type\" [attr.id]=\"inputId\" [ngStyle]=\"inputStyle\" [class]=\"inputStyleClass\" [autocomplete]=\"autocomplete\" [attr.required]=\"required\" [attr.name]=\"name\"\n            [ngClass]=\"'ui-inputtext ui-widget ui-state-default ui-corner-all ui-autocomplete-input'\" [value]=\"inputFieldValue\" aria-autocomplete=\"list\" [attr.aria-controls]=\"listId\" role=\"searchbox\" [attr.aria-expanded]=\"overlayVisible\" aria-haspopup=\"true\" [attr.aria-activedescendant]=\"'p-highlighted-option'\"\n            (click)=\"onInputClick($event)\" (input)=\"onInput($event)\" (keydown)=\"onKeydown($event)\" (keyup)=\"onKeyup($event)\" [attr.autofocus]=\"autofocus\" (focus)=\"onInputFocus($event)\" (blur)=\"onInputBlur($event)\" (change)=\"onInputChange($event)\" (paste)=\"onInputPaste($event)\"\n            [attr.placeholder]=\"placeholder\" [attr.size]=\"size\" [attr.maxlength]=\"maxlength\" [attr.tabindex]=\"tabindex\" [readonly]=\"readonly\" [disabled]=\"disabled\" [attr.aria-label]=\"ariaLabel\" [attr.aria-labelledby]=\"ariaLabelledBy\" [attr.aria-required]=\"required\"\n            ><ul *ngIf=\"multiple\" #multiContainer class=\"ui-autocomplete-multiple-container ui-widget ui-inputtext ui-state-default ui-corner-all\" [ngClass]=\"{'ui-state-disabled':disabled,'ui-state-focus':focus}\" (click)=\"multiIn.focus()\">\n                <li #token *ngFor=\"let val of value\" class=\"ui-autocomplete-token ui-state-highlight ui-corner-all\">\n                    <span class=\"ui-autocomplete-token-icon pi pi-fw pi-times\" (click)=\"removeItem(token)\" *ngIf=\"!disabled\"></span>\n                    <span *ngIf=\"!selectedItemTemplate\" class=\"ui-autocomplete-token-label\">{{resolveFieldData(val)}}</span>\n                    <ng-container *ngTemplateOutlet=\"selectedItemTemplate; context: {$implicit: val}\"></ng-container>\n                </li>\n                <li class=\"ui-autocomplete-input-token\">\n                    <input #multiIn [attr.type]=\"type\" [attr.id]=\"inputId\" [disabled]=\"disabled\" [attr.placeholder]=\"(value&&value.length ? null : placeholder)\" [attr.tabindex]=\"tabindex\" [attr.maxlength]=\"maxlength\" (input)=\"onInput($event)\"  (click)=\"onInputClick($event)\"\n                            (keydown)=\"onKeydown($event)\" [readonly]=\"readonly\" (keyup)=\"onKeyup($event)\" [attr.autofocus]=\"autofocus\" (focus)=\"onInputFocus($event)\" (blur)=\"onInputBlur($event)\" (change)=\"onInputChange($event)\" (paste)=\"onInputPaste($event)\" [autocomplete]=\"autocomplete\"\n                            [ngStyle]=\"inputStyle\" [class]=\"inputStyleClass\" [attr.aria-label]=\"ariaLabel\" [attr.aria-labelledby]=\"ariaLabelledBy\" [attr.aria-required]=\"required\"\n                            aria-autocomplete=\"list\" [attr.aria-controls]=\"listId\" role=\"searchbox\" [attr.aria-expanded]=\"overlayVisible\" aria-haspopup=\"true\" [attr.aria-activedescendant]=\"'p-highlighted-option'\">\n                </li>\n            </ul>\n            <i *ngIf=\"loading\" class=\"ui-autocomplete-loader pi pi-spinner pi-spin\"></i><button #ddBtn type=\"button\" pButton [icon]=\"dropdownIcon\" class=\"ui-autocomplete-dropdown\" [disabled]=\"disabled\"\n                (click)=\"handleDropdownClick($event)\" *ngIf=\"dropdown\" [attr.tabindex]=\"tabindex\"></button>\n            <div #panel *ngIf=\"overlayVisible\" [ngClass]=\"['ui-autocomplete-panel ui-widget ui-widget-content ui-corner-all ui-shadow']\" [style.max-height]=\"scrollHeight\" [ngStyle]=\"panelStyle\" [class]=\"panelStyleClass\"\n                [@overlayAnimation]=\"{value: 'visible', params: {showTransitionParams: showTransitionOptions, hideTransitionParams: hideTransitionOptions}}\" (@overlayAnimation.start)=\"onOverlayAnimationStart($event)\" (@overlayAnimation.done)=\"onOverlayAnimationDone($event)\" >\n                <ul role=\"listbox\" [attr.id]=\"listId\" class=\"ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-corner-all ui-helper-reset\">\n                    <li role=\"option\"  *ngFor=\"let option of suggestions; let idx = index\" [ngClass]=\"{'ui-autocomplete-list-item ui-corner-all':true,'ui-state-highlight':(highlightOption==option)}\"\n                        (mouseenter)=\"highlightOption=option\" (mouseleave)=\"highlightOption=null\" [id]=\"highlightOption == option ? 'p-highlighted-option':''\" (click)=\"selectItem(option)\">\n                        <span *ngIf=\"!itemTemplate\">{{resolveFieldData(option)}}</span>\n                        <ng-container *ngTemplateOutlet=\"itemTemplate; context: {$implicit: option, index: idx}\"></ng-container>\n                    </li>\n                    <li *ngIf=\"noResults && emptyMessage\" class=\"ui-autocomplete-emptymessage ui-autocomplete-list-item ui-corner-all\">{{emptyMessage}}</li>\n                </ul>\n            </div>\n        </span>\n    ",
                animations: [
                    animations.trigger('overlayAnimation', [
                        animations.state('void', animations.style({
                            transform: 'translateY(5%)',
                            opacity: 0
                        })),
                        animations.state('visible', animations.style({
                            transform: 'translateY(0)',
                            opacity: 1
                        })),
                        animations.transition('void => visible', animations.animate('{{showTransitionParams}}')),
                        animations.transition('visible => void', animations.animate('{{hideTransitionParams}}'))
                    ])
                ],
                host: {
                    '[class.ui-inputwrapper-filled]': 'filled',
                    '[class.ui-inputwrapper-focus]': 'focus && !disabled'
                },
                providers: [AUTOCOMPLETE_VALUE_ACCESSOR],
                changeDetection: core.ChangeDetectionStrategy.Default
            })
        ], AutoComplete);
        return AutoComplete;
    }());
    var AutoCompleteModule = /** @class */ (function () {
        function AutoCompleteModule() {
        }
        AutoCompleteModule = __decorate([
            core.NgModule({
                imports: [common.CommonModule, inputtext.InputTextModule, button.ButtonModule, api.SharedModule],
                exports: [AutoComplete, api.SharedModule],
                declarations: [AutoComplete]
            })
        ], AutoCompleteModule);
        return AutoCompleteModule;
    }());

    exports.AUTOCOMPLETE_VALUE_ACCESSOR = AUTOCOMPLETE_VALUE_ACCESSOR;
    exports.AutoComplete = AutoComplete;
    exports.AutoCompleteModule = AutoCompleteModule;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=primeng-autocomplete.umd.js.map
