import { forwardRef, EventEmitter, Input, Output, ViewChild, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NG_VALUE_ACCESSOR } from '@angular/forms';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

var _c0 = ["checkbox"];
var _c1 = function (a0, a1) { return { "ui-button-icon-left": a0, "ui-button-icon-right": a1 }; };
function ToggleButton_span_4_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "span", 6);
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵclassMap(ctx_r1.checked ? ctx_r1.onIcon : ctx_r1.offIcon);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(3, _c1, ctx_r1.iconPos === "left", ctx_r1.iconPos === "right"));
} }
var _c2 = function (a1, a2, a3, a4, a5, a6, a7) { return { "ui-button ui-togglebutton ui-widget ui-state-default ui-corner-all": true, "ui-button-text-only": a1, "ui-button-text-icon-left": a2, "ui-button-text-icon-right": a3, "ui-button-icon-only": a4, "ui-state-active": a5, "ui-state-focus": a6, "ui-state-disabled": a7 }; };
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var TOGGLEBUTTON_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return ToggleButton; }),
    multi: true
};
var ToggleButton = /** @class */ (function () {
    function ToggleButton() {
        this.onLabel = 'Yes';
        this.offLabel = 'No';
        this.iconPos = 'left';
        this.onChange = new EventEmitter();
        this.checked = false;
        this.focus = false;
        this.onModelChange = function () { };
        this.onModelTouched = function () { };
    }
    ToggleButton.prototype.ngAfterViewInit = function () {
        if (this.checkboxViewChild) {
            this.checkbox = this.checkboxViewChild.nativeElement;
        }
    };
    ToggleButton.prototype.toggle = function (event) {
        if (!this.disabled) {
            this.checked = !this.checked;
            this.onModelChange(this.checked);
            this.onModelTouched();
            this.onChange.emit({
                originalEvent: event,
                checked: this.checked
            });
            if (this.checkbox) {
                this.checkbox.focus();
            }
        }
    };
    ToggleButton.prototype.onFocus = function () {
        this.focus = true;
    };
    ToggleButton.prototype.onBlur = function () {
        this.focus = false;
        this.onModelTouched();
    };
    ToggleButton.prototype.writeValue = function (value) {
        this.checked = value;
    };
    ToggleButton.prototype.registerOnChange = function (fn) {
        this.onModelChange = fn;
    };
    ToggleButton.prototype.registerOnTouched = function (fn) {
        this.onModelTouched = fn;
    };
    ToggleButton.prototype.setDisabledState = function (val) {
        this.disabled = val;
    };
    Object.defineProperty(ToggleButton.prototype, "hasOnLabel", {
        get: function () {
            return this.onLabel && this.onLabel.length > 0;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ToggleButton.prototype, "hasOffLabel", {
        get: function () {
            return this.onLabel && this.onLabel.length > 0;
        },
        enumerable: true,
        configurable: true
    });
    __decorate([
        Input()
    ], ToggleButton.prototype, "onLabel", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "offLabel", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "onIcon", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "offIcon", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "ariaLabelledBy", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "disabled", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "style", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "inputId", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "tabindex", void 0);
    __decorate([
        Input()
    ], ToggleButton.prototype, "iconPos", void 0);
    __decorate([
        Output()
    ], ToggleButton.prototype, "onChange", void 0);
    __decorate([
        ViewChild('checkbox')
    ], ToggleButton.prototype, "checkboxViewChild", void 0);
ToggleButton.ɵfac = function ToggleButton_Factory(t) { return new (t || ToggleButton)(); };
ToggleButton.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: ToggleButton, selectors: [["p-toggleButton"]], viewQuery: function ToggleButton_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.checkboxViewChild = _t.first);
    } }, inputs: { onLabel: "onLabel", offLabel: "offLabel", iconPos: "iconPos", disabled: "disabled", onIcon: "onIcon", offIcon: "offIcon", ariaLabelledBy: "ariaLabelledBy", style: "style", styleClass: "styleClass", inputId: "inputId", tabindex: "tabindex" }, outputs: { onChange: "onChange" }, features: [ɵngcc0.ɵɵProvidersFeature([TOGGLEBUTTON_VALUE_ACCESSOR])], decls: 7, vars: 20, consts: [[3, "ngClass", "ngStyle", "click", "keydown.enter"], [1, "ui-helper-hidden-accessible"], ["type", "checkbox", "role", "button", 3, "checked", "disabled", "focus", "blur"], ["checkbox", ""], ["class", "ui-button-icon-left", 3, "class", "ngClass", 4, "ngIf"], [1, "ui-button-text", "ui-unselectable-text"], [1, "ui-button-icon-left", 3, "ngClass"]], template: function ToggleButton_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵlistener("click", function ToggleButton_Template_div_click_0_listener($event) { return ctx.toggle($event); })("keydown.enter", function ToggleButton_Template_div_keydown_enter_0_listener($event) { return ctx.toggle($event); });
        ɵngcc0.ɵɵelementStart(1, "div", 1);
        ɵngcc0.ɵɵelementStart(2, "input", 2, 3);
        ɵngcc0.ɵɵlistener("focus", function ToggleButton_Template_input_focus_2_listener() { return ctx.onFocus(); })("blur", function ToggleButton_Template_input_blur_2_listener() { return ctx.onBlur(); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵtemplate(4, ToggleButton_span_4_Template, 1, 6, "span", 4);
        ɵngcc0.ɵɵelementStart(5, "span", 5);
        ɵngcc0.ɵɵtext(6);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction7(12, _c2, !ctx.onIcon && !ctx.offIcon, ctx.onIcon && ctx.offIcon && ctx.hasOnLabel && ctx.hasOffLabel && ctx.iconPos === "left", ctx.onIcon && ctx.offIcon && ctx.hasOnLabel && ctx.hasOffLabel && ctx.iconPos === "right", ctx.onIcon && ctx.offIcon && !ctx.hasOnLabel && !ctx.hasOffLabel, ctx.checked, ctx.focus, ctx.disabled))("ngStyle", ctx.style);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("checked", ctx.checked)("disabled", ctx.disabled);
        ɵngcc0.ɵɵattribute("id", ctx.inputId)("tabindex", ctx.tabindex)("aria-pressed", ctx.checked)("aria-labelledby", ctx.ariaLabelledBy);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngIf", ctx.onIcon || ctx.offIcon);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵtextInterpolate(ctx.checked ? ctx.hasOnLabel ? ctx.onLabel : "ui-btn" : ctx.hasOffLabel ? ctx.offLabel : "ui-btn");
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle, ɵngcc1.NgIf], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(ToggleButton, [{
        type: Component,
        args: [{
                selector: 'p-toggleButton',
                template: "\n        <div [ngClass]=\"{'ui-button ui-togglebutton ui-widget ui-state-default ui-corner-all': true, 'ui-button-text-only': (!onIcon && !offIcon), \n                'ui-button-text-icon-left': (onIcon && offIcon && hasOnLabel && hasOffLabel && iconPos === 'left'), \n                'ui-button-text-icon-right': (onIcon && offIcon && hasOnLabel && hasOffLabel && iconPos === 'right'),'ui-button-icon-only': (onIcon && offIcon && !hasOnLabel && !hasOffLabel),\n                'ui-state-active': checked,'ui-state-focus':focus,'ui-state-disabled':disabled}\" [ngStyle]=\"style\" [class]=\"styleClass\" \n                (click)=\"toggle($event)\" (keydown.enter)=\"toggle($event)\">\n            <div class=\"ui-helper-hidden-accessible\">\n                <input #checkbox type=\"checkbox\" [attr.id]=\"inputId\" [checked]=\"checked\" (focus)=\"onFocus()\" (blur)=\"onBlur()\" [attr.tabindex]=\"tabindex\"\n                    role=\"button\" [attr.aria-pressed]=\"checked\" [attr.aria-labelledby]=\"ariaLabelledBy\" [disabled]=\"disabled\">\n            </div>\n            <span *ngIf=\"onIcon||offIcon\" class=\"ui-button-icon-left\" [class]=\"checked ? this.onIcon : this.offIcon\" [ngClass]=\"{'ui-button-icon-left': (iconPos === 'left'), \n            'ui-button-icon-right': (iconPos === 'right')}\"></span>\n            <span class=\"ui-button-text ui-unselectable-text\">{{checked ? hasOnLabel ? onLabel : 'ui-btn' : hasOffLabel ? offLabel : 'ui-btn'}}</span>\n        </div>\n    ",
                providers: [TOGGLEBUTTON_VALUE_ACCESSOR],
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return []; }, { onLabel: [{
            type: Input
        }], offLabel: [{
            type: Input
        }], iconPos: [{
            type: Input
        }], onChange: [{
            type: Output
        }], disabled: [{
            type: Input
        }], onIcon: [{
            type: Input
        }], offIcon: [{
            type: Input
        }], ariaLabelledBy: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], inputId: [{
            type: Input
        }], tabindex: [{
            type: Input
        }], checkboxViewChild: [{
            type: ViewChild,
            args: ['checkbox']
        }] }); })();
    return ToggleButton;
}());
var ToggleButtonModule = /** @class */ (function () {
    function ToggleButtonModule() {
    }
ToggleButtonModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: ToggleButtonModule });
ToggleButtonModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function ToggleButtonModule_Factory(t) { return new (t || ToggleButtonModule)(); }, imports: [[CommonModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(ToggleButtonModule, { declarations: function () { return [ToggleButton]; }, imports: function () { return [CommonModule]; }, exports: function () { return [ToggleButton]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(ToggleButtonModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [ToggleButton],
                declarations: [ToggleButton]
            }]
    }], function () { return []; }, null); })();
    return ToggleButtonModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { TOGGLEBUTTON_VALUE_ACCESSOR, ToggleButton, ToggleButtonModule };

//# sourceMappingURL=primeng-togglebutton.js.map