import { forwardRef, EventEmitter, ElementRef, Renderer2, NgZone, ChangeDetectorRef, Input, Output, ViewChild, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomHandler } from 'primeng/dom';
import { NG_VALUE_ACCESSOR } from '@angular/forms';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

var _c0 = ["sliderHandle"];
var _c1 = ["sliderHandleStart"];
var _c2 = ["sliderHandleEnd"];
var _c3 = function (a0, a1) { return { "left": a0, width: a1 }; };
function Slider_span_1_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "span", 5);
} if (rf & 2) {
    var ctx_r0 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction2(1, _c3, ctx_r0.handleValues[0] + "%", ctx_r0.handleValues[1] - ctx_r0.handleValues[0] + "%"));
} }
var _c4 = function (a0, a1) { return { "bottom": a0, height: a1 }; };
function Slider_span_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "span", 5);
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction2(1, _c4, ctx_r1.handleValues[0] + "%", ctx_r1.handleValues[1] - ctx_r1.handleValues[0] + "%"));
} }
var _c5 = function (a0) { return { "height": a0 }; };
function Slider_span_3_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "span", 6);
} if (rf & 2) {
    var ctx_r2 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction1(1, _c5, ctx_r2.handleValue + "%"));
} }
var _c6 = function (a0) { return { "width": a0 }; };
function Slider_span_4_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "span", 6);
} if (rf & 2) {
    var ctx_r3 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction1(1, _c6, ctx_r3.handleValue + "%"));
} }
var _c7 = function (a0, a1) { return { "left": a0, "bottom": a1 }; };
function Slider_span_5_Template(rf, ctx) { if (rf & 1) {
    var _r9 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "span", 7, 8);
    ɵngcc0.ɵɵlistener("keydown", function Slider_span_5_Template_span_keydown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r9); var ctx_r8 = ɵngcc0.ɵɵnextContext(); return ctx_r8.onHandleKeydown($event); })("mousedown", function Slider_span_5_Template_span_mousedown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r9); var ctx_r10 = ɵngcc0.ɵɵnextContext(); return ctx_r10.onMouseDown($event); })("touchstart", function Slider_span_5_Template_span_touchstart_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r9); var ctx_r11 = ɵngcc0.ɵɵnextContext(); return ctx_r11.onTouchStart($event); })("touchmove", function Slider_span_5_Template_span_touchmove_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r9); var ctx_r12 = ɵngcc0.ɵɵnextContext(); return ctx_r12.onTouchMove($event); })("touchend", function Slider_span_5_Template_span_touchend_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r9); var ctx_r13 = ɵngcc0.ɵɵnextContext(); return ctx_r13.onTouchEnd($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r4 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵstyleProp("transition", ctx_r4.dragging ? "none" : null);
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction2(8, _c7, ctx_r4.orientation == "horizontal" ? ctx_r4.handleValue + "%" : null, ctx_r4.orientation == "vertical" ? ctx_r4.handleValue + "%" : null));
    ɵngcc0.ɵɵattribute("tabindex", ctx_r4.tabindex)("aria-valuemin", ctx_r4.min)("aria-valuenow", ctx_r4.value)("aria-valuemax", ctx_r4.max)("aria-labelledby", ctx_r4.ariaLabelledBy);
} }
var _c8 = function (a0) { return { "ui-slider-handle-active": a0 }; };
function Slider_span_6_Template(rf, ctx) { if (rf & 1) {
    var _r16 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "span", 9, 10);
    ɵngcc0.ɵɵlistener("keydown", function Slider_span_6_Template_span_keydown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r16); var ctx_r15 = ɵngcc0.ɵɵnextContext(); return ctx_r15.onHandleKeydown($event, 0); })("mousedown", function Slider_span_6_Template_span_mousedown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r16); var ctx_r17 = ɵngcc0.ɵɵnextContext(); return ctx_r17.onMouseDown($event, 0); })("touchstart", function Slider_span_6_Template_span_touchstart_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r16); var ctx_r18 = ɵngcc0.ɵɵnextContext(); return ctx_r18.onTouchStart($event, 0); })("touchmove", function Slider_span_6_Template_span_touchmove_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r16); var ctx_r19 = ɵngcc0.ɵɵnextContext(); return ctx_r19.onTouchMove($event, 0); })("touchend", function Slider_span_6_Template_span_touchend_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r16); var ctx_r20 = ɵngcc0.ɵɵnextContext(); return ctx_r20.onTouchEnd($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r5 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵstyleProp("transition", ctx_r5.dragging ? "none" : null);
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction2(9, _c7, ctx_r5.rangeStartLeft, ctx_r5.rangeStartBottom))("ngClass", ɵngcc0.ɵɵpureFunction1(12, _c8, ctx_r5.handleIndex == 0));
    ɵngcc0.ɵɵattribute("tabindex", ctx_r5.tabindex)("aria-valuemin", ctx_r5.min)("aria-valuenow", ctx_r5.value ? ctx_r5.value[0] : null)("aria-valuemax", ctx_r5.max)("aria-labelledby", ctx_r5.ariaLabelledBy);
} }
function Slider_span_7_Template(rf, ctx) { if (rf & 1) {
    var _r23 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "span", 9, 11);
    ɵngcc0.ɵɵlistener("keydown", function Slider_span_7_Template_span_keydown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r23); var ctx_r22 = ɵngcc0.ɵɵnextContext(); return ctx_r22.onHandleKeydown($event, 1); })("mousedown", function Slider_span_7_Template_span_mousedown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r23); var ctx_r24 = ɵngcc0.ɵɵnextContext(); return ctx_r24.onMouseDown($event, 1); })("touchstart", function Slider_span_7_Template_span_touchstart_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r23); var ctx_r25 = ɵngcc0.ɵɵnextContext(); return ctx_r25.onTouchStart($event, 1); })("touchmove", function Slider_span_7_Template_span_touchmove_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r23); var ctx_r26 = ɵngcc0.ɵɵnextContext(); return ctx_r26.onTouchMove($event, 1); })("touchend", function Slider_span_7_Template_span_touchend_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r23); var ctx_r27 = ɵngcc0.ɵɵnextContext(); return ctx_r27.onTouchEnd($event); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r6 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵstyleProp("transition", ctx_r6.dragging ? "none" : null);
    ɵngcc0.ɵɵproperty("ngStyle", ɵngcc0.ɵɵpureFunction2(9, _c7, ctx_r6.rangeEndLeft, ctx_r6.rangeEndBottom))("ngClass", ɵngcc0.ɵɵpureFunction1(12, _c8, ctx_r6.handleIndex == 1));
    ɵngcc0.ɵɵattribute("tabindex", ctx_r6.tabindex)("aria-valuemin", ctx_r6.min)("aria-valuenow", ctx_r6.value ? ctx_r6.value[1] : null)("aria-valuemax", ctx_r6.max)("aria-labelledby", ctx_r6.ariaLabelledBy);
} }
var _c9 = function (a1, a2, a3, a4) { return { "ui-slider ui-widget ui-widget-content ui-corner-all": true, "ui-state-disabled": a1, "ui-slider-horizontal": a2, "ui-slider-vertical": a3, "ui-slider-animate": a4 }; };
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var SLIDER_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return Slider; }),
    multi: true
};
var Slider = /** @class */ (function () {
    function Slider(el, renderer, ngZone, cd) {
        this.el = el;
        this.renderer = renderer;
        this.ngZone = ngZone;
        this.cd = cd;
        this.min = 0;
        this.max = 100;
        this.orientation = 'horizontal';
        this.tabindex = 0;
        this.onChange = new EventEmitter();
        this.onSlideEnd = new EventEmitter();
        this.handleValues = [];
        this.onModelChange = function () { };
        this.onModelTouched = function () { };
        this.handleIndex = 0;
    }
    Slider.prototype.onMouseDown = function (event, index) {
        if (this.disabled) {
            return;
        }
        this.dragging = true;
        this.updateDomData();
        this.sliderHandleClick = true;
        this.handleIndex = index;
        this.bindDragListeners();
        event.target.focus();
        event.preventDefault();
    };
    Slider.prototype.onTouchStart = function (event, index) {
        if (this.disabled) {
            return;
        }
        var touchobj = event.changedTouches[0];
        this.startHandleValue = (this.range) ? this.handleValues[index] : this.handleValue;
        this.dragging = true;
        this.handleIndex = index;
        if (this.orientation === 'horizontal') {
            this.startx = parseInt(touchobj.clientX, 10);
            this.barWidth = this.el.nativeElement.children[0].offsetWidth;
        }
        else {
            this.starty = parseInt(touchobj.clientY, 10);
            this.barHeight = this.el.nativeElement.children[0].offsetHeight;
        }
        event.preventDefault();
    };
    Slider.prototype.onTouchMove = function (event, index) {
        if (this.disabled) {
            return;
        }
        var touchobj = event.changedTouches[0], handleValue = 0;
        if (this.orientation === 'horizontal') {
            handleValue = Math.floor(((parseInt(touchobj.clientX, 10) - this.startx) * 100) / (this.barWidth)) + this.startHandleValue;
        }
        else {
            handleValue = Math.floor(((this.starty - parseInt(touchobj.clientY, 10)) * 100) / (this.barHeight)) + this.startHandleValue;
        }
        this.setValueFromHandle(event, handleValue);
        event.preventDefault();
    };
    Slider.prototype.onTouchEnd = function (event, index) {
        if (this.disabled) {
            return;
        }
        this.dragging = false;
        if (this.range)
            this.onSlideEnd.emit({ originalEvent: event, values: this.values });
        else
            this.onSlideEnd.emit({ originalEvent: event, value: this.value });
        event.preventDefault();
    };
    Slider.prototype.onBarClick = function (event) {
        if (this.disabled) {
            return;
        }
        if (!this.sliderHandleClick) {
            this.updateDomData();
            this.handleChange(event);
        }
        this.sliderHandleClick = false;
    };
    Slider.prototype.onHandleKeydown = function (event, handleIndex) {
        if (event.which == 38 || event.which == 39) {
            this.spin(event, 1, handleIndex);
        }
        else if (event.which == 37 || event.which == 40) {
            this.spin(event, -1, handleIndex);
        }
    };
    Slider.prototype.spin = function (event, dir, handleIndex) {
        var step = (this.step || 1) * dir;
        if (this.range) {
            this.handleIndex = handleIndex;
            this.updateValue(this.values[this.handleIndex] + step);
            this.updateHandleValue();
        }
        else {
            this.updateValue(this.value + step);
            this.updateHandleValue();
        }
        event.preventDefault();
    };
    Slider.prototype.handleChange = function (event) {
        var handleValue = this.calculateHandleValue(event);
        this.setValueFromHandle(event, handleValue);
    };
    Slider.prototype.bindDragListeners = function () {
        var _this = this;
        this.ngZone.runOutsideAngular(function () {
            if (!_this.dragListener) {
                _this.dragListener = _this.renderer.listen('document', 'mousemove', function (event) {
                    if (_this.dragging) {
                        _this.ngZone.run(function () {
                            _this.handleChange(event);
                        });
                    }
                });
            }
            if (!_this.mouseupListener) {
                _this.mouseupListener = _this.renderer.listen('document', 'mouseup', function (event) {
                    if (_this.dragging) {
                        _this.dragging = false;
                        _this.ngZone.run(function () {
                            if (_this.range) {
                                _this.onSlideEnd.emit({ originalEvent: event, values: _this.values });
                            }
                            else {
                                _this.onSlideEnd.emit({ originalEvent: event, value: _this.value });
                            }
                        });
                    }
                });
            }
        });
    };
    Slider.prototype.unbindDragListeners = function () {
        if (this.dragListener) {
            this.dragListener();
        }
        if (this.mouseupListener) {
            this.mouseupListener();
        }
    };
    Slider.prototype.setValueFromHandle = function (event, handleValue) {
        var newValue = this.getValueFromHandle(handleValue);
        if (this.range) {
            if (this.step) {
                this.handleStepChange(newValue, this.values[this.handleIndex]);
            }
            else {
                this.handleValues[this.handleIndex] = handleValue;
                this.updateValue(newValue, event);
            }
        }
        else {
            if (this.step) {
                this.handleStepChange(newValue, this.value);
            }
            else {
                this.handleValue = handleValue;
                this.updateValue(newValue, event);
            }
        }
    };
    Slider.prototype.handleStepChange = function (newValue, oldValue) {
        var diff = (newValue - oldValue);
        var val = oldValue;
        if (diff < 0) {
            val = oldValue + Math.ceil(newValue / this.step - oldValue / this.step) * this.step;
        }
        else if (diff > 0) {
            val = oldValue + Math.floor(newValue / this.step - oldValue / this.step) * this.step;
        }
        this.updateValue(val);
        this.updateHandleValue();
    };
    Slider.prototype.writeValue = function (value) {
        if (this.range)
            this.values = value || [0, 0];
        else
            this.value = value || 0;
        this.updateHandleValue();
        this.cd.markForCheck();
    };
    Slider.prototype.registerOnChange = function (fn) {
        this.onModelChange = fn;
    };
    Slider.prototype.registerOnTouched = function (fn) {
        this.onModelTouched = fn;
    };
    Slider.prototype.setDisabledState = function (val) {
        this.disabled = val;
    };
    Object.defineProperty(Slider.prototype, "rangeStartLeft", {
        get: function () {
            return this.isVertical() ? 'auto' : this.handleValues[0] + '%';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Slider.prototype, "rangeStartBottom", {
        get: function () {
            return this.isVertical() ? this.handleValues[0] + '%' : 'auto';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Slider.prototype, "rangeEndLeft", {
        get: function () {
            return this.isVertical() ? 'auto' : this.handleValues[1] + '%';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Slider.prototype, "rangeEndBottom", {
        get: function () {
            return this.isVertical() ? this.handleValues[1] + '%' : 'auto';
        },
        enumerable: true,
        configurable: true
    });
    Slider.prototype.isVertical = function () {
        return this.orientation === 'vertical';
    };
    Slider.prototype.updateDomData = function () {
        var rect = this.el.nativeElement.children[0].getBoundingClientRect();
        this.initX = rect.left + DomHandler.getWindowScrollLeft();
        this.initY = rect.top + DomHandler.getWindowScrollTop();
        this.barWidth = this.el.nativeElement.children[0].offsetWidth;
        this.barHeight = this.el.nativeElement.children[0].offsetHeight;
    };
    Slider.prototype.calculateHandleValue = function (event) {
        if (this.orientation === 'horizontal')
            return ((event.pageX - this.initX) * 100) / (this.barWidth);
        else
            return (((this.initY + this.barHeight) - event.pageY) * 100) / (this.barHeight);
    };
    Slider.prototype.updateHandleValue = function () {
        if (this.range) {
            this.handleValues[0] = (this.values[0] < this.min ? 0 : this.values[0] - this.min) * 100 / (this.max - this.min);
            this.handleValues[1] = (this.values[1] > this.max ? 100 : this.values[1] - this.min) * 100 / (this.max - this.min);
        }
        else {
            if (this.value < this.min)
                this.handleValue = 0;
            else if (this.value > this.max)
                this.handleValue = 100;
            else
                this.handleValue = (this.value - this.min) * 100 / (this.max - this.min);
        }
    };
    Slider.prototype.updateValue = function (val, event) {
        if (this.range) {
            var value = val;
            if (this.handleIndex == 0) {
                if (value < this.min) {
                    value = this.min;
                    this.handleValues[0] = 0;
                }
                else if (value > this.values[1]) {
                    value = this.values[1];
                    this.handleValues[0] = this.handleValues[1];
                }
                this.sliderHandleStart.nativeElement.focus();
            }
            else {
                if (value > this.max) {
                    value = this.max;
                    this.handleValues[1] = 100;
                }
                else if (value < this.values[0]) {
                    value = this.values[0];
                    this.handleValues[1] = this.handleValues[0];
                }
                this.sliderHandleEnd.nativeElement.focus();
            }
            this.values[this.handleIndex] = this.getNormalizedValue(value);
            this.values = this.values.slice();
            this.onModelChange(this.values);
            this.onChange.emit({ event: event, values: this.values });
        }
        else {
            if (val < this.min) {
                val = this.min;
                this.handleValue = 0;
            }
            else if (val > this.max) {
                val = this.max;
                this.handleValue = 100;
            }
            this.value = this.getNormalizedValue(val);
            this.onModelChange(this.value);
            this.onChange.emit({ event: event, value: this.value });
            this.sliderHandle.nativeElement.focus();
        }
    };
    Slider.prototype.getValueFromHandle = function (handleValue) {
        return (this.max - this.min) * (handleValue / 100) + this.min;
    };
    Slider.prototype.getDecimalsCount = function (value) {
        if (value && Math.floor(value) !== value)
            return value.toString().split(".")[1].length || 0;
        return 0;
    };
    Slider.prototype.getNormalizedValue = function (val) {
        var decimalsCount = this.getDecimalsCount(this.step);
        if (decimalsCount > 0) {
            return +val.toFixed(decimalsCount);
        }
        else {
            return Math.floor(val);
        }
    };
    Slider.prototype.ngOnDestroy = function () {
        this.unbindDragListeners();
    };
    Slider.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 },
        { type: NgZone },
        { type: ChangeDetectorRef }
    ]; };
    __decorate([
        Input()
    ], Slider.prototype, "animate", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "disabled", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "min", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "max", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "orientation", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "step", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "range", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "style", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "ariaLabelledBy", void 0);
    __decorate([
        Input()
    ], Slider.prototype, "tabindex", void 0);
    __decorate([
        Output()
    ], Slider.prototype, "onChange", void 0);
    __decorate([
        Output()
    ], Slider.prototype, "onSlideEnd", void 0);
    __decorate([
        ViewChild("sliderHandle")
    ], Slider.prototype, "sliderHandle", void 0);
    __decorate([
        ViewChild("sliderHandleStart")
    ], Slider.prototype, "sliderHandleStart", void 0);
    __decorate([
        ViewChild("sliderHandleEnd")
    ], Slider.prototype, "sliderHandleEnd", void 0);
Slider.ɵfac = function Slider_Factory(t) { return new (t || Slider)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.Renderer2), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.NgZone), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ChangeDetectorRef)); };
Slider.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: Slider, selectors: [["p-slider"]], viewQuery: function Slider_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
        ɵngcc0.ɵɵviewQuery(_c1, true);
        ɵngcc0.ɵɵviewQuery(_c2, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.sliderHandle = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.sliderHandleStart = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.sliderHandleEnd = _t.first);
    } }, inputs: { min: "min", max: "max", orientation: "orientation", tabindex: "tabindex", disabled: "disabled", animate: "animate", step: "step", range: "range", style: "style", styleClass: "styleClass", ariaLabelledBy: "ariaLabelledBy" }, outputs: { onChange: "onChange", onSlideEnd: "onSlideEnd" }, features: [ɵngcc0.ɵɵProvidersFeature([SLIDER_VALUE_ACCESSOR])], decls: 8, vars: 16, consts: [[3, "ngStyle", "ngClass", "click"], ["class", "ui-slider-range ui-widget-header ui-corner-all", 3, "ngStyle", 4, "ngIf"], ["class", "ui-slider-range ui-slider-range-min ui-widget-header ui-corner-all", 3, "ngStyle", 4, "ngIf"], ["class", "ui-slider-handle ui-state-default ui-corner-all ui-clickable", 3, "transition", "ngStyle", "keydown", "mousedown", "touchstart", "touchmove", "touchend", 4, "ngIf"], ["class", "ui-slider-handle ui-state-default ui-corner-all ui-clickable", 3, "transition", "ngStyle", "ngClass", "keydown", "mousedown", "touchstart", "touchmove", "touchend", 4, "ngIf"], [1, "ui-slider-range", "ui-widget-header", "ui-corner-all", 3, "ngStyle"], [1, "ui-slider-range", "ui-slider-range-min", "ui-widget-header", "ui-corner-all", 3, "ngStyle"], [1, "ui-slider-handle", "ui-state-default", "ui-corner-all", "ui-clickable", 3, "ngStyle", "keydown", "mousedown", "touchstart", "touchmove", "touchend"], ["sliderHandle", ""], [1, "ui-slider-handle", "ui-state-default", "ui-corner-all", "ui-clickable", 3, "ngStyle", "ngClass", "keydown", "mousedown", "touchstart", "touchmove", "touchend"], ["sliderHandleStart", ""], ["sliderHandleEnd", ""]], template: function Slider_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵlistener("click", function Slider_Template_div_click_0_listener($event) { return ctx.onBarClick($event); });
        ɵngcc0.ɵɵtemplate(1, Slider_span_1_Template, 1, 4, "span", 1);
        ɵngcc0.ɵɵtemplate(2, Slider_span_2_Template, 1, 4, "span", 1);
        ɵngcc0.ɵɵtemplate(3, Slider_span_3_Template, 1, 3, "span", 2);
        ɵngcc0.ɵɵtemplate(4, Slider_span_4_Template, 1, 3, "span", 2);
        ɵngcc0.ɵɵtemplate(5, Slider_span_5_Template, 2, 11, "span", 3);
        ɵngcc0.ɵɵtemplate(6, Slider_span_6_Template, 2, 14, "span", 4);
        ɵngcc0.ɵɵtemplate(7, Slider_span_7_Template, 2, 14, "span", 4);
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngStyle", ctx.style)("ngClass", ɵngcc0.ɵɵpureFunction4(11, _c9, ctx.disabled, ctx.orientation == "horizontal", ctx.orientation == "vertical", ctx.animate));
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.range && ctx.orientation == "horizontal");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.range && ctx.orientation == "vertical");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", !ctx.range && ctx.orientation == "vertical");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", !ctx.range && ctx.orientation == "horizontal");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", !ctx.range);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.range);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.range);
    } }, directives: [ɵngcc1.NgStyle, ɵngcc1.NgClass, ɵngcc1.NgIf], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(Slider, [{
        type: Component,
        args: [{
                selector: 'p-slider',
                template: "\n        <div [ngStyle]=\"style\" [class]=\"styleClass\" [ngClass]=\"{'ui-slider ui-widget ui-widget-content ui-corner-all':true,'ui-state-disabled':disabled,\n            'ui-slider-horizontal':orientation == 'horizontal','ui-slider-vertical':orientation == 'vertical','ui-slider-animate':animate}\"\n            (click)=\"onBarClick($event)\">\n            <span *ngIf=\"range && orientation == 'horizontal'\" class=\"ui-slider-range ui-widget-header ui-corner-all\" [ngStyle]=\"{'left':handleValues[0] + '%',width: (handleValues[1] - handleValues[0] + '%')}\"></span>\n            <span *ngIf=\"range && orientation == 'vertical'\" class=\"ui-slider-range ui-widget-header ui-corner-all\" [ngStyle]=\"{'bottom':handleValues[0] + '%',height: (handleValues[1] - handleValues[0] + '%')}\"></span>\n            <span *ngIf=\"!range && orientation=='vertical'\" class=\"ui-slider-range ui-slider-range-min ui-widget-header ui-corner-all\" [ngStyle]=\"{'height': handleValue + '%'}\"></span>\n            <span *ngIf=\"!range && orientation=='horizontal'\" class=\"ui-slider-range ui-slider-range-min ui-widget-header ui-corner-all\" [ngStyle]=\"{'width': handleValue + '%'}\"></span>\n            <span #sliderHandle *ngIf=\"!range\" [attr.tabindex]=\"tabindex\" (keydown)=\"onHandleKeydown($event)\" class=\"ui-slider-handle ui-state-default ui-corner-all ui-clickable\" (mousedown)=\"onMouseDown($event)\" (touchstart)=\"onTouchStart($event)\" (touchmove)=\"onTouchMove($event)\" (touchend)=\"onTouchEnd($event)\"\n                [style.transition]=\"dragging ? 'none': null\" [ngStyle]=\"{'left': orientation == 'horizontal' ? handleValue + '%' : null,'bottom': orientation == 'vertical' ? handleValue + '%' : null}\"\n                [attr.aria-valuemin]=\"min\" [attr.aria-valuenow]=\"value\" [attr.aria-valuemax]=\"max\" [attr.aria-labelledby]=\"ariaLabelledBy\"></span>\n            <span #sliderHandleStart *ngIf=\"range\" [attr.tabindex]=\"tabindex\" (keydown)=\"onHandleKeydown($event,0)\" (mousedown)=\"onMouseDown($event,0)\" (touchstart)=\"onTouchStart($event,0)\" (touchmove)=\"onTouchMove($event,0)\" (touchend)=\"onTouchEnd($event)\" [style.transition]=\"dragging ? 'none': null\" class=\"ui-slider-handle ui-state-default ui-corner-all ui-clickable\" \n                [ngStyle]=\"{'left': rangeStartLeft, 'bottom': rangeStartBottom}\" [ngClass]=\"{'ui-slider-handle-active':handleIndex==0}\"\n                [attr.aria-valuemin]=\"min\" [attr.aria-valuenow]=\"value ? value[0] : null\" [attr.aria-valuemax]=\"max\" [attr.aria-labelledby]=\"ariaLabelledBy\"></span>\n            <span #sliderHandleEnd *ngIf=\"range\" [attr.tabindex]=\"tabindex\" (keydown)=\"onHandleKeydown($event,1)\" (mousedown)=\"onMouseDown($event,1)\" (touchstart)=\"onTouchStart($event,1)\" (touchmove)=\"onTouchMove($event,1)\" (touchend)=\"onTouchEnd($event)\" [style.transition]=\"dragging ? 'none': null\" class=\"ui-slider-handle ui-state-default ui-corner-all ui-clickable\" \n                [ngStyle]=\"{'left': rangeEndLeft, 'bottom': rangeEndBottom}\" [ngClass]=\"{'ui-slider-handle-active':handleIndex==1}\"\n                [attr.aria-valuemin]=\"min\" [attr.aria-valuenow]=\"value ? value[1] : null\" [attr.aria-valuemax]=\"max\" [attr.aria-labelledby]=\"ariaLabelledBy\"></span>\n        </div>\n    ",
                providers: [SLIDER_VALUE_ACCESSOR],
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }, { type: ɵngcc0.Renderer2 }, { type: ɵngcc0.NgZone }, { type: ɵngcc0.ChangeDetectorRef }]; }, { min: [{
            type: Input
        }], max: [{
            type: Input
        }], orientation: [{
            type: Input
        }], tabindex: [{
            type: Input
        }], onChange: [{
            type: Output
        }], onSlideEnd: [{
            type: Output
        }], disabled: [{
            type: Input
        }], animate: [{
            type: Input
        }], step: [{
            type: Input
        }], range: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], ariaLabelledBy: [{
            type: Input
        }], sliderHandle: [{
            type: ViewChild,
            args: ["sliderHandle"]
        }], sliderHandleStart: [{
            type: ViewChild,
            args: ["sliderHandleStart"]
        }], sliderHandleEnd: [{
            type: ViewChild,
            args: ["sliderHandleEnd"]
        }] }); })();
    return Slider;
}());
var SliderModule = /** @class */ (function () {
    function SliderModule() {
    }
SliderModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: SliderModule });
SliderModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function SliderModule_Factory(t) { return new (t || SliderModule)(); }, imports: [[CommonModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(SliderModule, { declarations: function () { return [Slider]; }, imports: function () { return [CommonModule]; }, exports: function () { return [Slider]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(SliderModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [Slider],
                declarations: [Slider]
            }]
    }], function () { return []; }, null); })();
    return SliderModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { SLIDER_VALUE_ACCESSOR, Slider, SliderModule };

//# sourceMappingURL=primeng-slider.js.map