import { EventEmitter, ElementRef, Renderer2, Input, ViewChild, Output, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { trigger, state, style, transition, animate } from '@angular/animations';
import { CommonModule } from '@angular/common';
import { DomHandler } from 'primeng/dom';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

var _c0 = ["container"];
var _c1 = function () { return { "ui-sidebar-close ui-corner-all": true }; };
function Sidebar_a_2_Template(rf, ctx) { if (rf & 1) {
    var _r3 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "a", 3);
    ɵngcc0.ɵɵlistener("click", function Sidebar_a_2_Template_a_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r3); var ctx_r2 = ɵngcc0.ɵɵnextContext(); return ctx_r2.close($event); })("keydown.enter", function Sidebar_a_2_Template_a_keydown_enter_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r3); var ctx_r4 = ɵngcc0.ɵɵnextContext(); return ctx_r4.close($event); });
    ɵngcc0.ɵɵelement(1, "span", 4);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction0(2, _c1));
    ɵngcc0.ɵɵattribute("aria-label", ctx_r1.ariaCloseLabel);
} }
var _c2 = function (a1, a2, a3, a4, a5, a6) { return { "ui-sidebar ui-widget ui-widget-content ui-shadow": true, "ui-sidebar-active": a1, "ui-sidebar-left": a2, "ui-sidebar-right": a3, "ui-sidebar-top": a4, "ui-sidebar-bottom": a5, "ui-sidebar-full": a6 }; };
var _c3 = ["*"];
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var Sidebar = /** @class */ (function () {
    function Sidebar(el, renderer) {
        this.el = el;
        this.renderer = renderer;
        this.position = 'left';
        this.blockScroll = false;
        this.autoZIndex = true;
        this.baseZIndex = 0;
        this.modal = true;
        this.dismissible = true;
        this.showCloseIcon = true;
        this.closeOnEscape = true;
        this.onShow = new EventEmitter();
        this.onHide = new EventEmitter();
        this.visibleChange = new EventEmitter();
    }
    Sidebar.prototype.ngAfterViewInit = function () {
        this.initialized = true;
        if (this.appendTo) {
            if (this.appendTo === 'body')
                document.body.appendChild(this.containerViewChild.nativeElement);
            else
                DomHandler.appendChild(this.containerViewChild.nativeElement, this.appendTo);
        }
        if (this.visible) {
            this.show();
        }
    };
    Object.defineProperty(Sidebar.prototype, "visible", {
        get: function () {
            return this._visible;
        },
        set: function (val) {
            this._visible = val;
            if (this.initialized && this.containerViewChild && this.containerViewChild.nativeElement) {
                if (this._visible)
                    this.show();
                else {
                    if (this.preventVisibleChangePropagation)
                        this.preventVisibleChangePropagation = false;
                    else
                        this.hide();
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Sidebar.prototype.ngAfterViewChecked = function () {
        if (this.executePostDisplayActions) {
            this.onShow.emit({});
            this.executePostDisplayActions = false;
        }
    };
    Sidebar.prototype.show = function () {
        this.executePostDisplayActions = true;
        if (this.autoZIndex) {
            this.containerViewChild.nativeElement.style.zIndex = String(this.baseZIndex + (++DomHandler.zindex));
        }
        if (this.modal) {
            this.enableModality();
        }
    };
    Sidebar.prototype.hide = function () {
        this.onHide.emit({});
        if (this.modal) {
            this.disableModality();
        }
    };
    Sidebar.prototype.close = function (event) {
        this.preventVisibleChangePropagation = true;
        this.hide();
        this.visibleChange.emit(false);
        event.preventDefault();
    };
    Sidebar.prototype.enableModality = function () {
        var _this = this;
        if (!this.mask) {
            this.mask = document.createElement('div');
            this.mask.style.zIndex = String(parseInt(this.containerViewChild.nativeElement.style.zIndex) - 1);
            DomHandler.addMultipleClasses(this.mask, 'ui-widget-overlay ui-sidebar-mask');
            if (this.dismissible) {
                this.maskClickListener = this.renderer.listen(this.mask, 'click', function (event) {
                    if (_this.dismissible) {
                        _this.close(event);
                    }
                });
            }
            document.body.appendChild(this.mask);
            if (this.blockScroll) {
                DomHandler.addClass(document.body, 'ui-overflow-hidden');
            }
        }
    };
    Sidebar.prototype.disableModality = function () {
        if (this.mask) {
            this.unbindMaskClickListener();
            document.body.removeChild(this.mask);
            if (this.blockScroll) {
                DomHandler.removeClass(document.body, 'ui-overflow-hidden');
            }
            this.mask = null;
        }
    };
    Sidebar.prototype.onAnimationStart = function (event) {
        switch (event.toState) {
            case 'visible':
                if (this.closeOnEscape) {
                    this.bindDocumentEscapeListener();
                }
                break;
            case 'hidden':
                this.unbindGlobalListeners();
                break;
        }
    };
    Sidebar.prototype.bindDocumentEscapeListener = function () {
        var _this = this;
        this.documentEscapeListener = this.renderer.listen('document', 'keydown', function (event) {
            if (event.which == 27) {
                if (parseInt(_this.containerViewChild.nativeElement.style.zIndex) === (DomHandler.zindex + _this.baseZIndex)) {
                    _this.close(event);
                }
            }
        });
    };
    Sidebar.prototype.unbindDocumentEscapeListener = function () {
        if (this.documentEscapeListener) {
            this.documentEscapeListener();
            this.documentEscapeListener = null;
        }
    };
    Sidebar.prototype.unbindMaskClickListener = function () {
        if (this.maskClickListener) {
            this.maskClickListener();
            this.maskClickListener = null;
        }
    };
    Sidebar.prototype.unbindGlobalListeners = function () {
        this.unbindMaskClickListener();
        this.unbindDocumentEscapeListener();
    };
    Sidebar.prototype.ngOnDestroy = function () {
        this.initialized = false;
        if (this.visible) {
            this.hide();
        }
        if (this.appendTo) {
            this.el.nativeElement.appendChild(this.containerViewChild.nativeElement);
        }
        this.unbindGlobalListeners();
    };
    Sidebar.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 }
    ]; };
    __decorate([
        Input()
    ], Sidebar.prototype, "position", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "fullScreen", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "appendTo", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "blockScroll", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "style", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "ariaCloseLabel", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "autoZIndex", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "baseZIndex", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "modal", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "dismissible", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "showCloseIcon", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "closeOnEscape", void 0);
    __decorate([
        ViewChild('container')
    ], Sidebar.prototype, "containerViewChild", void 0);
    __decorate([
        Output()
    ], Sidebar.prototype, "onShow", void 0);
    __decorate([
        Output()
    ], Sidebar.prototype, "onHide", void 0);
    __decorate([
        Output()
    ], Sidebar.prototype, "visibleChange", void 0);
    __decorate([
        Input()
    ], Sidebar.prototype, "visible", null);
Sidebar.ɵfac = function Sidebar_Factory(t) { return new (t || Sidebar)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.Renderer2)); };
Sidebar.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: Sidebar, selectors: [["p-sidebar"]], viewQuery: function Sidebar_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.containerViewChild = _t.first);
    } }, inputs: { position: "position", blockScroll: "blockScroll", autoZIndex: "autoZIndex", baseZIndex: "baseZIndex", modal: "modal", dismissible: "dismissible", showCloseIcon: "showCloseIcon", closeOnEscape: "closeOnEscape", visible: "visible", fullScreen: "fullScreen", appendTo: "appendTo", style: "style", styleClass: "styleClass", ariaCloseLabel: "ariaCloseLabel" }, outputs: { onShow: "onShow", onHide: "onHide", visibleChange: "visibleChange" }, ngContentSelectors: _c3, decls: 4, vars: 14, consts: [["role", "complementary", 3, "ngClass", "ngStyle"], ["container", ""], ["tabindex", "0", "role", "button", 3, "ngClass", "click", "keydown.enter", 4, "ngIf"], ["tabindex", "0", "role", "button", 3, "ngClass", "click", "keydown.enter"], [1, "pi", "pi-times"]], template: function Sidebar_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef();
        ɵngcc0.ɵɵelementStart(0, "div", 0, 1);
        ɵngcc0.ɵɵlistener("@panelState.start", function Sidebar_Template_div_animation_panelState_start_0_listener($event) { return ctx.onAnimationStart($event); });
        ɵngcc0.ɵɵtemplate(2, Sidebar_a_2_Template, 2, 3, "a", 2);
        ɵngcc0.ɵɵprojection(3);
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction6(7, _c2, ctx.visible, ctx.position === "left", ctx.position === "right", ctx.position === "top", ctx.position === "bottom", ctx.fullScreen))("@panelState", ctx.visible ? "visible" : "hidden")("ngStyle", ctx.style);
        ɵngcc0.ɵɵattribute("aria-modal", ctx.modal);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngIf", ctx.showCloseIcon);
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle, ɵngcc1.NgIf], encapsulation: 2, data: { animation: [
            trigger('panelState', [
                state('hidden', style({
                    opacity: 0
                })),
                state('visible', style({
                    opacity: 1
                })),
                transition('visible => hidden', animate('300ms ease-in')),
                transition('hidden => visible', animate('300ms ease-out'))
            ])
        ] } });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(Sidebar, [{
        type: Component,
        args: [{
                selector: 'p-sidebar',
                template: "\n        <div #container [ngClass]=\"{'ui-sidebar ui-widget ui-widget-content ui-shadow':true, 'ui-sidebar-active': visible, \n            'ui-sidebar-left': (position === 'left'), 'ui-sidebar-right': (position === 'right'),\n            'ui-sidebar-top': (position === 'top'), 'ui-sidebar-bottom': (position === 'bottom'), \n            'ui-sidebar-full': fullScreen}\"\n            [@panelState]=\"visible ? 'visible' : 'hidden'\" (@panelState.start)=\"onAnimationStart($event)\" [ngStyle]=\"style\" [class]=\"styleClass\"  role=\"complementary\" [attr.aria-modal]=\"modal\">\n            <a [ngClass]=\"{'ui-sidebar-close ui-corner-all':true}\" *ngIf=\"showCloseIcon\" tabindex=\"0\" role=\"button\" (click)=\"close($event)\" (keydown.enter)=\"close($event)\" [attr.aria-label]=\"ariaCloseLabel\">\n                <span class=\"pi pi-times\"></span>\n            </a>\n            <ng-content></ng-content>\n        </div>\n    ",
                animations: [
                    trigger('panelState', [
                        state('hidden', style({
                            opacity: 0
                        })),
                        state('visible', style({
                            opacity: 1
                        })),
                        transition('visible => hidden', animate('300ms ease-in')),
                        transition('hidden => visible', animate('300ms ease-out'))
                    ])
                ],
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }, { type: ɵngcc0.Renderer2 }]; }, { position: [{
            type: Input
        }], blockScroll: [{
            type: Input
        }], autoZIndex: [{
            type: Input
        }], baseZIndex: [{
            type: Input
        }], modal: [{
            type: Input
        }], dismissible: [{
            type: Input
        }], showCloseIcon: [{
            type: Input
        }], closeOnEscape: [{
            type: Input
        }], onShow: [{
            type: Output
        }], onHide: [{
            type: Output
        }], visibleChange: [{
            type: Output
        }], visible: [{
            type: Input
        }], fullScreen: [{
            type: Input
        }], appendTo: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], ariaCloseLabel: [{
            type: Input
        }], containerViewChild: [{
            type: ViewChild,
            args: ['container']
        }] }); })();
    return Sidebar;
}());
var SidebarModule = /** @class */ (function () {
    function SidebarModule() {
    }
SidebarModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: SidebarModule });
SidebarModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function SidebarModule_Factory(t) { return new (t || SidebarModule)(); }, imports: [[CommonModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(SidebarModule, { declarations: function () { return [Sidebar]; }, imports: function () { return [CommonModule]; }, exports: function () { return [Sidebar]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(SidebarModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [Sidebar],
                declarations: [Sidebar]
            }]
    }], function () { return []; }, null); })();
    return SidebarModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { Sidebar, SidebarModule };

//# sourceMappingURL=primeng-sidebar.js.map