import { forwardRef, EventEmitter, ElementRef, ChangeDetectorRef, Input, Output, ViewChild, ContentChild, ContentChildren, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { Header, Footer, PrimeTemplate, SharedModule } from 'primeng/api';
import { DomHandler } from 'primeng/dom';
import { ObjectUtils, FilterUtils } from 'primeng/utils';
import { NG_VALUE_ACCESSOR } from '@angular/forms';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

var _c0 = ["headerchkbox"];
function Listbox_div_3_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 8);
    ɵngcc0.ɵɵprojection(1);
    ɵngcc0.ɵɵelementEnd();
} }
var _c1 = function (a0, a1) { return { "ui-state-active": a0, "ui-state-focus": a1 }; };
var _c2 = function (a0) { return { "pi pi-check": a0 }; };
function Listbox_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    var _r8 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "div", 12);
    ɵngcc0.ɵɵelementStart(1, "div", 1);
    ɵngcc0.ɵɵelementStart(2, "input", 13);
    ɵngcc0.ɵɵlistener("focus", function Listbox_div_4_div_1_Template_input_focus_2_listener() { ɵngcc0.ɵɵrestoreView(_r8); var ctx_r7 = ɵngcc0.ɵɵnextContext(2); return ctx_r7.onHeaderCheckboxFocus(); })("blur", function Listbox_div_4_div_1_Template_input_blur_2_listener() { ɵngcc0.ɵɵrestoreView(_r8); var ctx_r9 = ɵngcc0.ɵɵnextContext(2); return ctx_r9.onHeaderCheckboxBlur(); })("keydown.space", function Listbox_div_4_div_1_Template_input_keydown_space_2_listener($event) { ɵngcc0.ɵɵrestoreView(_r8); var ctx_r10 = ɵngcc0.ɵɵnextContext(2); return ctx_r10.toggleAll($event); });
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(3, "div", 14, 15);
    ɵngcc0.ɵɵlistener("click", function Listbox_div_4_div_1_Template_div_click_3_listener($event) { ɵngcc0.ɵɵrestoreView(_r8); var ctx_r11 = ɵngcc0.ɵɵnextContext(2); return ctx_r11.toggleAll($event); });
    ɵngcc0.ɵɵelement(5, "span", 16);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r4 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("checked", ctx_r4.allChecked);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(3, _c1, ctx_r4.allChecked, ctx_r4.headerCheckboxFocus));
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(6, _c2, ctx_r4.allChecked));
} }
function Listbox_div_4_div_2_Template(rf, ctx) { if (rf & 1) {
    var _r13 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "div", 17);
    ɵngcc0.ɵɵelementStart(1, "input", 18);
    ɵngcc0.ɵɵlistener("input", function Listbox_div_4_div_2_Template_input_input_1_listener($event) { ɵngcc0.ɵɵrestoreView(_r13); var ctx_r12 = ɵngcc0.ɵɵnextContext(2); return ctx_r12.onFilter($event); });
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelement(2, "span", 19);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r5 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("value", ctx_r5.filterValue || "")("disabled", ctx_r5.disabled);
    ɵngcc0.ɵɵattribute("placeholder", ctx_r5.filterPlaceHolder)("aria-label", ctx_r5.ariaFilterLabel);
} }
var _c3 = function (a0) { return { "ui-listbox-header-w-checkbox": a0 }; };
function Listbox_div_4_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 9);
    ɵngcc0.ɵɵtemplate(1, Listbox_div_4_div_1_Template, 6, 8, "div", 10);
    ɵngcc0.ɵɵtemplate(2, Listbox_div_4_div_2_Template, 3, 4, "div", 11);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(3, _c3, ctx_r1.checkbox));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r1.checkbox && ctx_r1.multiple && ctx_r1.showToggleAll);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r1.filter);
} }
var _c4 = function (a0) { return { "ui-state-active": a0 }; };
function Listbox_li_7_div_1_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 12);
    ɵngcc0.ɵɵelementStart(1, "div", 23);
    ɵngcc0.ɵɵelement(2, "span", 16);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var option_r14 = ɵngcc0.ɵɵnextContext().$implicit;
    var ctx_r16 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(2, _c4, ctx_r16.isSelected(option_r14)));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(4, _c2, ctx_r16.isSelected(option_r14)));
} }
function Listbox_li_7_span_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "span");
    ɵngcc0.ɵɵtext(1);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var option_r14 = ɵngcc0.ɵɵnextContext().$implicit;
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵtextInterpolate(option_r14.label);
} }
function Listbox_li_7_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementContainer(0);
} }
var _c5 = function (a1, a2) { return { "ui-listbox-item ui-corner-all": true, "ui-state-highlight": a1, "ui-state-disabled": a2 }; };
var _c6 = function (a0, a1) { return { $implicit: a0, index: a1 }; };
function Listbox_li_7_Template(rf, ctx) { if (rf & 1) {
    var _r22 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "li", 20);
    ɵngcc0.ɵɵlistener("click", function Listbox_li_7_Template_li_click_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r22); var option_r14 = ctx.$implicit; var ctx_r21 = ɵngcc0.ɵɵnextContext(); return ctx_r21.onOptionClick($event, option_r14); })("dblclick", function Listbox_li_7_Template_li_dblclick_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r22); var option_r14 = ctx.$implicit; var ctx_r23 = ɵngcc0.ɵɵnextContext(); return ctx_r23.onOptionDoubleClick($event, option_r14); })("touchend", function Listbox_li_7_Template_li_touchend_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r22); var option_r14 = ctx.$implicit; var ctx_r24 = ɵngcc0.ɵɵnextContext(); return ctx_r24.onOptionTouchEnd($event, option_r14); })("keydown", function Listbox_li_7_Template_li_keydown_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r22); var option_r14 = ctx.$implicit; var ctx_r25 = ɵngcc0.ɵɵnextContext(); return ctx_r25.onOptionKeyDown($event, option_r14); });
    ɵngcc0.ɵɵtemplate(1, Listbox_li_7_div_1_Template, 3, 6, "div", 10);
    ɵngcc0.ɵɵtemplate(2, Listbox_li_7_span_2_Template, 2, 1, "span", 21);
    ɵngcc0.ɵɵtemplate(3, Listbox_li_7_ng_container_3_Template, 1, 0, "ng-container", 22);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var option_r14 = ctx.$implicit;
    var i_r15 = ctx.index;
    var ctx_r2 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵstyleProp("display", ctx_r2.isItemVisible(option_r14) ? "block" : "none");
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(10, _c5, ctx_r2.isSelected(option_r14), option_r14.disabled));
    ɵngcc0.ɵɵattribute("tabindex", option_r14.disabled ? null : "0")("aria-label", option_r14.label)("aria-selected", ctx_r2.isSelected(option_r14));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r2.checkbox && ctx_r2.multiple);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", !ctx_r2.itemTemplate);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngTemplateOutlet", ctx_r2.itemTemplate)("ngTemplateOutletContext", ɵngcc0.ɵɵpureFunction2(13, _c6, option_r14, i_r15));
} }
function Listbox_div_8_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 24);
    ɵngcc0.ɵɵprojection(1, 1);
    ɵngcc0.ɵɵelementEnd();
} }
var _c7 = [[["p-header"]], [["p-footer"]]];
var _c8 = function (a1, a2) { return { "ui-listbox ui-inputtext ui-widget ui-widget-content ui-corner-all": true, "ui-state-disabled": a1, "ui-state-focus": a2 }; };
var _c9 = ["p-header", "p-footer"];
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var LISTBOX_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return Listbox; }),
    multi: true
};
var Listbox = /** @class */ (function () {
    function Listbox(el, cd) {
        this.el = el;
        this.cd = cd;
        this.checkbox = false;
        this.filter = false;
        this.filterMode = 'contains';
        this.metaKeySelection = true;
        this.showToggleAll = true;
        this.onChange = new EventEmitter();
        this.onClick = new EventEmitter();
        this.onDblClick = new EventEmitter();
        this.onModelChange = function () { };
        this.onModelTouched = function () { };
        this.disabledSelectedOptions = [];
    }
    Object.defineProperty(Listbox.prototype, "options", {
        get: function () {
            return this._options;
        },
        set: function (val) {
            var opts = this.optionLabel ? ObjectUtils.generateSelectItems(val, this.optionLabel) : val;
            this._options = opts;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Listbox.prototype, "filterValue", {
        get: function () {
            return this._filterValue;
        },
        set: function (val) {
            this._filterValue = val;
        },
        enumerable: true,
        configurable: true
    });
    Listbox.prototype.ngAfterContentInit = function () {
        var _this = this;
        this.templates.forEach(function (item) {
            switch (item.getType()) {
                case 'item':
                    _this.itemTemplate = item.template;
                    break;
                default:
                    _this.itemTemplate = item.template;
                    break;
            }
        });
    };
    Listbox.prototype.writeValue = function (value) {
        this.value = value;
        this.setDisabledSelectedOptions();
        this.cd.markForCheck();
    };
    Listbox.prototype.registerOnChange = function (fn) {
        this.onModelChange = fn;
    };
    Listbox.prototype.registerOnTouched = function (fn) {
        this.onModelTouched = fn;
    };
    Listbox.prototype.setDisabledState = function (val) {
        this.disabled = val;
    };
    Listbox.prototype.onOptionClick = function (event, option) {
        if (this.disabled || option.disabled || this.readonly) {
            return;
        }
        if (this.multiple) {
            if (this.checkbox)
                this.onOptionClickCheckbox(event, option);
            else
                this.onOptionClickMultiple(event, option);
        }
        else {
            this.onOptionClickSingle(event, option);
        }
        this.onClick.emit({
            originalEvent: event,
            option: option,
            value: this.value
        });
        this.optionTouched = false;
    };
    Listbox.prototype.onOptionTouchEnd = function (event, option) {
        if (this.disabled || option.disabled || this.readonly) {
            return;
        }
        this.optionTouched = true;
    };
    Listbox.prototype.onOptionDoubleClick = function (event, option) {
        if (this.disabled || option.disabled || this.readonly) {
            return;
        }
        this.onDblClick.emit({
            originalEvent: event,
            option: option,
            value: this.value
        });
    };
    Listbox.prototype.onOptionClickSingle = function (event, option) {
        var selected = this.isSelected(option);
        var valueChanged = false;
        var metaSelection = this.optionTouched ? false : this.metaKeySelection;
        if (metaSelection) {
            var metaKey = (event.metaKey || event.ctrlKey);
            if (selected) {
                if (metaKey) {
                    this.value = null;
                    valueChanged = true;
                }
            }
            else {
                this.value = option.value;
                valueChanged = true;
            }
        }
        else {
            this.value = selected ? null : option.value;
            valueChanged = true;
        }
        if (valueChanged) {
            this.onModelChange(this.value);
            this.onChange.emit({
                originalEvent: event,
                value: this.value
            });
        }
    };
    Listbox.prototype.onOptionClickMultiple = function (event, option) {
        var selected = this.isSelected(option);
        var valueChanged = false;
        var metaSelection = this.optionTouched ? false : this.metaKeySelection;
        if (metaSelection) {
            var metaKey = (event.metaKey || event.ctrlKey);
            if (selected) {
                if (metaKey) {
                    this.removeOption(option);
                }
                else {
                    this.value = [option.value];
                }
                valueChanged = true;
            }
            else {
                this.value = (metaKey) ? this.value || [] : [];
                this.value = __spread(this.value, [option.value]);
                valueChanged = true;
            }
        }
        else {
            if (selected) {
                this.removeOption(option);
            }
            else {
                this.value = __spread(this.value || [], [option.value]);
            }
            valueChanged = true;
        }
        if (valueChanged) {
            this.onModelChange(this.value);
            this.onChange.emit({
                originalEvent: event,
                value: this.value
            });
        }
    };
    Listbox.prototype.onOptionClickCheckbox = function (event, option) {
        if (this.disabled || this.readonly) {
            return;
        }
        var selected = this.isSelected(option);
        if (selected) {
            this.removeOption(option);
        }
        else {
            this.value = this.value ? this.value : [];
            this.value = __spread(this.value, [option.value]);
        }
        this.onModelChange(this.value);
        this.onChange.emit({
            originalEvent: event,
            value: this.value
        });
    };
    Listbox.prototype.removeOption = function (option) {
        var _this = this;
        this.value = this.value.filter(function (val) { return !ObjectUtils.equals(val, option.value, _this.dataKey); });
    };
    Listbox.prototype.isSelected = function (option) {
        var e_1, _a;
        var selected = false;
        if (this.multiple) {
            if (this.value) {
                try {
                    for (var _b = __values(this.value), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var val = _c.value;
                        if (ObjectUtils.equals(val, option.value, this.dataKey)) {
                            selected = true;
                            break;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
        }
        else {
            selected = ObjectUtils.equals(this.value, option.value, this.dataKey);
        }
        return selected;
    };
    Object.defineProperty(Listbox.prototype, "allChecked", {
        get: function () {
            if (this.filterValue) {
                return this.allFilteredSelected();
            }
            else {
                var optionCount = this.getEnabledOptionCount();
                var disabledSelectedOptionCount = this.disabledSelectedOptions.length;
                return this.value && this.options && (this.value.length > 0 && this.value.length == optionCount + disabledSelectedOptionCount);
            }
        },
        enumerable: true,
        configurable: true
    });
    Listbox.prototype.getEnabledOptionCount = function () {
        var e_2, _a;
        if (this.options) {
            var count = 0;
            try {
                for (var _b = __values(this.options), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var opt = _c.value;
                    if (!opt.disabled) {
                        count++;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
            return count;
        }
        else {
            return 0;
        }
    };
    Listbox.prototype.allFilteredSelected = function () {
        var e_3, _a;
        var allSelected;
        var options = this.filterValue ? this.getFilteredOptions() : this.options;
        if (this.value && options && options.length) {
            allSelected = true;
            try {
                for (var _b = __values(this.options), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var opt = _c.value;
                    if (this.isItemVisible(opt)) {
                        if (!this.isSelected(opt)) {
                            allSelected = false;
                            break;
                        }
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
        return allSelected;
    };
    Listbox.prototype.onFilter = function (event) {
        this._filterValue = event.target.value;
    };
    Listbox.prototype.toggleAll = function (event) {
        if (this.disabled || this.readonly || !this.options || this.options.length === 0) {
            return;
        }
        if (this.allChecked) {
            if (this.disabledSelectedOptions && this.disabledSelectedOptions.length > 0) {
                var value = [];
                value = __spread(this.disabledSelectedOptions);
                this.value = value;
            }
            else {
                this.value = [];
            }
        }
        else {
            if (this.options) {
                this.value = [];
                if (this.disabledSelectedOptions && this.disabledSelectedOptions.length > 0) {
                    this.value = __spread(this.disabledSelectedOptions);
                }
                for (var i = 0; i < this.options.length; i++) {
                    var opt = this.options[i];
                    if (this.isItemVisible(opt) && !opt.disabled) {
                        this.value.push(opt.value);
                    }
                }
            }
        }
        this.onModelChange(this.value);
        this.onChange.emit({ originalEvent: event, value: this.value });
        event.preventDefault();
    };
    Listbox.prototype.isItemVisible = function (option) {
        if (this.filterValue) {
            var visible = void 0;
            if (this.filterMode) {
                visible = FilterUtils[this.filterMode](option.label, this.filterValue, this.filterLocale);
            }
            else {
                visible = true;
            }
            return visible;
        }
        else {
            return true;
        }
    };
    Listbox.prototype.onInputFocus = function (event) {
        this.focus = true;
    };
    Listbox.prototype.onInputBlur = function (event) {
        this.focus = false;
    };
    Listbox.prototype.onOptionKeyDown = function (event, option) {
        if (this.readonly) {
            return;
        }
        var item = event.currentTarget;
        switch (event.which) {
            //down
            case 40:
                var nextItem = this.findNextItem(item);
                if (nextItem) {
                    nextItem.focus();
                }
                event.preventDefault();
                break;
            //up
            case 38:
                var prevItem = this.findPrevItem(item);
                if (prevItem) {
                    prevItem.focus();
                }
                event.preventDefault();
                break;
            //enter
            case 13:
                this.onOptionClick(event, option);
                event.preventDefault();
                break;
        }
    };
    Listbox.prototype.findNextItem = function (item) {
        var nextItem = item.nextElementSibling;
        if (nextItem)
            return DomHandler.hasClass(nextItem, 'ui-state-disabled') || DomHandler.isHidden(nextItem) ? this.findNextItem(nextItem) : nextItem;
        else
            return null;
    };
    Listbox.prototype.findPrevItem = function (item) {
        var prevItem = item.previousElementSibling;
        if (prevItem)
            return DomHandler.hasClass(prevItem, 'ui-state-disabled') || DomHandler.isHidden(prevItem) ? this.findPrevItem(prevItem) : prevItem;
        else
            return null;
    };
    Listbox.prototype.getFilteredOptions = function () {
        var filteredOptions = [];
        if (this.filterValue) {
            for (var i = 0; i < this.options.length; i++) {
                var opt = this.options[i];
                if (this.isItemVisible(opt) && !opt.disabled) {
                    filteredOptions.push(opt);
                }
            }
            return filteredOptions;
        }
        else {
            return this.options;
        }
    };
    Listbox.prototype.onHeaderCheckboxFocus = function () {
        this.headerCheckboxFocus = true;
    };
    Listbox.prototype.onHeaderCheckboxBlur = function () {
        this.headerCheckboxFocus = false;
    };
    Listbox.prototype.setDisabledSelectedOptions = function () {
        var e_4, _a;
        if (this.options) {
            this.disabledSelectedOptions = [];
            if (this.value) {
                try {
                    for (var _b = __values(this.options), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var opt = _c.value;
                        if (opt.disabled && this.isSelected(opt)) {
                            this.disabledSelectedOptions.push(opt.value);
                        }
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
    };
    Listbox.ctorParameters = function () { return [
        { type: ElementRef },
        { type: ChangeDetectorRef }
    ]; };
    __decorate([
        Input()
    ], Listbox.prototype, "multiple", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "style", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "listStyle", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "listStyleClass", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "readonly", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "disabled", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "checkbox", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "filter", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "filterMode", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "filterLocale", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "metaKeySelection", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "dataKey", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "showToggleAll", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "optionLabel", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "ariaFilterLabel", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "filterPlaceHolder", void 0);
    __decorate([
        Output()
    ], Listbox.prototype, "onChange", void 0);
    __decorate([
        Output()
    ], Listbox.prototype, "onClick", void 0);
    __decorate([
        Output()
    ], Listbox.prototype, "onDblClick", void 0);
    __decorate([
        ViewChild('headerchkbox')
    ], Listbox.prototype, "headerCheckboxViewChild", void 0);
    __decorate([
        ContentChild(Header)
    ], Listbox.prototype, "headerFacet", void 0);
    __decorate([
        ContentChild(Footer)
    ], Listbox.prototype, "footerFacet", void 0);
    __decorate([
        ContentChildren(PrimeTemplate)
    ], Listbox.prototype, "templates", void 0);
    __decorate([
        Input()
    ], Listbox.prototype, "options", null);
    __decorate([
        Input()
    ], Listbox.prototype, "filterValue", null);
Listbox.ɵfac = function Listbox_Factory(t) { return new (t || Listbox)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ChangeDetectorRef)); };
Listbox.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: Listbox, selectors: [["p-listbox"]], contentQueries: function Listbox_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        ɵngcc0.ɵɵcontentQuery(dirIndex, Header, true);
        ɵngcc0.ɵɵcontentQuery(dirIndex, Footer, true);
        ɵngcc0.ɵɵcontentQuery(dirIndex, PrimeTemplate, false);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.headerFacet = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.footerFacet = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.templates = _t);
    } }, viewQuery: function Listbox_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.headerCheckboxViewChild = _t.first);
    } }, inputs: { checkbox: "checkbox", filter: "filter", filterMode: "filterMode", metaKeySelection: "metaKeySelection", showToggleAll: "showToggleAll", options: "options", filterValue: "filterValue", disabled: "disabled", multiple: "multiple", style: "style", styleClass: "styleClass", listStyle: "listStyle", listStyleClass: "listStyleClass", readonly: "readonly", filterLocale: "filterLocale", dataKey: "dataKey", optionLabel: "optionLabel", ariaFilterLabel: "ariaFilterLabel", filterPlaceHolder: "filterPlaceHolder" }, outputs: { onChange: "onChange", onClick: "onClick", onDblClick: "onDblClick" }, features: [ɵngcc0.ɵɵProvidersFeature([LISTBOX_VALUE_ACCESSOR])], ngContentSelectors: _c9, decls: 9, vars: 15, consts: [[3, "ngClass", "ngStyle"], [1, "ui-helper-hidden-accessible"], ["type", "text", "readonly", "readonly", 3, "focus", "blur"], ["class", "ui-widget-header ui-corner-all ui-listbox-header ui-helper-clearfix", 4, "ngIf"], ["class", "ui-widget-header ui-corner-all ui-listbox-header ui-helper-clearfix", 3, "ngClass", 4, "ngIf"], ["role", "listbox", "aria-multiselectable", "multiple", 1, "ui-listbox-list"], ["role", "option", 3, "display", "ngClass", "click", "dblclick", "touchend", "keydown", 4, "ngFor", "ngForOf"], ["class", "ui-listbox-footer ui-widget-header ui-corner-all", 4, "ngIf"], [1, "ui-widget-header", "ui-corner-all", "ui-listbox-header", "ui-helper-clearfix"], [1, "ui-widget-header", "ui-corner-all", "ui-listbox-header", "ui-helper-clearfix", 3, "ngClass"], ["class", "ui-chkbox ui-widget", 4, "ngIf"], ["class", "ui-listbox-filter-container", 4, "ngIf"], [1, "ui-chkbox", "ui-widget"], ["type", "checkbox", "readonly", "readonly", 3, "checked", "focus", "blur", "keydown.space"], [1, "ui-chkbox-box", "ui-widget", "ui-corner-all", "ui-state-default", 3, "ngClass", "click"], ["headerchkbox", ""], [1, "ui-chkbox-icon", "ui-clickable", 3, "ngClass"], [1, "ui-listbox-filter-container"], ["type", "text", 1, "ui-inputtext", "ui-widget", "ui-state-default", "ui-corner-all", 3, "value", "disabled", "input"], [1, "ui-listbox-filter-icon", "pi", "pi-search"], ["role", "option", 3, "ngClass", "click", "dblclick", "touchend", "keydown"], [4, "ngIf"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [1, "ui-chkbox-box", "ui-widget", "ui-corner-all", "ui-state-default", 3, "ngClass"], [1, "ui-listbox-footer", "ui-widget-header", "ui-corner-all"]], template: function Listbox_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef(_c7);
        ɵngcc0.ɵɵelementStart(0, "div", 0);
        ɵngcc0.ɵɵelementStart(1, "div", 1);
        ɵngcc0.ɵɵelementStart(2, "input", 2);
        ɵngcc0.ɵɵlistener("focus", function Listbox_Template_input_focus_2_listener($event) { return ctx.onInputFocus($event); })("blur", function Listbox_Template_input_blur_2_listener($event) { return ctx.onInputBlur($event); });
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵtemplate(3, Listbox_div_3_Template, 2, 0, "div", 3);
        ɵngcc0.ɵɵtemplate(4, Listbox_div_4_Template, 3, 5, "div", 4);
        ɵngcc0.ɵɵelementStart(5, "div", 0);
        ɵngcc0.ɵɵelementStart(6, "ul", 5);
        ɵngcc0.ɵɵtemplate(7, Listbox_li_7_Template, 4, 16, "li", 6);
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵelementEnd();
        ɵngcc0.ɵɵtemplate(8, Listbox_div_8_Template, 2, 0, "div", 7);
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(12, _c8, ctx.disabled, ctx.focus))("ngStyle", ctx.style);
        ɵngcc0.ɵɵadvance(3);
        ɵngcc0.ɵɵproperty("ngIf", ctx.headerFacet);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.checkbox && ctx.multiple && ctx.showToggleAll || ctx.filter);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵclassMap(ctx.listStyleClass);
        ɵngcc0.ɵɵproperty("ngClass", "ui-listbox-list-wrapper")("ngStyle", ctx.listStyle);
        ɵngcc0.ɵɵadvance(2);
        ɵngcc0.ɵɵproperty("ngForOf", ctx.options);
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.footerFacet);
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle, ɵngcc1.NgIf, ɵngcc1.NgForOf, ɵngcc1.NgTemplateOutlet], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(Listbox, [{
        type: Component,
        args: [{
                selector: 'p-listbox',
                template: "\n    <div [ngClass]=\"{'ui-listbox ui-inputtext ui-widget ui-widget-content ui-corner-all':true,'ui-state-disabled':disabled,'ui-state-focus':focus}\" [ngStyle]=\"style\" [class]=\"styleClass\">\n      <div class=\"ui-helper-hidden-accessible\">\n        <input type=\"text\" readonly=\"readonly\" (focus)=\"onInputFocus($event)\" (blur)=\"onInputBlur($event)\">\n      </div>\n      <div class=\"ui-widget-header ui-corner-all ui-listbox-header ui-helper-clearfix\" *ngIf=\"headerFacet\">\n        <ng-content select=\"p-header\"></ng-content>\n      </div>\n      <div class=\"ui-widget-header ui-corner-all ui-listbox-header ui-helper-clearfix\" *ngIf=\"(checkbox && multiple && showToggleAll) || filter\" [ngClass]=\"{'ui-listbox-header-w-checkbox': checkbox}\">\n        <div class=\"ui-chkbox ui-widget\" *ngIf=\"checkbox && multiple && showToggleAll\">\n          <div class=\"ui-helper-hidden-accessible\">\n            <input type=\"checkbox\" readonly=\"readonly\" [checked]=\"allChecked\" (focus)=\"onHeaderCheckboxFocus()\" (blur)=\"onHeaderCheckboxBlur()\" (keydown.space)=\"toggleAll($event)\">\n          </div>\n          <div #headerchkbox class=\"ui-chkbox-box ui-widget ui-corner-all ui-state-default\" [ngClass]=\"{'ui-state-active': allChecked, 'ui-state-focus': headerCheckboxFocus}\" (click)=\"toggleAll($event)\">\n            <span class=\"ui-chkbox-icon ui-clickable\" [ngClass]=\"{'pi pi-check':allChecked}\"></span>\n          </div>\n        </div>\n        <div class=\"ui-listbox-filter-container\" *ngIf=\"filter\">\n          <input type=\"text\" [value]=\"filterValue||''\" (input)=\"onFilter($event)\" class=\"ui-inputtext ui-widget ui-state-default ui-corner-all\" [disabled]=\"disabled\" [attr.placeholder]=\"filterPlaceHolder\" [attr.aria-label]=\"ariaFilterLabel\">\n          <span class=\"ui-listbox-filter-icon pi pi-search\"></span>\n        </div>\n      </div>\n      <div [ngClass]=\"'ui-listbox-list-wrapper'\" [ngStyle]=\"listStyle\" [class]=\"listStyleClass\">\n        <ul class=\"ui-listbox-list\" role=\"listbox\" aria-multiselectable=\"multiple\">\n          <li *ngFor=\"let option of options; let i = index;\" [style.display]=\"isItemVisible(option) ? 'block' : 'none'\" [attr.tabindex]=\"option.disabled ? null : '0'\"\n              [ngClass]=\"{'ui-listbox-item ui-corner-all':true,'ui-state-highlight':isSelected(option), 'ui-state-disabled': option.disabled}\" role=\"option\" [attr.aria-label]=\"option.label\"\n              [attr.aria-selected]=\"isSelected(option)\" (click)=\"onOptionClick($event,option)\" (dblclick)=\"onOptionDoubleClick($event,option)\" (touchend)=\"onOptionTouchEnd($event,option)\" (keydown)=\"onOptionKeyDown($event,option)\">\n            <div class=\"ui-chkbox ui-widget\" *ngIf=\"checkbox && multiple\">\n              <div class=\"ui-chkbox-box ui-widget ui-corner-all ui-state-default\" [ngClass]=\"{'ui-state-active':isSelected(option)}\">\n                <span class=\"ui-chkbox-icon ui-clickable\" [ngClass]=\"{'pi pi-check':isSelected(option)}\"></span>\n              </div>\n            </div>\n            <span *ngIf=\"!itemTemplate\">{{option.label}}</span>\n            <ng-container *ngTemplateOutlet=\"itemTemplate; context: {$implicit: option, index: i}\"></ng-container>\n          </li>\n        </ul>\n      </div>\n      <div class=\"ui-listbox-footer ui-widget-header ui-corner-all\" *ngIf=\"footerFacet\">\n        <ng-content select=\"p-footer\"></ng-content>\n      </div>\n    </div>\n  ",
                providers: [LISTBOX_VALUE_ACCESSOR],
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }, { type: ɵngcc0.ChangeDetectorRef }]; }, { checkbox: [{
            type: Input
        }], filter: [{
            type: Input
        }], filterMode: [{
            type: Input
        }], metaKeySelection: [{
            type: Input
        }], showToggleAll: [{
            type: Input
        }], onChange: [{
            type: Output
        }], onClick: [{
            type: Output
        }], onDblClick: [{
            type: Output
        }], options: [{
            type: Input
        }], filterValue: [{
            type: Input
        }], disabled: [{
            type: Input
        }], multiple: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], listStyle: [{
            type: Input
        }], listStyleClass: [{
            type: Input
        }], readonly: [{
            type: Input
        }], filterLocale: [{
            type: Input
        }], dataKey: [{
            type: Input
        }], optionLabel: [{
            type: Input
        }], ariaFilterLabel: [{
            type: Input
        }], filterPlaceHolder: [{
            type: Input
        }], headerCheckboxViewChild: [{
            type: ViewChild,
            args: ['headerchkbox']
        }], headerFacet: [{
            type: ContentChild,
            args: [Header]
        }], footerFacet: [{
            type: ContentChild,
            args: [Footer]
        }], templates: [{
            type: ContentChildren,
            args: [PrimeTemplate]
        }] }); })();
    return Listbox;
}());
var ListboxModule = /** @class */ (function () {
    function ListboxModule() {
    }
ListboxModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: ListboxModule });
ListboxModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function ListboxModule_Factory(t) { return new (t || ListboxModule)(); }, imports: [[CommonModule, SharedModule],
        SharedModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(ListboxModule, { declarations: function () { return [Listbox]; }, imports: function () { return [CommonModule, SharedModule]; }, exports: function () { return [Listbox,
        SharedModule]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(ListboxModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule, SharedModule],
                exports: [Listbox, SharedModule],
                declarations: [Listbox]
            }]
    }], function () { return []; }, null); })();
    return ListboxModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { LISTBOX_VALUE_ACCESSOR, Listbox, ListboxModule };

//# sourceMappingURL=primeng-listbox.js.map