import { EventEmitter, ElementRef, NgZone, Input, Output, ContentChildren, ViewChild, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomSanitizer } from '@angular/platform-browser';
import { ButtonModule } from 'primeng/button';
import { MessagesModule } from 'primeng/messages';
import { ProgressBarModule } from 'primeng/progressbar';
import { DomHandler } from 'primeng/dom';
import { PrimeTemplate, SharedModule } from 'primeng/api';
import { HttpEventType, HttpClient } from '@angular/common/http';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/platform-browser';
import * as ɵngcc2 from '@angular/common/http';
import * as ɵngcc3 from '@angular/common';
import * as ɵngcc4 from 'primeng/button';
import * as ɵngcc5 from 'primeng/messages';
import * as ɵngcc6 from 'primeng/progressbar';

var _c0 = ["advancedfileinput"];
var _c1 = ["basicfileinput"];
var _c2 = ["content"];
function FileUpload_div_0_p_button_5_Template(rf, ctx) { if (rf & 1) {
    var _r11 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "p-button", 14);
    ɵngcc0.ɵɵlistener("onClick", function FileUpload_div_0_p_button_5_Template_p_button_onClick_0_listener() { ɵngcc0.ɵɵrestoreView(_r11); var ctx_r10 = ɵngcc0.ɵɵnextContext(2); return ctx_r10.upload(); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r3 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵproperty("label", ctx_r3.uploadLabel)("icon", ctx_r3.uploadIcon)("disabled", !ctx_r3.hasFiles() || ctx_r3.isFileLimitExceeded());
} }
function FileUpload_div_0_p_button_6_Template(rf, ctx) { if (rf & 1) {
    var _r13 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "p-button", 14);
    ɵngcc0.ɵɵlistener("onClick", function FileUpload_div_0_p_button_6_Template_p_button_onClick_0_listener() { ɵngcc0.ɵɵrestoreView(_r13); var ctx_r12 = ɵngcc0.ɵɵnextContext(2); return ctx_r12.clear(); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r4 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵproperty("label", ctx_r4.cancelLabel)("icon", ctx_r4.cancelIcon)("disabled", !ctx_r4.hasFiles() || ctx_r4.uploading);
} }
function FileUpload_div_0_ng_container_7_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementContainer(0);
} }
function FileUpload_div_0_p_progressBar_10_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "p-progressBar", 15);
} if (rf & 2) {
    var ctx_r7 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵproperty("value", ctx_r7.progress)("showValue", false);
} }
function FileUpload_div_0_div_12_div_1_div_1_img_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelement(0, "img", 22);
} if (rf & 2) {
    var file_r17 = ɵngcc0.ɵɵnextContext().$implicit;
    var ctx_r19 = ɵngcc0.ɵɵnextContext(4);
    ɵngcc0.ɵɵproperty("src", file_r17.objectURL, ɵngcc0.ɵɵsanitizeUrl)("width", ctx_r19.previewWidth);
} }
function FileUpload_div_0_div_12_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    var _r22 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "div", 19);
    ɵngcc0.ɵɵelementStart(1, "div");
    ɵngcc0.ɵɵtemplate(2, FileUpload_div_0_div_12_div_1_div_1_img_2_Template, 1, 2, "img", 20);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(3, "div");
    ɵngcc0.ɵɵtext(4);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(5, "div");
    ɵngcc0.ɵɵtext(6);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(7, "div");
    ɵngcc0.ɵɵelementStart(8, "button", 21);
    ɵngcc0.ɵɵlistener("click", function FileUpload_div_0_div_12_div_1_div_1_Template_button_click_8_listener($event) { ɵngcc0.ɵɵrestoreView(_r22); var i_r18 = ctx.index; var ctx_r21 = ɵngcc0.ɵɵnextContext(4); return ctx_r21.remove($event, i_r18); });
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var file_r17 = ctx.$implicit;
    var ctx_r16 = ɵngcc0.ɵɵnextContext(4);
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r16.isImage(file_r17));
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵtextInterpolate(file_r17.name);
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵtextInterpolate(ctx_r16.formatSize(file_r17.size));
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("disabled", ctx_r16.uploading);
} }
function FileUpload_div_0_div_12_div_1_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div");
    ɵngcc0.ɵɵtemplate(1, FileUpload_div_0_div_12_div_1_div_1_Template, 9, 4, "div", 18);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r14 = ɵngcc0.ɵɵnextContext(3);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngForOf", ctx_r14.files);
} }
function FileUpload_div_0_div_12_div_2_ng_template_1_Template(rf, ctx) { }
function FileUpload_div_0_div_12_div_2_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div");
    ɵngcc0.ɵɵtemplate(1, FileUpload_div_0_div_12_div_2_ng_template_1_Template, 0, 0, "ng-template", 23);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r15 = ɵngcc0.ɵɵnextContext(3);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngForOf", ctx_r15.files)("ngForTemplate", ctx_r15.fileTemplate);
} }
function FileUpload_div_0_div_12_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementStart(0, "div", 16);
    ɵngcc0.ɵɵtemplate(1, FileUpload_div_0_div_12_div_1_Template, 2, 1, "div", 17);
    ɵngcc0.ɵɵtemplate(2, FileUpload_div_0_div_12_div_2_Template, 2, 2, "div", 17);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r8 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", !ctx_r8.fileTemplate);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r8.fileTemplate);
} }
function FileUpload_div_0_ng_container_13_Template(rf, ctx) { if (rf & 1) {
    ɵngcc0.ɵɵelementContainer(0);
} }
var _c3 = function (a0, a1) { return { "ui-state-focus": a0, "ui-state-disabled": a1 }; };
var _c4 = function () { return { "ui-fileupload-content ui-widget-content ui-corner-bottom": true }; };
function FileUpload_div_0_Template(rf, ctx) { if (rf & 1) {
    var _r25 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "div", 2);
    ɵngcc0.ɵɵelementStart(1, "div", 3);
    ɵngcc0.ɵɵelementStart(2, "span", 4);
    ɵngcc0.ɵɵelementStart(3, "input", 5, 6);
    ɵngcc0.ɵɵlistener("change", function FileUpload_div_0_Template_input_change_3_listener($event) { ɵngcc0.ɵɵrestoreView(_r25); var ctx_r24 = ɵngcc0.ɵɵnextContext(); return ctx_r24.onFileSelect($event); })("focus", function FileUpload_div_0_Template_input_focus_3_listener() { ɵngcc0.ɵɵrestoreView(_r25); var ctx_r26 = ɵngcc0.ɵɵnextContext(); return ctx_r26.onFocus(); })("blur", function FileUpload_div_0_Template_input_blur_3_listener() { ɵngcc0.ɵɵrestoreView(_r25); var ctx_r27 = ɵngcc0.ɵɵnextContext(); return ctx_r27.onBlur(); });
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵtemplate(5, FileUpload_div_0_p_button_5_Template, 1, 3, "p-button", 7);
    ɵngcc0.ɵɵtemplate(6, FileUpload_div_0_p_button_6_Template, 1, 3, "p-button", 7);
    ɵngcc0.ɵɵtemplate(7, FileUpload_div_0_ng_container_7_Template, 1, 0, "ng-container", 8);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementStart(8, "div", 9, 10);
    ɵngcc0.ɵɵlistener("dragenter", function FileUpload_div_0_Template_div_dragenter_8_listener($event) { ɵngcc0.ɵɵrestoreView(_r25); var ctx_r28 = ɵngcc0.ɵɵnextContext(); return ctx_r28.onDragEnter($event); })("dragleave", function FileUpload_div_0_Template_div_dragleave_8_listener($event) { ɵngcc0.ɵɵrestoreView(_r25); var ctx_r29 = ɵngcc0.ɵɵnextContext(); return ctx_r29.onDragLeave($event); })("drop", function FileUpload_div_0_Template_div_drop_8_listener($event) { ɵngcc0.ɵɵrestoreView(_r25); var ctx_r30 = ɵngcc0.ɵɵnextContext(); return ctx_r30.onDrop($event); });
    ɵngcc0.ɵɵtemplate(10, FileUpload_div_0_p_progressBar_10_Template, 1, 2, "p-progressBar", 11);
    ɵngcc0.ɵɵelement(11, "p-messages", 12);
    ɵngcc0.ɵɵtemplate(12, FileUpload_div_0_div_12_Template, 3, 2, "div", 13);
    ɵngcc0.ɵɵtemplate(13, FileUpload_div_0_ng_container_13_Template, 1, 0, "ng-container", 8);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r0 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵclassMap(ctx_r0.styleClass);
    ɵngcc0.ɵɵproperty("ngClass", "ui-fileupload ui-widget")("ngStyle", ctx_r0.style);
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("label", ctx_r0.chooseLabel)("icon", ctx_r0.chooseIcon)("ngClass", ɵngcc0.ɵɵpureFunction2(20, _c3, ctx_r0.focus, ctx_r0.disabled || ctx_r0.isChooseDisabled()));
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("multiple", ctx_r0.multiple)("accept", ctx_r0.accept)("disabled", ctx_r0.disabled || ctx_r0.isChooseDisabled());
    ɵngcc0.ɵɵattribute("title", "");
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("ngIf", !ctx_r0.auto && ctx_r0.showUploadButton);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", !ctx_r0.auto && ctx_r0.showCancelButton);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngTemplateOutlet", ctx_r0.toolbarTemplate);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction0(23, _c4));
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r0.hasFiles());
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("value", ctx_r0.msgs)("enableService", false);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", ctx_r0.hasFiles());
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngTemplateOutlet", ctx_r0.contentTemplate);
} }
function FileUpload_span_1_input_4_Template(rf, ctx) { if (rf & 1) {
    var _r34 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "input", 28, 29);
    ɵngcc0.ɵɵlistener("change", function FileUpload_span_1_input_4_Template_input_change_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r34); var ctx_r33 = ɵngcc0.ɵɵnextContext(2); return ctx_r33.onFileSelect($event); })("focus", function FileUpload_span_1_input_4_Template_input_focus_0_listener() { ɵngcc0.ɵɵrestoreView(_r34); var ctx_r35 = ɵngcc0.ɵɵnextContext(2); return ctx_r35.onFocus(); })("blur", function FileUpload_span_1_input_4_Template_input_blur_0_listener() { ɵngcc0.ɵɵrestoreView(_r34); var ctx_r36 = ɵngcc0.ɵɵnextContext(2); return ctx_r36.onBlur(); });
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r31 = ɵngcc0.ɵɵnextContext(2);
    ɵngcc0.ɵɵproperty("accept", ctx_r31.accept)("multiple", ctx_r31.multiple)("disabled", ctx_r31.disabled);
} }
var _c5 = function (a1, a2, a3) { return { "ui-button ui-fileupload-choose ui-widget ui-state-default ui-corner-all ui-button-text-icon-left": true, "ui-fileupload-choose-selected": a1, "ui-state-focus": a2, "ui-state-disabled": a3 }; };
var _c6 = function (a0, a1) { return { "pi-plus": a0, "pi-upload": a1 }; };
function FileUpload_span_1_Template(rf, ctx) { if (rf & 1) {
    var _r38 = ɵngcc0.ɵɵgetCurrentView();
    ɵngcc0.ɵɵelementStart(0, "span", 24);
    ɵngcc0.ɵɵlistener("mouseup", function FileUpload_span_1_Template_span_mouseup_0_listener($event) { ɵngcc0.ɵɵrestoreView(_r38); var ctx_r37 = ɵngcc0.ɵɵnextContext(); return ctx_r37.onSimpleUploaderClick($event); });
    ɵngcc0.ɵɵelement(1, "span", 25);
    ɵngcc0.ɵɵelementStart(2, "span", 26);
    ɵngcc0.ɵɵtext(3);
    ɵngcc0.ɵɵelementEnd();
    ɵngcc0.ɵɵtemplate(4, FileUpload_span_1_input_4_Template, 2, 3, "input", 27);
    ɵngcc0.ɵɵelementEnd();
} if (rf & 2) {
    var ctx_r1 = ɵngcc0.ɵɵnextContext();
    ɵngcc0.ɵɵclassMap(ctx_r1.styleClass);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction3(7, _c5, ctx_r1.hasFiles(), ctx_r1.focus, ctx_r1.disabled))("ngStyle", ctx_r1.style);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction2(11, _c6, !ctx_r1.hasFiles() || ctx_r1.auto, ctx_r1.hasFiles() && !ctx_r1.auto));
    ɵngcc0.ɵɵadvance(2);
    ɵngcc0.ɵɵtextInterpolate(ctx_r1.auto ? ctx_r1.chooseLabel : ctx_r1.hasFiles() ? ctx_r1.files[0].name : ctx_r1.chooseLabel);
    ɵngcc0.ɵɵadvance(1);
    ɵngcc0.ɵɵproperty("ngIf", !ctx_r1.hasFiles());
} }
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var FileUpload = /** @class */ (function () {
    function FileUpload(el, sanitizer, zone, http) {
        this.el = el;
        this.sanitizer = sanitizer;
        this.zone = zone;
        this.http = http;
        this.method = 'POST';
        this.invalidFileSizeMessageSummary = '{0}: Invalid file size, ';
        this.invalidFileSizeMessageDetail = 'maximum upload size is {0}.';
        this.invalidFileTypeMessageSummary = '{0}: Invalid file type, ';
        this.invalidFileTypeMessageDetail = 'allowed file types: {0}.';
        this.invalidFileLimitMessageDetail = 'limit is {0} at most.';
        this.invalidFileLimitMessageSummary = 'Maximum number of files exceeded, ';
        this.previewWidth = 50;
        this.chooseLabel = 'Choose';
        this.uploadLabel = 'Upload';
        this.cancelLabel = 'Cancel';
        this.chooseIcon = 'pi pi-plus';
        this.uploadIcon = 'pi pi-upload';
        this.cancelIcon = 'pi pi-times';
        this.showUploadButton = true;
        this.showCancelButton = true;
        this.mode = 'advanced';
        this.onBeforeUpload = new EventEmitter();
        this.onSend = new EventEmitter();
        this.onUpload = new EventEmitter();
        this.onError = new EventEmitter();
        this.onClear = new EventEmitter();
        this.onRemove = new EventEmitter();
        this.onSelect = new EventEmitter();
        this.onProgress = new EventEmitter();
        this.uploadHandler = new EventEmitter();
        this._files = [];
        this.progress = 0;
        this.uploadedFileCount = 0;
    }
    Object.defineProperty(FileUpload.prototype, "files", {
        get: function () {
            return this._files;
        },
        set: function (files) {
            this._files = [];
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                if (this.validate(file)) {
                    if (this.isImage(file)) {
                        file.objectURL = this.sanitizer.bypassSecurityTrustUrl((window.URL.createObjectURL(files[i])));
                    }
                    this._files.push(files[i]);
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    FileUpload.prototype.ngAfterContentInit = function () {
        var _this = this;
        this.templates.forEach(function (item) {
            switch (item.getType()) {
                case 'file':
                    _this.fileTemplate = item.template;
                    break;
                case 'content':
                    _this.contentTemplate = item.template;
                    break;
                case 'toolbar':
                    _this.toolbarTemplate = item.template;
                    break;
                default:
                    _this.fileTemplate = item.template;
                    break;
            }
        });
    };
    FileUpload.prototype.ngAfterViewInit = function () {
        var _this = this;
        if (this.mode === 'advanced') {
            this.zone.runOutsideAngular(function () {
                if (_this.content)
                    _this.content.nativeElement.addEventListener('dragover', _this.onDragOver.bind(_this));
            });
        }
    };
    FileUpload.prototype.onFileSelect = function (event) {
        if (event.type !== 'drop' && this.isIE11() && this.duplicateIEEvent) {
            this.duplicateIEEvent = false;
            return;
        }
        this.msgs = [];
        if (!this.multiple) {
            this.files = [];
        }
        var files = event.dataTransfer ? event.dataTransfer.files : event.target.files;
        for (var i = 0; i < files.length; i++) {
            var file = files[i];
            if (!this.isFileSelected(file)) {
                if (this.validate(file)) {
                    if (this.isImage(file)) {
                        file.objectURL = this.sanitizer.bypassSecurityTrustUrl((window.URL.createObjectURL(files[i])));
                    }
                    this.files.push(files[i]);
                }
            }
        }
        this.onSelect.emit({ originalEvent: event, files: files, currentFiles: this.files });
        if (this.fileLimit && this.mode == "advanced") {
            this.checkFileLimit();
        }
        if (this.hasFiles() && this.auto && (!(this.mode === "advanced") || !this.isFileLimitExceeded())) {
            this.upload();
        }
        if (event.type !== 'drop' && this.isIE11()) {
            this.clearIEInput();
        }
        else {
            this.clearInputElement();
        }
    };
    FileUpload.prototype.isFileSelected = function (file) {
        var e_1, _a;
        try {
            for (var _b = __values(this.files), _c = _b.next(); !_c.done; _c = _b.next()) {
                var sFile = _c.value;
                if ((sFile.name + sFile.type + sFile.size) === (file.name + file.type + file.size)) {
                    return true;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return false;
    };
    FileUpload.prototype.isIE11 = function () {
        return !!window['MSInputMethodContext'] && !!document['documentMode'];
    };
    FileUpload.prototype.validate = function (file) {
        if (this.accept && !this.isFileTypeValid(file)) {
            this.msgs.push({
                severity: 'error',
                summary: this.invalidFileTypeMessageSummary.replace('{0}', file.name),
                detail: this.invalidFileTypeMessageDetail.replace('{0}', this.accept)
            });
            return false;
        }
        if (this.maxFileSize && file.size > this.maxFileSize) {
            this.msgs.push({
                severity: 'error',
                summary: this.invalidFileSizeMessageSummary.replace('{0}', file.name),
                detail: this.invalidFileSizeMessageDetail.replace('{0}', this.formatSize(this.maxFileSize))
            });
            return false;
        }
        return true;
    };
    FileUpload.prototype.isFileTypeValid = function (file) {
        var e_2, _a;
        var acceptableTypes = this.accept.split(',').map(function (type) { return type.trim(); });
        try {
            for (var acceptableTypes_1 = __values(acceptableTypes), acceptableTypes_1_1 = acceptableTypes_1.next(); !acceptableTypes_1_1.done; acceptableTypes_1_1 = acceptableTypes_1.next()) {
                var type = acceptableTypes_1_1.value;
                var acceptable = this.isWildcard(type) ? this.getTypeClass(file.type) === this.getTypeClass(type)
                    : file.type == type || this.getFileExtension(file).toLowerCase() === type.toLowerCase();
                if (acceptable) {
                    return true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (acceptableTypes_1_1 && !acceptableTypes_1_1.done && (_a = acceptableTypes_1.return)) _a.call(acceptableTypes_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return false;
    };
    FileUpload.prototype.getTypeClass = function (fileType) {
        return fileType.substring(0, fileType.indexOf('/'));
    };
    FileUpload.prototype.isWildcard = function (fileType) {
        return fileType.indexOf('*') !== -1;
    };
    FileUpload.prototype.getFileExtension = function (file) {
        return '.' + file.name.split('.').pop();
    };
    FileUpload.prototype.isImage = function (file) {
        return /^image\//.test(file.type);
    };
    FileUpload.prototype.onImageLoad = function (img) {
        window.URL.revokeObjectURL(img.src);
    };
    FileUpload.prototype.upload = function () {
        var _this = this;
        if (this.customUpload) {
            if (this.fileLimit) {
                this.uploadedFileCount += this.files.length;
            }
            this.uploadHandler.emit({
                files: this.files
            });
        }
        else {
            this.uploading = true;
            this.msgs = [];
            var formData_1 = new FormData();
            this.onBeforeUpload.emit({
                'formData': formData_1
            });
            for (var i = 0; i < this.files.length; i++) {
                formData_1.append(this.name, this.files[i], this.files[i].name);
            }
            this.http.post(this.url, formData_1, {
                headers: this.headers, reportProgress: true, observe: 'events', withCredentials: this.withCredentials
            }).subscribe(function (event) {
                switch (event.type) {
                    case HttpEventType.Sent:
                        _this.onSend.emit({
                            originalEvent: event,
                            'formData': formData_1
                        });
                        break;
                    case HttpEventType.Response:
                        _this.uploading = false;
                        _this.progress = 0;
                        if (event['status'] >= 200 && event['status'] < 300) {
                            if (_this.fileLimit) {
                                _this.uploadedFileCount += _this.files.length;
                            }
                            _this.onUpload.emit({ originalEvent: event, files: _this.files });
                        }
                        else {
                            _this.onError.emit({ files: _this.files });
                        }
                        _this.clear();
                        break;
                    case HttpEventType.UploadProgress: {
                        if (event['loaded']) {
                            _this.progress = Math.round((event['loaded'] * 100) / event['total']);
                        }
                        _this.onProgress.emit({ originalEvent: event, progress: _this.progress });
                        break;
                    }
                }
            }, function (error) {
                _this.uploading = false;
                _this.onError.emit({ files: _this.files, error: error });
            });
        }
    };
    FileUpload.prototype.clear = function () {
        this.files = [];
        this.onClear.emit();
        this.clearInputElement();
    };
    FileUpload.prototype.remove = function (event, index) {
        this.clearInputElement();
        this.onRemove.emit({ originalEvent: event, file: this.files[index] });
        this.files.splice(index, 1);
    };
    FileUpload.prototype.isFileLimitExceeded = function () {
        if (this.fileLimit && this.fileLimit <= this.files.length + this.uploadedFileCount && this.focus) {
            this.focus = false;
        }
        return this.fileLimit && this.fileLimit < this.files.length + this.uploadedFileCount;
    };
    FileUpload.prototype.isChooseDisabled = function () {
        return this.fileLimit && this.fileLimit <= this.files.length + this.uploadedFileCount;
    };
    FileUpload.prototype.checkFileLimit = function () {
        if (this.isFileLimitExceeded()) {
            this.msgs.push({
                severity: 'error',
                summary: this.invalidFileLimitMessageSummary.replace('{0}', this.fileLimit.toString()),
                detail: this.invalidFileLimitMessageDetail.replace('{0}', this.fileLimit.toString())
            });
        }
    };
    FileUpload.prototype.clearInputElement = function () {
        if (this.advancedFileInput && this.advancedFileInput.nativeElement) {
            this.advancedFileInput.nativeElement.value = '';
        }
        if (this.basicFileInput && this.basicFileInput.nativeElement) {
            this.basicFileInput.nativeElement.value = '';
        }
    };
    FileUpload.prototype.clearIEInput = function () {
        if (this.advancedFileInput && this.advancedFileInput.nativeElement) {
            this.duplicateIEEvent = true; //IE11 fix to prevent onFileChange trigger again
            this.advancedFileInput.nativeElement.value = '';
        }
    };
    FileUpload.prototype.hasFiles = function () {
        return this.files && this.files.length > 0;
    };
    FileUpload.prototype.onDragEnter = function (e) {
        if (!this.disabled) {
            e.stopPropagation();
            e.preventDefault();
        }
    };
    FileUpload.prototype.onDragOver = function (e) {
        if (!this.disabled) {
            DomHandler.addClass(this.content.nativeElement, 'ui-fileupload-highlight');
            this.dragHighlight = true;
            e.stopPropagation();
            e.preventDefault();
        }
    };
    FileUpload.prototype.onDragLeave = function (event) {
        if (!this.disabled) {
            DomHandler.removeClass(this.content.nativeElement, 'ui-fileupload-highlight');
        }
    };
    FileUpload.prototype.onDrop = function (event) {
        if (!this.disabled) {
            DomHandler.removeClass(this.content.nativeElement, 'ui-fileupload-highlight');
            event.stopPropagation();
            event.preventDefault();
            var files = event.dataTransfer ? event.dataTransfer.files : event.target.files;
            var allowDrop = this.multiple || (files && files.length === 1);
            if (allowDrop) {
                this.onFileSelect(event);
            }
        }
    };
    FileUpload.prototype.onFocus = function () {
        this.focus = true;
    };
    FileUpload.prototype.onBlur = function () {
        this.focus = false;
    };
    FileUpload.prototype.formatSize = function (bytes) {
        if (bytes == 0) {
            return '0 B';
        }
        var k = 1024, dm = 3, sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'], i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
    };
    FileUpload.prototype.onSimpleUploaderClick = function (event) {
        if (this.hasFiles()) {
            this.upload();
        }
    };
    FileUpload.prototype.getBlockableElement = function () {
        return this.el.nativeElement.children[0];
    };
    FileUpload.prototype.ngOnDestroy = function () {
        if (this.content && this.content.nativeElement) {
            this.content.nativeElement.removeEventListener('dragover', this.onDragOver);
        }
    };
    FileUpload.ctorParameters = function () { return [
        { type: ElementRef },
        { type: DomSanitizer },
        { type: NgZone },
        { type: HttpClient }
    ]; };
    __decorate([
        Input()
    ], FileUpload.prototype, "name", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "url", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "method", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "multiple", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "accept", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "disabled", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "auto", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "withCredentials", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "maxFileSize", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "invalidFileSizeMessageSummary", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "invalidFileSizeMessageDetail", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "invalidFileTypeMessageSummary", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "invalidFileTypeMessageDetail", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "invalidFileLimitMessageDetail", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "invalidFileLimitMessageSummary", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "style", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "styleClass", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "previewWidth", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "chooseLabel", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "uploadLabel", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "cancelLabel", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "chooseIcon", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "uploadIcon", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "cancelIcon", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "showUploadButton", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "showCancelButton", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "mode", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "headers", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "customUpload", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "fileLimit", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onBeforeUpload", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onSend", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onUpload", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onError", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onClear", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onRemove", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onSelect", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "onProgress", void 0);
    __decorate([
        Output()
    ], FileUpload.prototype, "uploadHandler", void 0);
    __decorate([
        ContentChildren(PrimeTemplate)
    ], FileUpload.prototype, "templates", void 0);
    __decorate([
        ViewChild('advancedfileinput')
    ], FileUpload.prototype, "advancedFileInput", void 0);
    __decorate([
        ViewChild('basicfileinput')
    ], FileUpload.prototype, "basicFileInput", void 0);
    __decorate([
        ViewChild('content')
    ], FileUpload.prototype, "content", void 0);
    __decorate([
        Input()
    ], FileUpload.prototype, "files", null);
FileUpload.ɵfac = function FileUpload_Factory(t) { return new (t || FileUpload)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef), ɵngcc0.ɵɵdirectiveInject(ɵngcc1.DomSanitizer), ɵngcc0.ɵɵdirectiveInject(ɵngcc0.NgZone), ɵngcc0.ɵɵdirectiveInject(ɵngcc2.HttpClient)); };
FileUpload.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: FileUpload, selectors: [["p-fileUpload"]], contentQueries: function FileUpload_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        ɵngcc0.ɵɵcontentQuery(dirIndex, PrimeTemplate, false);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.templates = _t);
    } }, viewQuery: function FileUpload_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
        ɵngcc0.ɵɵviewQuery(_c1, true);
        ɵngcc0.ɵɵviewQuery(_c2, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.advancedFileInput = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.basicFileInput = _t.first);
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.content = _t.first);
    } }, inputs: { method: "method", invalidFileSizeMessageSummary: "invalidFileSizeMessageSummary", invalidFileSizeMessageDetail: "invalidFileSizeMessageDetail", invalidFileTypeMessageSummary: "invalidFileTypeMessageSummary", invalidFileTypeMessageDetail: "invalidFileTypeMessageDetail", invalidFileLimitMessageDetail: "invalidFileLimitMessageDetail", invalidFileLimitMessageSummary: "invalidFileLimitMessageSummary", previewWidth: "previewWidth", chooseLabel: "chooseLabel", uploadLabel: "uploadLabel", cancelLabel: "cancelLabel", chooseIcon: "chooseIcon", uploadIcon: "uploadIcon", cancelIcon: "cancelIcon", showUploadButton: "showUploadButton", showCancelButton: "showCancelButton", mode: "mode", files: "files", name: "name", url: "url", multiple: "multiple", accept: "accept", disabled: "disabled", auto: "auto", withCredentials: "withCredentials", maxFileSize: "maxFileSize", style: "style", styleClass: "styleClass", headers: "headers", customUpload: "customUpload", fileLimit: "fileLimit" }, outputs: { onBeforeUpload: "onBeforeUpload", onSend: "onSend", onUpload: "onUpload", onError: "onError", onClear: "onClear", onRemove: "onRemove", onSelect: "onSelect", onProgress: "onProgress", uploadHandler: "uploadHandler" }, decls: 2, vars: 2, consts: [[3, "ngClass", "ngStyle", "class", 4, "ngIf"], [3, "ngClass", "ngStyle", "class", "mouseup", 4, "ngIf"], [3, "ngClass", "ngStyle"], [1, "ui-fileupload-buttonbar", "ui-widget-header", "ui-corner-top"], ["pButton", "", 1, "ui-fileupload-choose", 3, "label", "icon", "ngClass"], ["type", "file", 3, "multiple", "accept", "disabled", "change", "focus", "blur"], ["advancedfileinput", ""], ["type", "button", 3, "label", "icon", "disabled", "onClick", 4, "ngIf"], [4, "ngTemplateOutlet"], [3, "ngClass", "dragenter", "dragleave", "drop"], ["content", ""], [3, "value", "showValue", 4, "ngIf"], [3, "value", "enableService"], ["class", "ui-fileupload-files", 4, "ngIf"], ["type", "button", 3, "label", "icon", "disabled", "onClick"], [3, "value", "showValue"], [1, "ui-fileupload-files"], [4, "ngIf"], ["class", "ui-fileupload-row", 4, "ngFor", "ngForOf"], [1, "ui-fileupload-row"], [3, "src", "width", 4, "ngIf"], ["type", "button", "icon", "pi pi-times", "pButton", "", 3, "disabled", "click"], [3, "src", "width"], ["ngFor", "", 3, "ngForOf", "ngForTemplate"], [3, "ngClass", "ngStyle", "mouseup"], [1, "ui-button-icon-left", "pi", 3, "ngClass"], [1, "ui-button-text", "ui-clickable"], ["type", "file", 3, "accept", "multiple", "disabled", "change", "focus", "blur", 4, "ngIf"], ["type", "file", 3, "accept", "multiple", "disabled", "change", "focus", "blur"], ["basicfileinput", ""]], template: function FileUpload_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵtemplate(0, FileUpload_div_0_Template, 14, 24, "div", 0);
        ɵngcc0.ɵɵtemplate(1, FileUpload_span_1_Template, 5, 14, "span", 1);
    } if (rf & 2) {
        ɵngcc0.ɵɵproperty("ngIf", ctx.mode === "advanced");
        ɵngcc0.ɵɵadvance(1);
        ɵngcc0.ɵɵproperty("ngIf", ctx.mode === "basic");
    } }, directives: [ɵngcc3.NgIf, ɵngcc3.NgClass, ɵngcc3.NgStyle, ɵngcc4.ButtonDirective, ɵngcc3.NgTemplateOutlet, ɵngcc5.Messages, ɵngcc4.Button, ɵngcc6.ProgressBar, ɵngcc3.NgForOf], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(FileUpload, [{
        type: Component,
        args: [{
                selector: 'p-fileUpload',
                template: "\n        <div [ngClass]=\"'ui-fileupload ui-widget'\" [ngStyle]=\"style\" [class]=\"styleClass\" *ngIf=\"mode === 'advanced'\">\n            <div class=\"ui-fileupload-buttonbar ui-widget-header ui-corner-top\">\n                <span class=\"ui-fileupload-choose\" [label]=\"chooseLabel\" [icon]=\"chooseIcon\" pButton [ngClass]=\"{'ui-state-focus': focus, 'ui-state-disabled':disabled || isChooseDisabled()}\"> \n                    <input #advancedfileinput type=\"file\" (change)=\"onFileSelect($event)\" [multiple]=\"multiple\" [accept]=\"accept\" [disabled]=\"disabled || isChooseDisabled()\" \n                        (focus)=\"onFocus()\" (blur)=\"onBlur()\" [attr.title]=\"''\">\n                </span>\n\n                <p-button *ngIf=\"!auto&&showUploadButton\" type=\"button\" [label]=\"uploadLabel\" [icon]=\"uploadIcon\" (onClick)=\"upload()\" [disabled]=\"!hasFiles() || isFileLimitExceeded()\"></p-button>\n                <p-button *ngIf=\"!auto&&showCancelButton\" type=\"button\" [label]=\"cancelLabel\" [icon]=\"cancelIcon\" (onClick)=\"clear()\" [disabled]=\"!hasFiles() ||\u00A0uploading\"></p-button>\n\n                <ng-container *ngTemplateOutlet=\"toolbarTemplate\"></ng-container>\n            </div>\n            <div #content [ngClass]=\"{'ui-fileupload-content ui-widget-content ui-corner-bottom':true}\"\n                 (dragenter)=\"onDragEnter($event)\" (dragleave)=\"onDragLeave($event)\" (drop)=\"onDrop($event)\">\n                <p-progressBar [value]=\"progress\" [showValue]=\"false\" *ngIf=\"hasFiles()\"></p-progressBar>\n\n                <p-messages [value]=\"msgs\" [enableService]=\"false\"></p-messages>\n\n                <div class=\"ui-fileupload-files\" *ngIf=\"hasFiles()\">\n                    <div *ngIf=\"!fileTemplate\">\n                        <div class=\"ui-fileupload-row\" *ngFor=\"let file of files; let i = index;\">\n                            <div><img [src]=\"file.objectURL\" *ngIf=\"isImage(file)\" [width]=\"previewWidth\" /></div>\n                            <div>{{file.name}}</div>\n                            <div>{{formatSize(file.size)}}</div>\n                            <div>\n                                <button type=\"button\" icon=\"pi pi-times\" pButton (click)=\"remove($event,i)\" [disabled]=\"uploading\"></button>\n                            </div>\n                        </div>\n                    </div>\n                    <div *ngIf=\"fileTemplate\">\n                        <ng-template ngFor [ngForOf]=\"files\" [ngForTemplate]=\"fileTemplate\"></ng-template>\n                    </div>\n                </div>\n                <ng-container *ngTemplateOutlet=\"contentTemplate\"></ng-container>\n            </div>\n        </div>\n        <span *ngIf=\"mode === 'basic'\" [ngClass]=\"{'ui-button ui-fileupload-choose ui-widget ui-state-default ui-corner-all ui-button-text-icon-left': true, \n                'ui-fileupload-choose-selected': hasFiles(),'ui-state-focus': focus, 'ui-state-disabled':disabled}\"\n              [ngStyle]=\"style\" [class]=\"styleClass\" (mouseup)=\"onSimpleUploaderClick($event)\">\n            <span class=\"ui-button-icon-left pi\" [ngClass]=\"{'pi-plus': !hasFiles()||auto, 'pi-upload': hasFiles()&&!auto}\"></span>\n            <span class=\"ui-button-text ui-clickable\">{{auto ? chooseLabel : hasFiles() ? files[0].name : chooseLabel}}</span>\n            <input #basicfileinput type=\"file\" [accept]=\"accept\" [multiple]=\"multiple\" [disabled]=\"disabled\"\n                   (change)=\"onFileSelect($event)\" *ngIf=\"!hasFiles()\" (focus)=\"onFocus()\" (blur)=\"onBlur()\">\n        </span>\n    ",
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }, { type: ɵngcc1.DomSanitizer }, { type: ɵngcc0.NgZone }, { type: ɵngcc2.HttpClient }]; }, { method: [{
            type: Input
        }], invalidFileSizeMessageSummary: [{
            type: Input
        }], invalidFileSizeMessageDetail: [{
            type: Input
        }], invalidFileTypeMessageSummary: [{
            type: Input
        }], invalidFileTypeMessageDetail: [{
            type: Input
        }], invalidFileLimitMessageDetail: [{
            type: Input
        }], invalidFileLimitMessageSummary: [{
            type: Input
        }], previewWidth: [{
            type: Input
        }], chooseLabel: [{
            type: Input
        }], uploadLabel: [{
            type: Input
        }], cancelLabel: [{
            type: Input
        }], chooseIcon: [{
            type: Input
        }], uploadIcon: [{
            type: Input
        }], cancelIcon: [{
            type: Input
        }], showUploadButton: [{
            type: Input
        }], showCancelButton: [{
            type: Input
        }], mode: [{
            type: Input
        }], onBeforeUpload: [{
            type: Output
        }], onSend: [{
            type: Output
        }], onUpload: [{
            type: Output
        }], onError: [{
            type: Output
        }], onClear: [{
            type: Output
        }], onRemove: [{
            type: Output
        }], onSelect: [{
            type: Output
        }], onProgress: [{
            type: Output
        }], uploadHandler: [{
            type: Output
        }], files: [{
            type: Input
        }], name: [{
            type: Input
        }], url: [{
            type: Input
        }], multiple: [{
            type: Input
        }], accept: [{
            type: Input
        }], disabled: [{
            type: Input
        }], auto: [{
            type: Input
        }], withCredentials: [{
            type: Input
        }], maxFileSize: [{
            type: Input
        }], style: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], headers: [{
            type: Input
        }], customUpload: [{
            type: Input
        }], fileLimit: [{
            type: Input
        }], templates: [{
            type: ContentChildren,
            args: [PrimeTemplate]
        }], advancedFileInput: [{
            type: ViewChild,
            args: ['advancedfileinput']
        }], basicFileInput: [{
            type: ViewChild,
            args: ['basicfileinput']
        }], content: [{
            type: ViewChild,
            args: ['content']
        }] }); })();
    return FileUpload;
}());
var FileUploadModule = /** @class */ (function () {
    function FileUploadModule() {
    }
FileUploadModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: FileUploadModule });
FileUploadModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function FileUploadModule_Factory(t) { return new (t || FileUploadModule)(); }, imports: [[CommonModule, SharedModule, ButtonModule, ProgressBarModule, MessagesModule],
        SharedModule, ButtonModule, ProgressBarModule, MessagesModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(FileUploadModule, { declarations: function () { return [FileUpload]; }, imports: function () { return [CommonModule, SharedModule, ButtonModule, ProgressBarModule, MessagesModule]; }, exports: function () { return [FileUpload,
        SharedModule, ButtonModule, ProgressBarModule, MessagesModule]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(FileUploadModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule, SharedModule, ButtonModule, ProgressBarModule, MessagesModule],
                exports: [FileUpload, SharedModule, ButtonModule, ProgressBarModule, MessagesModule],
                declarations: [FileUpload]
            }]
    }], function () { return []; }, null); })();
    return FileUploadModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { FileUpload, FileUploadModule };

//# sourceMappingURL=primeng-fileupload.js.map