import { ElementRef, Input, ViewChild, Component, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomHandler } from 'primeng/dom';

import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/common';

var _c0 = ["mask"];
var _c1 = function (a0) { return { "ui-blockui-document": a0, "ui-blockui ui-widget-overlay": true }; };
var _c2 = function (a0) { return { display: a0 }; };
var _c3 = ["*"];
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var BlockUI = /** @class */ (function () {
    function BlockUI(el) {
        this.el = el;
        this.autoZIndex = true;
        this.baseZIndex = 0;
    }
    Object.defineProperty(BlockUI.prototype, "blocked", {
        get: function () {
            return this._blocked;
        },
        set: function (val) {
            this._blocked = val;
            if (this.mask && this.mask.nativeElement) {
                if (this._blocked)
                    this.block();
                else
                    this.unblock();
            }
        },
        enumerable: true,
        configurable: true
    });
    BlockUI.prototype.ngAfterViewInit = function () {
        if (this.target && !this.target.getBlockableElement) {
            throw 'Target of BlockUI must implement BlockableUI interface';
        }
    };
    BlockUI.prototype.block = function () {
        if (this.target) {
            this.target.getBlockableElement().appendChild(this.mask.nativeElement);
            var style = this.target.style || {};
            style.position = 'relative';
            this.target.style = style;
        }
        else {
            document.body.appendChild(this.mask.nativeElement);
        }
        if (this.autoZIndex) {
            this.mask.nativeElement.style.zIndex = String(this.baseZIndex + (++DomHandler.zindex));
        }
    };
    BlockUI.prototype.unblock = function () {
        this.el.nativeElement.appendChild(this.mask.nativeElement);
    };
    BlockUI.prototype.ngOnDestroy = function () {
        this.unblock();
    };
    BlockUI.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        Input()
    ], BlockUI.prototype, "target", void 0);
    __decorate([
        Input()
    ], BlockUI.prototype, "autoZIndex", void 0);
    __decorate([
        Input()
    ], BlockUI.prototype, "baseZIndex", void 0);
    __decorate([
        Input()
    ], BlockUI.prototype, "styleClass", void 0);
    __decorate([
        ViewChild('mask')
    ], BlockUI.prototype, "mask", void 0);
    __decorate([
        Input()
    ], BlockUI.prototype, "blocked", null);
BlockUI.ɵfac = function BlockUI_Factory(t) { return new (t || BlockUI)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef)); };
BlockUI.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: BlockUI, selectors: [["p-blockUI"]], viewQuery: function BlockUI_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.mask = _t.first);
    } }, inputs: { autoZIndex: "autoZIndex", baseZIndex: "baseZIndex", blocked: "blocked", target: "target", styleClass: "styleClass" }, ngContentSelectors: _c3, decls: 3, vars: 8, consts: [[3, "ngClass", "ngStyle"], ["mask", ""]], template: function BlockUI_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵprojectionDef();
        ɵngcc0.ɵɵelementStart(0, "div", 0, 1);
        ɵngcc0.ɵɵprojection(2);
        ɵngcc0.ɵɵelementEnd();
    } if (rf & 2) {
        ɵngcc0.ɵɵclassMap(ctx.styleClass);
        ɵngcc0.ɵɵproperty("ngClass", ɵngcc0.ɵɵpureFunction1(4, _c1, !ctx.target))("ngStyle", ɵngcc0.ɵɵpureFunction1(6, _c2, ctx.blocked ? "block" : "none"));
    } }, directives: [ɵngcc1.NgClass, ɵngcc1.NgStyle], encapsulation: 2 });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(BlockUI, [{
        type: Component,
        args: [{
                selector: 'p-blockUI',
                template: "\n        <div #mask [class]=\"styleClass\" [ngClass]=\"{'ui-blockui-document':!target, 'ui-blockui ui-widget-overlay': true}\" [ngStyle]=\"{display: blocked ? 'block' : 'none'}\">\n            <ng-content></ng-content>\n        </div>\n    ",
                changeDetection: ChangeDetectionStrategy.Default
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }]; }, { autoZIndex: [{
            type: Input
        }], baseZIndex: [{
            type: Input
        }], blocked: [{
            type: Input
        }], target: [{
            type: Input
        }], styleClass: [{
            type: Input
        }], mask: [{
            type: ViewChild,
            args: ['mask']
        }] }); })();
    return BlockUI;
}());
var BlockUIModule = /** @class */ (function () {
    function BlockUIModule() {
    }
BlockUIModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: BlockUIModule });
BlockUIModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function BlockUIModule_Factory(t) { return new (t || BlockUIModule)(); }, imports: [[CommonModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(BlockUIModule, { declarations: function () { return [BlockUI]; }, imports: function () { return [CommonModule]; }, exports: function () { return [BlockUI]; } }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(BlockUIModule, [{
        type: NgModule,
        args: [{
                imports: [CommonModule],
                exports: [BlockUI],
                declarations: [BlockUI]
            }]
    }], function () { return []; }, null); })();
    return BlockUIModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { BlockUI, BlockUIModule };

//# sourceMappingURL=primeng-blockui.js.map