/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ViewChild, Output, EventEmitter } from '@angular/core';
var PdfZoomDropdownComponent = /** @class */ (function () {
    function PdfZoomDropdownComponent() {
        this.zoomChange = new EventEmitter();
    }
    /**
     * @return {?}
     */
    PdfZoomDropdownComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    /**
     * @return {?}
     */
    PdfZoomDropdownComponent.prototype.emitZoomChange = /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var selectedIndex = this.sizeSelector.nativeElement.selectedIndex;
        if (selectedIndex || selectedIndex === 0) {
            /** @type {?} */
            var s = (/** @type {?} */ (this.sizeSelector.nativeElement.options[selectedIndex]));
            /** @type {?} */
            var value = s.label;
            if (value.endsWith('%')) {
                value = Number(value.replace('%', ''));
            }
            else {
                value = s.value;
            }
            this.zoomChange.emit(value);
        }
    };
    PdfZoomDropdownComponent.decorators = [
        { type: Component, args: [{
                    selector: 'pdf-zoom-dropdown',
                    template: "<span id=\"scaleSelectContainer\" class=\"dropdownToolbarButton\">\n  <select\n    id=\"scaleSelect\"\n    title=\"Zoom\"\n    data-l10n-id=\"zoom\"\n    #sizeSelector\n  >\n    <option\n      id=\"pageAutoOption\"\n      title=\"\"\n      value=\"auto\"\n      selected=\"selected\"\n      data-l10n-id=\"page_scale_auto\"\n      >Automatic Zoom</option\n    >\n    <option\n      id=\"pageActualOption\"\n      title=\"\"\n      value=\"page-actual\"\n      data-l10n-id=\"page_scale_actual\"\n      >Actual Size</option\n    >\n    <option\n      id=\"pageFitOption\"\n      title=\"\"\n      value=\"page-fit\"\n      data-l10n-id=\"page_scale_fit\"\n      >Page Fit</option\n    >\n    <option\n      id=\"pageWidthOption\"\n      title=\"\"\n      value=\"page-width\"\n      data-l10n-id=\"page_scale_width\"\n      >Page Width</option\n    >\n    <option\n      id=\"customScaleOption\"\n      title=\"\"\n      value=\"custom\"\n      disabled=\"disabled\"\n      hidden=\"true\"\n    ></option>\n    <option\n      title=\"\"\n      value=\"0.5\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 50 }\"\n      >50%</option\n    >\n    <option\n      title=\"\"\n      value=\"0.75\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 75 }\"\n      >75%</option\n    >\n    <option\n      title=\"\"\n      value=\"1\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 100 }\"\n      >100%</option\n    >\n    <option\n      title=\"\"\n      value=\"1.25\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 125 }\"\n      >125%</option\n    >\n    <option\n      title=\"\"\n      value=\"1.5\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 150 }\"\n      >150%</option\n    >\n    <option\n      title=\"\"\n      value=\"2\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 200 }\"\n      >200%</option\n    >\n    <option\n      title=\"\"\n      value=\"3\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 300 }\"\n      >300%</option\n    >\n    <option\n      title=\"\"\n      value=\"4\"\n      data-l10n-id=\"page_scale_percent\"\n      data-l10n-args=\"{ &quot;scale&quot;: 400 }\"\n      >400%</option\n    >\n  </select>\n</span>\n",
                    styles: [".dropdownToolbarButton{display:table-cell;-webkit-appearance:none;width:150px;max-width:150px}.dropdownToolbarButton>select{width:170px}@media screen and (-webkit-min-device-pixel-ratio:1.1),screen and (min-resolution:1.1dppx){.dropdownToolbarButton::after{top:-1px}}"]
                }] }
    ];
    /** @nocollapse */
    PdfZoomDropdownComponent.ctorParameters = function () { return []; };
    PdfZoomDropdownComponent.propDecorators = {
        sizeSelector: [{ type: ViewChild, args: ['sizeSelector',] }],
        zoomChange: [{ type: Output }]
    };
    return PdfZoomDropdownComponent;
}());
export { PdfZoomDropdownComponent };
if (false) {
    /** @type {?} */
    PdfZoomDropdownComponent.prototype.sizeSelector;
    /** @type {?} */
    PdfZoomDropdownComponent.prototype.zoomChange;
}
//# sourceMappingURL=data:application/json;base64,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