/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
export class PdfFindButtonComponent {
    constructor() {
        this.showFindButton = undefined;
        this.textLayer = undefined;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
PdfFindButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'pdf-find-button',
                template: "<button\n  type=\"button\"\n  [class.invisible]=\"!showFindButton || !textLayer\"\n  id=\"viewFind\"\n  class=\"toolbarButton\"\n  title=\"Find in Document\"\n  data-l10n-id=\"findbar\"\n>\n  <svg style=\"width:24px;height:24px\" viewBox=\"0 0 24 24\">\n    <path fill=\"currentColor\" d=\"M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z\" />\n  </svg>\n  <span data-l10n-id=\"findbar_label\">Find</span>\n</button>\n",
                styles: ["button svg{margin-top:-2px}:host:focus{outline:0}button:focus,svg:focus{outline:0}"]
            }] }
];
/** @nocollapse */
PdfFindButtonComponent.ctorParameters = () => [];
PdfFindButtonComponent.propDecorators = {
    showFindButton: [{ type: Input }],
    textLayer: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    PdfFindButtonComponent.prototype.showFindButton;
    /** @type {?} */
    PdfFindButtonComponent.prototype.textLayer;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGRmLWZpbmQtYnV0dG9uLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL25neC1leHRlbmRlZC1wZGYtdmlld2VyLyIsInNvdXJjZXMiOlsibGliL3Rvb2xiYXIvcGRmLWZpbmQtYnV0dG9uL3BkZi1maW5kLWJ1dHRvbi5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQVUsS0FBSyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBT3pELE1BQU0sT0FBTyxzQkFBc0I7SUFPakM7UUFMTyxtQkFBYyxHQUF3QixTQUFTLENBQUM7UUFHaEQsY0FBUyxHQUF3QixTQUFTLENBQUM7SUFFbEMsQ0FBQzs7OztJQUVqQixRQUFRO0lBQ1IsQ0FBQzs7O1lBZkYsU0FBUyxTQUFDO2dCQUNULFFBQVEsRUFBRSxpQkFBaUI7Z0JBQzNCLCtuQkFBK0M7O2FBRWhEOzs7Ozs2QkFFRSxLQUFLO3dCQUdMLEtBQUs7Ozs7SUFITixnREFDdUQ7O0lBRXZELDJDQUNrRCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgT25Jbml0LCBJbnB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdwZGYtZmluZC1idXR0b24nLFxuICB0ZW1wbGF0ZVVybDogJy4vcGRmLWZpbmQtYnV0dG9uLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vcGRmLWZpbmQtYnV0dG9uLmNvbXBvbmVudC5jc3MnXVxufSlcbmV4cG9ydCBjbGFzcyBQZGZGaW5kQnV0dG9uQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcbiAgQElucHV0KClcbiAgcHVibGljIHNob3dGaW5kQnV0dG9uOiBib29sZWFuIHwgdW5kZWZpbmVkID0gdW5kZWZpbmVkO1xuXG4gIEBJbnB1dCgpXG4gIHB1YmxpYyB0ZXh0TGF5ZXI6IGJvb2xlYW4gfCB1bmRlZmluZWQgPSB1bmRlZmluZWQ7XG5cbiAgY29uc3RydWN0b3IoKSB7IH1cblxuICBuZ09uSW5pdCgpIHtcbiAgfVxuXG59XG4iXX0=