/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Input, Output, EventEmitter, HostBinding, HostListener } from '@angular/core';
import { coerceBooleanProperty } from '../helpers';
import { DomSanitizer } from '@angular/platform-browser';
/** @enum {number} */
var KEY_CODE = {
    BACKSPACE: 8,
    DELETE: 46,
};
KEY_CODE[KEY_CODE.BACKSPACE] = 'BACKSPACE';
KEY_CODE[KEY_CODE.DELETE] = 'DELETE';
var NgxDropzonePreviewComponent = /** @class */ (function () {
    function NgxDropzonePreviewComponent(sanitizer) {
        this.sanitizer = sanitizer;
        this._removable = false;
        /**
         * Emitted when the element should be removed.
         */
        this.removed = new EventEmitter();
        /**
         * Make the preview item focusable using the tab key.
         */
        this.tabIndex = 0;
    }
    Object.defineProperty(NgxDropzonePreviewComponent.prototype, "removable", {
        /** Allow the user to remove files. */
        get: /**
         * Allow the user to remove files.
         * @return {?}
         */
        function () {
            return this._removable;
        },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._removable = coerceBooleanProperty(value);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @param {?} event
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype.keyEvent = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        switch (event.keyCode) {
            case KEY_CODE.BACKSPACE:
            case KEY_CODE.DELETE:
                this.remove();
                break;
            default:
                break;
        }
    };
    Object.defineProperty(NgxDropzonePreviewComponent.prototype, "hostStyle", {
        /** We use the HostBinding to pass these common styles to child components. */
        get: /**
         * We use the HostBinding to pass these common styles to child components.
         * @return {?}
         */
        function () {
            /** @type {?} */
            var styles = "\n\t\t\tdisplay: flex;\n\t\t\theight: 140px;\n\t\t\tmin-height: 140px;\n\t\t\tmin-width: 180px;\n\t\t\tmax-width: 180px;\n\t\t\tjustify-content: center;\n\t\t\talign-items: center;\n\t\t\tpadding: 0 20px;\n\t\t\tmargin: 10px;\n\t\t\tborder-radius: 5px;\n\t\t\tposition: relative;\n\t\t";
            return this.sanitizer.bypassSecurityTrustStyle(styles);
        },
        enumerable: true,
        configurable: true
    });
    /** Remove method to be used from the template. */
    /**
     * Remove method to be used from the template.
     * @param {?} event
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype._remove = /**
     * Remove method to be used from the template.
     * @param {?} event
     * @return {?}
     */
    function (event) {
        event.stopPropagation();
        this.remove();
    };
    /** Remove the preview item (use from component code). */
    /**
     * Remove the preview item (use from component code).
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype.remove = /**
     * Remove the preview item (use from component code).
     * @return {?}
     */
    function () {
        if (this._removable) {
            this.removed.next(this.file);
        }
    };
    /**
     * @protected
     * @return {?}
     */
    NgxDropzonePreviewComponent.prototype.readFile = /**
     * @protected
     * @return {?}
     */
    function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, new Promise((/**
                     * @param {?} resolve
                     * @param {?} reject
                     * @return {?}
                     */
                    function (resolve, reject) {
                        /** @type {?} */
                        var reader = new FileReader();
                        reader.onload = (/**
                         * @param {?} e
                         * @return {?}
                         */
                        function (e) {
                            resolve(((/** @type {?} */ (e.target))).result);
                        });
                        reader.onerror = (/**
                         * @param {?} e
                         * @return {?}
                         */
                        function (e) {
                            console.error("FileReader failed on file " + _this.file.name + ".");
                            reject(e);
                        });
                        if (!_this.file) {
                            return reject('No file to read. Please provide a file using the [file] Input property.');
                        }
                        reader.readAsDataURL(_this.file);
                    }))];
            });
        });
    };
    NgxDropzonePreviewComponent.decorators = [
        { type: Component, args: [{
                    selector: 'ngx-dropzone-preview',
                    template: "\n\t\t<ng-content select=\"ngx-dropzone-label\"></ng-content>\n\t\t<ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n\t\t</ngx-dropzone-remove-badge>\n\t",
                    styles: [":host(){background-image:linear-gradient(to top,#ededed,#efefef,#f1f1f1,#f4f4f4,#f6f6f6)}:host():focus,:host():hover{background-image:linear-gradient(to top,#e3e3e3,#ebeaea,#e8e7e7,#ebeaea,#f4f4f4);outline:0}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() ::ng-deep ngx-dropzone-label{overflow-wrap:break-word}"]
                },] },
    ];
    /** @nocollapse */
    NgxDropzonePreviewComponent.ctorParameters = function () { return [
        { type: DomSanitizer }
    ]; };
    NgxDropzonePreviewComponent.propDecorators = {
        file: [{ type: Input }],
        removable: [{ type: Input }],
        removed: [{ type: Output }],
        keyEvent: [{ type: HostListener, args: ['keyup', ['$event'],] }],
        hostStyle: [{ type: HostBinding, args: ['style',] }],
        tabIndex: [{ type: HostBinding, args: ['tabindex',] }]
    };
    return NgxDropzonePreviewComponent;
}());
export { NgxDropzonePreviewComponent };
if (false) {
    /**
     * The file to preview.
     * @type {?}
     */
    NgxDropzonePreviewComponent.prototype.file;
    /**
     * @type {?}
     * @protected
     */
    NgxDropzonePreviewComponent.prototype._removable;
    /**
     * Emitted when the element should be removed.
     * @type {?}
     */
    NgxDropzonePreviewComponent.prototype.removed;
    /**
     * Make the preview item focusable using the tab key.
     * @type {?}
     */
    NgxDropzonePreviewComponent.prototype.tabIndex;
    /**
     * @type {?}
     * @protected
     */
    NgxDropzonePreviewComponent.prototype.sanitizer;
}
//# sourceMappingURL=data:application/json;base64,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