/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component } from '@angular/core';
import { NgxDropzonePreviewComponent } from '../ngx-dropzone-preview.component';
import { DomSanitizer } from '@angular/platform-browser';
export class NgxDropzoneVideoPreviewComponent extends NgxDropzonePreviewComponent {
    /**
     * @param {?} sanitizer
     */
    constructor(sanitizer) {
        super(sanitizer);
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        if (!this.file) {
            console.error('No file to read. Please provide a file using the [file] Input property.');
            return;
        }
        /**
         * We sanitize the URL here to enable the preview.
         * Please note that this could cause security issues!
         **/
        this.videoSrc = URL.createObjectURL(this.file);
        this.sanitizedVideoSrc = this.sanitizer.bypassSecurityTrustUrl(this.videoSrc);
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        URL.revokeObjectURL(this.videoSrc);
    }
}
NgxDropzoneVideoPreviewComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-dropzone-video-preview',
                template: `
    <video *ngIf="sanitizedVideoSrc" controls (click)="$event.stopPropagation()">
      <source [src]="sanitizedVideoSrc" />
    </video>
    <ng-content select="ngx-dropzone-label"></ng-content>
    <ngx-dropzone-remove-badge *ngIf="removable" (click)="_remove($event)">
    </ngx-dropzone-remove-badge>
	`,
                styles: [`:host(){min-width:unset!important;max-width:unset!important;padding:0!important}:host():focus video,:host():hover video{opacity:.7}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() video{max-height:100%;border-radius:5px}:host() ::ng-deep ngx-dropzone-label{position:absolute;overflow-wrap:break-word}`],
                providers: [
                    {
                        provide: NgxDropzonePreviewComponent,
                        useExisting: NgxDropzoneVideoPreviewComponent
                    }
                ]
            },] },
];
/** @nocollapse */
NgxDropzoneVideoPreviewComponent.ctorParameters = () => [
    { type: DomSanitizer }
];
if (false) {
    /**
     * The video data source.
     * @type {?}
     */
    NgxDropzoneVideoPreviewComponent.prototype.sanitizedVideoSrc;
    /**
     * @type {?}
     * @private
     */
    NgxDropzoneVideoPreviewComponent.prototype.videoSrc;
}
//# sourceMappingURL=data:application/json;base64,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