(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/platform-browser'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ngx-dropzone', ['exports', '@angular/core', '@angular/platform-browser', '@angular/common'], factory) :
    (factory((global['ngx-dropzone'] = {}),global.ng.core,global.ng.platformBrowser,global.ng.common));
}(this, (function (exports,core,platformBrowser,common) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgxDropzoneLabelDirective = /** @class */ (function () {
        function NgxDropzoneLabelDirective() {
        }
        NgxDropzoneLabelDirective.decorators = [
            { type: core.Directive, args: [{
                        selector: 'ngx-dropzone-label'
                    },] },
        ];
        return NgxDropzoneLabelDirective;
    }());

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (b.hasOwnProperty(p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try {
                step(generator.next(value));
            }
            catch (e) {
                reject(e);
            } }
            function rejected(value) { try {
                step(generator["throw"](value));
            }
            catch (e) {
                reject(e);
            } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () { if (t[0] & 1)
                throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * Coerces a data-bound value (typically a string) to a boolean.
     * Taken from https://github.com/angular/components/blob/master/src/cdk/coercion/boolean-property.ts
     * @param {?} value
     * @return {?}
     */
    function coerceBooleanProperty(value) {
        return value != null && "" + value !== 'false';
    }
    /**
     * Whether the provided value is considered a number.
     * Taken from https://github.com/angular/components/blob/master/src/cdk/coercion/number-property.ts
     * @param {?} value
     * @return {?}
     */
    function coerceNumberProperty(value) {
        // parseFloat(value) handles most of the cases we're interested in (it treats null, empty string,
        // and other non-number values as NaN, where Number just uses 0) but it considers the string
        // '123hello' to be a valid number. Therefore we also check if Number(value) is NaN.
        return (!isNaN(parseFloat(( /** @type {?} */(value)))) && !isNaN(Number(value))) ? Number(value) : null;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @enum {number} */
    var KEY_CODE = {
        BACKSPACE: 8,
        DELETE: 46,
    };
    KEY_CODE[KEY_CODE.BACKSPACE] = 'BACKSPACE';
    KEY_CODE[KEY_CODE.DELETE] = 'DELETE';
    var NgxDropzonePreviewComponent = /** @class */ (function () {
        function NgxDropzonePreviewComponent(sanitizer) {
            this.sanitizer = sanitizer;
            this._removable = false;
            /**
             * Emitted when the element should be removed.
             */
            this.removed = new core.EventEmitter();
            /**
             * Make the preview item focusable using the tab key.
             */
            this.tabIndex = 0;
        }
        Object.defineProperty(NgxDropzonePreviewComponent.prototype, "removable", {
            /** Allow the user to remove files. */
            get: /**
             * Allow the user to remove files.
             * @return {?}
             */ function () {
                return this._removable;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._removable = coerceBooleanProperty(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} event
         * @return {?}
         */
        NgxDropzonePreviewComponent.prototype.keyEvent = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                switch (event.keyCode) {
                    case KEY_CODE.BACKSPACE:
                    case KEY_CODE.DELETE:
                        this.remove();
                        break;
                    default:
                        break;
                }
            };
        Object.defineProperty(NgxDropzonePreviewComponent.prototype, "hostStyle", {
            /** We use the HostBinding to pass these common styles to child components. */
            get: /**
             * We use the HostBinding to pass these common styles to child components.
             * @return {?}
             */ function () {
                /** @type {?} */
                var styles = "\n\t\t\tdisplay: flex;\n\t\t\theight: 140px;\n\t\t\tmin-height: 140px;\n\t\t\tmin-width: 180px;\n\t\t\tmax-width: 180px;\n\t\t\tjustify-content: center;\n\t\t\talign-items: center;\n\t\t\tpadding: 0 20px;\n\t\t\tmargin: 10px;\n\t\t\tborder-radius: 5px;\n\t\t\tposition: relative;\n\t\t";
                return this.sanitizer.bypassSecurityTrustStyle(styles);
            },
            enumerable: true,
            configurable: true
        });
        /** Remove method to be used from the template. */
        /**
         * Remove method to be used from the template.
         * @param {?} event
         * @return {?}
         */
        NgxDropzonePreviewComponent.prototype._remove = /**
         * Remove method to be used from the template.
         * @param {?} event
         * @return {?}
         */
            function (event) {
                event.stopPropagation();
                this.remove();
            };
        /** Remove the preview item (use from component code). */
        /**
         * Remove the preview item (use from component code).
         * @return {?}
         */
        NgxDropzonePreviewComponent.prototype.remove = /**
         * Remove the preview item (use from component code).
         * @return {?}
         */
            function () {
                if (this._removable) {
                    this.removed.next(this.file);
                }
            };
        /**
         * @protected
         * @return {?}
         */
        NgxDropzonePreviewComponent.prototype.readFile = /**
         * @protected
         * @return {?}
         */
            function () {
                return __awaiter(this, void 0, void 0, function () {
                    var _this = this;
                    return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(( /**
                                 * @param {?} resolve
                                 * @param {?} reject
                                 * @return {?}
                                 */function (resolve, reject) {
                                /** @type {?} */
                                var reader = new FileReader();
                                reader.onload = ( /**
                                 * @param {?} e
                                 * @return {?}
                                 */function (e) {
                                    resolve((( /** @type {?} */(e.target))).result);
                                });
                                reader.onerror = ( /**
                                 * @param {?} e
                                 * @return {?}
                                 */function (e) {
                                    console.error("FileReader failed on file " + _this.file.name + ".");
                                    reject(e);
                                });
                                if (!_this.file) {
                                    return reject('No file to read. Please provide a file using the [file] Input property.');
                                }
                                reader.readAsDataURL(_this.file);
                            }))];
                    });
                });
            };
        NgxDropzonePreviewComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'ngx-dropzone-preview',
                        template: "\n\t\t<ng-content select=\"ngx-dropzone-label\"></ng-content>\n\t\t<ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n\t\t</ngx-dropzone-remove-badge>\n\t",
                        styles: [":host(){background-image:linear-gradient(to top,#ededed,#efefef,#f1f1f1,#f4f4f4,#f6f6f6)}:host():focus,:host():hover{background-image:linear-gradient(to top,#e3e3e3,#ebeaea,#e8e7e7,#ebeaea,#f4f4f4);outline:0}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() ::ng-deep ngx-dropzone-label{overflow-wrap:break-word}"]
                    },] },
        ];
        /** @nocollapse */
        NgxDropzonePreviewComponent.ctorParameters = function () {
            return [
                { type: platformBrowser.DomSanitizer }
            ];
        };
        NgxDropzonePreviewComponent.propDecorators = {
            file: [{ type: core.Input }],
            removable: [{ type: core.Input }],
            removed: [{ type: core.Output }],
            keyEvent: [{ type: core.HostListener, args: ['keyup', ['$event'],] }],
            hostStyle: [{ type: core.HostBinding, args: ['style',] }],
            tabIndex: [{ type: core.HostBinding, args: ['tabindex',] }]
        };
        return NgxDropzonePreviewComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * This service contains the filtering logic to be applied to
     * any dropped or selected file. If a file matches all criteria
     * like maximum size or accept type, it will be emitted in the
     * addedFiles array, otherwise in the rejectedFiles array.
     */
    var NgxDropzoneService = /** @class */ (function () {
        function NgxDropzoneService() {
        }
        /**
         * @param {?} files
         * @param {?} accept
         * @param {?} maxFileSize
         * @param {?} multiple
         * @return {?}
         */
        NgxDropzoneService.prototype.parseFileList = /**
         * @param {?} files
         * @param {?} accept
         * @param {?} maxFileSize
         * @param {?} multiple
         * @return {?}
         */
            function (files, accept, maxFileSize, multiple) {
                /** @type {?} */
                var addedFiles = [];
                /** @type {?} */
                var rejectedFiles = [];
                for (var i = 0; i < files.length; i++) {
                    /** @type {?} */
                    var file = files.item(i);
                    if (!this.isAccepted(file, accept)) {
                        this.rejectFile(rejectedFiles, file, 'type');
                        continue;
                    }
                    if (maxFileSize && file.size > maxFileSize) {
                        this.rejectFile(rejectedFiles, file, 'size');
                        continue;
                    }
                    if (!multiple && addedFiles.length >= 1) {
                        this.rejectFile(rejectedFiles, file, 'no_multiple');
                        continue;
                    }
                    addedFiles.push(file);
                }
                /** @type {?} */
                var result = {
                    addedFiles: addedFiles,
                    rejectedFiles: rejectedFiles
                };
                return result;
            };
        /**
         * @private
         * @param {?} file
         * @param {?} accept
         * @return {?}
         */
        NgxDropzoneService.prototype.isAccepted = /**
         * @private
         * @param {?} file
         * @param {?} accept
         * @return {?}
         */
            function (file, accept) {
                if (accept === '*') {
                    return true;
                }
                /** @type {?} */
                var acceptFiletypes = accept.split(',').map(( /**
                 * @param {?} it
                 * @return {?}
                 */function (it) { return it.toLowerCase().trim(); }));
                /** @type {?} */
                var filetype = file.type.toLowerCase();
                /** @type {?} */
                var filename = file.name.toLowerCase();
                /** @type {?} */
                var matchedFileType = acceptFiletypes.find(( /**
                 * @param {?} acceptFiletype
                 * @return {?}
                 */function (acceptFiletype) {
                    // check for wildcard mimetype (e.g. image/*)
                    if (acceptFiletype.endsWith('/*')) {
                        return filetype.split('/')[0] === acceptFiletype.split('/')[0];
                    }
                    // check for file extension (e.g. .csv)
                    if (acceptFiletype.startsWith(".")) {
                        return filename.endsWith(acceptFiletype);
                    }
                    // check for exact mimetype match (e.g. image/jpeg)
                    return acceptFiletype == filetype;
                }));
                return !!matchedFileType;
            };
        /**
         * @private
         * @param {?} rejectedFiles
         * @param {?} file
         * @param {?} reason
         * @return {?}
         */
        NgxDropzoneService.prototype.rejectFile = /**
         * @private
         * @param {?} rejectedFiles
         * @param {?} file
         * @param {?} reason
         * @return {?}
         */
            function (rejectedFiles, file, reason) {
                /** @type {?} */
                var rejectedFile = ( /** @type {?} */(file));
                rejectedFile.reason = reason;
                rejectedFiles.push(rejectedFile);
            };
        NgxDropzoneService.decorators = [
            { type: core.Injectable },
        ];
        return NgxDropzoneService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgxDropzoneComponent = /** @class */ (function () {
        function NgxDropzoneComponent(service) {
            this.service = service;
            /**
             * Emitted when any files were added or rejected.
             */
            this.change = new core.EventEmitter();
            /**
             * Set the accepted file types. Defaults to '*'.
             */
            this.accept = '*';
            this._disabled = false;
            this._multiple = true;
            this._maxFileSize = undefined;
            this._expandable = false;
            this._disableClick = false;
            this._isHovered = false;
        }
        Object.defineProperty(NgxDropzoneComponent.prototype, "_hasPreviews", {
            get: /**
             * @return {?}
             */ function () {
                return !!this._previewChildren.length;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NgxDropzoneComponent.prototype, "disabled", {
            /** Disable any user interaction with the component. */
            get: /**
             * Disable any user interaction with the component.
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = coerceBooleanProperty(value);
                if (this._isHovered) {
                    this._isHovered = false;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NgxDropzoneComponent.prototype, "multiple", {
            /** Allow the selection of multiple files. */
            get: /**
             * Allow the selection of multiple files.
             * @return {?}
             */ function () {
                return this._multiple;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._multiple = coerceBooleanProperty(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NgxDropzoneComponent.prototype, "maxFileSize", {
            /** Set the maximum size a single file may have. */
            get: /**
             * Set the maximum size a single file may have.
             * @return {?}
             */ function () {
                return this._maxFileSize;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._maxFileSize = coerceNumberProperty(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NgxDropzoneComponent.prototype, "expandable", {
            /** Allow the dropzone container to expand vertically. */
            get: /**
             * Allow the dropzone container to expand vertically.
             * @return {?}
             */ function () {
                return this._expandable;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._expandable = coerceBooleanProperty(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NgxDropzoneComponent.prototype, "disableClick", {
            /** Open the file selector on click. */
            get: /**
             * Open the file selector on click.
             * @return {?}
             */ function () {
                return this._disableClick;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disableClick = coerceBooleanProperty(value);
            },
            enumerable: true,
            configurable: true
        });
        /** Show the native OS file explorer to select files. */
        /**
         * Show the native OS file explorer to select files.
         * @return {?}
         */
        NgxDropzoneComponent.prototype._onClick = /**
         * Show the native OS file explorer to select files.
         * @return {?}
         */
            function () {
                if (!this.disableClick) {
                    this.showFileSelector();
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NgxDropzoneComponent.prototype._onDragOver = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this.disabled) {
                    return;
                }
                this.preventDefault(event);
                this._isHovered = true;
            };
        /**
         * @return {?}
         */
        NgxDropzoneComponent.prototype._onDragLeave = /**
         * @return {?}
         */
            function () {
                this._isHovered = false;
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NgxDropzoneComponent.prototype._onDrop = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this.disabled) {
                    return;
                }
                this.preventDefault(event);
                this._isHovered = false;
                this.handleFileDrop(event.dataTransfer.files);
            };
        /**
         * @return {?}
         */
        NgxDropzoneComponent.prototype.showFileSelector = /**
         * @return {?}
         */
            function () {
                if (!this.disabled) {
                    (( /** @type {?} */(this._fileInput.nativeElement))).click();
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NgxDropzoneComponent.prototype._onFilesSelected = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var files = event.target.files;
                this.handleFileDrop(files);
                // Reset the native file input element to allow selecting the same file again
                this._fileInput.nativeElement.value = '';
                // fix(#32): Prevent the default event behaviour which caused the change event to emit twice.
                this.preventDefault(event);
            };
        /**
         * @private
         * @param {?} files
         * @return {?}
         */
        NgxDropzoneComponent.prototype.handleFileDrop = /**
         * @private
         * @param {?} files
         * @return {?}
         */
            function (files) {
                /** @type {?} */
                var result = this.service.parseFileList(files, this.accept, this.maxFileSize, this.multiple);
                this.change.next({
                    addedFiles: result.addedFiles,
                    rejectedFiles: result.rejectedFiles,
                    source: this
                });
            };
        /**
         * @private
         * @param {?} event
         * @return {?}
         */
        NgxDropzoneComponent.prototype.preventDefault = /**
         * @private
         * @param {?} event
         * @return {?}
         */
            function (event) {
                event.preventDefault();
                event.stopPropagation();
            };
        NgxDropzoneComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'ngx-dropzone, [ngx-dropzone]',
                        template: "<input #fileInput type=\"file\" [id]=\"id\" [multiple]=\"multiple\" [accept]=\"accept\" [disabled]=\"disabled\"\n  (change)=\"_onFilesSelected($event)\" [attr.aria-label]=\"ariaLabel\" [attr.aria-labelledby]=\"ariaLabelledby\"\n  [attr.aria-describedby]=\"ariaDescribedBy\">\n<ng-content select=\"ngx-dropzone-label\" *ngIf=\"!_hasPreviews\"></ng-content>\n<ng-content select=\"ngx-dropzone-preview\"></ng-content>\n<ng-content></ng-content>\n",
                        styles: [":host(){display:flex;align-items:center;height:180px;background:#fff;cursor:pointer;color:#717386;border:2px dashed #717386;border-radius:5px;font-size:16px;overflow-x:auto}:host().ngx-dz-hovered{border-style:solid}:host().ngx-dz-disabled{opacity:.5;cursor:no-drop;pointer-events:none}:host().expandable{overflow:hidden;height:unset;min-height:180px;flex-wrap:wrap}:host().unclickable{cursor:default}:host() ::ng-deep ngx-dropzone-label{text-align:center;z-index:10;margin:10px auto}:host() input{width:.1px;height:.1px;opacity:0;overflow:hidden;position:absolute;z-index:-1}:host() input:focus+::ng-deep ngx-dropzone-label{outline:#000 dotted 1px;outline:-webkit-focus-ring-color auto 5px}"],
                        providers: [NgxDropzoneService]
                    },] },
        ];
        /** @nocollapse */
        NgxDropzoneComponent.ctorParameters = function () {
            return [
                { type: NgxDropzoneService, decorators: [{ type: core.Self }] }
            ];
        };
        NgxDropzoneComponent.propDecorators = {
            _previewChildren: [{ type: core.ContentChildren, args: [NgxDropzonePreviewComponent, { descendants: true },] }],
            _fileInput: [{ type: core.ViewChild, args: ['fileInput',] }],
            change: [{ type: core.Output }],
            accept: [{ type: core.Input }],
            disabled: [{ type: core.Input }, { type: core.HostBinding, args: ['class.ngx-dz-disabled',] }],
            multiple: [{ type: core.Input }],
            maxFileSize: [{ type: core.Input }],
            expandable: [{ type: core.Input }, { type: core.HostBinding, args: ['class.expandable',] }],
            disableClick: [{ type: core.Input }, { type: core.HostBinding, args: ['class.unclickable',] }],
            id: [{ type: core.Input }],
            ariaLabel: [{ type: core.Input, args: ['aria-label',] }],
            ariaLabelledby: [{ type: core.Input, args: ['aria-labelledby',] }],
            ariaDescribedBy: [{ type: core.Input, args: ['aria-describedby',] }],
            _isHovered: [{ type: core.HostBinding, args: ['class.ngx-dz-hovered',] }],
            _onClick: [{ type: core.HostListener, args: ['click',] }],
            _onDragOver: [{ type: core.HostListener, args: ['dragover', ['$event'],] }],
            _onDragLeave: [{ type: core.HostListener, args: ['dragleave',] }],
            _onDrop: [{ type: core.HostListener, args: ['drop', ['$event'],] }]
        };
        return NgxDropzoneComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgxDropzoneImagePreviewComponent = /** @class */ (function (_super) {
        __extends(NgxDropzoneImagePreviewComponent, _super);
        function NgxDropzoneImagePreviewComponent(sanitizer) {
            var _this = _super.call(this, sanitizer) || this;
            /**
             * The image data source.
             */
            _this.imageSrc = '';
            return _this;
        }
        /**
         * @return {?}
         */
        NgxDropzoneImagePreviewComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.readFile()
                    .then(( /**
             * @param {?} img
             * @return {?}
             */function (img) {
                    return setTimeout(( /**
                     * @return {?}
                     */function () { return _this.imageSrc = img; }));
                }))
                    .catch(( /**
             * @param {?} err
             * @return {?}
             */function (err) { return console.error(err); }));
            };
        NgxDropzoneImagePreviewComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'ngx-dropzone-image-preview',
                        template: "\n    <img [src]=\"imageSrc\" />\n\t\t<ng-content select=\"ngx-dropzone-label\"></ng-content>\n    <ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n    </ngx-dropzone-remove-badge>\n\t",
                        styles: [":host(){min-width:unset!important;max-width:unset!important;padding:0!important}:host():focus img,:host():hover img{opacity:.7}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() img{max-height:100%;border-radius:5px;opacity:.8}:host() ::ng-deep ngx-dropzone-label{position:absolute;overflow-wrap:break-word}"],
                        providers: [
                            {
                                provide: NgxDropzonePreviewComponent,
                                useExisting: NgxDropzoneImagePreviewComponent
                            }
                        ]
                    },] },
        ];
        /** @nocollapse */
        NgxDropzoneImagePreviewComponent.ctorParameters = function () {
            return [
                { type: platformBrowser.DomSanitizer }
            ];
        };
        return NgxDropzoneImagePreviewComponent;
    }(NgxDropzonePreviewComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgxDropzoneRemoveBadgeComponent = /** @class */ (function () {
        function NgxDropzoneRemoveBadgeComponent() {
        }
        NgxDropzoneRemoveBadgeComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'ngx-dropzone-remove-badge',
                        template: "\n    <svg>\n      <line x1=\"0\" y1=\"0\" x2=\"10\" y2=\"10\" />\n      <line x1=\"0\" y1=\"10\" x2=\"10\" y2=\"0\" />\n    </svg>\n  ",
                        styles: [":host(){display:flex;justify-content:center;align-items:center;height:22px;width:22px;position:absolute;top:5px;right:5px;border-radius:50%;background:#bbb;color:#333;cursor:pointer}:host():hover{background:#aeaeae}:host()>svg{height:10px;width:10px}:host()>svg>line{stroke-width:2px;stroke:#fff}"]
                    },] },
        ];
        return NgxDropzoneRemoveBadgeComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgxDropzoneVideoPreviewComponent = /** @class */ (function (_super) {
        __extends(NgxDropzoneVideoPreviewComponent, _super);
        function NgxDropzoneVideoPreviewComponent(sanitizer) {
            return _super.call(this, sanitizer) || this;
        }
        /**
         * @return {?}
         */
        NgxDropzoneVideoPreviewComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (!this.file) {
                    console.error('No file to read. Please provide a file using the [file] Input property.');
                    return;
                }
                /**
                 * We sanitize the URL here to enable the preview.
                 * Please note that this could cause security issues!
                 **/
                this.videoSrc = URL.createObjectURL(this.file);
                this.sanitizedVideoSrc = this.sanitizer.bypassSecurityTrustUrl(this.videoSrc);
            };
        /**
         * @return {?}
         */
        NgxDropzoneVideoPreviewComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                URL.revokeObjectURL(this.videoSrc);
            };
        NgxDropzoneVideoPreviewComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'ngx-dropzone-video-preview',
                        template: "\n    <video *ngIf=\"sanitizedVideoSrc\" controls (click)=\"$event.stopPropagation()\">\n      <source [src]=\"sanitizedVideoSrc\" />\n    </video>\n    <ng-content select=\"ngx-dropzone-label\"></ng-content>\n    <ngx-dropzone-remove-badge *ngIf=\"removable\" (click)=\"_remove($event)\">\n    </ngx-dropzone-remove-badge>\n\t",
                        styles: [":host(){min-width:unset!important;max-width:unset!important;padding:0!important}:host():focus video,:host():hover video{opacity:.7}:host():focus ngx-dropzone-remove-badge,:host():hover ngx-dropzone-remove-badge{opacity:1}:host() ngx-dropzone-remove-badge{opacity:0}:host() video{max-height:100%;border-radius:5px}:host() ::ng-deep ngx-dropzone-label{position:absolute;overflow-wrap:break-word}"],
                        providers: [
                            {
                                provide: NgxDropzonePreviewComponent,
                                useExisting: NgxDropzoneVideoPreviewComponent
                            }
                        ]
                    },] },
        ];
        /** @nocollapse */
        NgxDropzoneVideoPreviewComponent.ctorParameters = function () {
            return [
                { type: platformBrowser.DomSanitizer }
            ];
        };
        return NgxDropzoneVideoPreviewComponent;
    }(NgxDropzonePreviewComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgxDropzoneModule = /** @class */ (function () {
        function NgxDropzoneModule() {
        }
        NgxDropzoneModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [
                            common.CommonModule
                        ],
                        declarations: [
                            NgxDropzoneComponent,
                            NgxDropzoneLabelDirective,
                            NgxDropzonePreviewComponent,
                            NgxDropzoneImagePreviewComponent,
                            NgxDropzoneRemoveBadgeComponent,
                            NgxDropzoneVideoPreviewComponent,
                        ],
                        exports: [
                            NgxDropzoneComponent,
                            NgxDropzoneLabelDirective,
                            NgxDropzonePreviewComponent,
                            NgxDropzoneImagePreviewComponent,
                            NgxDropzoneRemoveBadgeComponent,
                            NgxDropzoneVideoPreviewComponent,
                        ]
                    },] },
        ];
        return NgxDropzoneModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */

    exports.NgxDropzoneModule = NgxDropzoneModule;
    exports.NgxDropzoneComponent = NgxDropzoneComponent;
    exports.NgxDropzonePreviewComponent = NgxDropzonePreviewComponent;
    exports.NgxDropzoneImagePreviewComponent = NgxDropzoneImagePreviewComponent;
    exports.NgxDropzoneVideoPreviewComponent = NgxDropzoneVideoPreviewComponent;
    exports.NgxDropzoneRemoveBadgeComponent = NgxDropzoneRemoveBadgeComponent;
    exports.ɵb = NgxDropzoneLabelDirective;
    exports.ɵa = NgxDropzoneService;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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