import { __assign, __decorate } from 'tslib';
import { EventEmitter, ElementRef, ViewChild, Output, Input, HostListener, Component, NgModule } from '@angular/core';
import * as PDFJS from 'pdfjs-dist/es5/build/pdf';
import { VerbosityLevel, version, GlobalWorkerOptions, LinkTarget, getDocument } from 'pdfjs-dist/es5/build/pdf';
import * as PDFJSViewer from 'pdfjs-dist/es5/web/pdf_viewer';
import { PDFLinkService, PDFFindController, PDFViewer, PDFSinglePageViewer } from 'pdfjs-dist/es5/web/pdf_viewer';

import * as ɵngcc0 from '@angular/core';

var _c0 = ["pdfViewerContainer"];
function _createEventBus(pdfJsViewer) {
    var globalEventBus = new pdfJsViewer.EventBus(true);
    attachDOMEventsToEventBus(globalEventBus);
    return globalEventBus;
}
function attachDOMEventsToEventBus(eventBus) {
    eventBus.on('documentload', function () {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('documentload', true, true, {});
        window.dispatchEvent(event);
    });
    eventBus.on('pagerendered', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagerendered', true, true, {
            pageNumber: evt.pageNumber,
            cssTransform: evt.cssTransform
        });
        evt.source.div.dispatchEvent(event);
    });
    eventBus.on('textlayerrendered', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('textlayerrendered', true, true, {
            pageNumber: evt.pageNumber
        });
        evt.source.textLayerDiv.dispatchEvent(event);
    });
    eventBus.on('pagechanging', function (evt) {
        var event = document.createEvent('UIEvents');
        event.initEvent('pagechanging', true, true);
        /* tslint:disable:no-string-literal */
        event['pageNumber'] = evt.pageNumber;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('pagesinit', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagesinit', true, true, null);
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('pagesloaded', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagesloaded', true, true, {
            pagesCount: evt.pagesCount
        });
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('scalechange', function (evt) {
        var event = document.createEvent('UIEvents');
        event.initEvent('scalechange', true, true);
        /* tslint:disable:no-string-literal */
        event['scale'] = evt.scale;
        /* tslint:disable:no-string-literal */
        event['presetValue'] = evt.presetValue;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('updateviewarea', function (evt) {
        var event = document.createEvent('UIEvents');
        event.initEvent('updateviewarea', true, true);
        event['location'] = evt.location;
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('find', function (evt) {
        if (evt.source === window) {
            return; // event comes from FirefoxCom, no need to replicate
        }
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('find' + evt.type, true, true, {
            query: evt.query,
            phraseSearch: evt.phraseSearch,
            caseSensitive: evt.caseSensitive,
            highlightAll: evt.highlightAll,
            findPrevious: evt.findPrevious
        });
        window.dispatchEvent(event);
    });
    eventBus.on('attachmentsloaded', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('attachmentsloaded', true, true, {
            attachmentsCount: evt.attachmentsCount
        });
        evt.source.container.dispatchEvent(event);
    });
    eventBus.on('sidebarviewchanged', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('sidebarviewchanged', true, true, {
            view: evt.view
        });
        evt.source.outerContainer.dispatchEvent(event);
    });
    eventBus.on('pagemode', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('pagemode', true, true, {
            mode: evt.mode
        });
        evt.source.pdfViewer.container.dispatchEvent(event);
    });
    eventBus.on('namedaction', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('namedaction', true, true, {
            action: evt.action
        });
        evt.source.pdfViewer.container.dispatchEvent(event);
    });
    eventBus.on('presentationmodechanged', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('presentationmodechanged', true, true, {
            active: evt.active,
            switchInProgress: evt.switchInProgress
        });
        window.dispatchEvent(event);
    });
    eventBus.on('outlineloaded', function (evt) {
        var event = document.createEvent('CustomEvent');
        event.initCustomEvent('outlineloaded', true, true, {
            outlineCount: evt.outlineCount
        });
        evt.source.container.dispatchEvent(event);
    });
}
var createEventBus = _createEventBus;

function assign(obj, prop, value) {
    obj[prop] = value;
}
function isSSR() {
    return typeof window === 'undefined';
}

if (!isSSR()) {
    assign(PDFJS, "verbosity", VerbosityLevel.ERRORS);
}
var RenderTextMode;
(function (RenderTextMode) {
    RenderTextMode[RenderTextMode["DISABLED"] = 0] = "DISABLED";
    RenderTextMode[RenderTextMode["ENABLED"] = 1] = "ENABLED";
    RenderTextMode[RenderTextMode["ENHANCED"] = 2] = "ENHANCED";
})(RenderTextMode || (RenderTextMode = {}));
var PdfViewerComponent = /** @class */ (function () {
    function PdfViewerComponent(element) {
        this.element = element;
        this.isVisible = false;
        this._cMapsUrl = typeof PDFJS !== 'undefined'
            ? "https://unpkg.com/pdfjs-dist@" + version + "/cmaps/"
            : null;
        this._renderText = true;
        this._renderTextMode = RenderTextMode.ENABLED;
        this._stickToPage = false;
        this._originalSize = true;
        this._page = 1;
        this._zoom = 1;
        this._zoomScale = 'page-width';
        this._rotation = 0;
        this._showAll = true;
        this._canAutoResize = true;
        this._fitToPage = false;
        this._externalLinkTarget = 'blank';
        this._showBorders = false;
        this.isInitialized = false;
        this.afterLoadComplete = new EventEmitter();
        this.pageRendered = new EventEmitter();
        this.pageInitialized = new EventEmitter();
        this.textLayerRendered = new EventEmitter();
        this.onError = new EventEmitter();
        this.onProgress = new EventEmitter();
        this.pageChange = new EventEmitter(true);
        if (isSSR()) {
            return;
        }
        var pdfWorkerSrc;
        if (window.hasOwnProperty('pdfWorkerSrc') &&
            typeof window.pdfWorkerSrc === 'string' &&
            window.pdfWorkerSrc) {
            pdfWorkerSrc = window.pdfWorkerSrc;
        }
        else {
            pdfWorkerSrc = "https://cdn.jsdelivr.net/npm/pdfjs-dist@" + version + "/es5/build/pdf.worker.js";
        }
        assign(GlobalWorkerOptions, "workerSrc", pdfWorkerSrc);
    }
    PdfViewerComponent_1 = PdfViewerComponent;
    Object.defineProperty(PdfViewerComponent.prototype, "cMapsUrl", {
        set: function (cMapsUrl) {
            this._cMapsUrl = cMapsUrl;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "page", {
        set: function (_page) {
            _page = parseInt(_page, 10) || 1;
            var originalPage = _page;
            if (this._pdf) {
                _page = this.getValidPageNumber(_page);
            }
            this._page = _page;
            if (originalPage !== _page) {
                this.pageChange.emit(_page);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "renderText", {
        set: function (renderText) {
            this._renderText = renderText;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "renderTextMode", {
        set: function (renderTextMode) {
            this._renderTextMode = renderTextMode;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "originalSize", {
        set: function (originalSize) {
            this._originalSize = originalSize;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "showAll", {
        set: function (value) {
            this._showAll = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "stickToPage", {
        set: function (value) {
            this._stickToPage = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "zoom", {
        get: function () {
            return this._zoom;
        },
        set: function (value) {
            if (value <= 0) {
                return;
            }
            this._zoom = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "zoomScale", {
        get: function () {
            return this._zoomScale;
        },
        set: function (value) {
            this._zoomScale = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "rotation", {
        set: function (value) {
            if (!(typeof value === 'number' && value % 90 === 0)) {
                console.warn('Invalid pages rotation angle.');
                return;
            }
            this._rotation = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "externalLinkTarget", {
        set: function (value) {
            this._externalLinkTarget = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "autoresize", {
        set: function (value) {
            this._canAutoResize = Boolean(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "fitToPage", {
        set: function (value) {
            this._fitToPage = Boolean(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "showBorders", {
        set: function (value) {
            this._showBorders = Boolean(value);
        },
        enumerable: true,
        configurable: true
    });
    PdfViewerComponent.getLinkTarget = function (type) {
        switch (type) {
            case 'blank':
                return LinkTarget.BLANK;
            case 'none':
                return LinkTarget.NONE;
            case 'self':
                return LinkTarget.SELF;
            case 'parent':
                return LinkTarget.PARENT;
            case 'top':
                return LinkTarget.TOP;
        }
        return null;
    };
    PdfViewerComponent.prototype.ngAfterViewChecked = function () {
        var _this = this;
        if (this.isInitialized) {
            return;
        }
        var offset = this.pdfViewerContainer.nativeElement.offsetParent;
        if (this.isVisible === true && offset == null) {
            this.isVisible = false;
            return;
        }
        if (this.isVisible === false && offset != null) {
            this.isVisible = true;
            setTimeout(function () {
                _this.ngOnInit();
                _this.ngOnChanges({ src: _this.src });
            });
        }
    };
    PdfViewerComponent.prototype.ngOnInit = function () {
        if (!isSSR() && this.isVisible) {
            this.isInitialized = true;
            this.setupMultiPageViewer();
            this.setupSinglePageViewer();
        }
    };
    PdfViewerComponent.prototype.ngOnDestroy = function () {
        this.clear();
    };
    PdfViewerComponent.prototype.onPageResize = function () {
        var _this = this;
        if (!this._canAutoResize || !this._pdf) {
            return;
        }
        if (this.resizeTimeout) {
            clearTimeout(this.resizeTimeout);
        }
        this.resizeTimeout = setTimeout(function () {
            _this.updateSize();
        }, 100);
    };
    Object.defineProperty(PdfViewerComponent.prototype, "pdfLinkService", {
        get: function () {
            return this._showAll
                ? this.pdfMultiPageLinkService
                : this.pdfSinglePageLinkService;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "pdfViewer", {
        get: function () {
            return this.getCurrentViewer();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PdfViewerComponent.prototype, "pdfFindController", {
        get: function () {
            return this._showAll
                ? this.pdfMultiPageFindController
                : this.pdfSinglePageFindController;
        },
        enumerable: true,
        configurable: true
    });
    PdfViewerComponent.prototype.ngOnChanges = function (changes) {
        if (isSSR() || !this.isVisible) {
            return;
        }
        if ('src' in changes) {
            this.loadPDF();
        }
        else if (this._pdf) {
            if ('renderText' in changes) {
                this.getCurrentViewer().textLayerMode = this._renderText
                    ? this._renderTextMode
                    : RenderTextMode.DISABLED;
                this.resetPdfDocument();
            }
            else if ('showAll' in changes) {
                this.resetPdfDocument();
            }
            if ('page' in changes) {
                var page = changes.page;
                if (page.currentValue === this._latestScrolledPage) {
                    return;
                }
                // New form of page changing: The viewer will now jump to the specified page when it is changed.
                // This behavior is introduced by using the PDFSinglePageViewer
                this.getCurrentViewer().scrollPageIntoView({ pageNumber: this._page });
            }
            this.update();
        }
    };
    PdfViewerComponent.prototype.updateSize = function () {
        var _this = this;
        var currentViewer = this.getCurrentViewer();
        this._pdf
            .getPage(currentViewer.currentPageNumber)
            .then(function (page) {
            var rotation = _this._rotation || page.rotate;
            var viewportWidth = page.getViewport({
                scale: _this._zoom,
                rotation: rotation
            }).width * PdfViewerComponent_1.CSS_UNITS;
            var scale = _this._zoom;
            var stickToPage = true;
            // Scale the document when it shouldn't be in original size or doesn't fit into the viewport
            if (!_this._originalSize ||
                (_this._fitToPage &&
                    viewportWidth > _this.pdfViewerContainer.nativeElement.clientWidth)) {
                var viewPort = page.getViewport({ scale: 1, rotation: rotation });
                scale = _this.getScale(viewPort.width, viewPort.height);
                stickToPage = !_this._stickToPage;
            }
            currentViewer._setScale(scale, stickToPage);
        });
    };
    PdfViewerComponent.prototype.clear = function () {
        if (this.loadingTask && !this.loadingTask.destroyed) {
            this.loadingTask.destroy();
        }
        if (this._pdf) {
            this._pdf.destroy();
            this._pdf = null;
            this.pdfMultiPageViewer.setDocument(null);
            this.pdfSinglePageViewer.setDocument(null);
            this.pdfMultiPageLinkService.setDocument(null, null);
            this.pdfSinglePageLinkService.setDocument(null, null);
            this.pdfMultiPageFindController.setDocument(null);
            this.pdfSinglePageFindController.setDocument(null);
        }
    };
    PdfViewerComponent.prototype.getPDFLinkServiceConfig = function () {
        var pdfLinkServiceConfig = {};
        var linkTarget = PdfViewerComponent_1.getLinkTarget(this._externalLinkTarget);
        if (linkTarget) {
            pdfLinkServiceConfig.externalLinkTarget = linkTarget;
        }
        return pdfLinkServiceConfig;
    };
    PdfViewerComponent.prototype.setupMultiPageViewer = function () {
        var _this = this;
        assign(PDFJS, "disableTextLayer", !this._renderText);
        var eventBus = createEventBus(PDFJSViewer);
        eventBus.on('pagerendered', function (e) {
            _this.pageRendered.emit(e);
        });
        eventBus.on('pagesinit', function (e) {
            _this.pageInitialized.emit(e);
        });
        eventBus.on('pagechanging', function (e) {
            if (_this.pageScrollTimeout) {
                clearTimeout(_this.pageScrollTimeout);
            }
            _this.pageScrollTimeout = setTimeout(function () {
                _this._latestScrolledPage = e.pageNumber;
                _this.pageChange.emit(e.pageNumber);
            }, 100);
        });
        eventBus.on('textlayerrendered', function (e) {
            _this.textLayerRendered.emit(e);
        });
        this.pdfMultiPageLinkService = new PDFLinkService(__assign({ eventBus: eventBus }, this.getPDFLinkServiceConfig()));
        this.pdfMultiPageFindController = new PDFFindController({
            linkService: this.pdfMultiPageLinkService,
            eventBus: eventBus
        });
        var pdfOptions = {
            eventBus: eventBus,
            container: this.element.nativeElement.querySelector('div'),
            removePageBorders: !this._showBorders,
            linkService: this.pdfMultiPageLinkService,
            textLayerMode: this._renderText
                ? this._renderTextMode
                : RenderTextMode.DISABLED,
            findController: this.pdfMultiPageFindController
        };
        this.pdfMultiPageViewer = new PDFViewer(pdfOptions);
        this.pdfMultiPageLinkService.setViewer(this.pdfMultiPageViewer);
        this.pdfMultiPageFindController.setDocument(this._pdf);
    };
    PdfViewerComponent.prototype.setupSinglePageViewer = function () {
        var _this = this;
        assign(PDFJS, "disableTextLayer", !this._renderText);
        var eventBus = createEventBus(PDFJSViewer);
        eventBus.on('pagechanging', function (e) {
            if (e.pageNumber !== _this._page) {
                _this.page = e.pageNumber;
            }
        });
        eventBus.on('pagerendered', function (e) {
            _this.pageRendered.emit(e);
        });
        eventBus.on('pagesinit', function (e) {
            _this.pageInitialized.emit(e);
        });
        eventBus.on('textlayerrendered', function (e) {
            _this.textLayerRendered.emit(e);
        });
        this.pdfSinglePageLinkService = new PDFLinkService(__assign({ eventBus: eventBus }, this.getPDFLinkServiceConfig()));
        this.pdfSinglePageFindController = new PDFFindController({
            linkService: this.pdfSinglePageLinkService,
            eventBus: eventBus
        });
        var pdfOptions = {
            eventBus: eventBus,
            container: this.element.nativeElement.querySelector('div'),
            removePageBorders: !this._showBorders,
            linkService: this.pdfSinglePageLinkService,
            textLayerMode: this._renderText
                ? this._renderTextMode
                : RenderTextMode.DISABLED,
            findController: this.pdfSinglePageFindController
        };
        this.pdfSinglePageViewer = new PDFSinglePageViewer(pdfOptions);
        this.pdfSinglePageLinkService.setViewer(this.pdfSinglePageViewer);
        this.pdfSinglePageFindController.setDocument(this._pdf);
        this.pdfSinglePageViewer._currentPageNumber = this._page;
    };
    PdfViewerComponent.prototype.getValidPageNumber = function (page) {
        if (page < 1) {
            return 1;
        }
        if (page > this._pdf.numPages) {
            return this._pdf.numPages;
        }
        return page;
    };
    PdfViewerComponent.prototype.getDocumentParams = function () {
        var srcType = typeof this.src;
        if (!this._cMapsUrl) {
            return this.src;
        }
        var params = {
            cMapUrl: this._cMapsUrl,
            cMapPacked: true
        };
        if (srcType === 'string') {
            params.url = this.src;
        }
        else if (srcType === 'object') {
            if (this.src.byteLength !== undefined) {
                params.data = this.src;
            }
            else {
                Object.assign(params, this.src);
            }
        }
        return params;
    };
    PdfViewerComponent.prototype.loadPDF = function () {
        var _this = this;
        if (!this.src) {
            return;
        }
        if (this.lastLoaded === this.src) {
            this.update();
            return;
        }
        this.clear();
        this.loadingTask = getDocument(this.getDocumentParams());
        this.loadingTask.onProgress = function (progressData) {
            _this.onProgress.emit(progressData);
        };
        var src = this.src;
        this.loadingTask.promise.then(function (pdf) {
            _this._pdf = pdf;
            _this.lastLoaded = src;
            _this.afterLoadComplete.emit(pdf);
            if (!_this.pdfMultiPageViewer) {
                _this.setupMultiPageViewer();
                _this.setupSinglePageViewer();
            }
            _this.resetPdfDocument();
            _this.update();
        }, function (error) {
            _this.onError.emit(error);
        });
    };
    PdfViewerComponent.prototype.update = function () {
        this.page = this._page;
        this.render();
    };
    PdfViewerComponent.prototype.render = function () {
        var _this = this;
        this._page = this.getValidPageNumber(this._page);
        var currentViewer = this.getCurrentViewer();
        if (this._rotation !== 0 ||
            currentViewer.pagesRotation !== this._rotation) {
            setTimeout(function () {
                currentViewer.pagesRotation = _this._rotation;
            });
        }
        if (this._stickToPage) {
            setTimeout(function () {
                currentViewer.currentPageNumber = _this._page;
            });
        }
        this.updateSize();
    };
    PdfViewerComponent.prototype.getScale = function (viewportWidth, viewportHeight) {
        var borderSize = (this._showBorders ? 2 * PdfViewerComponent_1.BORDER_WIDTH : 0);
        var pdfContainerWidth = this.pdfViewerContainer.nativeElement.clientWidth - borderSize;
        var pdfContainerHeight = this.pdfViewerContainer.nativeElement.clientHeight - borderSize;
        if (pdfContainerHeight === 0 || viewportHeight === 0 || pdfContainerWidth === 0 || viewportWidth === 0) {
            return 1;
        }
        var ratio = 1;
        switch (this._zoomScale) {
            case 'page-fit':
                ratio = Math.min((pdfContainerHeight / viewportHeight), (pdfContainerWidth / viewportWidth));
                break;
            case 'page-height':
                ratio = (pdfContainerHeight / viewportHeight);
                break;
            case 'page-width':
            default:
                ratio = (pdfContainerWidth / viewportWidth);
                break;
        }
        return (this._zoom * ratio) / PdfViewerComponent_1.CSS_UNITS;
    };
    PdfViewerComponent.prototype.getCurrentViewer = function () {
        return this._showAll ? this.pdfMultiPageViewer : this.pdfSinglePageViewer;
    };
    PdfViewerComponent.prototype.resetPdfDocument = function () {
        this.pdfFindController.setDocument(this._pdf);
        if (this._showAll) {
            this.pdfSinglePageViewer.setDocument(null);
            this.pdfSinglePageLinkService.setDocument(null);
            this.pdfMultiPageViewer.setDocument(this._pdf);
            this.pdfMultiPageLinkService.setDocument(this._pdf, null);
        }
        else {
            this.pdfMultiPageViewer.setDocument(null);
            this.pdfMultiPageLinkService.setDocument(null);
            this.pdfSinglePageViewer.setDocument(this._pdf);
            this.pdfSinglePageLinkService.setDocument(this._pdf, null);
        }
    };
    var PdfViewerComponent_1;
    PdfViewerComponent.CSS_UNITS = 96.0 / 72.0;
    PdfViewerComponent.BORDER_WIDTH = 9;
    PdfViewerComponent.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        ViewChild('pdfViewerContainer')
    ], PdfViewerComponent.prototype, "pdfViewerContainer", void 0);
    __decorate([
        Output('after-load-complete')
    ], PdfViewerComponent.prototype, "afterLoadComplete", void 0);
    __decorate([
        Output('page-rendered')
    ], PdfViewerComponent.prototype, "pageRendered", void 0);
    __decorate([
        Output('pages-initialized')
    ], PdfViewerComponent.prototype, "pageInitialized", void 0);
    __decorate([
        Output('text-layer-rendered')
    ], PdfViewerComponent.prototype, "textLayerRendered", void 0);
    __decorate([
        Output('error')
    ], PdfViewerComponent.prototype, "onError", void 0);
    __decorate([
        Output('on-progress')
    ], PdfViewerComponent.prototype, "onProgress", void 0);
    __decorate([
        Output()
    ], PdfViewerComponent.prototype, "pageChange", void 0);
    __decorate([
        Input()
    ], PdfViewerComponent.prototype, "src", void 0);
    __decorate([
        Input('c-maps-url')
    ], PdfViewerComponent.prototype, "cMapsUrl", null);
    __decorate([
        Input('page')
    ], PdfViewerComponent.prototype, "page", null);
    __decorate([
        Input('render-text')
    ], PdfViewerComponent.prototype, "renderText", null);
    __decorate([
        Input('render-text-mode')
    ], PdfViewerComponent.prototype, "renderTextMode", null);
    __decorate([
        Input('original-size')
    ], PdfViewerComponent.prototype, "originalSize", null);
    __decorate([
        Input('show-all')
    ], PdfViewerComponent.prototype, "showAll", null);
    __decorate([
        Input('stick-to-page')
    ], PdfViewerComponent.prototype, "stickToPage", null);
    __decorate([
        Input('zoom')
    ], PdfViewerComponent.prototype, "zoom", null);
    __decorate([
        Input('zoom-scale')
    ], PdfViewerComponent.prototype, "zoomScale", null);
    __decorate([
        Input('rotation')
    ], PdfViewerComponent.prototype, "rotation", null);
    __decorate([
        Input('external-link-target')
    ], PdfViewerComponent.prototype, "externalLinkTarget", null);
    __decorate([
        Input('autoresize')
    ], PdfViewerComponent.prototype, "autoresize", null);
    __decorate([
        Input('fit-to-page')
    ], PdfViewerComponent.prototype, "fitToPage", null);
    __decorate([
        Input('show-borders')
    ], PdfViewerComponent.prototype, "showBorders", null);
    __decorate([
        HostListener('window:resize', [])
    ], PdfViewerComponent.prototype, "onPageResize", null);
PdfViewerComponent.ɵfac = function PdfViewerComponent_Factory(t) { return new (t || PdfViewerComponent)(ɵngcc0.ɵɵdirectiveInject(ɵngcc0.ElementRef)); };
PdfViewerComponent.ɵcmp = ɵngcc0.ɵɵdefineComponent({ type: PdfViewerComponent, selectors: [["pdf-viewer"]], viewQuery: function PdfViewerComponent_Query(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵviewQuery(_c0, true);
    } if (rf & 2) {
        var _t;
        ɵngcc0.ɵɵqueryRefresh(_t = ɵngcc0.ɵɵloadQuery()) && (ctx.pdfViewerContainer = _t.first);
    } }, hostBindings: function PdfViewerComponent_HostBindings(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵlistener("resize", function PdfViewerComponent_resize_HostBindingHandler() { return ctx.onPageResize(); }, false, ɵngcc0.ɵɵresolveWindow);
    } }, inputs: { cMapsUrl: ["c-maps-url", "cMapsUrl"], page: "page", renderText: ["render-text", "renderText"], renderTextMode: ["render-text-mode", "renderTextMode"], originalSize: ["original-size", "originalSize"], showAll: ["show-all", "showAll"], stickToPage: ["stick-to-page", "stickToPage"], zoom: "zoom", zoomScale: ["zoom-scale", "zoomScale"], rotation: "rotation", externalLinkTarget: ["external-link-target", "externalLinkTarget"], autoresize: "autoresize", fitToPage: ["fit-to-page", "fitToPage"], showBorders: ["show-borders", "showBorders"], src: "src" }, outputs: { afterLoadComplete: "after-load-complete", pageRendered: "page-rendered", pageInitialized: "pages-initialized", textLayerRendered: "text-layer-rendered", onError: "error", onProgress: "on-progress", pageChange: "pageChange" }, features: [ɵngcc0.ɵɵNgOnChangesFeature], decls: 3, vars: 0, consts: [[1, "ng2-pdf-viewer-container"], ["pdfViewerContainer", ""], [1, "pdfViewer"]], template: function PdfViewerComponent_Template(rf, ctx) { if (rf & 1) {
        ɵngcc0.ɵɵelementStart(0, "div", 0, 1);
        ɵngcc0.ɵɵelement(2, "div", 2);
        ɵngcc0.ɵɵelementEnd();
    } }, styles: [".ng2-pdf-viewer-container[_ngcontent-%COMP%]{overflow-x:auto;position:relative;height:100%;-webkit-overflow-scrolling:touch}[_nghost-%COMP%]     .textLayer{position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;opacity:.2;line-height:1}[_nghost-%COMP%]     .textLayer>span{color:transparent;position:absolute;white-space:pre;cursor:text;transform-origin:0 0}[_nghost-%COMP%]     .textLayer .highlight{margin:-1px;padding:1px;background-color:#b400aa;border-radius:4px}[_nghost-%COMP%]     .textLayer .highlight.begin{border-radius:4px 0 0 4px}[_nghost-%COMP%]     .textLayer .highlight.end{border-radius:0 4px 4px 0}[_nghost-%COMP%]     .textLayer .highlight.middle{border-radius:0}[_nghost-%COMP%]     .textLayer .highlight.selected{background-color:#006400}[_nghost-%COMP%]     .textLayer ::-moz-selection{background:#00f}[_nghost-%COMP%]     .textLayer ::selection{background:#00f}[_nghost-%COMP%]     .textLayer .endOfContent{display:block;position:absolute;left:0;top:100%;right:0;bottom:0;z-index:-1;cursor:default;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}[_nghost-%COMP%]     .textLayer .endOfContent.active{top:0}[_nghost-%COMP%]     .annotationLayer section{position:absolute}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.pushButton>a, [_nghost-%COMP%]     .annotationLayer .linkAnnotation>a{position:absolute;font-size:1em;top:0;left:0;width:100%;height:100%}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.pushButton>a:hover, [_nghost-%COMP%]     .annotationLayer .linkAnnotation>a:hover{opacity:.2;background:#ff0;box-shadow:0 2px 10px #ff0}[_nghost-%COMP%]     .annotationLayer .textAnnotation img{position:absolute;cursor:pointer}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation input, [_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation textarea{background-color:rgba(0,54,255,.13);border:1px solid transparent;box-sizing:border-box;font-size:9px;height:100%;margin:0;padding:0 3px;vertical-align:top;width:100%}[_nghost-%COMP%]     .annotationLayer .choiceWidgetAnnotation select{background-color:rgba(0,54,255,.13);border:1px solid transparent;box-sizing:border-box;font-size:9px;height:100%;margin:0;padding:0 3px;vertical-align:top;width:100%}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input, [_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.radioButton input{background-color:rgba(0,54,255,.13);border:1px solid transparent;box-sizing:border-box;font-size:9px;height:100%;margin:0;vertical-align:top;width:100%}[_nghost-%COMP%]     .annotationLayer .choiceWidgetAnnotation select option{padding:0}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.radioButton input{border-radius:50%}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation textarea{font:message-box;font-size:9px;resize:none}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation input[disabled], [_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation textarea[disabled]{background:0 0;border:1px solid transparent;cursor:not-allowed}[_nghost-%COMP%]     .annotationLayer .choiceWidgetAnnotation select[disabled]{background:0 0;border:1px solid transparent;cursor:not-allowed}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input[disabled], [_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.radioButton input[disabled]{background:0 0;border:1px solid transparent;cursor:not-allowed}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation input:hover, [_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation textarea:hover{border:1px solid #000}[_nghost-%COMP%]     .annotationLayer .choiceWidgetAnnotation select:hover{border:1px solid #000}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input:hover, [_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.radioButton input:hover{border:1px solid #000}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation input:focus, [_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation textarea:focus{background:0 0;border:1px solid transparent}[_nghost-%COMP%]     .annotationLayer .choiceWidgetAnnotation select:focus{background:0 0;border:1px solid transparent}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:after, [_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:before{background-color:#000;content:\"\";display:block;position:absolute;height:80%;left:45%;width:1px}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.radioButton input:checked:before{background-color:#000;content:\"\";display:block;position:absolute;border-radius:50%;height:50%;left:30%;top:20%;width:50%}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:before{transform:rotate(45deg)}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:after{transform:rotate(-45deg)}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation input.comb{font-family:monospace;padding-left:2px;padding-right:0}[_nghost-%COMP%]     .annotationLayer .textWidgetAnnotation input.comb:focus{width:115%}[_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.checkBox input, [_nghost-%COMP%]     .annotationLayer .buttonWidgetAnnotation.radioButton input{-webkit-appearance:none;-moz-appearance:none;appearance:none;padding:0}[_nghost-%COMP%]     .annotationLayer .popupWrapper{position:absolute;width:20em}[_nghost-%COMP%]     .annotationLayer .popup{position:absolute;z-index:200;max-width:20em;background-color:#ff9;box-shadow:0 2px 5px #888;border-radius:2px;padding:6px;margin-left:5px;cursor:pointer;font:message-box;font-size:9px;word-wrap:break-word}[_nghost-%COMP%]     .annotationLayer .popup>*{font-size:9px}[_nghost-%COMP%]     .annotationLayer .popup h1{display:inline-block}[_nghost-%COMP%]     .annotationLayer .popup span{display:inline-block;margin-left:5px}[_nghost-%COMP%]     .annotationLayer .popup p{border-top:1px solid #333;margin-top:2px;padding-top:2px}[_nghost-%COMP%]     .annotationLayer .caretAnnotation, [_nghost-%COMP%]     .annotationLayer .circleAnnotation svg ellipse, [_nghost-%COMP%]     .annotationLayer .fileAttachmentAnnotation, [_nghost-%COMP%]     .annotationLayer .freeTextAnnotation, [_nghost-%COMP%]     .annotationLayer .highlightAnnotation, [_nghost-%COMP%]     .annotationLayer .inkAnnotation svg polyline, [_nghost-%COMP%]     .annotationLayer .lineAnnotation svg line, [_nghost-%COMP%]     .annotationLayer .polygonAnnotation svg polygon, [_nghost-%COMP%]     .annotationLayer .polylineAnnotation svg polyline, [_nghost-%COMP%]     .annotationLayer .squareAnnotation svg rect, [_nghost-%COMP%]     .annotationLayer .squigglyAnnotation, [_nghost-%COMP%]     .annotationLayer .stampAnnotation, [_nghost-%COMP%]     .annotationLayer .strikeoutAnnotation, [_nghost-%COMP%]     .annotationLayer .underlineAnnotation{cursor:pointer}[_nghost-%COMP%]     .pdfViewer{padding-bottom:10px}[_nghost-%COMP%]     .pdfViewer .canvasWrapper{overflow:hidden}[_nghost-%COMP%]     .pdfViewer .page{direction:ltr;width:816px;height:1056px;margin:1px auto -8px;position:relative;overflow:visible;border:9px solid rgba(0,0,0,.01);box-sizing:initial;background-clip:content-box;-o-border-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAQAAADYWf5HAAAA6UlEQVR4Xl2Pi2rEMAwE16fm1f7/r14v7w4rI0IzLAF7hLxNevBSEMEF5+OilNCsRd8ZMyn+a4NmsOT8WJw1lFbSYgGFzF2bLFoLjTClWjKKGRWpDYAGXUnZ4uhbBUzF3Oe/GG/ue2fn4GgsyXhNgysV2JnrhKEMg4fEZcALmiKbNhBBRFpSyDOj1G4QOVly6O1FV54ZZq8OVygrciDt6JazRgi1ljTPH0gbrPmHPXAbCiDd4GawIjip1TPh9tt2sz24qaCjr/jAb/GBFTbq9KZ7Ke/Cqt8nayUikZKsWZK7Fe6bg5dOUt8fZHWG2BHc+6EAAAAASUVORK5CYII=) 9 9 repeat;border-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAQAAADYWf5HAAAA6UlEQVR4Xl2Pi2rEMAwE16fm1f7/r14v7w4rI0IzLAF7hLxNevBSEMEF5+OilNCsRd8ZMyn+a4NmsOT8WJw1lFbSYgGFzF2bLFoLjTClWjKKGRWpDYAGXUnZ4uhbBUzF3Oe/GG/ue2fn4GgsyXhNgysV2JnrhKEMg4fEZcALmiKbNhBBRFpSyDOj1G4QOVly6O1FV54ZZq8OVygrciDt6JazRgi1ljTPH0gbrPmHPXAbCiDd4GawIjip1TPh9tt2sz24qaCjr/jAb/GBFTbq9KZ7Ke/Cqt8nayUikZKsWZK7Fe6bg5dOUt8fZHWG2BHc+6EAAAAASUVORK5CYII=) 9 9 repeat;background-color:#fff}[_nghost-%COMP%]     .pdfViewer.removePageBorders .page{margin:0 auto 10px;border:none}[_nghost-%COMP%]     .pdfViewer.removePageBorders{padding-bottom:0}[_nghost-%COMP%]     .pdfViewer.singlePageView{display:inline-block}[_nghost-%COMP%]     .pdfViewer.singlePageView .page{margin:0;border:none}[_nghost-%COMP%]     .pdfViewer.scrollHorizontal, [_nghost-%COMP%]     .pdfViewer.scrollWrapped{margin-left:3.5px;margin-right:3.5px;text-align:center}[_nghost-%COMP%]     .spread{margin-left:3.5px;margin-right:3.5px;text-align:center}[_nghost-%COMP%]     .pdfViewer.scrollHorizontal, [_nghost-%COMP%]     .spread{white-space:nowrap}[_nghost-%COMP%]     .pdfViewer.removePageBorders, [_nghost-%COMP%]     .pdfViewer.scrollHorizontal .spread, [_nghost-%COMP%]     .pdfViewer.scrollWrapped .spread{margin-left:0;margin-right:0}[_nghost-%COMP%]     .spread .page{display:inline-block;vertical-align:middle;margin-left:-3.5px;margin-right:-3.5px}[_nghost-%COMP%]     .pdfViewer.scrollHorizontal .page, [_nghost-%COMP%]     .pdfViewer.scrollHorizontal .spread, [_nghost-%COMP%]     .pdfViewer.scrollWrapped .page, [_nghost-%COMP%]     .pdfViewer.scrollWrapped .spread{display:inline-block;vertical-align:middle}[_nghost-%COMP%]     .pdfViewer.scrollHorizontal .page, [_nghost-%COMP%]     .pdfViewer.scrollWrapped .page{margin-left:-3.5px;margin-right:-3.5px}[_nghost-%COMP%]     .pdfViewer.removePageBorders .spread .page, [_nghost-%COMP%]     .pdfViewer.removePageBorders.scrollHorizontal .page, [_nghost-%COMP%]     .pdfViewer.removePageBorders.scrollWrapped .page{margin-left:5px;margin-right:5px}[_nghost-%COMP%]     .pdfViewer .page canvas{margin:0;display:block}[_nghost-%COMP%]     .pdfViewer .page canvas[hidden]{display:none}[_nghost-%COMP%]     .pdfViewer .page .loadingIcon{position:absolute;display:block;left:0;top:0;right:0;bottom:0;background:url(data:image/gif;base64,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) center no-repeat}[_nghost-%COMP%]     .pdfPresentationMode .pdfViewer{margin-left:0;margin-right:0}[_nghost-%COMP%]     .pdfPresentationMode .pdfViewer .page, [_nghost-%COMP%]     .pdfPresentationMode .pdfViewer .spread{display:block}[_nghost-%COMP%]     .pdfPresentationMode .pdfViewer .page, [_nghost-%COMP%]     .pdfPresentationMode .pdfViewer.removePageBorders .page{margin-left:auto;margin-right:auto}[_nghost-%COMP%]     .pdfPresentationMode:-ms-fullscreen .pdfViewer .page{margin-bottom:100%!important}[_nghost-%COMP%]     .pdfPresentationMode:-webkit-full-screen .pdfViewer .page{margin-bottom:100%;border:0}[_nghost-%COMP%]     .pdfPresentationMode:-moz-full-screen .pdfViewer .page, [_nghost-%COMP%]     .pdfPresentationMode:-webkit-full-screen .pdfViewer .page, [_nghost-%COMP%]     .pdfPresentationMode:fullscreen .pdfViewer .page{margin-bottom:100%;border:0}"] });
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(PdfViewerComponent, [{
        type: Component,
        args: [{
                selector: 'pdf-viewer',
                template: "\n    <div #pdfViewerContainer class=\"ng2-pdf-viewer-container\">\n      <div class=\"pdfViewer\"></div>\n    </div>\n  ",
                styles: [".ng2-pdf-viewer-container{overflow-x:auto;position:relative;height:100%;-webkit-overflow-scrolling:touch}:host ::ng-deep .textLayer{position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;opacity:.2;line-height:1}:host ::ng-deep .textLayer>span{color:transparent;position:absolute;white-space:pre;cursor:text;transform-origin:0 0}:host ::ng-deep .textLayer .highlight{margin:-1px;padding:1px;background-color:#b400aa;border-radius:4px}:host ::ng-deep .textLayer .highlight.begin{border-radius:4px 0 0 4px}:host ::ng-deep .textLayer .highlight.end{border-radius:0 4px 4px 0}:host ::ng-deep .textLayer .highlight.middle{border-radius:0}:host ::ng-deep .textLayer .highlight.selected{background-color:#006400}:host ::ng-deep .textLayer ::-moz-selection{background:#00f}:host ::ng-deep .textLayer ::selection{background:#00f}:host ::ng-deep .textLayer .endOfContent{display:block;position:absolute;left:0;top:100%;right:0;bottom:0;z-index:-1;cursor:default;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}:host ::ng-deep .textLayer .endOfContent.active{top:0}:host ::ng-deep .annotationLayer section{position:absolute}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.pushButton>a,:host ::ng-deep .annotationLayer .linkAnnotation>a{position:absolute;font-size:1em;top:0;left:0;width:100%;height:100%}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.pushButton>a:hover,:host ::ng-deep .annotationLayer .linkAnnotation>a:hover{opacity:.2;background:#ff0;box-shadow:0 2px 10px #ff0}:host ::ng-deep .annotationLayer .textAnnotation img{position:absolute;cursor:pointer}:host ::ng-deep .annotationLayer .textWidgetAnnotation input,:host ::ng-deep .annotationLayer .textWidgetAnnotation textarea{background-color:rgba(0,54,255,.13);border:1px solid transparent;box-sizing:border-box;font-size:9px;height:100%;margin:0;padding:0 3px;vertical-align:top;width:100%}:host ::ng-deep .annotationLayer .choiceWidgetAnnotation select{background-color:rgba(0,54,255,.13);border:1px solid transparent;box-sizing:border-box;font-size:9px;height:100%;margin:0;padding:0 3px;vertical-align:top;width:100%}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input,:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.radioButton input{background-color:rgba(0,54,255,.13);border:1px solid transparent;box-sizing:border-box;font-size:9px;height:100%;margin:0;vertical-align:top;width:100%}:host ::ng-deep .annotationLayer .choiceWidgetAnnotation select option{padding:0}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.radioButton input{border-radius:50%}:host ::ng-deep .annotationLayer .textWidgetAnnotation textarea{font:message-box;font-size:9px;resize:none}:host ::ng-deep .annotationLayer .textWidgetAnnotation input[disabled],:host ::ng-deep .annotationLayer .textWidgetAnnotation textarea[disabled]{background:0 0;border:1px solid transparent;cursor:not-allowed}:host ::ng-deep .annotationLayer .choiceWidgetAnnotation select[disabled]{background:0 0;border:1px solid transparent;cursor:not-allowed}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input[disabled],:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.radioButton input[disabled]{background:0 0;border:1px solid transparent;cursor:not-allowed}:host ::ng-deep .annotationLayer .textWidgetAnnotation input:hover,:host ::ng-deep .annotationLayer .textWidgetAnnotation textarea:hover{border:1px solid #000}:host ::ng-deep .annotationLayer .choiceWidgetAnnotation select:hover{border:1px solid #000}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input:hover,:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.radioButton input:hover{border:1px solid #000}:host ::ng-deep .annotationLayer .textWidgetAnnotation input:focus,:host ::ng-deep .annotationLayer .textWidgetAnnotation textarea:focus{background:0 0;border:1px solid transparent}:host ::ng-deep .annotationLayer .choiceWidgetAnnotation select:focus{background:0 0;border:1px solid transparent}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:after,:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:before{background-color:#000;content:\"\";display:block;position:absolute;height:80%;left:45%;width:1px}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.radioButton input:checked:before{background-color:#000;content:\"\";display:block;position:absolute;border-radius:50%;height:50%;left:30%;top:20%;width:50%}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:before{transform:rotate(45deg)}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input:checked:after{transform:rotate(-45deg)}:host ::ng-deep .annotationLayer .textWidgetAnnotation input.comb{font-family:monospace;padding-left:2px;padding-right:0}:host ::ng-deep .annotationLayer .textWidgetAnnotation input.comb:focus{width:115%}:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.checkBox input,:host ::ng-deep .annotationLayer .buttonWidgetAnnotation.radioButton input{-webkit-appearance:none;-moz-appearance:none;appearance:none;padding:0}:host ::ng-deep .annotationLayer .popupWrapper{position:absolute;width:20em}:host ::ng-deep .annotationLayer .popup{position:absolute;z-index:200;max-width:20em;background-color:#ff9;box-shadow:0 2px 5px #888;border-radius:2px;padding:6px;margin-left:5px;cursor:pointer;font:message-box;font-size:9px;word-wrap:break-word}:host ::ng-deep .annotationLayer .popup>*{font-size:9px}:host ::ng-deep .annotationLayer .popup h1{display:inline-block}:host ::ng-deep .annotationLayer .popup span{display:inline-block;margin-left:5px}:host ::ng-deep .annotationLayer .popup p{border-top:1px solid #333;margin-top:2px;padding-top:2px}:host ::ng-deep .annotationLayer .caretAnnotation,:host ::ng-deep .annotationLayer .circleAnnotation svg ellipse,:host ::ng-deep .annotationLayer .fileAttachmentAnnotation,:host ::ng-deep .annotationLayer .freeTextAnnotation,:host ::ng-deep .annotationLayer .highlightAnnotation,:host ::ng-deep .annotationLayer .inkAnnotation svg polyline,:host ::ng-deep .annotationLayer .lineAnnotation svg line,:host ::ng-deep .annotationLayer .polygonAnnotation svg polygon,:host ::ng-deep .annotationLayer .polylineAnnotation svg polyline,:host ::ng-deep .annotationLayer .squareAnnotation svg rect,:host ::ng-deep .annotationLayer .squigglyAnnotation,:host ::ng-deep .annotationLayer .stampAnnotation,:host ::ng-deep .annotationLayer .strikeoutAnnotation,:host ::ng-deep .annotationLayer .underlineAnnotation{cursor:pointer}:host ::ng-deep .pdfViewer{padding-bottom:10px}:host ::ng-deep .pdfViewer .canvasWrapper{overflow:hidden}:host ::ng-deep .pdfViewer .page{direction:ltr;width:816px;height:1056px;margin:1px auto -8px;position:relative;overflow:visible;border:9px solid rgba(0,0,0,.01);box-sizing:initial;background-clip:content-box;-o-border-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAQAAADYWf5HAAAA6UlEQVR4Xl2Pi2rEMAwE16fm1f7/r14v7w4rI0IzLAF7hLxNevBSEMEF5+OilNCsRd8ZMyn+a4NmsOT8WJw1lFbSYgGFzF2bLFoLjTClWjKKGRWpDYAGXUnZ4uhbBUzF3Oe/GG/ue2fn4GgsyXhNgysV2JnrhKEMg4fEZcALmiKbNhBBRFpSyDOj1G4QOVly6O1FV54ZZq8OVygrciDt6JazRgi1ljTPH0gbrPmHPXAbCiDd4GawIjip1TPh9tt2sz24qaCjr/jAb/GBFTbq9KZ7Ke/Cqt8nayUikZKsWZK7Fe6bg5dOUt8fZHWG2BHc+6EAAAAASUVORK5CYII=) 9 9 repeat;border-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAQAAADYWf5HAAAA6UlEQVR4Xl2Pi2rEMAwE16fm1f7/r14v7w4rI0IzLAF7hLxNevBSEMEF5+OilNCsRd8ZMyn+a4NmsOT8WJw1lFbSYgGFzF2bLFoLjTClWjKKGRWpDYAGXUnZ4uhbBUzF3Oe/GG/ue2fn4GgsyXhNgysV2JnrhKEMg4fEZcALmiKbNhBBRFpSyDOj1G4QOVly6O1FV54ZZq8OVygrciDt6JazRgi1ljTPH0gbrPmHPXAbCiDd4GawIjip1TPh9tt2sz24qaCjr/jAb/GBFTbq9KZ7Ke/Cqt8nayUikZKsWZK7Fe6bg5dOUt8fZHWG2BHc+6EAAAAASUVORK5CYII=) 9 9 repeat;background-color:#fff}:host ::ng-deep .pdfViewer.removePageBorders .page{margin:0 auto 10px;border:none}:host ::ng-deep .pdfViewer.removePageBorders{padding-bottom:0}:host ::ng-deep .pdfViewer.singlePageView{display:inline-block}:host ::ng-deep .pdfViewer.singlePageView .page{margin:0;border:none}:host ::ng-deep .pdfViewer.scrollHorizontal,:host ::ng-deep .pdfViewer.scrollWrapped{margin-left:3.5px;margin-right:3.5px;text-align:center}:host ::ng-deep .spread{margin-left:3.5px;margin-right:3.5px;text-align:center}:host ::ng-deep .pdfViewer.scrollHorizontal,:host ::ng-deep .spread{white-space:nowrap}:host ::ng-deep .pdfViewer.removePageBorders,:host ::ng-deep .pdfViewer.scrollHorizontal .spread,:host ::ng-deep .pdfViewer.scrollWrapped .spread{margin-left:0;margin-right:0}:host ::ng-deep .spread .page{display:inline-block;vertical-align:middle;margin-left:-3.5px;margin-right:-3.5px}:host ::ng-deep .pdfViewer.scrollHorizontal .page,:host ::ng-deep .pdfViewer.scrollHorizontal .spread,:host ::ng-deep .pdfViewer.scrollWrapped .page,:host ::ng-deep .pdfViewer.scrollWrapped .spread{display:inline-block;vertical-align:middle}:host ::ng-deep .pdfViewer.scrollHorizontal .page,:host ::ng-deep .pdfViewer.scrollWrapped .page{margin-left:-3.5px;margin-right:-3.5px}:host ::ng-deep .pdfViewer.removePageBorders .spread .page,:host ::ng-deep .pdfViewer.removePageBorders.scrollHorizontal .page,:host ::ng-deep .pdfViewer.removePageBorders.scrollWrapped .page{margin-left:5px;margin-right:5px}:host ::ng-deep .pdfViewer .page canvas{margin:0;display:block}:host ::ng-deep .pdfViewer .page canvas[hidden]{display:none}:host ::ng-deep .pdfViewer .page .loadingIcon{position:absolute;display:block;left:0;top:0;right:0;bottom:0;background:url(data:image/gif;base64,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) center no-repeat}:host ::ng-deep .pdfPresentationMode .pdfViewer{margin-left:0;margin-right:0}:host ::ng-deep .pdfPresentationMode .pdfViewer .page,:host ::ng-deep .pdfPresentationMode .pdfViewer .spread{display:block}:host ::ng-deep .pdfPresentationMode .pdfViewer .page,:host ::ng-deep .pdfPresentationMode .pdfViewer.removePageBorders .page{margin-left:auto;margin-right:auto}:host ::ng-deep .pdfPresentationMode:-ms-fullscreen .pdfViewer .page{margin-bottom:100%!important}:host ::ng-deep .pdfPresentationMode:-webkit-full-screen .pdfViewer .page{margin-bottom:100%;border:0}:host ::ng-deep .pdfPresentationMode:-moz-full-screen .pdfViewer .page,:host ::ng-deep .pdfPresentationMode:-webkit-full-screen .pdfViewer .page,:host ::ng-deep .pdfPresentationMode:fullscreen .pdfViewer .page{margin-bottom:100%;border:0}"]
            }]
    }], function () { return [{ type: ɵngcc0.ElementRef }]; }, { afterLoadComplete: [{
            type: Output,
            args: ['after-load-complete']
        }], pageRendered: [{
            type: Output,
            args: ['page-rendered']
        }], pageInitialized: [{
            type: Output,
            args: ['pages-initialized']
        }], textLayerRendered: [{
            type: Output,
            args: ['text-layer-rendered']
        }], onError: [{
            type: Output,
            args: ['error']
        }], onProgress: [{
            type: Output,
            args: ['on-progress']
        }], pageChange: [{
            type: Output
        }], cMapsUrl: [{
            type: Input,
            args: ['c-maps-url']
        }], page: [{
            type: Input,
            args: ['page']
        }], renderText: [{
            type: Input,
            args: ['render-text']
        }], renderTextMode: [{
            type: Input,
            args: ['render-text-mode']
        }], originalSize: [{
            type: Input,
            args: ['original-size']
        }], showAll: [{
            type: Input,
            args: ['show-all']
        }], stickToPage: [{
            type: Input,
            args: ['stick-to-page']
        }], zoom: [{
            type: Input,
            args: ['zoom']
        }], zoomScale: [{
            type: Input,
            args: ['zoom-scale']
        }], rotation: [{
            type: Input,
            args: ['rotation']
        }], externalLinkTarget: [{
            type: Input,
            args: ['external-link-target']
        }], autoresize: [{
            type: Input,
            args: ['autoresize']
        }], fitToPage: [{
            type: Input,
            args: ['fit-to-page']
        }], showBorders: [{
            type: Input,
            args: ['show-borders']
        }], onPageResize: [{
            type: HostListener,
            args: ['window:resize', []]
        }], pdfViewerContainer: [{
            type: ViewChild,
            args: ['pdfViewerContainer']
        }], src: [{
            type: Input
        }] }); })();
    return PdfViewerComponent;
}());

var PdfViewerModule = /** @class */ (function () {
    function PdfViewerModule() {
    }
PdfViewerModule.ɵmod = ɵngcc0.ɵɵdefineNgModule({ type: PdfViewerModule });
PdfViewerModule.ɵinj = ɵngcc0.ɵɵdefineInjector({ factory: function PdfViewerModule_Factory(t) { return new (t || PdfViewerModule)(); } });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && ɵngcc0.ɵɵsetNgModuleScope(PdfViewerModule, { declarations: [PdfViewerComponent], exports: [PdfViewerComponent] }); })();
/*@__PURE__*/ (function () { ɵngcc0.ɵsetClassMetadata(PdfViewerModule, [{
        type: NgModule,
        args: [{
                declarations: [PdfViewerComponent],
                exports: [PdfViewerComponent]
            }]
    }], function () { return []; }, null); })();
    return PdfViewerModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { PdfViewerComponent, PdfViewerModule, RenderTextMode };

//# sourceMappingURL=ng2-pdf-viewer.js.map