import { buildMessage, ValidateBy } from "../common/ValidateBy";
export var ARRAY_MIN_SIZE = "arrayMinSize";
/**
 * Checks if array's length is as minimal this number.
 * If null or undefined is given then this function returns false.
 */
export function arrayMinSize(array, min) {
    return array instanceof Array && array.length >= min;
}
/**
 * Checks if array's length is as minimal this number.
 * If null or undefined is given then this function returns false.
 */
export function ArrayMinSize(min, validationOptions) {
    return ValidateBy({
        name: ARRAY_MIN_SIZE,
        constraints: [min],
        validator: {
            validate: function (value, args) { return arrayMinSize(value, args.constraints[0]); },
            defaultMessage: buildMessage(function (eachPrefix) { return eachPrefix + "$property must contain at least $constraint1 elements"; }, validationOptions)
        }
    }, validationOptions);
}

//# sourceMappingURL=ArrayMinSize.js.map
